/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.license;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.license.License;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.dialogs.PreferencesUtil;

public final class LicenseValidator {
    private static String resolvedLicenseFilePath = "";
    public static final int MILLISECONDS_IN_A_DAY = 86400000;
    public static final int EXPIRATION_WARNING_TIMEOUT = 14;
    private static final String CORRECTIONSTRING = "Please check that the \"License file\" field on the Window / Preferences / TITAN preferences page is set correctly.";
    private static boolean wasChecked = false;
    private static boolean wasCorrect = false;

    private LicenseValidator() {
    }

    public static synchronized boolean check() {
        if (!License.isLicenseNeeded()) {
            return true;
        }
        if (wasChecked) {
            return wasCorrect;
        }
        String licensePath = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.LICENSE_FILE", "", null);
        wasChecked = true;
        if (licensePath == null || licensePath.trim().length() == 0) {
            LicenseValidator.showErrorDialog("Checking for TITAN license failed", "The path of the license for TITAN is not set.\n\nPlease check that the \"License file\" field on the Window / Preferences / TITAN preferences page is set correctly.");
            wasCorrect = false;
            return false;
        }
        File realFile = new File(licensePath);
        if (!realFile.exists()) {
            LicenseValidator.showErrorDialog("Checking for TITAN license failed", "The file set as the TITAN license file does not seem to exist.\n\nPlease check that the \"License file\" field on the Window / Preferences / TITAN preferences page is set correctly.");
            wasCorrect = false;
            return false;
        }
        License license = new License(licensePath);
        license.process();
        if (!license.isValid()) {
            LicenseValidator.showErrorDialog("Checking for TITAN license failed", "The file set as the TITAN license file is not TITAN license file or is corrupt.\n\nPlease check that the \"License file\" field on the Window / Preferences / TITAN preferences page is set correctly.");
            wasCorrect = false;
            return false;
        }
        long validUntil = license.getValidUntil().getTime();
        long now = System.currentTimeMillis();
        if (now > validUntil) {
            LicenseValidator.showErrorDialog("Checking for TITAN license failed", "The TITAN license has expired.\n\nPlease check that the \"License file\" field on the Window / Preferences / TITAN preferences page is set correctly.");
            wasCorrect = false;
            return false;
        }
        wasCorrect = true;
        long difference = (validUntil - now) / 86400000L + 1L;
        if (difference <= 14L) {
            if (difference == 1L) {
                LicenseValidator.showErrorDialog("Checking for TITAN license", "Please note that your TITAN license will expire within 1 day.");
            } else {
                LicenseValidator.showErrorDialog("Checking for TITAN license", "Please note that your TITAN license will expire within " + difference + " days.");
            }
        }
        return true;
    }

    private static void showErrorDialog(final String title, final String message) {
        if (PlatformUI.isWorkbenchRunning()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (LicenseErrorDialog.isDialogOpen) {
                        return;
                    }
                    LicenseErrorDialog.isDialogOpen = true;
                    LicenseErrorDialog dialog = new LicenseErrorDialog(null, title, message);
                    dialog.open();
                    LicenseErrorDialog.isDialogOpen = false;
                }
            });
        } else {
            ErrorReporter.logError((String)message);
        }
    }

    public static void clear() {
        resolvedLicenseFilePath = "";
        wasChecked = false;
    }

    public static String getResolvedLicenseFilePath(boolean force) {
        if (!License.isLicenseNeeded()) {
            return "";
        }
        IPreferencesService preferenceService = Platform.getPreferencesService();
        boolean reportDebugInformation = preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        if (force || resolvedLicenseFilePath.length() == 0) {
            String licensePath = preferenceService.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.LICENSE_FILE", "", null);
            resolvedLicenseFilePath = PathConverter.convert((String)licensePath, (boolean)reportDebugInformation, (MessageConsole)TITANDebugConsole.getConsole());
        }
        return resolvedLicenseFilePath;
    }

    private static class LicenseErrorDialog
    extends MessageDialog {
        private static volatile boolean isDialogOpen = false;

        public LicenseErrorDialog(Shell parent, String title, String message) {
            super(parent, title, null, message, 1, new String[]{IDialogConstants.OK_LABEL, "Open License Preferences"}, 0);
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            if (buttonId == 1) {
                PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.titan.designer.preferences.pages.TITANPreferencePage", null, null).open();
            }
        }
    }
}

