/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.editors.StringDetectionPatternRule;
import org.eclipse.titan.designer.editors.WhiteSpaceDetector;
import org.eclipse.titan.designer.editors.ttcn3editor.MacroDetector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3StringDetectionPatternRule;
import org.eclipse.titan.designer.editors.ttcn3editor.TitanSpecificKeywordDetector;
import org.eclipse.titan.designer.editors.ttcn3editor.WordDetector;

public final class CodeScanner
extends RuleBasedScanner {
    public static final String[] KEYWORDS = new String[]{"activate", "address", "alive", "all", "alt", "altstep", "and", "and4b", "any", "break", "case", "component", "const", "continue", "control", "deactivate", "display", "do", "else", "encode", "enumerated", "except", "exception", "execute", "extends", "extension", "external", "for", "from", "function", "goto", "group", "if", "import", "in", "infinity", "inout", "interleave", "label", "language", "length", "log", "match", "message", "mixed", "mod", "modifies", "module", "modulepar", "mtc", "noblock", "not", "not4b", "nowait", "of", "omit", "on", "optional", "or", "or4b", "out", "override", "param", "pattern", "port", "present", "procedure", "record", "recursive", "rem", "repeat", "return", "runs", "select", "self", "sender", "set", "signature", "system", "template", "testcase", "to", "type", "union", "value", "valueof", "var", "variant", "while", "with", "xor", "xor4b"};
    public static final String[] TITANSPECIFICKEYWORDS = new String[]{"@try", "@catch"};
    public static final String[] TEMPLATE_MATCH = new String[]{"complement", "ifpresent", "subset", "superset", "permutation"};
    public static final String[] TYPES = new String[]{"anytype", "bitstring", "boolean", "char", "charstring", "default", "float", "hexstring", "integer", "objid", "octetstring", "universal", "verdicttype", "timer"};
    public static final String[] TIMER_OPERATIONS = new String[]{"start", "stop", "timeout", "read", "running"};
    public static final String[] PORT_OPERATIONS = new String[]{"call", "catch", "check", "clear", "getcall", "getreply", "halt", "raise", "receive", "reply", "send", "trigger"};
    public static final String[] CONFIGURATION_OPERATIONS = new String[]{"create", "connect", "disconnect", "done", "kill", "killed", "map", "unmap"};
    public static final String[] VERDICT_OPERATIONS = new String[]{"getverdict", "setverdict"};
    public static final String[] SUT_OPERATION = new String[]{"action"};
    public static final String[] FUNCTION_OPERATIONS = new String[]{"apply", "derefers", "refers"};
    public static final String[] PREDEFINED_OPERATIONS = new String[]{"bit2hex", "bit2int", "bit2oct", "bit2str", "char2int", "char2oct", "encvalue", "decomp", "decvalue", "float2int", "float2str", "hex2bit", "hex2int", "hex2oct", "hex2str", "int2bit", "int2char", "int2float", "int2hex", "int2oct", "int2str", "int2unichar", "isbound", "ischosen", "ispresent", "isvalue", "lengthof", "log2str", "oct2bit", "oct2char", "oct2hex", "oct2int", "oct2str", "regexp", "replace", "rnd", "sizeof", "str2bit", "str2float", "str2hex", "str2int", "str2oct", "substr", "unichar2int", "unichar2char", "enum2int", "get_stringencoding", "oct2unichar", "remove_bom", "unichar2oct", "encode_base64", "decode_base64"};
    public static final String[] BOOLEAN_CONSTANTS = new String[]{"true", "false"};
    public static final String[] VERDICT_CONSTANT = new String[]{"none", "pass", "inconc", "fail", "error"};
    public static final String[] OTHER_CONSTANT = new String[]{"null", "NULL"};
    public static final String[] MACROS = new String[]{"%moduleId", "%definitionId", "%testcaseId", "%fileName", "%lineNumber", "__MODULE__", "__FILE__", "__BFILE__", "__LINE__", "__SCOPE__", "__TESTCASE__"};
    public static final String[] VISIBILITY_MODIFIERS = new String[]{"public", "private", "friend"};

    public CodeScanner(ColorManager colorManager) {
        List<IRule> rules = CodeScanner.getTTCNRules(colorManager);
        Token preprocessor = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.preprocessor");
        rules.add((IRule)new EndOfLineRule("#", (IToken)preprocessor));
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    public static List<IRule> getTTCNRules(ColorManager colorManager) {
        Token singleLineComment = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.comments");
        Token multiLineComment = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.comments");
        Token keyword = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.ttcn3_keywords");
        Token templateMatch = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.template_match");
        Token types = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.type");
        Token timerOp = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.timer_op");
        Token portOp = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.port_op");
        Token configOp = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.config_op");
        Token verdictOp = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.verdict_op");
        Token sutOp = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.sut_op");
        Token functionOp = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.function_op");
        Token predefinedOp = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.predefined_op");
        Token booleanConst = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.boolean_const");
        Token verdictConst = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.ttcn3_verdict_const");
        Token otherConst = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.other_const");
        Token macro = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.preprocessor");
        Token visibility = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.visibility_op");
        Token string = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.strings");
        Token other = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.normalText");
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add((IRule)new EndOfLineRule("//", (IToken)singleLineComment));
        rules.add((IRule)new MultiLineRule("/*", "*/", (IToken)multiLineComment, '\u0000', true));
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new WhiteSpaceDetector()));
        rules.add((IRule)new TTCN3StringDetectionPatternRule((IToken)string));
        rules.add((IRule)new StringDetectionPatternRule("'", new char[][]{{'\'', 'B'}, {'\'', 'H'}, {'\'', 'O'}}, (IToken)string));
        WordRule wordRule = new WordRule((IWordDetector)new WordDetector(), (IToken)other);
        for (String element : KEYWORDS) {
            wordRule.addWord(element, (IToken)keyword);
        }
        for (String element : TEMPLATE_MATCH) {
            wordRule.addWord(element, (IToken)templateMatch);
        }
        for (String element : TYPES) {
            wordRule.addWord(element, (IToken)types);
        }
        for (String element : TIMER_OPERATIONS) {
            wordRule.addWord(element, (IToken)timerOp);
        }
        for (String element : PORT_OPERATIONS) {
            wordRule.addWord(element, (IToken)portOp);
        }
        for (String element : CONFIGURATION_OPERATIONS) {
            wordRule.addWord(element, (IToken)configOp);
        }
        for (String element : VERDICT_OPERATIONS) {
            wordRule.addWord(element, (IToken)verdictOp);
        }
        for (String element : SUT_OPERATION) {
            wordRule.addWord(element, (IToken)sutOp);
        }
        for (String element : FUNCTION_OPERATIONS) {
            wordRule.addWord(element, (IToken)functionOp);
        }
        for (String element : PREDEFINED_OPERATIONS) {
            wordRule.addWord(element, (IToken)predefinedOp);
        }
        for (String element : BOOLEAN_CONSTANTS) {
            wordRule.addWord(element, (IToken)booleanConst);
        }
        for (String element : VERDICT_CONSTANT) {
            wordRule.addWord(element, (IToken)verdictConst);
        }
        for (String element : OTHER_CONSTANT) {
            wordRule.addWord(element, (IToken)otherConst);
        }
        for (String element : VISIBILITY_MODIFIERS) {
            wordRule.addWord(element, (IToken)visibility);
        }
        rules.add((IRule)wordRule);
        WordRule macroRule = new WordRule((IWordDetector)new MacroDetector(), (IToken)other);
        for (String element : MACROS) {
            macroRule.addWord(element, (IToken)macro);
        }
        rules.add((IRule)macroRule);
        WordRule titanSpecificKeywordsRule = new WordRule((IWordDetector)new TitanSpecificKeywordDetector(), (IToken)other);
        for (String element : TITANSPECIFICKEYWORDS) {
            titanSpecificKeywordsRule.addWord(element, (IToken)keyword);
        }
        rules.add((IRule)titanSpecificKeywordsRule);
        return rules;
    }
}

