/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.ui;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.sew.launcher.Activator;
import org.eclipse.efm.sew.launcher.LaunchConfigurationTabGroup;
import org.eclipse.efm.sew.launcher.ui.AbstractSewLaunchConfigurationTab;
import org.eclipse.efm.sew.launcher.ui.internal.SWTFactory;
import org.eclipse.efm.sew.launcher.ui.internal.fieldeditor.BooleanFieldEditor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class NonRegressionTab
extends AbstractSewLaunchConfigurationTab {
    public static final String ATTR_ENABLED_NON_REGRESSION = "org.eclipse.efm.sew.launcher.ATTR_ENABLED_NON_REGRESSION";
    public static final String ATTR_SPECIFICATION_PROJECT_NAME = "org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_PROJECT_NAME";
    public static final String ATTR_SPECIFICATION_MODEL_FILE_LOCATION = "org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_FILE_LOCATION";
    private final String WORKSPACE_SELECTION_DIALOG = "org.eclipse.efm.sew.launcher.WORKSPACE_SELECTION_DIALOG";
    public static final String ATTR_BASIC_TRANSITION_BUTTON = "org.eclipse.efm.sew.launcher.ATTR_BASIC_TRANSITION_BUTTON";
    public static final String ATTR_SELECTED_TRANSITIONS = "org.eclipse.efm.sew.launcher.ATTR_SELECTED_TRANSITIONS";
    private BooleanFieldEditor fNonRegressionBooleanField;
    private String fProjectName;
    private Text fModelPathText;
    private String currentModelPath = "";
    private Button fModelWorkspaceBrowse;
    private String specMainFileLocation = "<model file location>";
    private Composite compNonRegressionCaseButton;
    private Composite compNonRegressionCaseCoverage;
    private Button fAllNonRegressionCaseButton = null;
    private Button fDetailsNonRegressionCaseButton = null;
    private String fNonRegressionCaseButton = "All";
    private Table fNonRegressionCaseTable1;
    private TableColumn colonne1;
    private Table fNonRegressionCaseTable2;
    private TableColumn colonne2;
    private List<String> transitionsToBeSelected;
    private List<String> selectedTransitions;
    private TabListener fListener = new TabListener();
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent evt) {
            NonRegressionTab.this.scheduleUpdateJob();
        }
    };

    public NonRegressionTab(LaunchConfigurationTabGroup groupTab) {
        super(groupTab);
        this.setHelpContextId("org.eclipse.efm.sew.launcher.efm_runconf_main_tab");
    }

    public void handleSelectedTransition() {
        boolean refresh = false;
        int i = 0;
        while (i < this.transitionsToBeSelected.size()) {
            if (this.fNonRegressionCaseTable1.getItem(i).getChecked()) {
                if (!this.selectedTransitions.contains(this.transitionsToBeSelected.get(i))) {
                    this.selectedTransitions.add(this.transitionsToBeSelected.get(i));
                    refresh = true;
                }
            } else if (this.selectedTransitions.contains(this.transitionsToBeSelected.get(i))) {
                this.selectedTransitions.remove(this.transitionsToBeSelected.get(i));
                refresh = true;
            }
            ++i;
        }
        if (refresh) {
            this.selectedTransitions.sort(null);
            this.updateTransitionTable2();
        }
        this.updateLaunchConfigurationDialog();
    }

    public void handleAllTransitionButtonSelected() {
        if (this.fAllNonRegressionCaseButton.getSelection()) {
            this.fNonRegressionCaseButton = "All";
            this.visibleAndExclude((Control)this.compNonRegressionCaseCoverage, false);
        }
        this.updateLaunchConfigurationDialog();
    }

    public void handleDetailedTransitionSelected() {
        if (this.fDetailsNonRegressionCaseButton.getSelection()) {
            this.fNonRegressionCaseButton = "Details";
            this.visibleAndExclude((Control)this.compNonRegressionCaseCoverage, true);
        }
        this.updateLaunchConfigurationDialog();
    }

    IDialogSettings getDialogBoundsSettings(String id) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(id);
        if (section == null) {
            section = settings.addNewSection(id);
        }
        return section;
    }

    public void createControl(Composite parent) {
        Composite simpleComposite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 768, 0, 0);
        this.setControl((Control)simpleComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
        this.createNonRegressionSelectionComponent(simpleComposite);
        this.createModelFileSelectionComponent(simpleComposite);
        this.createAnalyseProfileComponent(simpleComposite);
    }

    private void createNonRegressionSelectionComponent(Composite parent) {
        Group group = SWTFactory.createGroup(parent, "Non Regression", 1, 1, 768);
        Composite comp = SWTFactory.createComposite((Composite)group, 1, 1, 768);
        this.fNonRegressionBooleanField = new BooleanFieldEditor(this, ATTR_ENABLED_NON_REGRESSION, "&Non Regression Execution", comp, false);
    }

    private void createModelFileSelectionComponent(Composite parent) {
        Group group = SWTFactory.createGroup(parent, "Non Regression Folder Selection", 5, 1, 768);
        Composite comp = SWTFactory.createComposite((Composite)group, group.getFont(), 5, 5, 1808, 0, 0);
        this.fModelPathText = SWTFactory.createSingleText(comp, 4);
        this.fModelPathText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Non Regression Folder";
            }
        });
        this.fModelPathText.addModifyListener(this.fBasicModifyListener);
        Composite bcomp = SWTFactory.createComposite(comp, 3, 5, 128);
        GridLayout ld = (GridLayout)bcomp.getLayout();
        ld.marginHeight = 1;
        ld.marginWidth = 0;
        this.fModelWorkspaceBrowse = this.createPushButton(bcomp, "&Workspace...", null);
        this.fModelWorkspaceBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(NonRegressionTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle("Select a &Diversity Specification:");
                dialog.setMessage("Select a resource to redirect output to:");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.setDialogBoundsSettings(NonRegressionTab.this.getDialogBoundsSettings("org.eclipse.efm.sew.launcher.WORKSPACE_SELECTION_DIALOG"), 2);
                if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                    NonRegressionTab.this.fProjectName = resource.getProject().getName();
                    String specFile = resource.getLocation().toString();
                    NonRegressionTab.this.fModelPathText.setText(specFile);
                }
            }
        });
    }

    protected void createAnalyseProfileComponent(Composite parent) {
        Group group = SWTFactory.createGroup(parent, "&Non Regression Profile", 2, 1, 768);
        Composite comp = SWTFactory.createComposite((Composite)group, 1, 2, 768);
        this.createNonRegressionListComponent(comp);
    }

    private void createNonRegressionListComponent(Composite parent) {
        this.compNonRegressionCaseButton = SWTFactory.createComposite(parent, 1, 1, 768);
        GridData gridData1 = new GridData();
        gridData1.horizontalIndent = 50;
        this.compNonRegressionCaseButton.setLayoutData((Object)gridData1);
        SWTFactory.createLabel(this.compNonRegressionCaseButton, "&Non Regression Case To Be Covered", 1);
        Composite comp = SWTFactory.createComposite(this.compNonRegressionCaseButton, 2, 1, 768);
        this.fAllNonRegressionCaseButton = SWTFactory.createRadioButton(comp, "&All");
        this.fAllNonRegressionCaseButton.addSelectionListener((SelectionListener)this.fListener);
        this.fAllNonRegressionCaseButton.setToolTipText("All transitions must be covered");
        this.fDetailsNonRegressionCaseButton = SWTFactory.createRadioButton(comp, "&Details");
        this.fDetailsNonRegressionCaseButton.addSelectionListener((SelectionListener)this.fListener);
        this.fDetailsNonRegressionCaseButton.setToolTipText("Select a detailed list of transitions to be covered");
        this.fAllNonRegressionCaseButton.setSelection(false);
        this.fDetailsNonRegressionCaseButton.setSelection(false);
        this.compNonRegressionCaseCoverage = SWTFactory.createComposite(parent, 2, 1, 768);
        this.fNonRegressionCaseTable1 = new Table(this.compNonRegressionCaseCoverage, 2080);
        this.colonne1 = new TableColumn(this.fNonRegressionCaseTable1, 0);
        this.colonne1.setText("Transitions to be selected");
        this.fNonRegressionCaseTable1.setHeaderVisible(true);
        this.fNonRegressionCaseTable2 = new Table(this.compNonRegressionCaseCoverage, 2048);
        this.colonne2 = new TableColumn(this.fNonRegressionCaseTable2, 0);
        this.colonne2.setText("Selected transitions");
        this.fNonRegressionCaseTable2.setHeaderVisible(true);
        int listHeight = this.fNonRegressionCaseTable1.getItemHeight() * 10;
        Rectangle trim = this.fNonRegressionCaseTable1.computeTrim(0, 0, 0, listHeight);
        GridData gridDataLeft = new GridData();
        gridDataLeft.heightHint = trim.height;
        gridDataLeft.horizontalIndent = 0;
        gridDataLeft.verticalIndent = 10;
        this.fNonRegressionCaseTable1.setLayoutData((Object)gridDataLeft);
        GridData gridDataRight = new GridData();
        gridDataRight.heightHint = trim.height;
        gridDataRight.horizontalIndent = 0;
        gridDataRight.verticalIndent = 10;
        this.fNonRegressionCaseTable2.setLayoutData((Object)gridDataRight);
        this.fNonRegressionCaseTable1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean refresh = false;
                int i = 0;
                while (i < NonRegressionTab.this.transitionsToBeSelected.size()) {
                    if (NonRegressionTab.this.fNonRegressionCaseTable1.getItem(i).getChecked()) {
                        if (!NonRegressionTab.this.selectedTransitions.contains(NonRegressionTab.this.transitionsToBeSelected.get(i))) {
                            NonRegressionTab.this.selectedTransitions.add((String)NonRegressionTab.this.transitionsToBeSelected.get(i));
                            refresh = true;
                        }
                    } else if (NonRegressionTab.this.selectedTransitions.contains(NonRegressionTab.this.transitionsToBeSelected.get(i))) {
                        NonRegressionTab.this.selectedTransitions.remove(NonRegressionTab.this.transitionsToBeSelected.get(i));
                        refresh = true;
                    }
                    ++i;
                }
                if (refresh) {
                    NonRegressionTab.this.selectedTransitions.sort(null);
                    NonRegressionTab.this.updateTransitionTable2();
                }
                NonRegressionTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NonRegressionTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void initTransitionTable() {
        this.createTransitionToBeSelectedList();
        this.fNonRegressionCaseTable1.removeAll();
        int i = 0;
        while (i < this.transitionsToBeSelected.size()) {
            TableItem item = new TableItem(this.fNonRegressionCaseTable1, 0);
            item.setChecked(false);
            item.setText(new String[]{this.transitionsToBeSelected.get(i), ""});
            ++i;
        }
    }

    private void updateTransitionTable2() {
        this.fNonRegressionCaseTable2.removeAll();
        int i = 0;
        while (i < this.transitionsToBeSelected.size()) {
            TableItem item = new TableItem(this.fNonRegressionCaseTable2, 0);
            if (i < this.selectedTransitions.size()) {
                item.setText(new String[]{this.selectedTransitions.get(i)});
            } else {
                item.setText(new String[]{""});
            }
            ++i;
        }
    }

    private void createTransitionToBeSelectedList() {
        String pathFile = this.fModelPathText.getText();
        this.transitionsToBeSelected = new ArrayList<String>();
        try {
            if (!pathFile.equals("<model file location>") && !pathFile.equals("")) {
                String ligne;
                FileInputStream ips = new FileInputStream(pathFile);
                InputStreamReader ipsr = new InputStreamReader(ips);
                BufferedReader br = new BufferedReader(ipsr);
                String transitionName = "";
                int maxSizetransitionName = 0;
                while ((ligne = br.readLine()) != null) {
                    if (ligne.contains("transition ")) {
                        ligne = ligne.replaceAll("\t", "");
                        ligne = ligne.replaceAll("transition ", "");
                        ligne = ligne.replaceAll("<prior:1> ", "");
                        ligne = ligne.replaceAll("<prior:1 > ", "");
                        ligne = ligne.replaceAll("<prior:3> ", "");
                        if ((ligne = ligne.replaceAll("<prior:3 > ", "")).contains("-->")) {
                            ligne = ligne.substring(0, ligne.indexOf("-->"));
                        } else if (ligne.contains("{")) {
                            ligne = ligne.substring(0, ligne.indexOf("{"));
                        } else {
                            transitionName = "transition_name_not_found";
                        }
                        transitionName = ligne.replaceAll(" ", "");
                        if (transitionName.length() == 0) continue;
                        this.transitionsToBeSelected.add(transitionName);
                        maxSizetransitionName = Math.max(maxSizetransitionName, transitionName.length());
                        continue;
                    }
                    if (!ligne.contains("-->") || ligne.contains("}") || ligne.contains("output ") || ligne.contains("procedure ") || ligne.contains("call ")) continue;
                    ligne = ligne.replaceAll("\t", "");
                    ligne = ligne.substring(0, ligne.indexOf("-->"));
                    transitionName = (ligne = ligne.replaceAll(" ", "")).replaceFirst("@", "");
                    if (transitionName.length() == 0) continue;
                    this.transitionsToBeSelected.add(transitionName);
                    maxSizetransitionName = Math.max(maxSizetransitionName, transitionName.length());
                }
                br.close();
                this.transitionsToBeSelected.sort(null);
                if (maxSizetransitionName <= 30) {
                    this.colonne1.setWidth(200);
                    this.colonne2.setWidth(200);
                } else {
                    this.colonne1.setWidth(maxSizetransitionName * 9 + 30);
                    this.colonne2.setWidth(maxSizetransitionName * 9 + 10);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.fNonRegressionCaseButton.equals("Details") && this.selectedTransitions.size() == 0) {
            this.setErrorMessage("You must select at least one transition");
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(ATTR_SPECIFICATION_PROJECT_NAME, "<project location>");
        configuration.setAttribute(ATTR_SPECIFICATION_MODEL_FILE_LOCATION, "<model file location>");
        configuration.setAttribute(ATTR_BASIC_TRANSITION_BUTTON, "All");
        configuration.setAttribute(ATTR_SELECTED_TRANSITIONS, new ArrayList());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fNonRegressionBooleanField.initializeFrom(configuration);
            this.fProjectName = configuration.getAttribute(ATTR_SPECIFICATION_PROJECT_NAME, "");
            this.specMainFileLocation = configuration.getAttribute(ATTR_SPECIFICATION_MODEL_FILE_LOCATION, "<model file location>");
            this.fModelPathText.setText(this.specMainFileLocation);
            if (!this.fModelPathText.getText().equals(this.currentModelPath)) {
                this.currentModelPath = this.fModelPathText.getText();
                this.initTransitionTable();
            }
            this.fNonRegressionCaseButton = configuration.getAttribute(ATTR_BASIC_TRANSITION_BUTTON, "All");
            this.initializeTransitionOption(configuration);
            this.selectedTransitions = new ArrayList<String>();
            this.selectedTransitions.addAll(configuration.getAttribute(ATTR_SELECTED_TRANSITIONS, new ArrayList()));
            this.updateTransitionTable2();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void initializeTransitionOption(ILaunchConfiguration configuration) {
        switch (this.fNonRegressionCaseButton) {
            case "All": {
                this.fAllNonRegressionCaseButton.setSelection(true);
                this.fDetailsNonRegressionCaseButton.setSelection(false);
                this.visibleAndExclude((Control)this.compNonRegressionCaseCoverage, false);
                break;
            }
            case "Details": {
                this.fAllNonRegressionCaseButton.setSelection(false);
                this.fDetailsNonRegressionCaseButton.setSelection(true);
                this.visibleAndExclude((Control)this.compNonRegressionCaseCoverage, true);
                break;
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.fNonRegressionBooleanField.performApply(configuration);
        configuration.setAttribute(ATTR_SPECIFICATION_PROJECT_NAME, this.fProjectName);
        configuration.setAttribute(ATTR_SPECIFICATION_MODEL_FILE_LOCATION, this.fModelPathText.getText());
        if (!this.fModelPathText.getText().equals(this.currentModelPath)) {
            this.currentModelPath = this.fModelPathText.getText();
            this.initTransitionTable();
        }
        configuration.setAttribute(ATTR_BASIC_TRANSITION_BUTTON, this.fNonRegressionCaseButton);
        configuration.setAttribute(ATTR_SELECTED_TRANSITIONS, this.selectedTransitions);
    }

    public String getName() {
        return "Non Regression";
    }

    private class TabListener
    extends SelectionAdapter
    implements ModifyListener {
        private TabListener() {
        }

        public void modifyText(ModifyEvent e) {
            NonRegressionTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == NonRegressionTab.this.fAllNonRegressionCaseButton) {
                NonRegressionTab.this.handleAllTransitionButtonSelected();
            } else if (source == NonRegressionTab.this.fDetailsNonRegressionCaseButton) {
                NonRegressionTab.this.handleDetailedTransitionSelected();
            }
        }
    }
}

