/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.utils;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.common.utils.MapAppender;
import org.eclipse.titan.common.utils.StringUtils;

public class ProjectStructureExporter {
    private IProject project;

    public ProjectStructureExporter(IProject project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(URI path) throws IOException {
        ResourceVisitor visitor = new ResourceVisitor();
        try {
            this.project.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e1) {
            ErrorReporter.logExceptionStackTrace((String)"Error while collecting resources", (Throwable)e1);
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(path)), "UTF-8"));
            MapAppender appender = new MapAppender((Appendable)writer, StringUtils.lineSeparator(), ";");
            for (ResourceData data : visitor.resources) {
                appender.append(new Object[]{data.type, data.projectRelativePath, data.absoluteURI.toString()});
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)writer);
    }

    private static class ResourceVisitor
    implements IResourceVisitor {
        private List<ResourceData> resources = new ArrayList<ResourceData>();

        private ResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            ResourceData data = new ResourceData();
            switch (resource.getType()) {
                case 4: {
                    data.type = ResourceData.ResourceType.PROJECT;
                    break;
                }
                case 2: {
                    data.type = ResourceData.ResourceType.FOLDER;
                    if (!this.isIgnored(resource)) break;
                    return false;
                }
                case 1: {
                    data.type = ResourceData.ResourceType.FILE;
                    break;
                }
            }
            data.projectRelativePath = resource.getProjectRelativePath().toString();
            data.absoluteURI = resource.getLocationURI();
            this.resources.add(data);
            return true;
        }

        private boolean isIgnored(IResource resource) {
            return ".sonar".equals(resource.getName()) || ".sonar_titanium".equals(resource.getName());
        }
    }

    private static class ResourceData {
        private ResourceType type;
        private String projectRelativePath;
        private URI absoluteURI;

        private ResourceData() {
        }

        static enum ResourceType {
            FILE,
            PROJECT,
            FOLDER;

        }
    }
}

