/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.editors.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class BooleanFieldEditor
extends FieldEditor {
    private boolean fValue;
    private boolean fDefaultValue;
    public static final int DEFAULT = 0;
    public static final int SEPARATE_LABEL = 1;
    private int style;
    private boolean wasSelected;
    private Button checkBox = null;

    public BooleanFieldEditor(AbstractConfigurationPage configurationPage, String storeKey, String labelText, int style, Composite parent, boolean defaultValue) {
        this.fDefaultValue = defaultValue;
        this.init(configurationPage, storeKey, labelText);
        this.style = style;
        this.createControl(parent);
    }

    public BooleanFieldEditor(AbstractConfigurationPage configurationPage, String storeKey, String labelText, Composite parent, boolean defaultValue) {
        this(configurationPage, storeKey, labelText, 0, parent, defaultValue);
    }

    public BooleanFieldEditor(AbstractConfigurationPage configurationPage, String storeKey, String labelText, Composite parent) {
        this(configurationPage, storeKey, labelText, 0, parent, false);
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        if (this.style == 1) {
            --numColumns;
        }
        ((GridData)this.checkBox.getLayoutData()).horizontalSpan = numColumns;
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        String text = this.getLabelText();
        switch (this.style) {
            case 1: {
                this.getLabelControl(parent);
                --numColumns;
                text = null;
            }
        }
        this.checkBox = this.getChangeControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        this.checkBox.setLayoutData((Object)gd);
        if (text != null) {
            this.checkBox.setText(text);
        }
    }

    public Control getDescriptionControl(Composite parent) {
        if (this.style == 1) {
            return this.getLabelControl(parent);
        }
        return this.getChangeControl(parent);
    }

    public boolean getBooleanValue() {
        return this.checkBox.getSelection();
    }

    protected Button getChangeControl(Composite parent) {
        if (this.checkBox == null) {
            this.checkBox = this.getConfigurationPage().getWidgetToolkit().newButton(parent, null, 16416);
            this.checkBox.setFont(parent.getFont());
            this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = BooleanFieldEditor.this.checkBox.getSelection();
                    BooleanFieldEditor.this.valueChanged(BooleanFieldEditor.this.wasSelected, isSelected);
                    BooleanFieldEditor.this.wasSelected = isSelected;
                }
            });
            this.checkBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    BooleanFieldEditor.this.checkBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.checkBox, parent);
        }
        return this.checkBox;
    }

    @Override
    public int getNumberOfControls() {
        switch (this.style) {
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    @Override
    public void setFocus() {
        if (this.checkBox != null) {
            this.checkBox.setFocus();
        }
    }

    @Override
    public void setLabelText(String text) {
        super.setLabelText(text);
        Label label = this.getLabelControl();
        if (label == null && this.checkBox != null) {
            this.checkBox.setText(text);
        }
    }

    @Override
    public void setToolTipText(String string) {
        if (this.checkBox != null) {
            this.checkBox.setToolTipText(string);
        } else {
            super.setToolTipText(string);
        }
    }

    protected void valueChanged(boolean oldValue, boolean newValue) {
        this.setPresentsDefaultValue(false);
        if (oldValue != newValue) {
            this.fireStateChanged(this.fStoreKey, oldValue, newValue);
            this.fValue = newValue;
        }
        this.updateLaunchConfigurationDialog();
    }

    @Override
    public void setEnabled(boolean enabled, Composite parent) {
        if (this.style == 1) {
            super.setEnabled(enabled, parent);
        }
        this.getChangeControl(parent).setEnabled(enabled);
    }

    public void setEnabled(boolean enabled) {
        if (this.checkBox != null) {
            if (this.style == 1) {
                super.setEnabled(enabled, this.checkBox.getParent());
            }
            this.checkBox.setEnabled(enabled);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.checkBox != null) {
            this.checkBox.addSelectionListener(listener);
        }
    }

    @Override
    protected void setDefaultsImpl(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(this.getStoreKey(), this.fDefaultValue);
    }

    @Override
    protected void initializeFromImpl(ILaunchConfiguration configuration) {
        try {
            this.setBooleanValue(configuration.getAttribute(this.getStoreKey(), this.fDefaultValue));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void setBooleanValue(boolean bValue) {
        if (this.checkBox != null) {
            this.fValue = this.checkBox.getSelection();
            if (this.fValue != bValue) {
                this.checkBox.setSelection(bValue);
                this.valueChanged(this.wasSelected, bValue);
                this.wasSelected = bValue;
            }
        }
    }

    @Override
    protected void performApplyImpl(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isValid()) {
            configuration.setAttribute(this.getStoreKey(), this.fValue);
        }
    }
}

