/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.impl;

import org.eclipse.efm.ecore.formalml.FormalmlFactory;
import org.eclipse.efm.ecore.formalml.FormalmlPackage;
import org.eclipse.efm.ecore.formalml.XliaAttribute;
import org.eclipse.efm.ecore.formalml.XliaModel;
import org.eclipse.efm.ecore.formalml.XliaModelKind;
import org.eclipse.efm.ecore.formalml.XliaNamedElement;
import org.eclipse.efm.ecore.formalml.XliaObject;
import org.eclipse.efm.ecore.formalml.impl.XliaAttributeImpl;
import org.eclipse.efm.ecore.formalml.impl.XliaModelImpl;
import org.eclipse.efm.ecore.formalml.impl.XliaNamedElementImpl;
import org.eclipse.efm.ecore.formalml.impl.XliaObjectImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class FormalmlFactoryImpl
extends EFactoryImpl
implements FormalmlFactory {
    public static FormalmlFactory init() {
        try {
            FormalmlFactory theFormalmlFactory = (FormalmlFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/efm/FormalML");
            if (theFormalmlFactory != null) {
                return theFormalmlFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new FormalmlFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createXliaModel();
            }
            case 1: {
                return this.createXliaNamedElement();
            }
            case 2: {
                return this.createXliaObject();
            }
            case 3: {
                return this.createXliaAttribute();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.createXliaModelKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.convertXliaModelKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public XliaModel createXliaModel() {
        XliaModelImpl xliaModel = new XliaModelImpl();
        return xliaModel;
    }

    @Override
    public XliaNamedElement createXliaNamedElement() {
        XliaNamedElementImpl xliaNamedElement = new XliaNamedElementImpl();
        return xliaNamedElement;
    }

    @Override
    public XliaObject createXliaObject() {
        XliaObjectImpl xliaObject = new XliaObjectImpl();
        return xliaObject;
    }

    @Override
    public XliaAttribute createXliaAttribute() {
        XliaAttributeImpl xliaAttribute = new XliaAttributeImpl();
        return xliaAttribute;
    }

    public XliaModelKind createXliaModelKindFromString(EDataType eDataType, String initialValue) {
        XliaModelKind result = XliaModelKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertXliaModelKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public FormalmlPackage getFormalmlPackage() {
        return (FormalmlPackage)this.getEPackage();
    }

    @Deprecated
    public static FormalmlPackage getPackage() {
        return FormalmlPackage.eINSTANCE;
    }
}

