/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.datatype;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PrimitiveNumberSign implements Enumerator
{
    ANY(0, "any", "any"),
    NEGATIVE(-1, "negative", "negative"),
    NEGATIVE_STRICT(-2, "negative_strict", "negative_strict"),
    POSITIVE(1, "positive", "positive"),
    POSITIVE_STRICT(2, "positive_strict", "positive_strict");

    public static final int ANY_VALUE = 0;
    public static final int NEGATIVE_VALUE = -1;
    public static final int NEGATIVE_STRICT_VALUE = -2;
    public static final int POSITIVE_VALUE = 1;
    public static final int POSITIVE_STRICT_VALUE = 2;
    private static final PrimitiveNumberSign[] VALUES_ARRAY;
    public static final List<PrimitiveNumberSign> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PrimitiveNumberSign[]{ANY, NEGATIVE, NEGATIVE_STRICT, POSITIVE, POSITIVE_STRICT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PrimitiveNumberSign get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveNumberSign result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveNumberSign getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveNumberSign result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveNumberSign get(int value) {
        switch (value) {
            case 0: {
                return ANY;
            }
            case -1: {
                return NEGATIVE;
            }
            case -2: {
                return NEGATIVE_STRICT;
            }
            case 1: {
                return POSITIVE;
            }
            case 2: {
                return POSITIVE_STRICT;
            }
        }
        return null;
    }

    private PrimitiveNumberSign(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

