/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.formalml.xtext.ui.labeling;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.efm.ecore.formalml.common.NamedElement;
import org.eclipse.efm.ecore.formalml.common.QualifiedName;
import org.eclipse.efm.ecore.formalml.common.Type;
import org.eclipse.efm.ecore.formalml.datatype.ChoiceType;
import org.eclipse.efm.ecore.formalml.datatype.CollectionType;
import org.eclipse.efm.ecore.formalml.datatype.DataSupportedType;
import org.eclipse.efm.ecore.formalml.datatype.DataType;
import org.eclipse.efm.ecore.formalml.datatype.DataTypeReference;
import org.eclipse.efm.ecore.formalml.datatype.EnumerationLiteral;
import org.eclipse.efm.ecore.formalml.datatype.EnumerationType;
import org.eclipse.efm.ecore.formalml.datatype.IntervalType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveBooleanType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveCharacterType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveFloatType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveInstanceType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveIntegerType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveRationalType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveRealType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveStringType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveTimeType;
import org.eclipse.efm.ecore.formalml.datatype.PrimitiveType;
import org.eclipse.efm.ecore.formalml.datatype.StructureType;
import org.eclipse.efm.ecore.formalml.datatype.UnionType;
import org.eclipse.efm.ecore.formalml.expression.AssignmentExpression;
import org.eclipse.efm.ecore.formalml.expression.AssociativeExpression;
import org.eclipse.efm.ecore.formalml.expression.BinaryExpression;
import org.eclipse.efm.ecore.formalml.expression.Expression;
import org.eclipse.efm.ecore.formalml.expression.ExpressionAsPort;
import org.eclipse.efm.ecore.formalml.expression.IncrementOrDecrementExpression;
import org.eclipse.efm.ecore.formalml.expression.IncrementOrDecrementPostfixExpression;
import org.eclipse.efm.ecore.formalml.expression.IncrementOrDecrementPrefixExpression;
import org.eclipse.efm.ecore.formalml.expression.InstantiationExpression;
import org.eclipse.efm.ecore.formalml.expression.InvokeExpression;
import org.eclipse.efm.ecore.formalml.expression.LeftHandSideExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralBooleanExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralCharacterExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralCollectionExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralEnvExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralFloatExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralIntegerExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralNullExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralParentExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralRationalExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralRealExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralReferenceElement;
import org.eclipse.efm.ecore.formalml.expression.LiteralSelfExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralStringExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralSuperExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralSystemExpression;
import org.eclipse.efm.ecore.formalml.expression.LiteralThisExpression;
import org.eclipse.efm.ecore.formalml.expression.NewfreshExpression;
import org.eclipse.efm.ecore.formalml.expression.RelationalTernaryExpression;
import org.eclipse.efm.ecore.formalml.expression.TupleExpression;
import org.eclipse.efm.ecore.formalml.expression.UnaryExpression;
import org.eclipse.efm.ecore.formalml.expression.ValueElementSpecification;
import org.eclipse.efm.ecore.formalml.expression.ValueElementSpecificationKind;
import org.eclipse.efm.ecore.formalml.infrastructure.Behavior;
import org.eclipse.efm.ecore.formalml.infrastructure.Buffer;
import org.eclipse.efm.ecore.formalml.infrastructure.ChannelDirection;
import org.eclipse.efm.ecore.formalml.infrastructure.ComCastKind;
import org.eclipse.efm.ecore.formalml.infrastructure.ComPoint;
import org.eclipse.efm.ecore.formalml.infrastructure.ComProtocol;
import org.eclipse.efm.ecore.formalml.infrastructure.ComProtocolKind;
import org.eclipse.efm.ecore.formalml.infrastructure.Connector;
import org.eclipse.efm.ecore.formalml.infrastructure.InstanceMachine;
import org.eclipse.efm.ecore.formalml.infrastructure.Machine;
import org.eclipse.efm.ecore.formalml.infrastructure.ModelOfExecution;
import org.eclipse.efm.ecore.formalml.infrastructure.ModelOfInteraction;
import org.eclipse.efm.ecore.formalml.infrastructure.Parameter;
import org.eclipse.efm.ecore.formalml.infrastructure.ParameterDirectionKind;
import org.eclipse.efm.ecore.formalml.infrastructure.Port;
import org.eclipse.efm.ecore.formalml.infrastructure.PropertyDefinition;
import org.eclipse.efm.ecore.formalml.infrastructure.Route;
import org.eclipse.efm.ecore.formalml.infrastructure.Routine;
import org.eclipse.efm.ecore.formalml.infrastructure.Signal;
import org.eclipse.efm.ecore.formalml.infrastructure.SlotProperty;
import org.eclipse.efm.ecore.formalml.infrastructure.System;
import org.eclipse.efm.ecore.formalml.infrastructure.Variable;
import org.eclipse.efm.ecore.formalml.statemachine.FinalState;
import org.eclipse.efm.ecore.formalml.statemachine.Pseudostate;
import org.eclipse.efm.ecore.formalml.statemachine.PseudostateKind;
import org.eclipse.efm.ecore.formalml.statemachine.Region;
import org.eclipse.efm.ecore.formalml.statemachine.StartState;
import org.eclipse.efm.ecore.formalml.statemachine.State;
import org.eclipse.efm.ecore.formalml.statemachine.Statemachine;
import org.eclipse.efm.ecore.formalml.statemachine.Transition;
import org.eclipse.efm.ecore.formalml.statemachine.TransitionMoc;
import org.eclipse.efm.ecore.formalml.statemachine.TransitionMoe;
import org.eclipse.efm.ecore.formalml.statement.ActivityStatement;
import org.eclipse.efm.ecore.formalml.statement.AssignmentStatement;
import org.eclipse.efm.ecore.formalml.statement.BlockStatement;
import org.eclipse.efm.ecore.formalml.statement.ConditionalBlockStatement;
import org.eclipse.efm.ecore.formalml.statement.DoWhileStatement;
import org.eclipse.efm.ecore.formalml.statement.ExpressionStatement;
import org.eclipse.efm.ecore.formalml.statement.ForEachStatement;
import org.eclipse.efm.ecore.formalml.statement.ForStatement;
import org.eclipse.efm.ecore.formalml.statement.GuardStatement;
import org.eclipse.efm.ecore.formalml.statement.IfStatement;
import org.eclipse.efm.ecore.formalml.statement.InputComStatement;
import org.eclipse.efm.ecore.formalml.statement.InterruptStatement;
import org.eclipse.efm.ecore.formalml.statement.OutputComStatement;
import org.eclipse.efm.ecore.formalml.statement.Statement;
import org.eclipse.efm.ecore.formalml.statement.TimedGuardStatement;
import org.eclipse.efm.ecore.formalml.statement.WhileDoStatement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

public class FormalMLLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    private IQualifiedNameProvider nameProvider;

    @Inject
    public FormalMLLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    public String fqnString(QualifiedName qualifiedname) {
        boolean _tripleNotEquals;
        String _path;
        String _xblockexpression = null;
        String path = "";
        String sep = "";
        EList _nameBinding = qualifiedname.getNameBinding();
        for (String name : _nameBinding) {
            _path = path;
            path = String.valueOf(_path) + sep + name;
            boolean _isEmpty = sep.isEmpty();
            if (!_isEmpty) continue;
            sep = ".";
        }
        String _unqualifiedName = qualifiedname.getUnqualifiedName();
        boolean bl = _tripleNotEquals = _unqualifiedName != null;
        if (_tripleNotEquals) {
            _path = path;
            String _unqualifiedName_1 = qualifiedname.getUnqualifiedName();
            String _plus = String.valueOf(sep) + _unqualifiedName_1;
            path = String.valueOf(_path) + _plus;
        }
        _xblockexpression = path;
        return _xblockexpression;
    }

    public String text(NamedElement decl) {
        String _xblockexpression = null;
        org.eclipse.xtext.naming.QualifiedName fqn = this.nameProvider.getFullyQualifiedName((EObject)decl);
        String _elvis = null;
        String _string = null;
        if (fqn != null) {
            _string = fqn.toString();
        }
        if (_string != null) {
            _elvis = _string;
        } else {
            String _plus;
            String _elvis_1 = null;
            String _name = decl.getName();
            _elvis_1 = _name != null ? _name : "<unamed>";
            _elvis = _plus = "no qfn: " + _elvis_1;
        }
        _xblockexpression = _elvis;
        return _xblockexpression;
    }

    public String text(PropertyDefinition decl) {
        String _xblockexpression = null;
        org.eclipse.xtext.naming.QualifiedName fqn = this.nameProvider.getFullyQualifiedName((EObject)decl);
        String _elvis = null;
        String _string = null;
        if (fqn != null) {
            _string = fqn.toString();
        }
        if (_string != null) {
            _elvis = _string;
        } else {
            String _plus;
            String _elvis_1 = null;
            String _name = decl.getName();
            _elvis_1 = _name != null ? _name : "<property>";
            _elvis = _plus = "no qfn: " + _elvis_1;
        }
        _xblockexpression = _elvis;
        return _xblockexpression;
    }

    public String text(Parameter decl) {
        String _elvis = null;
        String _name = decl.getName();
        _elvis = _name != null ? _name : "<parameter>";
        return _elvis;
    }

    public String image(Parameter decl) {
        String _switchResult = null;
        ParameterDirectionKind _direction = decl.getDirection();
        if (_direction != null) {
            switch (_direction) {
                case IN: {
                    _switchResult = "fml/Parameter_in.gif";
                    break;
                }
                case OUT: {
                    _switchResult = "fml/Parameter_out.gif";
                    break;
                }
                case INOUT: {
                    _switchResult = "fml/Parameter_inout.gif";
                    break;
                }
                case RETURN: {
                    _switchResult = "fml/Parameter_return.gif";
                    break;
                }
                default: {
                    _switchResult = "fml/Port.gif";
                    break;
                }
            }
        } else {
            _switchResult = "fml/Port.gif";
        }
        return _switchResult;
    }

    public String text(Port decl) {
        String _xblockexpression = null;
        org.eclipse.xtext.naming.QualifiedName fqn = this.nameProvider.getFullyQualifiedName((EObject)decl);
        String _xifexpression = null;
        if (fqn != null) {
            _xifexpression = fqn.toString();
        } else {
            String _elvis = null;
            String _name = decl.getName();
            _elvis = _name != null ? _name : "<port>";
            _xifexpression = "no qfn: " + _elvis;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String image(Port port) {
        String _switchResult = null;
        ChannelDirection _direction = port.getDirection();
        if (_direction != null) {
            switch (_direction) {
                case INPUT: {
                    _switchResult = "fml/InputPin.gif";
                    break;
                }
                case OUTPUT: {
                    _switchResult = "fml/OutputPin.gif";
                    break;
                }
                case INOUT: {
                    _switchResult = "fml/FlowProperty.gif";
                    break;
                }
                default: {
                    _switchResult = "fml/Port.gif";
                    break;
                }
            }
        } else {
            _switchResult = "fml/Port.gif";
        }
        return _switchResult;
    }

    public String text(Signal decl) {
        String _xblockexpression = null;
        org.eclipse.xtext.naming.QualifiedName fqn = this.nameProvider.getFullyQualifiedName((EObject)decl);
        String _xifexpression = null;
        if (fqn != null) {
            _xifexpression = fqn.toString();
        } else {
            String _elvis = null;
            String _name = decl.getName();
            _elvis = _name != null ? _name : "<signal>";
            _xifexpression = "no qfn: " + _elvis;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String image(Signal decl) {
        return "fml/Signal.gif";
    }

    public String text(Buffer decl) {
        String _xblockexpression = null;
        org.eclipse.xtext.naming.QualifiedName fqn = this.nameProvider.getFullyQualifiedName((EObject)decl);
        String _xifexpression = null;
        if (fqn != null) {
            _xifexpression = fqn.toString();
        } else {
            String _elvis = null;
            String _name = decl.getName();
            _elvis = _name != null ? _name : "<buffer>";
            _xifexpression = "no qfn: " + _elvis;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String image(Buffer decl) {
        return "fml/Signal.gif";
    }

    public String text(Variable decl) {
        String _xblockexpression = null;
        org.eclipse.xtext.naming.QualifiedName fqn = this.nameProvider.getFullyQualifiedName((EObject)decl);
        String _xifexpression = null;
        if (fqn != null) {
            _xifexpression = fqn.toString();
        } else {
            String _xifexpression_1 = null;
            if (decl.getName() == null && decl.getType() != null) {
                _xifexpression_1 = this.text(decl.getType());
            } else {
                String _elvis = null;
                String _name = decl.getName();
                _elvis = _name != null ? _name : "<variable>";
                _xifexpression_1 = "no qfn: " + _elvis;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String image(Variable decl) {
        return "fml/Property.gif";
    }

    public String text(SlotProperty slot) {
        String _xifexpression = null;
        PropertyDefinition _xliaProperty = slot.getXliaProperty();
        boolean _tripleNotEquals = _xliaProperty != null;
        _xifexpression = _tripleNotEquals ? this.text(slot.getXliaProperty()) : "<slot>";
        return _xifexpression;
    }

    public String image(SlotProperty slot) {
        String _xifexpression = null;
        PropertyDefinition _xliaProperty = slot.getXliaProperty();
        boolean _tripleNotEquals = _xliaProperty != null;
        _xifexpression = _tripleNotEquals ? "fml/QualifierValue.gif" : "fml/Property.gif";
        return _xifexpression;
    }

    public String text(Type type) {
        String _xblockexpression = null;
        org.eclipse.xtext.naming.QualifiedName fqn = this.nameProvider.getFullyQualifiedName((EObject)type);
        String _xifexpression = null;
        if (fqn != null) {
            _xifexpression = fqn.toString();
        } else {
            String _elvis = null;
            String _name = type.getName();
            _elvis = _name != null ? _name : "<type>";
            _xifexpression = "no qfn: " + _elvis;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String text(DataType type) {
        String _xblockexpression = null;
        org.eclipse.xtext.naming.QualifiedName fqn = this.nameProvider.getFullyQualifiedName((EObject)type);
        String _xifexpression = null;
        if (fqn != null) {
            _xifexpression = fqn.toString();
        } else {
            String _elvis = null;
            String _name = type.getName();
            _elvis = _name != null ? _name : "<datatype>";
            _xifexpression = "no qfn: " + _elvis;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String image(DataType type) {
        String _switchResult = null;
        boolean _matched = false;
        if (type instanceof PrimitiveType) {
            _matched = true;
            _switchResult = "fml/PrimitiveType.gif";
        }
        if (!_matched && type instanceof EnumerationType) {
            _matched = true;
            _switchResult = "fml/Enumeration.gif";
        }
        if (!_matched && type instanceof IntervalType) {
            _matched = true;
            _switchResult = "fml/IntervalType.gif";
        }
        if (!_matched && type instanceof StructureType) {
            _matched = true;
            _switchResult = "fml/StructureType.gif";
        }
        if (!_matched && type instanceof UnionType) {
            _matched = true;
            _switchResult = "fml/UnionType.gif";
        }
        if (!_matched && type instanceof ChoiceType) {
            _matched = true;
            _switchResult = "fml/ChoiceType.gif";
        }
        if (!_matched && type instanceof DataTypeReference) {
            boolean _tripleNotEquals;
            _matched = true;
            String _xifexpression = null;
            DataType _typeref = ((DataTypeReference)type).getTyperef();
            boolean bl = _tripleNotEquals = _typeref != null;
            if (_tripleNotEquals) {
                _xifexpression = this.image(((DataTypeReference)type).getTyperef());
            } else {
                String _xifexpression_1 = null;
                DataType _support = ((DataTypeReference)type).getSupport();
                boolean _tripleNotEquals_1 = _support != null;
                _xifexpression_1 = _tripleNotEquals_1 ? this.image(((DataTypeReference)type).getSupport()) : "fml/DataType.gif";
                _xifexpression = _xifexpression_1;
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && type instanceof DataSupportedType) {
            _matched = true;
            _switchResult = this.image(((DataSupportedType)type).getSupport());
        }
        if (!_matched) {
            _switchResult = "fml/DataType.gif";
        }
        return _switchResult;
    }

    public String text(DataTypeReference type) {
        boolean _tripleNotEquals_4;
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        String _xifexpression = null;
        String _name = type.getName();
        boolean bl = _tripleNotEquals = _name != null;
        if (_tripleNotEquals) {
            boolean _tripleNotEquals_1;
            String _xifexpression_1 = null;
            DataType _typeref = type.getTyperef();
            boolean bl2 = _tripleNotEquals_1 = _typeref != null;
            if (_tripleNotEquals_1) {
                String _name_1 = type.getName();
                String _plus = String.valueOf(_name_1) + " ";
                String _text = this.text(type.getTyperef());
                _xifexpression_1 = String.valueOf(_plus) + _text;
            } else {
                _xifexpression_1 = type.getName();
            }
            _xifexpression = _xifexpression_1;
        } else {
            boolean _tripleNotEquals_2;
            String _xifexpression_2 = null;
            DataType _typeref_1 = type.getTyperef();
            boolean bl3 = _tripleNotEquals_2 = _typeref_1 != null;
            if (_tripleNotEquals_2) {
                _xifexpression_2 = this.text(type.getTyperef());
            } else {
                String _xifexpression_3 = null;
                DataType _support = type.getSupport();
                boolean _tripleNotEquals_3 = _support != null;
                _xifexpression_3 = _tripleNotEquals_3 ? this.text(type.getSupport()) : "<datatype>";
                _xifexpression_2 = _xifexpression_3;
            }
            _xifexpression = _xifexpression_2;
        }
        String str = _xifexpression;
        String _xifexpression_4 = null;
        Expression _multiplicity = type.getMultiplicity();
        boolean bl4 = _tripleNotEquals_4 = _multiplicity != null;
        if (_tripleNotEquals_4) {
            Expression _multiplicity_1 = type.getMultiplicity();
            String _plus_1 = String.valueOf(str) + " [ " + _multiplicity_1;
            _xifexpression_4 = String.valueOf(_plus_1) + " ]";
        } else {
            _xifexpression_4 = str;
        }
        _xblockexpression = _xifexpression_4;
        return _xblockexpression;
    }

    public String image(DataTypeReference type) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        DataType _typeref = type.getTyperef();
        boolean bl = _tripleNotEquals = _typeref != null;
        if (_tripleNotEquals) {
            _xifexpression = this.image(type.getTyperef());
        } else {
            String _xifexpression_1 = null;
            DataType _support = type.getSupport();
            boolean _tripleNotEquals_1 = _support != null;
            _xifexpression_1 = _tripleNotEquals_1 ? this.text(type.getSupport()) : "fml/DataType.gif";
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public String text(EnumerationType type) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        String _name = type.getName();
        boolean bl = _tripleNotEquals = _name != null;
        if (_tripleNotEquals) {
            String _name_1 = type.getName();
            _xifexpression = "enum " + _name_1;
        } else {
            _xifexpression = "<enum>";
        }
        return _xifexpression;
    }

    public String image(EnumerationType type) {
        return "fml/Enumeration.gif";
    }

    public String text(EnumerationLiteral literal) {
        return literal.getName();
    }

    public String image(EnumerationLiteral literal) {
        return "fml/EnumerationLiteral.gif";
    }

    public String text(CollectionType type) {
        String _string = type.getContainer().toString();
        String _plus = String.valueOf(_string) + " ";
        String _elvis = null;
        String _name = type.getName();
        _elvis = _name != null ? _name : "";
        String _plus_1 = String.valueOf(_plus) + _elvis;
        String _xifexpression = null;
        if (type.isUnbounded() || type.getSize() < 0) {
            _xifexpression = " [*]";
        } else {
            int _size = type.getSize();
            String _plus_2 = " [ " + Integer.valueOf(_size);
            _xifexpression = String.valueOf(_plus_2) + " ]";
        }
        return String.valueOf(_plus_1) + _xifexpression;
    }

    public String image(CollectionType type) {
        return this.image(type.getSupport());
    }

    public String text(StructureType type) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        String _name = type.getName();
        boolean bl = _tripleNotEquals = _name != null;
        if (_tripleNotEquals) {
            String _name_1 = type.getName();
            _xifexpression = "struct " + _name_1;
        } else {
            _xifexpression = "<struct>";
        }
        return _xifexpression;
    }

    public String image(StructureType type) {
        return "fml/StructureType.gif";
    }

    public String text(UnionType type) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        String _name = type.getName();
        boolean bl = _tripleNotEquals = _name != null;
        if (_tripleNotEquals) {
            String _name_1 = type.getName();
            _xifexpression = "union " + _name_1;
        } else {
            _xifexpression = "<union>";
        }
        return _xifexpression;
    }

    public String image(UnionType type) {
        return "fml/UnionType.gif";
    }

    public String text(ChoiceType type) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        String _name = type.getName();
        boolean bl = _tripleNotEquals = _name != null;
        if (_tripleNotEquals) {
            String _name_1 = type.getName();
            _xifexpression = "choice " + _name_1;
        } else {
            _xifexpression = "<choice>";
        }
        return _xifexpression;
    }

    public String image(ChoiceType type) {
        return "fml/ChoiceType.gif";
    }

    public String text(PrimitiveBooleanType type) {
        return "boolean";
    }

    public String text(PrimitiveIntegerType type) {
        return "integer";
    }

    public String text(PrimitiveRationalType type) {
        return "rational";
    }

    public String text(PrimitiveFloatType type) {
        return "float";
    }

    public String text(PrimitiveRealType type) {
        return "real";
    }

    public String text(PrimitiveTimeType type) {
        String _xifexpression = null;
        boolean _isClock = type.isClock();
        _xifexpression = _isClock ? "clock" : "time";
        return _xifexpression;
    }

    public String text(PrimitiveCharacterType type) {
        return "char";
    }

    public String text(PrimitiveStringType type) {
        return "string";
    }

    public String text(PrimitiveInstanceType type) {
        boolean _tripleNotEquals;
        String _string = type.getExpected().toString();
        String _xifexpression = null;
        NamedElement _model = type.getModel();
        boolean bl = _tripleNotEquals = _model != null;
        if (_tripleNotEquals) {
            String _name = type.getModel().getName();
            String _plus = "< " + _name;
            _xifexpression = String.valueOf(_plus) + " >";
        } else {
            _xifexpression = "";
        }
        return String.valueOf(_string) + _xifexpression;
    }

    public String text(IntervalType type) {
        String _elvis = null;
        String _name = type.getName();
        _elvis = _name != null ? _name : "";
        String _plus = "interval " + _elvis;
        String _xifexpression = null;
        boolean _isLopen = type.isLopen();
        _xifexpression = _isLopen ? "] " : " [ ";
        String _plus_1 = String.valueOf(_plus) + _xifexpression;
        String _xifexpression_1 = null;
        boolean _isRopen = type.isRopen();
        _xifexpression_1 = _isRopen ? "[" : "]";
        return String.valueOf(_plus_1) + _xifexpression_1;
    }

    public String image(IntervalType type) {
        return "fml/IntervalType.gif";
    }

    public String image(PrimitiveType type) {
        return "fml/PrimitiveType.gif";
    }

    public String text(Behavior behavior) {
        String _xifexpression = null;
        EObject _eContainer = behavior.eContainer();
        Behavior _main = ((Machine)_eContainer).getMain();
        boolean _equals = Objects.equal((Object)behavior, (Object)_main);
        _xifexpression = _equals ? "Main Behavior" : "Behavior";
        return _xifexpression;
    }

    public String image(Behavior behavior) {
        String _xifexpression = null;
        EObject _eContainer = behavior.eContainer();
        Behavior _main = ((Machine)_eContainer).getMain();
        boolean _equals = Objects.equal((Object)behavior, (Object)_main);
        _xifexpression = _equals ? "fml/BehaviorExecutionSpecification.gif" : "fml/BehaviorExecutionSpecification.gif";
        return _xifexpression;
    }

    public CharSequence text(Region region) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        String _name = region.getName();
        boolean bl = _tripleNotEquals = _name != null;
        if (_tripleNotEquals) {
            boolean _tripleNotEquals_1;
            StyledString _xblockexpression = null;
            String _name_1 = region.getName();
            StyledString str = new StyledString(_name_1);
            StyledString _xifexpression_1 = null;
            String _unrestrictedName = region.getUnrestrictedName();
            boolean bl2 = _tripleNotEquals_1 = _unrestrictedName != null;
            if (_tripleNotEquals_1) {
                String _unrestrictedName_1 = region.getUnrestrictedName();
                String _plus = " " + _unrestrictedName_1;
                StyledString _styledString = new StyledString(_plus, StyledString.DECORATIONS_STYLER);
                _xifexpression_1 = str.append(_styledString);
            } else {
                _xifexpression_1 = str;
            }
            _xblockexpression = _xifexpression_1;
            _xifexpression = _xblockexpression;
        } else {
            String _xifexpression_1 = null;
            EObject _eContainer = region.eContainer();
            _xifexpression_1 = _eContainer instanceof Statemachine ? "Statemachine Region" : "State Region";
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public String image(Region region) {
        return "fml/Region.gif";
    }

    public StyledString text(System system) {
        boolean _tripleNotEquals;
        StyledString _xblockexpression = null;
        String _name = system.getName();
        StyledString str = new StyledString(_name);
        StyledString _xifexpression = null;
        String _unrestrictedName = system.getUnrestrictedName();
        boolean bl = _tripleNotEquals = _unrestrictedName != null;
        if (_tripleNotEquals) {
            String _unrestrictedName_1 = system.getUnrestrictedName();
            String _plus = " " + _unrestrictedName_1;
            StyledString _styledString = new StyledString(_plus, StyledString.DECORATIONS_STYLER);
            _xifexpression = str.append(_styledString);
        } else {
            _xifexpression = str;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String image(System system) {
        return "fml/Block.gif";
    }

    public StyledString text(Machine machine) {
        boolean _tripleNotEquals;
        StyledString _xblockexpression = null;
        String _name = machine.getName();
        StyledString str = new StyledString(_name);
        StyledString _xifexpression = null;
        String _unrestrictedName = machine.getUnrestrictedName();
        boolean bl = _tripleNotEquals = _unrestrictedName != null;
        if (_tripleNotEquals) {
            String _unrestrictedName_1 = machine.getUnrestrictedName();
            String _plus = " " + _unrestrictedName_1;
            StyledString _styledString = new StyledString(_plus, StyledString.DECORATIONS_STYLER);
            _xifexpression = str.append(_styledString);
        } else {
            _xifexpression = str;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String image(Machine machine) {
        return "fml/Block.gif";
    }

    public StyledString text(InstanceMachine instance) {
        boolean _tripleNotEquals;
        StyledString _xblockexpression = null;
        String _name = instance.getName();
        StyledString str = new StyledString(_name);
        StyledString _xifexpression = null;
        String _unrestrictedName = instance.getUnrestrictedName();
        boolean bl = _tripleNotEquals = _unrestrictedName != null;
        if (_tripleNotEquals) {
            String _unrestrictedName_1 = instance.getUnrestrictedName();
            String _plus = " " + _unrestrictedName_1;
            StyledString _styledString = new StyledString(_plus, StyledString.DECORATIONS_STYLER);
            _xifexpression = str.append(_styledString);
        } else {
            StyledString _xifexpression_1 = null;
            if (instance.getSlot().isEmpty() && instance.getModel() != null) {
                StyledString _styledString_1 = new StyledString(" as ", StyledString.DECORATIONS_STYLER);
                String _name_1 = instance.getModel().getName();
                StyledString _styledString_2 = new StyledString(_name_1, StyledString.QUALIFIER_STYLER);
                _xifexpression_1 = str.append(_styledString_1.append(_styledString_2));
            } else {
                _xifexpression_1 = str;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String image(InstanceMachine machine) {
        return "fml/InstanceSpecification.gif";
    }

    public StyledString text(Statemachine statemachine) {
        boolean _tripleNotEquals;
        StyledString _xblockexpression = null;
        String _name = statemachine.getName();
        StyledString str = new StyledString(_name);
        StyledString _xifexpression = null;
        String _unrestrictedName = statemachine.getUnrestrictedName();
        boolean bl = _tripleNotEquals = _unrestrictedName != null;
        if (_tripleNotEquals) {
            String _unrestrictedName_1 = statemachine.getUnrestrictedName();
            String _plus = " " + _unrestrictedName_1;
            StyledString _styledString = new StyledString(_plus, StyledString.DECORATIONS_STYLER);
            _xifexpression = str.append(_styledString);
        } else {
            _xifexpression = str;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String image(Statemachine statemachine) {
        return "fml/StateMachine.gif";
    }

    public StyledString text(State state) {
        boolean _tripleNotEquals;
        StyledString _xblockexpression = null;
        String _name = state.getName();
        StyledString str = new StyledString(_name);
        StyledString _xifexpression = null;
        String _unrestrictedName = state.getUnrestrictedName();
        boolean bl = _tripleNotEquals = _unrestrictedName != null;
        if (_tripleNotEquals) {
            String _unrestrictedName_1 = state.getUnrestrictedName();
            String _plus = " " + _unrestrictedName_1;
            StyledString _styledString = new StyledString(_plus, StyledString.DECORATIONS_STYLER);
            _xifexpression = str.append(_styledString);
        } else {
            _xifexpression = str;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String image(State state) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        EList _region = state.getRegion();
        boolean bl = _tripleNotEquals = _region != null;
        if (_tripleNotEquals) {
            String _xifexpression_1 = null;
            boolean _isEmpty = state.getRegion().isEmpty();
            if (_isEmpty) {
                _xifexpression_1 = "fml/State.gif";
            } else {
                String _xifexpression_2 = null;
                int _size = state.getRegion().size();
                boolean _greaterThan = _size > 1;
                _xifexpression_2 = _greaterThan ? "fml/StateMachine.gif" : "fml/StateMachine.gif";
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = "fml/State.gif";
        }
        return _xifexpression;
    }

    public String image(StartState state) {
        return "fml/State_start.gif";
    }

    public String image(FinalState state) {
        return "fml/FinalState.gif";
    }

    public StyledString text(Pseudostate state) {
        boolean _tripleNotEquals;
        StyledString _xblockexpression = null;
        String _name = state.getName();
        StyledString str = new StyledString(_name);
        StyledString _xifexpression = null;
        String _unrestrictedName = state.getUnrestrictedName();
        boolean bl = _tripleNotEquals = _unrestrictedName != null;
        if (_tripleNotEquals) {
            String _unrestrictedName_1 = state.getUnrestrictedName();
            String _plus = " " + _unrestrictedName_1;
            StyledString _styledString = new StyledString(_plus, StyledString.DECORATIONS_STYLER);
            _xifexpression = str.append(_styledString);
        } else {
            _xifexpression = str;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String image(Pseudostate state) {
        String _switchResult = null;
        PseudostateKind _kind = state.getKind();
        if (_kind != null) {
            switch (_kind) {
                case INITIAL: {
                    _switchResult = "fml/Pseudostate_initial.gif";
                    break;
                }
                case TERMINATE: {
                    _switchResult = "fml/Pseudostate_terminate.gif";
                    break;
                }
                case JUNCTION: {
                    _switchResult = "fml/Pseudostate_junction.gif";
                    break;
                }
                case CHOICE: {
                    _switchResult = "fml/Pseudostate_choice.gif";
                    break;
                }
                case FORK: {
                    _switchResult = "fml/Pseudostate_fork.gif";
                    break;
                }
                case JOIN: {
                    _switchResult = "fml/Pseudostate_join.gif";
                    break;
                }
                case DEEP_HISTORY: {
                    _switchResult = "fml/Pseudostate_deepHistory.gif";
                    break;
                }
                case SHALLOW_HISTORY: {
                    _switchResult = "fml/Pseudostate_shallowHistory.gif";
                    break;
                }
                default: {
                    _switchResult = "fml/State.gif";
                    break;
                }
            }
        } else {
            _switchResult = "fml/State.gif";
        }
        return _switchResult;
    }

    public StyledString text(Transition transition) {
        boolean _tripleNotEquals;
        StyledString _xblockexpression = null;
        String _elvis = null;
        String _name = transition.getName();
        _elvis = _name != null ? _name : "<transition>";
        StyledString str = new StyledString(_elvis);
        StyledString _xifexpression = null;
        String _unrestrictedName = transition.getUnrestrictedName();
        boolean bl = _tripleNotEquals = _unrestrictedName != null;
        if (_tripleNotEquals) {
            String _unrestrictedName_1 = transition.getUnrestrictedName();
            String _plus = " " + _unrestrictedName_1;
            StyledString _styledString = new StyledString(_plus, StyledString.DECORATIONS_STYLER);
            StyledString _append = str.append(_styledString);
            NamedElement _target = transition.getTarget();
            String _name_1 = null;
            if (_target != null) {
                _name_1 = _target.getName();
            }
            String _plus_1 = " --> " + _name_1;
            _xifexpression = _append.append(_plus_1);
        } else {
            NamedElement _target_1 = transition.getTarget();
            String _name_2 = null;
            if (_target_1 != null) {
                _name_2 = _target_1.getName();
            }
            String _plus_2 = " --> " + _name_2;
            _xifexpression = str.append(_plus_2);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String image(Transition transition) {
        return "fml/Transition_local.gif";
    }

    public String text(TransitionMoe moe) {
        int _prior;
        boolean _notEquals_2;
        boolean _isIsElse;
        boolean _notEquals;
        String info = "moe< ";
        TransitionMoc _moc = moe.getMoc();
        boolean bl = _notEquals = !Objects.equal((Object)_moc, (Object)TransitionMoc.SIMPLE);
        if (_notEquals) {
            String _info = info;
            String _string = moe.getMoc().toString();
            String _plus = "moc: " + _string;
            info = String.valueOf(_info) + _plus;
        }
        if (_isIsElse = moe.isIsElse()) {
            boolean _notEquals_1;
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)info, (Object)"moe< ");
            if (_notEquals_1) {
                String _info_1 = info;
                info = String.valueOf(_info_1) + " & ";
            }
            String _info_2 = info;
            info = String.valueOf(_info_2) + "else";
        }
        boolean bl3 = _notEquals_2 = (_prior = moe.getPrior()) != 0;
        if (_notEquals_2) {
            boolean _notEquals_3;
            boolean bl4 = _notEquals_3 = !Objects.equal((Object)info, (Object)"moe< ");
            if (_notEquals_3) {
                String _info_3 = info;
                info = String.valueOf(_info_3) + " , ";
            }
            String _info_4 = info;
            int _prior_1 = moe.getPrior();
            String _plus_1 = "prior: " + Integer.valueOf(_prior_1);
            info = String.valueOf(_info_4) + _plus_1;
        }
        String _info_5 = info;
        info = String.valueOf(_info_5) + " >";
        return info;
    }

    public String image(TransitionMoe moe) {
        return "fml/ExecutionEnvironment.gif";
    }

    public String text(ModelOfExecution moe) {
        return "Model Of Execution";
    }

    public String image(ModelOfExecution moe) {
        return "fml/ExecutionEnvironment.gif";
    }

    public CharSequence text(Routine routine) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        String _name = routine.getName();
        boolean bl = _tripleNotEquals = _name != null;
        if (_tripleNotEquals) {
            boolean _tripleNotEquals_1;
            StyledString _xblockexpression = null;
            String _name_1 = routine.getName();
            StyledString str = new StyledString(_name_1);
            StyledString _xifexpression_1 = null;
            String _unrestrictedName = routine.getUnrestrictedName();
            boolean bl2 = _tripleNotEquals_1 = _unrestrictedName != null;
            if (_tripleNotEquals_1) {
                String _unrestrictedName_1 = routine.getUnrestrictedName();
                String _plus = " " + _unrestrictedName_1;
                StyledString _styledString = new StyledString(_plus, StyledString.DECORATIONS_STYLER);
                _xifexpression_1 = str.append(_styledString);
            } else {
                _xifexpression_1 = str;
            }
            _xblockexpression = _xifexpression_1;
            _xifexpression = _xblockexpression;
        } else {
            String _xifexpression_1 = null;
            EObject _eContainer = routine.eContainer();
            if (_eContainer instanceof ModelOfExecution) {
                Routine _scheduleRoutine;
                Routine _concurrencyRoutine;
                Routine _runRoutine;
                Routine _irunRoutine;
                Routine _disableRoutine;
                Routine _enableRoutine;
                Routine _finalRoutine;
                String _xblockexpression_1 = null;
                EObject _eContainer_1 = routine.eContainer();
                ModelOfExecution moe = (ModelOfExecution)_eContainer_1;
                String _switchResult = null;
                boolean _matched = false;
                Routine _initRoutine = moe.getInitRoutine();
                if (Objects.equal((Object)routine, (Object)_initRoutine)) {
                    _matched = true;
                    _switchResult = "@init";
                }
                if (!_matched && Objects.equal((Object)routine, (Object)(_finalRoutine = moe.getFinalRoutine()))) {
                    _matched = true;
                    _switchResult = "@final";
                }
                if (!_matched && Objects.equal((Object)routine, (Object)(_enableRoutine = moe.getEnableRoutine()))) {
                    _matched = true;
                    _switchResult = "@enable";
                }
                if (!_matched && Objects.equal((Object)routine, (Object)(_disableRoutine = moe.getDisableRoutine()))) {
                    _matched = true;
                    _switchResult = "@disable";
                }
                if (!_matched && Objects.equal((Object)routine, (Object)(_irunRoutine = moe.getIrunRoutine()))) {
                    _matched = true;
                    _switchResult = "@irun";
                }
                if (!_matched && Objects.equal((Object)routine, (Object)(_runRoutine = moe.getRunRoutine()))) {
                    _matched = true;
                    _switchResult = "@run";
                }
                if (!_matched && Objects.equal((Object)routine, (Object)(_concurrencyRoutine = moe.getConcurrencyRoutine()))) {
                    _matched = true;
                    _switchResult = "@concurrency";
                }
                if (!_matched && Objects.equal((Object)routine, (Object)(_scheduleRoutine = moe.getScheduleRoutine()))) {
                    _matched = true;
                    _switchResult = "@schedule";
                }
                if (!_matched) {
                    _switchResult = "Unknown Predefined Routine";
                }
                _xifexpression_1 = _xblockexpression_1 = _switchResult;
            } else {
                _xifexpression_1 = "Anonymous Routine";
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public String image(Routine routine) {
        return "fml/StartClassifierBehaviorAction.gif";
    }

    public String text(ModelOfInteraction moi) {
        return "Model Of Interaction";
    }

    public String image(ModelOfInteraction moi) {
        return "fml/Diagram_Sequence.gif";
    }

    public String text(Connector connector) {
        String _elvis = null;
        String _name = connector.getName();
        _elvis = _name != null ? _name : "Connection";
        return _elvis;
    }

    public String image(Connector connector) {
        return "fml/Connector_assembly.gif";
    }

    public String text(Route route) {
        return "Route";
    }

    public String image(Route route) {
        return "fml/Connector_assembly.gif";
    }

    public String text(ComPoint comPoint) {
        return "<compoint>";
    }

    public String image(ComPoint comPoint) {
        String _switchResult = null;
        ChannelDirection _direction = comPoint.getDirection();
        if (_direction != null) {
            switch (_direction) {
                case INPUT: {
                    _switchResult = "fml/InputPin.gif";
                    break;
                }
                case OUTPUT: {
                    _switchResult = "fml/OutputPin.gif";
                    break;
                }
                case INOUT: {
                    _switchResult = "fml/FlowProperty.gif";
                    break;
                }
                default: {
                    _switchResult = "fml/FlowPort.gif";
                    break;
                }
            }
        } else {
            _switchResult = "fml/FlowPort.gif";
        }
        return _switchResult;
    }

    public String text(ComCastKind cast) {
        String _switchResult = null;
        if (cast != null) {
            switch (cast) {
                case UNICAST: {
                    _switchResult = "unicast";
                    break;
                }
                case ANYCAST: {
                    _switchResult = "anycast";
                    break;
                }
                case MULTICAST: {
                    _switchResult = "multicast";
                    break;
                }
                case BROADCAST: {
                    _switchResult = "broadcast";
                    break;
                }
                case NONE: {
                    _switchResult = "none";
                    break;
                }
            }
        }
        return _switchResult;
    }

    public String text(ComProtocol com) {
        String _switchResult = null;
        ComProtocolKind _protocol = com.getProtocol();
        if (_protocol != null) {
            switch (_protocol) {
                case BUFFER: {
                    boolean _tripleNotEquals;
                    String _xifexpression = null;
                    CollectionType _inner_buffer = com.getInner_buffer();
                    boolean bl = _tripleNotEquals = _inner_buffer != null;
                    if (_tripleNotEquals) {
                        String _text = this.text(com.getInner_buffer());
                        _xifexpression = "buffer: " + _text;
                    } else {
                        boolean _tripleNotEquals_1;
                        String _xifexpression_1 = null;
                        ValueElementSpecification _buffer = com.getBuffer();
                        boolean bl2 = _tripleNotEquals_1 = _buffer != null;
                        if (_tripleNotEquals_1) {
                            String _text_1 = this.text(com.getBuffer());
                            _xifexpression_1 = "buffer: " + _text_1;
                        } else {
                            _xifexpression_1 = "buffer";
                        }
                        _xifexpression = _xifexpression_1;
                    }
                    _switchResult = _xifexpression;
                    break;
                }
                case ENV: {
                    _switchResult = "env";
                    break;
                }
                case RDV: {
                    _switchResult = "rdv";
                    break;
                }
                case MULTI_RDV: {
                    boolean _notEquals;
                    String _xifexpression_2 = null;
                    ComCastKind _cast = com.getCast();
                    boolean bl = _notEquals = !Objects.equal((Object)_cast, (Object)ComCastKind.NONE);
                    if (_notEquals) {
                        String _text_2 = this.text(com.getCast());
                        String _plus = "multirdv< " + _text_2;
                        _xifexpression_2 = String.valueOf(_plus) + " >";
                    } else {
                        _xifexpression_2 = "multirdv";
                    }
                    _switchResult = _xifexpression_2;
                    break;
                }
                case NONE: {
                    _switchResult = this.text(com.getCast());
                    break;
                }
            }
        }
        return _switchResult;
    }

    public String image(ComProtocol com) {
        return "fml/Diagram_Communication.gif";
    }

    public String text(Statement statement) {
        return "Statement";
    }

    public String image(Statement statement) {
        return "fml/ExecutionEnvironment.gif";
    }

    public String text(BlockStatement statement) {
        String _xblockexpression = null;
        String strBlock = "Block";
        EObject _eContainer = statement.eContainer();
        if (_eContainer instanceof IfStatement) {
            EObject _eContainer_1 = statement.eContainer();
            BlockStatement _bodyBlock = ((IfStatement)_eContainer_1).getBodyBlock();
            boolean _equals = Objects.equal((Object)statement, (Object)_bodyBlock);
            if (_equals) {
                strBlock = "then";
            } else {
                EObject _eContainer_2 = statement.eContainer();
                BlockStatement _elseBlock = ((IfStatement)_eContainer_2).getElseBlock();
                boolean _equals_1 = Objects.equal((Object)statement, (Object)_elseBlock);
                if (_equals_1) {
                    strBlock = "else";
                }
            }
        }
        if (statement.getOp() != null && !statement.getOp().isEmpty()) {
            String _strBlock = strBlock;
            String _op = statement.getOp();
            String _plus = " { " + _op;
            String _plus_1 = String.valueOf(_plus) + " }";
            strBlock = String.valueOf(_strBlock) + _plus_1;
        }
        _xblockexpression = strBlock;
        return _xblockexpression;
    }

    public String image(BlockStatement statement) {
        return "fml/Activity.gif";
    }

    public String text(ExpressionStatement statement) {
        String _switchResult = null;
        Expression _expression = statement.getExpression();
        boolean _matched = false;
        if (_expression instanceof AssignmentExpression) {
            _matched = true;
            _switchResult = "assignment";
        }
        if (!_matched && _expression instanceof NewfreshExpression) {
            _matched = true;
            _switchResult = "newfresh";
        }
        if (!_matched && _expression instanceof IncrementOrDecrementPrefixExpression) {
            _matched = true;
            _switchResult = "IncrementOrDecrementPrefix";
        }
        if (!_matched && _expression instanceof IncrementOrDecrementPostfixExpression) {
            _matched = true;
            _switchResult = "IncrementOrDecrementPostfix";
        }
        if (!_matched) {
            _switchResult = "Expression Statement";
        }
        return _switchResult;
    }

    public String text(AssignmentStatement statement) {
        String _operator = statement.getOperator();
        return "assign " + _operator;
    }

    public String text(GuardStatement statement) {
        return "Guard";
    }

    public String image(GuardStatement statement) {
        return "fml/Constraint.gif";
    }

    public String text(TimedGuardStatement statement) {
        return "TimedGuard";
    }

    public String image(TimedGuardStatement statement) {
        return "fml/TimeConstraint.gif";
    }

    public String text(InputComStatement statement) {
        return "<input>";
    }

    public String image(InputComStatement statement) {
        return "fml/InputPin.gif";
    }

    public String text(OutputComStatement statement) {
        return "<output>";
    }

    public String image(OutputComStatement statement) {
        return "fml/OutputPin.gif";
    }

    public String text(ActivityStatement statement) {
        return statement.getOp().toString();
    }

    public String image(ActivityStatement statement) {
        return "fml/CallBehaviorAction.gif";
    }

    public String text(InterruptStatement statement) {
        return statement.getKind().toString();
    }

    public String image(InterruptStatement statement) {
        return "fml/CallBehaviorAction.gif";
    }

    public String text(IfStatement statement) {
        return "if";
    }

    public String image(IfStatement statement) {
        return "fml/Diagram_Activity.gif";
    }

    public String text(ConditionalBlockStatement statement) {
        String _xifexpression = null;
        EObject _eContainer = statement.eContainer();
        _xifexpression = _eContainer instanceof IfStatement ? "elseif" : "Conditional Block";
        return _xifexpression;
    }

    public String image(ConditionalBlockStatement statement) {
        String _xifexpression = null;
        EObject _eContainer = statement.eContainer();
        _xifexpression = _eContainer instanceof IfStatement ? "fml/Diagram_Activity.gif" : "fml/Activity.gif";
        return _xifexpression;
    }

    public String text(ForStatement statement) {
        return "for( ; ; )";
    }

    public String image(ForStatement statement) {
        return "fml/LoopStatement.gif";
    }

    public String text(ForEachStatement statement) {
        return "foreach";
    }

    public String image(ForEachStatement statement) {
        return "fml/LoopStatement.gif";
    }

    public String text(WhileDoStatement statement) {
        return "while(...) do{...}";
    }

    public String image(WhileDoStatement statement) {
        return "fml/LoopStatement.gif";
    }

    public String text(DoWhileStatement statement) {
        return "do{...} while(...)";
    }

    public String image(DoWhileStatement statement) {
        return "fml/LoopStatement.gif";
    }

    public String text(LiteralBooleanExpression expression) {
        boolean _isValue = expression.isValue();
        return "" + Boolean.valueOf(_isValue);
    }

    public String image(LiteralBooleanExpression expression) {
        return "fml/LiteralBoolean.gif";
    }

    public String text(LiteralIntegerExpression expression) {
        long _value = expression.getValue();
        return "" + Long.valueOf(_value);
    }

    public String image(LiteralIntegerExpression expression) {
        return "fml/LiteralInteger.gif";
    }

    public String text(LiteralRationalExpression expression) {
        long _numerator = expression.getNumerator();
        String _plus = "" + Long.valueOf(_numerator);
        String _plus_1 = String.valueOf(_plus) + "/";
        long _denominator = expression.getDenominator();
        return String.valueOf(_plus_1) + Long.valueOf(_denominator);
    }

    public String image(LiteralRationalExpression expression) {
        return "fml/LiteralInteger.gif";
    }

    public String text(LiteralFloatExpression expression) {
        double _value = expression.getValue();
        return "" + Double.valueOf(_value);
    }

    public String image(LiteralFloatExpression expression) {
        return "fml/LiteralReal.gif";
    }

    public String text(LiteralRealExpression expression) {
        double _value = expression.getValue();
        return "" + Double.valueOf(_value);
    }

    public String image(LiteralRealExpression expression) {
        return "fml/LiteralReal.gif";
    }

    public String text(LiteralCharacterExpression expression) {
        String _string = Character.valueOf(expression.getValue()).toString();
        return _string;
    }

    public String image(LiteralCharacterExpression expression) {
        return "fml/LiteralString.gif";
    }

    public String text(LiteralStringExpression expression) {
        String _value = expression.getValue();
        return _value;
    }

    public String image(LiteralStringExpression expression) {
        return "fml/LiteralString.gif";
    }

    public String text(LiteralCollectionExpression expression) {
        return "<collection>";
    }

    public String image(LiteralCollectionExpression expression) {
        return "fml/Variable.gif";
    }

    public String text(LiteralReferenceElement expression) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        NamedElement _value = expression.getValue();
        boolean bl = _tripleNotEquals = _value != null;
        if (_tripleNotEquals) {
            String _xblockexpression = null;
            org.eclipse.xtext.naming.QualifiedName fqn = this.nameProvider.getFullyQualifiedName((EObject)expression.getValue());
            String _elvis = null;
            String _string = null;
            if (fqn != null) {
                _string = fqn.toString();
            }
            if (_string != null) {
                _elvis = _string;
            } else {
                String _plus;
                String _elvis_1 = null;
                String _name = expression.getValue().getName();
                _elvis_1 = _name != null ? _name : "<reference>";
                _elvis = _plus = "no qfn: " + _elvis_1;
            }
            _xifexpression = _xblockexpression = _elvis;
        } else {
            _xifexpression = "<reference>";
        }
        return _xifexpression;
    }

    public Object image(LiteralReferenceElement expression) {
        Object _xifexpression = null;
        NamedElement _value = expression.getValue();
        boolean _tripleNotEquals = _value != null;
        _xifexpression = _tripleNotEquals ? this.image(expression.getValue()) : "fml/QualifierValue.gif";
        return _xifexpression;
    }

    public String text(LiteralThisExpression expression) {
        return "$this";
    }

    public String image(LiteralThisExpression expression) {
        return "fml/QualifierValue.gif";
    }

    public String text(LiteralSelfExpression expression) {
        return "$self";
    }

    public String image(LiteralSelfExpression expression) {
        return "fml/QualifierValue.gif";
    }

    public String text(LiteralSuperExpression expression) {
        return "$super";
    }

    public String image(LiteralSuperExpression expression) {
        return "fml/QualifierValue.gif";
    }

    public String text(LiteralParentExpression expression) {
        return "$parent";
    }

    public String image(LiteralParentExpression expression) {
        return "fml/QualifierValue.gif";
    }

    public String text(LiteralSystemExpression expression) {
        return "$system";
    }

    public String image(LiteralSystemExpression expression) {
        return "fml/QualifierValue.gif";
    }

    public String text(LiteralEnvExpression expression) {
        return "$env";
    }

    public String image(LiteralEnvExpression expression) {
        return "fml/QualifierValue.gif";
    }

    public String text(LiteralNullExpression expression) {
        return "$null";
    }

    public String image(LiteralNullExpression expression) {
        return "fml/LiteralNull.gif";
    }

    public String text(LeftHandSideExpression expression) {
        return "<lvalue>";
    }

    public String image(LeftHandSideExpression expression) {
        return "fml/Variable.gif";
    }

    public String text(InstantiationExpression expression) {
        String _elvis = null;
        InstanceMachine _instance = expression.getInstance();
        Machine _model = null;
        if (_instance != null) {
            _model = _instance.getModel();
        }
        String _name = null;
        if (_model != null) {
            _name = _model.getName();
        }
        _elvis = _name != null ? _name : "<model>";
        return "Instantiation " + _elvis;
    }

    public String image(InvokeExpression expression) {
        return "fml/Parameter_return.gif";
    }

    public String text(TupleExpression expression) {
        String _xifexpression = null;
        _xifexpression = expression.eContainer() instanceof ValueElementSpecification && Objects.equal((Object)((ValueElementSpecification)expression.eContainer()).getKind(), (Object)ValueElementSpecificationKind.INDEX) ? "[i,n,d,e,x]" : "(t,u,p,l,e)";
        return _xifexpression;
    }

    public String image(TupleExpression expression) {
        return "fml/Parameter_in.gif";
    }

    public String text(UnaryExpression expression) {
        String _operator = expression.getOperator();
        return "operator " + _operator;
    }

    public String image(UnaryExpression expression) {
        return "fml/Expression.gif";
    }

    public String text(IncrementOrDecrementPrefixExpression expression) {
        String _operator = expression.getOperator();
        String _plus = "operator " + _operator;
        return String.valueOf(_plus) + "()";
    }

    public String text(IncrementOrDecrementPostfixExpression expression) {
        String _operator = expression.getOperator();
        return "operator ()" + _operator;
    }

    public String image(IncrementOrDecrementExpression expression) {
        return "fml/Expression.gif";
    }

    public String text(BinaryExpression expression) {
        String _operator = expression.getOperator();
        return "operator " + _operator;
    }

    public String image(BinaryExpression expression) {
        return "fml/Expression.gif";
    }

    public String text(RelationalTernaryExpression expression) {
        String _operator = expression.getLeftRelation().getOperator();
        String _plus = String.valueOf(_operator) + " operator ";
        String _rigthOperator = expression.getRigthOperator();
        return String.valueOf(_plus) + _rigthOperator;
    }

    public String image(RelationalTernaryExpression expression) {
        return "fml/Expression.gif";
    }

    public String text(AssignmentExpression expression) {
        String _operator = expression.getOperator();
        return "operator " + _operator;
    }

    public String text(NewfreshExpression expression) {
        return "newfresh";
    }

    public String image(AssignmentExpression expression) {
        return "fml/Expression.gif";
    }

    public String text(AssociativeExpression expression) {
        String _operator = expression.getOperator();
        return "operator " + _operator;
    }

    public String image(AssociativeExpression expression) {
        return "fml/Expression.gif";
    }

    public String text(ValueElementSpecification ves) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        String _xifexpression = null;
        NamedElement _element = ves.getElement();
        boolean bl = _tripleNotEquals = _element != null;
        if (_tripleNotEquals) {
            String _xifexpression_1 = null;
            NamedElement _element_1 = ves.getElement();
            if (_element_1 instanceof NamedElement) {
                NamedElement _element_2 = ves.getElement();
                _xifexpression_1 = _element_2.getName();
            } else {
                _xifexpression_1 = this.text(ves.getElement());
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = "<ves>";
        }
        String str = _xifexpression;
        Expression _arg = ves.getArg();
        boolean bl2 = _tripleNotEquals_1 = _arg != null;
        if (_tripleNotEquals_1) {
            Object _elvis = null;
            Object _text = this.text(ves.getArg());
            _elvis = _text != null ? _text : "<arg>";
            Object arg = _elvis;
            ValueElementSpecificationKind _kind = ves.getKind();
            if (_kind != null) {
                switch (_kind) {
                    case INDEX: {
                        String _str = str;
                        str = String.valueOf(_str) + "[ " + arg + " ]";
                        break;
                    }
                    case PARAMETER: {
                        String _str_1 = str;
                        str = String.valueOf(_str_1) + "( " + arg + " )";
                        break;
                    }
                    default: {
                        String _str_2 = str;
                        str = String.valueOf(_str_2) + " : " + arg;
                        break;
                    }
                }
            } else {
                String _str_2 = str;
                str = String.valueOf(_str_2) + " : " + arg;
            }
        }
        _xblockexpression = str;
        return _xblockexpression;
    }

    public String image(ValueElementSpecification ves) {
        String _switchResult = null;
        ValueElementSpecificationKind _kind = ves.getKind();
        if (_kind != null) {
            switch (_kind) {
                case FIELD: {
                    _switchResult = "fml/Property.gif";
                    break;
                }
                case INDEX: {
                    _switchResult = "fml/Variable.gif";
                    break;
                }
                case PARAMETER: {
                    _switchResult = "fml/Parameter_inout.gif";
                    break;
                }
                default: {
                    _switchResult = "fml/QualifierValue.gif";
                    break;
                }
            }
        } else {
            _switchResult = "fml/QualifierValue.gif";
        }
        return _switchResult;
    }

    public String text(ExpressionAsPort expression) {
        return "<port>";
    }

    public String image(ExpressionAsPort expression) {
        return "fml/Port.gif";
    }
}

