/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.conversions;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ArgumentUtils;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.DataProcessingException;
import org.junit.jupiter.params.shadow.com.univocity.parsers.conversions.FormattedConversion;
import org.junit.jupiter.params.shadow.com.univocity.parsers.conversions.ObjectConversion;

public class DateConversion
extends ObjectConversion<Date>
implements FormattedConversion<SimpleDateFormat> {
    private final SimpleDateFormat[] parsers;
    private final String[] formats;

    public DateConversion(Date valueIfStringIsNull, String valueIfObjectIsNull, String ... dateFormats) {
        super(valueIfStringIsNull, valueIfObjectIsNull);
        ArgumentUtils.noNulls("Date formats", dateFormats);
        this.formats = (String[])dateFormats.clone();
        this.parsers = new SimpleDateFormat[dateFormats.length];
        for (int i = 0; i < dateFormats.length; ++i) {
            String dateFormat = dateFormats[i];
            this.parsers[i] = new SimpleDateFormat(dateFormat);
        }
    }

    public DateConversion(String ... dateFormats) {
        this((Date)null, (String)null, dateFormats);
    }

    @Override
    public String revert(Date input) {
        if (input == null) {
            return super.revert((Object)null);
        }
        return this.parsers[0].format(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Date fromString(String input) {
        for (SimpleDateFormat formatter : this.parsers) {
            try {
                SimpleDateFormat simpleDateFormat = formatter;
                synchronized (simpleDateFormat) {
                    return formatter.parse(input);
                }
            }
            catch (ParseException ex) {
            }
        }
        DataProcessingException exception = new DataProcessingException("Cannot parse '{value}' as a valid date. Supported formats are: " + Arrays.toString(this.formats));
        exception.setValue(input);
        throw exception;
    }

    public SimpleDateFormat[] getFormatterObjects() {
        return this.parsers;
    }
}

