/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine.portals;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.portals.CameraPortal;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.Translucent;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.Vector;

public class RoundCameraPortal
extends CameraPortal {
    Ellipse2D clippingShape;

    public RoundCameraPortal(int x, int y, int w, int h, Camera c) {
        this(x, y, w, h, c, 1.0f);
    }

    public RoundCameraPortal(int x, int y, int w, int h, Camera c, float a) {
        super(x, y, w, h, c);
        this.clippingShape = new Ellipse2D.Float(x, y, w, h);
    }

    @Override
    public double[] getVisibleRegion() {
        return super.getVisibleRegion();
    }

    @Override
    public boolean coordInside(int cx, int cy) {
        return this.clippingShape.contains(cx, cy);
    }

    @Override
    public void move(int dx, int dy) {
        super.move(dx, dy);
        this.clippingShape.setFrame(this.x, this.y, this.w, this.h);
    }

    @Override
    public void moveTo(int x, int y) {
        super.moveTo(x, y);
        this.clippingShape.setFrame(x, y, this.w, this.h);
    }

    @Override
    public void updateDimensions() {
        this.size.setSize(this.w, this.h);
        if (this.clippingShape != null) {
            this.clippingShape.setFrame(this.x, this.y, this.w, this.h);
        } else {
            this.clippingShape = new Ellipse2D.Float(this.x, this.y, this.w, this.h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g2d, int viewWidth, int viewHeight) {
        if (!this.visible) {
            return;
        }
        if (this.alphaC != null) {
            if (this.alphaC.getAlpha() == 0.0f) {
                return;
            }
            g2d.setComposite(this.alphaC);
        }
        g2d.setClip(this.clippingShape);
        if (this.bkgColor != null) {
            g2d.setColor(this.bkgColor);
            g2d.fill(this.clippingShape);
        }
        this.standardStroke = g2d.getStroke();
        this.standardTransform = g2d.getTransform();
        this.drawnGlyphs = this.cameraSpace.getDrawnGlyphs(this.camIndex);
        Vector vector = this.drawnGlyphs;
        synchronized (vector) {
            this.drawnGlyphs.removeAllElements();
            this.duncoef = (this.camera.focal + this.camera.altitude) / this.camera.focal;
            this.viewWC = this.camera.vx - (double)this.w / 2.0 * this.duncoef;
            this.viewNC = this.camera.vy + (double)this.h / 2.0 * this.duncoef;
            this.viewEC = this.camera.vx + (double)this.w / 2.0 * this.duncoef;
            this.viewSC = this.camera.vy - (double)this.h / 2.0 * this.duncoef;
            this.gll = this.cameraSpace.getDrawingList();
            for (int i = 0; i < this.gll.length; ++i) {
                if (this.gll[i] == null) continue;
                Glyph glyph = this.gll[i];
                synchronized (glyph) {
                    if (this.gll[i].visibleInViewport(this.viewWC, this.viewNC, this.viewEC, this.viewSC, this.camera)) {
                        this.gll[i].project(this.camera, this.size);
                        if (this.gll[i].isVisible()) {
                            this.gll[i].draw(g2d, this.w, this.h, this.camIndex, this.standardStroke, this.standardTransform, this.x, this.y);
                        }
                        this.cameraSpace.drewGlyph(this.gll[i], this.camIndex);
                    }
                    continue;
                }
            }
        }
        g2d.setClip(0, 0, viewWidth, viewHeight);
        if (this.borderColor != null) {
            g2d.setColor(this.borderColor);
            g2d.draw(this.clippingShape);
        }
        if (this.alphaC != null) {
            g2d.setComposite(Translucent.acO);
        }
    }
}

