/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.page.overview;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.api.ILaunchConfigurationGUIelement;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.page.overview.OverviewAnalysisProfileSection;
import org.eclipse.efm.execution.configuration.common.ui.page.overview.OverviewWorkspaceDataSection;
import org.eclipse.efm.execution.configuration.common.ui.util.GenericCompositeCreator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class OverviewConfigurationPage
extends AbstractConfigurationPage {
    private String fProjectName;
    private Text fModelPathText;
    private Button fModelWorkspaceBrowse;
    OverviewWorkspaceDataSection fOverviewWorkspaceDataSection;
    OverviewAnalysisProfileSection fAnalysisProfileSection;
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent evt) {
            OverviewConfigurationPage.this.propagateUpdateJobScheduling();
            OverviewConfigurationPage.this.propertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", (Object)OverviewConfigurationPage.this.fModelPathText.getText(), (Object)OverviewConfigurationPage.this.fModelPathText.getText()));
        }
    };

    public OverviewConfigurationPage(ILaunchConfigurationGUIelement masterGUIelement) {
        super(masterGUIelement);
        this.fAnalysisProfileSection = new OverviewAnalysisProfileSection(this);
        this.fOverviewWorkspaceDataSection = new OverviewWorkspaceDataSection(this);
        this.fOverviewWorkspaceDataSection.setExpanded(false);
    }

    @Override
    protected void createContent(Composite parent, IWidgetToolkit widgetToolkit) {
        this.createModelFileSelectionComponent(parent, widgetToolkit);
        this.createWorkspaceComponent(parent, widgetToolkit);
        this.createAnalyseProfileComponent(parent, widgetToolkit);
    }

    private void createModelFileSelectionComponent(final Composite parent, IWidgetToolkit widgetToolkit) {
        Group group = widgetToolkit.createGroup(parent, "&Model File Selection", 1, 1, 768);
        Composite comp = widgetToolkit.createComposite((Composite)group, 3, 1, 768);
        this.fModelPathText = widgetToolkit.createSingleText(comp, 1);
        this.fModelPathText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Model File";
            }
        });
        this.fModelWorkspaceBrowse = widgetToolkit.createPushButton(comp, "&Workspace...", null);
        this.fModelPathText.addModifyListener(this.fBasicModifyListener);
        this.fModelWorkspaceBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle("Select a Diversity Specification");
                dialog.setMessage("Select a resource to redirect output to:");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                    OverviewConfigurationPage.this.fProjectName = resource.getProject().getName();
                    String specFile = resource.getLocation().toString();
                    OverviewConfigurationPage.this.fModelPathText.setText(specFile);
                    OverviewConfigurationPage.this.fOverviewWorkspaceDataSection.updateWorkspaceRootPath(resource);
                }
            }
        });
    }

    protected void createWorkspaceComponent(Composite parent, IWidgetToolkit widgetToolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        Action[] toputinbar = this.getActionsByStringKey(new String[]{"action_apply_changes"});
        GenericCompositeCreator.fillToolBar((IToolBarManager)toolBarManager, toputinbar);
        this.fOverviewWorkspaceDataSection.createControl(parent, (IToolBarManager)toolBarManager, widgetToolkit);
    }

    protected void createAnalyseProfileComponent(Composite parent, IWidgetToolkit widgetToolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        Action[] toputinbar = this.getActionsByStringKey(new String[]{"action_apply_changes"});
        GenericCompositeCreator.fillToolBar((IToolBarManager)toolBarManager, toputinbar);
        this.fAnalysisProfileSection.createControl(parent, (IToolBarManager)toolBarManager, widgetToolkit);
    }

    @Override
    public void setDefaultFieldValues(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_PROJECT_NAME", "<project-name>");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", "<spec-model-file-location>");
        this.fOverviewWorkspaceDataSection.setDefaults(configuration);
        this.fAnalysisProfileSection.setDefaults(configuration);
    }

    @Override
    public void initializeFieldValuesFrom(ILaunchConfiguration configuration) {
        try {
            this.fProjectName = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_PROJECT_NAME", "");
            String specMainFileLocation = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", "<spec-model-file-location>");
            this.fModelPathText.setText(specMainFileLocation);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.fOverviewWorkspaceDataSection.initializeFrom(configuration);
        this.fAnalysisProfileSection.initializeFrom(configuration);
    }

    @Override
    public void applyUpdatesOnFieldValuesFrom(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_PROJECT_NAME", this.fProjectName);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", this.fModelPathText.getText());
        this.fOverviewWorkspaceDataSection.performApply(configuration);
        this.fAnalysisProfileSection.performApply(configuration);
    }

    @Override
    public AbstractConfigurationPage.FieldValidationReturn areFieldsValid(ILaunchConfiguration launchConfig) {
        String messageToSend = null;
        String filePath = this.fModelPathText.getText();
        if (filePath == null || filePath.isEmpty()) {
            messageToSend = "The resource model file path is empty (or null)";
        } else {
            File aFile = new File(filePath);
            if (!aFile.exists()) {
                messageToSend = "The resource model file \"" + filePath + "\" does not exist.";
            } else if (!aFile.isFile()) {
                messageToSend = "The resource model \"" + filePath + "\" is not a file.";
            }
        }
        boolean isValid = this.fOverviewWorkspaceDataSection.isValid(launchConfig) && this.fAnalysisProfileSection.isValid(launchConfig);
        return new AbstractConfigurationPage.FieldValidationReturn(isValid, messageToSend);
    }

    @Override
    protected void handleConfigurationPropertyChange(PropertyChangeEvent event) {
        this.fOverviewWorkspaceDataSection.handleConfigurationPropertyChange(event);
        this.fAnalysisProfileSection.handleConfigurationPropertyChange(event);
    }
}

