/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.ILaunchConfigurationGUIelement;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.core.IWorkflowConfigurationConstants;
import org.eclipse.efm.execution.core.IWorkflowPreferenceConstants;
import org.eclipse.efm.execution.core.SymbexPreferenceUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractConfigurationPage
implements IPropertyChangeListener,
IWorkflowConfigurationConstants,
IWorkflowPreferenceConstants {
    private ILaunchConfigurationGUIelement masterGUIelement;
    protected Composite fControl;
    protected boolean fEnabledSymbexDeveloperMode;
    protected boolean fEnabledSymbexIncubationMode;
    private Map<String, Action> registered_actions;

    public boolean isEnabledSymbexDeveloperMode() {
        return this.fEnabledSymbexDeveloperMode;
    }

    public boolean isEnabledSymbexIncubationMode() {
        return this.fEnabledSymbexIncubationMode;
    }

    public abstract void setDefaultFieldValues(ILaunchConfigurationWorkingCopy var1);

    public abstract void initializeFieldValuesFrom(ILaunchConfiguration var1);

    public abstract void applyUpdatesOnFieldValuesFrom(ILaunchConfigurationWorkingCopy var1);

    public AbstractConfigurationPage(ILaunchConfigurationGUIelement masterGUIelement) {
        Assert.isNotNull((Object)masterGUIelement);
        this.masterGUIelement = masterGUIelement;
        this.fEnabledSymbexDeveloperMode = SymbexPreferenceUtil.getBooleanPreference((String)"org.eclipse.efm.execution.core.PREF_SYMBEX_DEVELOPER_MODE");
        this.fEnabledSymbexIncubationMode = SymbexPreferenceUtil.getBooleanPreference((String)"org.eclipse.efm.execution.core.PREF_INCUBATION_MODE");
        this.registered_actions = new HashMap<String, Action>();
    }

    public void setRegisteredActions(Map<String, Action> acts) {
        this.registered_actions = acts;
    }

    protected Action[] getActionsByStringKey(String[] kids) {
        HashSet<Action> foundActions = new HashSet<Action>();
        String[] stringArray = kids;
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            String kid = stringArray[n2];
            Action current = this.registered_actions.get(kid);
            if (current != null) {
                foundActions.add(current);
            }
            ++n2;
        }
        return foundActions.toArray(new Action[foundActions.size()]);
    }

    public ILaunchConfigurationGUIelement getMasterGUIelement() {
        return this.masterGUIelement;
    }

    public IWidgetToolkit getWidgetToolkit() {
        return this.masterGUIelement.getWidgetToolkit();
    }

    public Composite getControl() {
        return this.fControl;
    }

    public void propertyChange(PropertyChangeEvent event) {
        AbstractConfigurationPage[] abstractConfigurationPageArray = this.getConfigurationPages();
        int n = abstractConfigurationPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractConfigurationPage confPage = abstractConfigurationPageArray[n2];
            confPage.handleConfigurationPropertyChange(event);
            ++n2;
        }
    }

    protected void handleConfigurationPropertyChange(PropertyChangeEvent event) {
    }

    public AbstractConfigurationPage[] getConfigurationPages() {
        return this.masterGUIelement.getConfigurationPages();
    }

    public abstract FieldValidationReturn areFieldsValid(ILaunchConfiguration var1);

    public void createControl(Composite parent, IWidgetToolkit widgetToolkit) {
        this.fControl = widgetToolkit.createComposite(parent, 1, 1, 1808);
        this.createContent(this.fControl, widgetToolkit);
    }

    protected abstract void createContent(Composite var1, IWidgetToolkit var2);

    public void propagateMessage(String message) {
        this.masterGUIelement.setMessage(message);
    }

    public void propagateWarningMessage(String warningmessage) {
        this.masterGUIelement.setWarningMessage(warningmessage);
    }

    public void propagateErrorMessage(String errormessage) {
        this.masterGUIelement.setErrorMessage(errormessage);
    }

    public void propagateGUIupdate() {
        this.masterGUIelement.updateGUI();
    }

    public void setVisibleAndEnabled(Composite aComposite, boolean visible) {
        this.getWidgetToolkit().setVisibleAndEnabled(aComposite, visible);
    }

    public void propagateVisibility(Composite aComposite, boolean visible) {
        this.getWidgetToolkit().propagateVisibility(aComposite, visible);
    }

    public void propagateUpdateJobScheduling() {
        this.masterGUIelement.scheduleUpdateJob();
    }

    public Map<String, Action> getRunnableActions() {
        return this.registered_actions;
    }

    public final class FieldValidationReturn {
        private final boolean fieldValidation;
        private final String reasonString;

        public FieldValidationReturn(boolean fieldValidation, String reasonString) {
            this.fieldValidation = fieldValidation;
            this.reasonString = reasonString;
        }

        public boolean areFieldsValid() {
            return this.fieldValidation;
        }

        public String getReason() {
            return this.reasonString;
        }
    }
}

