/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

class ProcessOutputConsumer
extends Thread {
    private BufferedReader pout;
    private BufferedReader perr;
    private long waitTime = 200L;

    public ProcessOutputConsumer(Process p) throws IOException {
        p.getOutputStream().close();
        this.pout = new BufferedReader(new InputStreamReader(p.getInputStream()));
        this.perr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        this.setDaemon(true);
    }

    public ProcessOutputConsumer(Process p, long waitTime) throws IOException {
        this(p);
        this.waitTime = waitTime;
    }

    public void run() {
        try {
            while (true) {
                if (this.pout.ready()) {
                    this.pout.readLine();
                    continue;
                }
                while (this.perr.ready()) {
                    this.perr.readLine();
                }
                if (this.waitTime <= 0L) continue;
                ProcessOutputConsumer.sleep(this.waitTime);
            }
        }
        catch (IOException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

