/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.svg;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.EView;
import fr.inria.zvtm.engine.SwingWorker;
import fr.inria.zvtm.engine.Utils;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.event.ViewListener;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.svg.Config;
import fr.inria.zvtm.svg.MainEventHandler;
import fr.inria.zvtm.svg.Messages;
import fr.inria.zvtm.svg.Navigation;
import fr.inria.zvtm.svg.Overlay;
import fr.inria.zvtm.svg.SVGReader;
import fr.inria.zvtm.svg.SVGWriter;
import fr.inria.zvtm.svg.VWGlassPane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Scanner;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Viewer {
    static int SCREEN_WIDTH = Toolkit.getDefaultToolkit().getScreenSize().width;
    static int SCREEN_HEIGHT = Toolkit.getDefaultToolkit().getScreenSize().height;
    static int VIEW_MAX_W = 1024;
    static int VIEW_MAX_H = 768;
    int VIEW_W;
    int VIEW_H;
    int VIEW_X;
    int VIEW_Y;
    int panelWidth;
    int panelHeight;
    VirtualSpaceManager vsm;
    VirtualSpace svgSpace;
    VirtualSpace aboutSpace;
    EView mView;
    MainEventHandler eh;
    Navigation nm;
    Overlay ovm;
    VWGlassPane gp;
    File SCENE_FILE;
    File SCENE_FILE_DIR;
    static final String LOAD_EXTERNAL_DTD_URL = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    static final String SVG_OUTPUT_ENCODING = "UTF-8";

    public Viewer(File svgF, boolean fullscreen, boolean opengl, boolean antialiased) {
        this.init();
        this.initGUI(fullscreen, opengl, antialiased);
        if (svgF != null) {
            this.loadSVG(svgF);
        }
    }

    void init() {
        Scanner sc = new Scanner(Viewer.class.getResourceAsStream("/properties")).useDelimiter("\\s*=\\s*");
        while (sc.hasNext()) {
            String token = sc.next();
            if (!token.equals("version")) continue;
            Messages.VERSION = sc.next();
        }
    }

    void initGUI(boolean fullscreen, boolean opengl, boolean antialiased) {
        this.windowLayout();
        Glyph.setDefaultCursorInsideHighlightColor((Color)Config.HIGHLIGHT_COLOR);
        this.vsm = VirtualSpaceManager.INSTANCE;
        this.ovm = new Overlay(this);
        this.nm = new Navigation(this);
        this.svgSpace = this.vsm.addVirtualSpace("SVG");
        Camera mCamera = this.svgSpace.addCamera();
        mCamera.setZoomFloor(-99.0);
        this.nm.ovCamera = this.svgSpace.addCamera();
        this.aboutSpace = this.vsm.addVirtualSpace("About layer");
        this.aboutSpace.addCamera();
        Vector<Camera> cameras = new Vector<Camera>();
        cameras.add(mCamera);
        this.nm.setCamera(mCamera);
        cameras.add(this.aboutSpace.getCamera(0));
        this.mView = (EView)this.vsm.addFrameView(cameras, "SVG Viewer", opengl ? "ogl" : "std", this.VIEW_W, this.VIEW_H, false, false, !fullscreen, !fullscreen ? Config.initMenu(this) : null);
        if (fullscreen) {
            GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow((JFrame)this.mView.getFrame());
        } else {
            this.mView.setVisible(true);
        }
        this.updatePanelSize();
        this.ovm.init();
        this.gp = new VWGlassPane(this);
        ((JFrame)this.mView.getFrame()).setGlassPane(this.gp);
        this.eh = new MainEventHandler(this);
        this.mView.setListener((ViewListener)this.eh, 0);
        this.mView.setListener((ViewListener)this.ovm, 1);
        this.mView.setNotifyCursorMoved(true);
        this.mView.setAntialiasing(antialiased);
        this.mView.setBackgroundColor(Config.BACKGROUND_COLOR);
        this.mView.getPanel().getComponent().addComponentListener(this.eh);
        ComponentAdapter ca0 = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Viewer.this.updatePanelSize();
            }
        };
        this.mView.getFrame().addComponentListener(ca0);
        this.nm.createOverview();
    }

    void windowLayout() {
        if (Utils.osIsWindows()) {
            this.VIEW_Y = 0;
            this.VIEW_X = 0;
        } else if (Utils.osIsMacOS()) {
            this.VIEW_X = 80;
            SCREEN_WIDTH -= 80;
        }
        this.VIEW_W = SCREEN_WIDTH <= VIEW_MAX_W ? SCREEN_WIDTH : VIEW_MAX_W;
        this.VIEW_H = SCREEN_HEIGHT <= VIEW_MAX_H ? SCREEN_HEIGHT : VIEW_MAX_H;
    }

    void updatePanelSize() {
        Dimension d = this.mView.getPanel().getComponent().getSize();
        this.panelWidth = d.width;
        this.panelHeight = d.height;
        this.nm.updateOverviewLocation();
    }

    void reset() {
        this.svgSpace.removeAllGlyphs();
    }

    void openFile() {
        final JFileChooser fc = new JFileChooser(this.SCENE_FILE_DIR);
        fc.setFileSelectionMode(0);
        fc.setDialogTitle("Find SVG File");
        int returnVal = fc.showOpenDialog(this.mView.getFrame());
        if (returnVal == 0) {
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    Viewer.this.reset();
                    Viewer.this.loadSVG(fc.getSelectedFile());
                    return null;
                }
            };
            worker.start();
        }
    }

    void reload() {
        if (this.SCENE_FILE == null) {
            return;
        }
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                Viewer.this.reset();
                Viewer.this.loadSVG(Viewer.this.SCENE_FILE);
                return null;
            }
        };
        worker.start();
    }

    void loadSVG(File svgF) {
        this.gp.setVisible(true);
        this.gp.setValue(20);
        this.gp.setLabel("Loading " + svgF.getName());
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setAttribute(LOAD_EXTERNAL_DTD_URL, Boolean.FALSE);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            String svgURL = svgF.toURI().toURL().toString();
            Document xmlSVG = builder.parse(svgURL);
            this.gp.setValue(60);
            SVGReader.load(xmlSVG, this.svgSpace, true, svgURL);
            this.nm.getGlobalView();
            this.nm.updateOverview();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.SCENE_FILE = svgF;
        this.SCENE_FILE_DIR = this.SCENE_FILE.getParentFile();
        this.mView.setTitle("SVG Viewer - " + this.SCENE_FILE.getName());
        this.gp.setVisible(false);
    }

    void export() {
        final JFileChooser fc = new JFileChooser(this.SCENE_FILE_DIR);
        fc.setFileSelectionMode(0);
        fc.setDialogTitle("Export SVG File");
        int returnVal = fc.showSaveDialog(this.mView.getFrame());
        if (returnVal == 0) {
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    Viewer.this.exportSVG(fc.getSelectedFile());
                    return null;
                }
            };
            worker.start();
        }
    }

    void exportSVG(File f) {
        SVGWriter sw = new SVGWriter();
        if (f.exists()) {
            f.delete();
        }
        Document d = sw.exportVirtualSpace(this.svgSpace, (DOMImplementation)new DOMImplementationImpl(), f);
        OutputFormat format = new OutputFormat(d, SVG_OUTPUT_ENCODING, true);
        format.setLineSeparator("\n");
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(f), SVG_OUTPUT_ENCODING);
            DOMSerializer serializer = new XMLSerializer((Writer)osw, format).asDOMSerializer();
            serializer.serialize(d);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void exit() {
        System.exit(0);
    }

    public static void main(String[] args) {
        boolean fs = false;
        boolean ogl = false;
        boolean aa = true;
        File svgF = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].substring(1).equals("fs")) {
                    fs = true;
                    continue;
                }
                if (args[i].substring(1).equals("opengl")) {
                    System.setProperty("sun.java2d.opengl", "true");
                    ogl = true;
                    continue;
                }
                if (args[i].substring(1).equals("noaa")) {
                    aa = false;
                    continue;
                }
                if (!args[i].substring(1).equals("h") && !args[i].substring(1).equals("-help")) continue;
                Messages.printCmdLineHelp();
                System.exit(0);
                continue;
            }
            File f = new File(args[i]);
            if (!f.exists()) continue;
            svgF = f;
        }
        if (!fs && Utils.osIsMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        System.out.println("--help for command line options");
        new Viewer(svgF, fs, ogl, aa);
    }
}

