/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ide.types;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.ide.types.ITypeDescriptor;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.objectweb.asm.ClassReader;

@Data
public class ClasspathTypeDescriptor
implements ITypeDescriptor {
    private static final Splitter NESTED_CLASS_SPLITTER = Splitter.on((String)"$");
    private static final Splitter PACKAGE_AND_NESTED_CLASS_SPLITTER = Splitter.onPattern((String)"\\.|\\$");
    private static final Pattern ANONYMOUS_CLASS_PATTERN = Pattern.compile("\\d+");
    private final String name;
    private final int accessFlags;

    @Override
    public String getSimpleName() {
        return this.getQualifiedName().getLastSegment();
    }

    @Override
    public QualifiedName getQualifiedName() {
        return QualifiedName.create((String[])((String[])Conversions.unwrapArray((Object)PACKAGE_AND_NESTED_CLASS_SPLITTER.split((CharSequence)this.name), String.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClasspathTypeDescriptor forFile(File file, String packageName, Collection<String> packagePrefixes) {
        try {
            ClasspathTypeDescriptor _xblockexpression = null;
            if (!packagePrefixes.isEmpty() && !IterableExtensions.exists(packagePrefixes, it -> packageName.startsWith((String)it))) {
                return null;
            }
            String fileName = file.getName();
            ClasspathTypeDescriptor _xtrycatchfinallyexpression = null;
            try (InputStream inputStream = null;){
                ClasspathTypeDescriptor _xifexpression = null;
                boolean _endsWith = fileName.endsWith(".class");
                if (_endsWith) {
                    ClasspathTypeDescriptor _xblockexpression_1 = null;
                    int _length = fileName.length();
                    int _minus = _length - 6;
                    String simpleNames = fileName.substring(0, _minus);
                    Iterable _split = NESTED_CLASS_SPLITTER.split((CharSequence)simpleNames);
                    for (String s : _split) {
                        boolean _matches = ANONYMOUS_CLASS_PATTERN.matcher(s).matches();
                        if (!_matches) continue;
                        ClasspathTypeDescriptor classpathTypeDescriptor = null;
                        return classpathTypeDescriptor;
                    }
                    String _xifexpression_1 = null;
                    boolean _isEmpty = packageName.isEmpty();
                    _xifexpression_1 = _isEmpty ? simpleNames : packageName + "." + simpleNames;
                    String name = _xifexpression_1;
                    FileInputStream _fileInputStream = new FileInputStream(file);
                    inputStream = _fileInputStream;
                    ClassReader classReader = new ClassReader(inputStream);
                    int accessFlags = classReader.getAccess();
                    _xifexpression = _xblockexpression_1 = new ClasspathTypeDescriptor(name, accessFlags);
                }
                _xtrycatchfinallyexpression = _xifexpression;
                return _xtrycatchfinallyexpression;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClasspathTypeDescriptor forJarEntry(JarEntry jarEntry, JarFile jarFile, Collection<String> packagePrefixes) {
        try {
            ClasspathTypeDescriptor _xblockexpression = null;
            String filePath = jarEntry.getName();
            ClasspathTypeDescriptor _xtrycatchfinallyexpression = null;
            try (InputStream inputStream = null;){
                ClasspathTypeDescriptor _xifexpression = null;
                boolean _endsWith = filePath.endsWith(".class");
                if (_endsWith) {
                    ClasspathTypeDescriptor _xblockexpression_1 = null;
                    int _length = filePath.length();
                    int _minus = _length - 6;
                    String name = filePath.substring(0, _minus).replace("/", ".");
                    if (!packagePrefixes.isEmpty() && !IterableExtensions.exists(packagePrefixes, it -> name.startsWith((String)it))) {
                        ClasspathTypeDescriptor classpathTypeDescriptor = null;
                        return classpathTypeDescriptor;
                    }
                    int _lastIndexOf = name.lastIndexOf(".");
                    int _plus = _lastIndexOf + 1;
                    String simpleNames = name.substring(_plus);
                    Iterable _split = NESTED_CLASS_SPLITTER.split((CharSequence)simpleNames);
                    for (String s : _split) {
                        boolean _matches = ANONYMOUS_CLASS_PATTERN.matcher(s).matches();
                        if (!_matches) continue;
                        ClasspathTypeDescriptor classpathTypeDescriptor = null;
                        return classpathTypeDescriptor;
                    }
                    inputStream = jarFile.getInputStream(jarEntry);
                    ClassReader classReader = new ClassReader(inputStream);
                    int accessFlags = classReader.getAccess();
                    _xifexpression = _xblockexpression_1 = new ClasspathTypeDescriptor(name, accessFlags);
                }
                _xtrycatchfinallyexpression = _xifexpression;
                return _xtrycatchfinallyexpression;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ClasspathTypeDescriptor(String name, int accessFlags) {
        this.name = name;
        this.accessFlags = accessFlags;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.accessFlags;
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClasspathTypeDescriptor other = (ClasspathTypeDescriptor)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return other.accessFlags == this.accessFlags;
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("name", (Object)this.name);
        b.add("accessFlags", (Object)this.accessFlags);
        return b.toString();
    }

    @Override
    @Pure
    public String getName() {
        return this.name;
    }

    @Override
    @Pure
    public int getAccessFlags() {
        return this.accessFlags;
    }
}

