/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.debug.ui.WorkingDirectoryBlock;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaWorkingDirectoryBlock;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.VMArgumentsBlock;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class JavaArgumentsTab
extends JavaLaunchTab {
    protected Label fPrgmArgumentsLabel;
    protected Text fPrgmArgumentsText;
    protected VMArgumentsBlock fVMArgumentsBlock = this.createVMArgsBlock();
    protected WorkingDirectoryBlock fWorkingDirectoryBlock = this.createWorkingDirBlock();
    protected static final String EMPTY_STRING = "";

    protected VMArgumentsBlock createVMArgsBlock() {
        return new VMArgumentsBlock();
    }

    protected WorkingDirectoryBlock createWorkingDirBlock() {
        return new JavaWorkingDirectoryBlock();
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
        this.setHelpContextId();
        Group group = new Group(comp, 0);
        group.setFont(font);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        String controlName = LauncherMessages.JavaArgumentsTab__Program_arguments__5;
        group.setText(controlName);
        this.fPrgmArgumentsText = new Text((Composite)group, 2626);
        this.fPrgmArgumentsText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 2: 
                    case 256: 
                    case 512: {
                        e.doit = true;
                        break;
                    }
                    case 4: 
                    case 8: 
                    case 16: {
                        if ((JavaArgumentsTab.this.fPrgmArgumentsText.getStyle() & 4) != 0) {
                            e.doit = true;
                            break;
                        }
                        if (JavaArgumentsTab.this.fPrgmArgumentsText.isEnabled() && (e.stateMask & SWT.MODIFIER_MASK) == 0) break;
                        e.doit = true;
                    }
                }
            }
        });
        gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 100;
        this.fPrgmArgumentsText.setLayoutData((Object)gd);
        this.fPrgmArgumentsText.setFont(font);
        this.fPrgmArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JavaArgumentsTab.this.scheduleUpdateJob();
            }
        });
        ControlAccessibleListener.addListener((Control)this.fPrgmArgumentsText, group.getText());
        String buttonLabel = LauncherMessages.JavaArgumentsTab_5;
        Button pgrmArgVariableButton = this.createPushButton((Composite)group, buttonLabel, null);
        pgrmArgVariableButton.setLayoutData((Object)new GridData(128));
        pgrmArgVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(JavaArgumentsTab.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    JavaArgumentsTab.this.fPrgmArgumentsText.insert(variable);
                }
            }
        });
        this.fVMArgumentsBlock.createControl(comp);
        this.fWorkingDirectoryBlock.createControl(comp);
    }

    protected void setHelpContextId() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_ARGUMENTS_TAB);
    }

    public void dispose() {
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.fWorkingDirectoryBlock.isValid(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
        this.fVMArgumentsBlock.setDefaults(config);
        this.fWorkingDirectoryBlock.setDefaults(config);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fPrgmArgumentsText.setText(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, EMPTY_STRING));
            this.fVMArgumentsBlock.initializeFrom(configuration);
            this.fWorkingDirectoryBlock.initializeFrom(configuration);
        }
        catch (CoreException e) {
            this.setErrorMessage(String.valueOf(LauncherMessages.JavaArgumentsTab_Exception_occurred_reading_configuration___15) + e.getStatus().getMessage());
            JDIDebugUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this.getAttributeValueFrom(this.fPrgmArgumentsText));
        this.fVMArgumentsBlock.performApply(configuration);
        this.fWorkingDirectoryBlock.performApply(configuration);
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }

    public String getName() {
        return LauncherMessages.JavaArgumentsTab__Arguments_16;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.fWorkingDirectoryBlock.setLaunchConfigurationDialog(dialog);
        this.fVMArgumentsBlock.setLaunchConfigurationDialog(dialog);
    }

    public String getErrorMessage() {
        String m = super.getErrorMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getErrorMessage();
        }
        return m;
    }

    public String getMessage() {
        String m = super.getMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getMessage();
        }
        return m;
    }

    public Image getImage() {
        return JavaDebugImages.get("IMG_VIEW_ARGUMENTS_TAB");
    }

    public String getId() {
        return "org.eclipse.jdt.debug.ui.javaArgumentsTab";
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fWorkingDirectoryBlock.initializeFrom((ILaunchConfiguration)workingCopy);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

