/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.ContextSet;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingTableManager {
    private static final String BINDING_TABLE_PREFIX = "bindingTable:";
    @Inject
    private IEclipseContext eclipseContext;
    private ContextSet definedTables = ContextSet.EMPTY;
    private String[] activeSchemeIds;

    public void addTable(BindingTable table) {
        String contextId = this.getTableId(table.getId());
        if (this.eclipseContext.containsKey(contextId)) {
            return;
        }
        this.eclipseContext.set(contextId, (Object)table);
        List<Context> contexts = this.definedTables.getContexts();
        if (!contexts.contains(table.getTableId())) {
            contexts.add(table.getTableId());
            this.definedTables = this.createContextSet(contexts);
        }
    }

    private String getTableId(String id) {
        return BINDING_TABLE_PREFIX + id;
    }

    public void removeTable(BindingTable table) {
        String contextId = this.getTableId(table.getId());
        if (!this.eclipseContext.containsKey(contextId)) {
            throw new IllegalArgumentException("Does not contains table " + contextId);
        }
        this.eclipseContext.remove(contextId);
        List<Context> contexts = this.definedTables.getContexts();
        if (contexts.contains(table.getTableId())) {
            contexts.remove(table.getTableId());
            this.definedTables = this.createContextSet(contexts);
        }
    }

    public BindingTable getTable(String id) {
        return (BindingTable)this.eclipseContext.get(this.getTableId(id));
    }

    public Collection<Binding> getActiveBindings() {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (Context ctx : this.definedTables.getContexts()) {
            BindingTable table = this.getTable(ctx.getId());
            if (table == null) continue;
            bindings.addAll(table.getBindings());
        }
        return bindings;
    }

    public ContextSet createContextSet(Collection<Context> contexts) {
        return new ContextSet(contexts);
    }

    public Collection<Binding> getConflictsFor(ContextSet contextSet, TriggerSequence triggerSequence) {
        ArrayList<Binding> matches = new ArrayList<Binding>();
        for (Context ctx : contextSet.getContexts()) {
            Collection<Binding> matchesFor;
            BindingTable table = this.getTable(ctx.getId());
            if (table == null || (matchesFor = table.getConflictsFor(triggerSequence)) == null) continue;
            matches.addAll(matchesFor);
        }
        return matches.size() == 0 ? null : matches;
    }

    public Collection<Binding> getAllConflicts() {
        ArrayList<Binding> conflictsList = new ArrayList<Binding>();
        for (Context ctx : this.definedTables.getContexts()) {
            Collection<Binding> conflictsInTable;
            BindingTable table = this.getTable(ctx.getId());
            if (table == null || (conflictsInTable = table.getConflicts()) == null) continue;
            conflictsList.addAll(conflictsInTable);
        }
        return conflictsList;
    }

    public Binding getPerfectMatch(ContextSet contextSet, TriggerSequence triggerSequence) {
        Binding result = null;
        Binding currentResult = null;
        List<Context> contexts = contextSet.getContexts();
        ListIterator<Context> it = contexts.listIterator(contexts.size());
        while (it.hasPrevious()) {
            Context c = it.previous();
            BindingTable table = this.getTable(c.getId());
            if (table != null) {
                currentResult = table.getPerfectMatch(triggerSequence);
            }
            if (currentResult == null) continue;
            if (this.isMostActiveScheme(currentResult)) {
                return currentResult;
            }
            if (result == null) {
                result = currentResult;
                continue;
            }
            int rc = this.compareSchemes(result.getSchemeId(), currentResult.getSchemeId());
            if (rc >= 0) continue;
            result = currentResult;
        }
        return result;
    }

    private boolean isMostActiveScheme(Binding currentResult) {
        if (this.activeSchemeIds == null || this.activeSchemeIds.length < 2) {
            return true;
        }
        String mostActive = this.activeSchemeIds[0];
        return mostActive == null ? false : mostActive.equals(currentResult.getSchemeId());
    }

    public Binding getBestSequenceFor(ContextSet contextSet, ParameterizedCommand parameterizedCommand) {
        ArrayList bindings = (ArrayList)this.getSequencesFor(contextSet, parameterizedCommand);
        if (bindings.size() == 0) {
            return null;
        }
        return (Binding)bindings.get(0);
    }

    public Collection<Binding> getSequencesFor(ContextSet contextSet, ParameterizedCommand parameterizedCommand) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        List<Context> contexts = contextSet.getContexts();
        ListIterator<Context> it = contexts.listIterator(contexts.size());
        while (it.hasPrevious()) {
            Collection<Binding> sequences;
            Context c = it.previous();
            BindingTable table = this.getTable(c.getId());
            if (table == null || (sequences = table.getSequencesFor(parameterizedCommand)) == null) continue;
            bindings.addAll(sequences);
        }
        Collections.sort(bindings, BindingTable.BEST_SEQUENCE);
        return bindings;
    }

    public Collection<Binding> getBindingsFor(ContextSet contextSet, ParameterizedCommand cmd) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (Context ctx : contextSet.getContexts()) {
            Collection<Binding> matches;
            BindingTable table = this.getTable(ctx.getId());
            if (table == null || (matches = table.getSequencesFor(cmd)) == null) continue;
            bindings.addAll(matches);
        }
        return bindings;
    }

    public boolean isPartialMatch(ContextSet contextSet, TriggerSequence sequence) {
        List<Context> contexts = contextSet.getContexts();
        ListIterator<Context> it = contexts.listIterator(contexts.size());
        while (it.hasPrevious()) {
            Context c = it.previous();
            BindingTable table = this.getTable(c.getId());
            if (table == null || !table.isPartialMatch(sequence)) continue;
            return true;
        }
        return false;
    }

    public Collection<Binding> getPartialMatches(ContextSet contextSet, TriggerSequence sequence) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        List<Context> contexts = contextSet.getContexts();
        ListIterator<Context> it = contexts.listIterator(contexts.size());
        while (it.hasPrevious()) {
            Collection<Binding> partialMatches;
            Context c = it.previous();
            BindingTable table = this.getTable(c.getId());
            if (table == null || (partialMatches = table.getPartialMatches(sequence)) == null) continue;
            bindings.addAll(partialMatches);
        }
        return bindings;
    }

    public void setActiveSchemes(String[] activeSchemeIds) {
        this.activeSchemeIds = activeSchemeIds;
        BindingTable.BEST_SEQUENCE.setActiveSchemes(activeSchemeIds);
    }

    private final int compareSchemes(String schemeId1, String schemeId2) {
        if (this.activeSchemeIds == null) {
            return 0;
        }
        if (!schemeId2.equals(schemeId1)) {
            int i = 0;
            while (i < this.activeSchemeIds.length) {
                String schemePointer = this.activeSchemeIds[i];
                if (schemeId2.equals(schemePointer)) {
                    return 1;
                }
                if (schemeId1.equals(schemePointer)) {
                    return -1;
                }
                ++i;
            }
        }
        return 0;
    }
}

