/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    int day;
    int month;
    int year;
    int hours;
    int minutes;
    int seconds;
    Calendar calendar;
    DateFormatSymbols formatSymbols;
    Button down;
    Button up;
    Text text;
    String format;
    Point[] fieldIndices;
    int[] fieldNames;
    int fieldCount;
    int currentField = 0;
    int characterCount = 0;
    boolean ignoreVerify = false;
    Color fg;
    Color bg;
    boolean hasFocus;
    boolean monthChanged;
    boolean calendarDisplayed;
    int savedYear;
    int savedMonth;
    int savedDay;
    Shell popupShell;
    DateTime popupCalendar;
    Listener popupListener;
    Listener popupFilter;
    Listener clickListener;
    static final String DEFAULT_SHORT_DATE_FORMAT = "MM/YYYY";
    static final String DEFAULT_MEDIUM_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_LONG_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_SHORT_TIME_FORMAT = "HH:MM AM";
    static final String DEFAULT_MEDIUM_TIME_FORMAT = "HH:MM:SS AM";
    static final String DEFAULT_LONG_TIME_FORMAT = "HH:MM:SS AM";
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;

    public DateTime(Composite parent, int style) {
        super(parent, DateTime.checkStyle(style));
        if ((this.style & 0x400) == 0) {
            this.createText((this.style & 4) != 0);
        }
        this.initAccessible();
    }

    void createText(boolean dropDown) {
        this.calendar = Calendar.getInstance();
        this.formatSymbols = new DateFormatSymbols();
        this.text = new Text(this, 4);
        OS.gtk_drag_dest_unset(this.text.handle);
        if ((this.style & 0x20) != 0) {
            this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((this.style & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY"));
        } else {
            this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((this.style & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM"));
        }
        this.text.setText(this.getFormattedString(this.style));
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                DateTime.this.onResize(event);
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: {
                        DateTime.this.onTextKeyDown(event);
                        break;
                    }
                    case 15: {
                        DateTime.this.onTextFocusIn(event);
                        break;
                    }
                    case 16: {
                        DateTime.this.onTextFocusOut(event);
                        break;
                    }
                    case 3: 
                    case 4: {
                        DateTime.this.onTextMouseClick(event);
                        break;
                    }
                    case 35: {
                        DateTime.this.notifyListeners(35, event);
                        break;
                    }
                    case 25: {
                        DateTime.this.onTextVerify(event);
                    }
                }
            }
        };
        int[] listeners = new int[]{1, 15, 16, 3, 4, 35, 25};
        int i = 0;
        while (i < listeners.length) {
            this.text.addListener(listeners[i], listener);
            ++i;
        }
        if ((this.style & 0x20) != 0 && dropDown) {
            this.createDropDownButton();
            this.createPopupShell(-1, -1, -1);
        } else {
            this.up = new Button(this, 132);
            OS.GTK_WIDGET_UNSET_FLAGS(this.up.handle, 2048);
            this.down = new Button(this, 1028);
            OS.GTK_WIDGET_UNSET_FLAGS(this.down.handle, 2048);
            this.up.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.incrementField(1);
                    DateTime.this.text.setFocus();
                }
            });
            this.down.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.incrementField(-1);
                    DateTime.this.text.setFocus();
                }
            });
        }
    }

    void createDropDownButton() {
        this.down = new Button(this, 1028);
        OS.GTK_WIDGET_UNSET_FLAGS(this.down.handle, 2048);
        this.down.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean dropped = DateTime.this.isDropped();
                DateTime.this.popupCalendar.calendarDisplayed = !dropped;
                DateTime.this.setFocus();
                DateTime.this.dropDownCalendar(!dropped);
            }
        });
        this.popupListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == DateTime.this.popupShell) {
                    DateTime.this.popupShellEvent(event);
                    return;
                }
                if (event.widget == DateTime.this.popupCalendar) {
                    DateTime.this.popupCalendarEvent(event);
                    return;
                }
                if (event.widget == DateTime.this) {
                    DateTime.this.onDispose(event);
                    return;
                }
                if (event.widget == DateTime.this.getShell()) {
                    DateTime.this.getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (6.access$0(this.this$1).isDisposed()) {
                                return;
                            }
                            6.access$0(this.this$1).handleFocus(16);
                        }
                    });
                }
            }

            static /* synthetic */ DateTime access$0(6 var0) {
                return var0.DateTime.this;
            }
        };
        this.popupFilter = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = ((Control)event.widget).getShell();
                if (shell == DateTime.this.getShell()) {
                    DateTime.this.handleFocus(16);
                }
            }
        };
    }

    void createPopupShell(int year, int month, int day) {
        this.popupShell = new Shell(this.getShell(), 16392);
        this.popupCalendar = new DateTime(this.popupShell, 1024);
        if (this.font != null) {
            this.popupCalendar.setFont(this.font);
        }
        if (this.fg != null) {
            this.popupCalendar.setForeground(this.fg);
        }
        if (this.bg != null) {
            this.popupCalendar.setBackground(this.bg);
        }
        this.clickListener = new Listener(){

            public void handleEvent(Event event) {
                Control c;
                if (event.widget instanceof Control && (c = (Control)event.widget) != DateTime.this.down && c.getShell() != DateTime.this.popupShell) {
                    DateTime.this.dropDownCalendar(false);
                }
            }
        };
        int[] listeners = new int[]{21, 4, 9};
        int i = 0;
        while (i < listeners.length) {
            this.popupShell.addListener(listeners[i], this.popupListener);
            ++i;
        }
        listeners = new int[]{3, 4, 13, 31, 1, 2, 15, 16, 12};
        i = 0;
        while (i < listeners.length) {
            this.popupCalendar.addListener(listeners[i], this.popupListener);
            ++i;
        }
        this.addListener(12, this.popupListener);
        if (year != -1) {
            this.popupCalendar.setDate(year, month, day);
        }
    }

    static int checkStyle(int style) {
        style &= 0xFFFFFCFF;
        if (((style = DateTime.checkBits(style, 32, 128, 1024, 0, 0, 0)) & 0x20) == 0) {
            style &= 0xFFFFFFFB;
        }
        return DateTime.checkBits(style, 65536, 32768, 0x10000000, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (wHint == -1 || hHint == -1) {
            if ((this.style & 0x400) != 0) {
                Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
                width = size.x;
                height = size.y;
            } else {
                GC gc = new GC(this.text);
                Point textSize = gc.stringExtent(this.getComputeSizeString(this.style));
                gc.dispose();
                Rectangle trim = this.text.computeTrim(0, 0, textSize.x, textSize.y);
                Point buttonSize = this.down.computeSize(-1, -1, changed);
                width = trim.width + buttonSize.x;
                height = Math.max(trim.height, buttonSize.y);
            }
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int borderWidth = this.getBorderWidth();
        return new Point(width + 2 * borderWidth, height + 2 * borderWidth);
    }

    void createHandle(int index) {
        if ((this.style & 0x400) != 0) {
            this.state |= 8;
            this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
            if (this.fixedHandle == 0) {
                this.error(2);
            }
            OS.gtk_fixed_set_has_window(this.fixedHandle, true);
            this.handle = OS.gtk_calendar_new();
            if (this.handle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.handle);
            OS.gtk_calendar_set_display_options(this.handle, 3);
        } else {
            super.createHandle(index);
        }
    }

    boolean checkSubwindow() {
        return false;
    }

    void createWidget(int index) {
        super.createWidget(index);
        if ((this.style & 0x400) != 0) {
            this.getDate();
        }
    }

    void commitCurrentField() {
        if (this.characterCount > 0) {
            int newValue;
            this.characterCount = 0;
            int fieldName = this.fieldNames[this.currentField];
            int start = this.fieldIndices[this.currentField].x;
            int end = this.fieldIndices[this.currentField].y;
            String value = this.text.getText(start, end - 1);
            int s = value.lastIndexOf(32);
            if (s != -1) {
                value = value.substring(s + 1);
            }
            if ((newValue = this.unformattedIntValue(fieldName, value, this.characterCount == 0, this.calendar.getActualMaximum(fieldName))) != -1) {
                this.setTextField(fieldName, newValue, true, true);
            }
        }
    }

    void onDispose(Event event) {
        if (this.popupShell != null && !this.popupShell.isDisposed()) {
            this.popupCalendar.removeListener(12, this.popupListener);
            this.popupShell.dispose();
        }
        Shell shell = this.getShell();
        shell.removeListener(27, this.popupListener);
        Display display = this.getDisplay();
        display.removeFilter(15, this.popupFilter);
        this.popupShell = null;
        this.text = null;
        this.popupCalendar = null;
        this.down = null;
        this.up = null;
    }

    void dropDownCalendar(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            this.popupShell.setVisible(false);
            OS.gtk_calendar_clear_marks(this.popupCalendar.handle);
            this.display.removeFilter(3, this.clickListener);
            return;
        }
        this.savedYear = this.getYear();
        this.savedMonth = this.getMonth();
        this.savedDay = this.getDay();
        if (this.getShell() != this.popupShell.getParent()) {
            int year = this.popupCalendar.getYear();
            int month = this.popupCalendar.getMonth();
            int day = this.popupCalendar.getDay();
            this.popupCalendar.removeListener(12, this.popupListener);
            this.popupShell.dispose();
            this.popupShell = null;
            this.popupCalendar = null;
            this.createPopupShell(year, month, day);
        }
        Point dateBounds = this.getSize();
        Point calendarSize = this.popupCalendar.computeSize(-1, -1, false);
        this.popupCalendar.setBounds(1, 1, Math.max(dateBounds.x - 2, calendarSize.x), calendarSize.y);
        this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
        if (this.savedYear == Calendar.getInstance().get(1) && this.savedMonth == Calendar.getInstance().get(2)) {
            OS.gtk_calendar_mark_day(this.popupCalendar.handle, Calendar.getInstance().get(5));
        }
        Display display = this.getDisplay();
        Rectangle parentRect = display.map((Control)this.getParent(), null, this.getBounds());
        Rectangle displayRect = this.getMonitor().getClientArea();
        int width = Math.max(dateBounds.x, calendarSize.x + 2);
        int height = calendarSize.y + 2;
        int x = parentRect.x;
        int y = parentRect.y + dateBounds.y;
        if (y + height > displayRect.y + displayRect.height) {
            y = parentRect.y - height;
        }
        if (x + width > displayRect.x + displayRect.width) {
            x = displayRect.x + displayRect.width - calendarSize.x;
        }
        this.popupShell.setBounds(x, y, width, height);
        this.popupShell.setVisible(true);
        if (this.isFocusControl()) {
            this.popupCalendar.setFocus();
        }
        display.addFilter(3, this.clickListener);
    }

    int focusHandle() {
        if (this.text != null) {
            return this.text.handle;
        }
        return super.focusHandle();
    }

    String formattedStringValue(int fieldName, int value, boolean adjust) {
        if (fieldName == 9) {
            String[] ampm = this.formatSymbols.getAmPmStrings();
            return ampm[value];
        }
        if (adjust) {
            if (fieldName == 10 && value == 0) {
                return String.valueOf(12);
            }
            if (fieldName == 2) {
                return String.valueOf(value + 1);
            }
        }
        return String.valueOf(value);
    }

    GdkColor getBackgroundColor() {
        if ((this.style & 0x400) != 0) {
            return this.getBaseColor();
        }
        return super.getBackgroundColor();
    }

    String getComputeSizeString(int style) {
        if ((style & 0x20) != 0) {
            return (style & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((style & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY");
        }
        return (style & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((style & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM");
    }

    int getFieldIndex(int fieldName) {
        int i = 0;
        while (i < this.fieldCount) {
            if (this.fieldNames[i] == fieldName) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    String getFormattedString(int style) {
        if ((style & 0x80) != 0) {
            String[] ampm = this.formatSymbols.getAmPmStrings();
            int h = this.calendar.get(10);
            if (h == 0) {
                h = 12;
            }
            int m = this.calendar.get(12);
            int s = this.calendar.get(13);
            int a = this.calendar.get(9);
            if ((style & 0x8000) != 0) {
                return (h < 10 ? " " : "") + h + ":" + (m < 10 ? "0" : "") + m + " " + ampm[a];
            }
            return (h < 10 ? " " : "") + h + ":" + (m < 10 ? "0" : "") + m + ":" + (s < 10 ? "0" : "") + s + " " + ampm[a];
        }
        int y = this.calendar.get(1);
        int m = this.calendar.get(2) + 1;
        int d = this.calendar.get(5);
        if ((style & 0x8000) != 0) {
            return (m < 10 ? " " : "") + m + "/" + y;
        }
        return (m < 10 ? " " : "") + m + "/" + (d < 10 ? " " : "") + d + "/" + y;
    }

    void getDate() {
        int[] y = new int[1];
        int[] m = new int[1];
        int[] d = new int[1];
        OS.gtk_calendar_get_date(this.handle, y, m, d);
        this.year = y[0];
        this.month = m[0];
        this.day = d[0];
    }

    public int getDay() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            this.getDate();
            return this.day;
        }
        return this.calendar.get(5);
    }

    public int getHours() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.hours;
        }
        return this.calendar.get(11);
    }

    public int getMinutes() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.minutes;
        }
        return this.calendar.get(12);
    }

    public int getMonth() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            this.getDate();
            return this.month;
        }
        return this.calendar.get(2);
    }

    String getNameText() {
        return (this.style & 0x80) != 0 ? String.valueOf(this.getHours()) + ":" + this.getMinutes() + ":" + this.getSeconds() : String.valueOf(this.getMonth() + 1) + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.seconds;
        }
        return this.calendar.get(13);
    }

    String getSpokenText() {
        StringBuffer result = new StringBuffer();
        if ((this.style & 0x80) != 0) {
            int h = this.calendar.get(10);
            if (h == 0) {
                h = 12;
            }
            result.append(h);
            int m = this.calendar.get(12);
            result.append(":" + (m < 10 ? "0" : "") + m);
            if ((this.style & 0x8000) == 0) {
                int s = this.calendar.get(13);
                result.append(":" + (s < 10 ? "0" : "") + s);
            }
            result.append(" " + this.formatSymbols.getAmPmStrings()[this.calendar.get(9)]);
        } else {
            Calendar cal = this.calendar;
            if ((this.style & 0x400) != 0) {
                this.formatSymbols = new DateFormatSymbols();
                cal = Calendar.getInstance();
                this.getDate();
                cal.set(this.year, this.month, this.day);
            }
            if ((this.style & 0x8000) == 0) {
                result.append(String.valueOf(this.formatSymbols.getWeekdays()[cal.get(7)]) + ", ");
            }
            result.append(String.valueOf(this.formatSymbols.getMonths()[cal.get(2)]) + " ");
            if ((this.style & 0x8000) == 0) {
                result.append(String.valueOf(cal.get(5)) + ", ");
            }
            result.append(cal.get(1));
        }
        return result.toString();
    }

    public int getYear() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            this.getDate();
            return this.year;
        }
        return this.calendar.get(1);
    }

    int gtk_day_selected(int widget) {
        this.sendSelectionEvent();
        return 0;
    }

    int gtk_day_selected_double_click(int widget) {
        this.sendSelectionEvent(14);
        return 0;
    }

    int gtk_month_changed(int widget) {
        if (this.calendarDisplayed) {
            this.calendarDisplayed = false;
        } else {
            this.monthChanged = true;
        }
        this.sendSelectionEvent();
        return 0;
    }

    boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        Control focusControl = this.display.getFocusControl();
        return focusControl != null && focusControl == this.text;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 0x400) != 0) {
            OS.g_signal_connect_closure(this.handle, OS.day_selected, this.display.closures[61], false);
            OS.g_signal_connect_closure(this.handle, OS.day_selected_double_click, this.display.closures[66], false);
            OS.g_signal_connect_closure(this.handle, OS.month_changed, this.display.closures[62], false);
        }
    }

    void incrementField(int amount) {
        int fieldName = this.fieldNames[this.currentField];
        int value = this.calendar.get(fieldName);
        if (fieldName == 10) {
            int max = this.calendar.getMaximum(10);
            int min = this.calendar.getMinimum(10);
            if (value == max && amount == 1 || value == min && amount == -1) {
                int temp = this.currentField;
                this.currentField = this.getFieldIndex(9);
                this.setTextField(9, (this.calendar.get(9) + 1) % 2, true, true);
                this.currentField = temp;
            }
        }
        this.setTextField(fieldName, value + amount, true, true);
    }

    boolean isDropped() {
        return this.popupShell.getVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if ((this.style & 4) != 0 && (this.text.isFocusControl() || this.popupShell.isFocusControl() || this.popupCalendar.isFocusControl())) {
            return true;
        }
        return super.isFocusControl();
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DateTime.this.getSpokenText();
            }

            public void getHelp(AccessibleEvent e) {
                e.result = DateTime.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                e.childID = -1;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle rect = DateTime.this.display.map((Control)DateTime.this.getParent(), null, DateTime.this.getBounds());
                e.x = rect.x;
                e.y = rect.y;
                e.width = rect.width;
                e.height = rect.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = (DateTime.this.style & 0x400) != 0 ? 41 : 42;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x100000;
                if (DateTime.this.hasFocus()) {
                    e.detail |= 4;
                }
            }

            public void getSelection(AccessibleControlEvent e) {
                if (DateTime.this.hasFocus()) {
                    e.childID = -1;
                }
            }

            public void getFocus(AccessibleControlEvent e) {
                if (DateTime.this.hasFocus()) {
                    e.childID = -1;
                }
            }
        });
    }

    boolean isValidTime(int fieldName, int value) {
        Calendar validCalendar = (this.style & 0x400) != 0 ? Calendar.getInstance() : this.calendar;
        int min = validCalendar.getActualMinimum(fieldName);
        int max = validCalendar.getActualMaximum(fieldName);
        return value >= min && value <= max;
    }

    boolean isValidDate(int year, int month, int day) {
        if (year < 1752 || year > 9999) {
            return false;
        }
        Calendar valid = Calendar.getInstance();
        valid.set(year, month, day);
        return valid.get(1) == year && valid.get(2) == month && valid.get(5) == day;
    }

    void popupCalendarEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popupShell == null || this.popupShell.isDisposed() || this.isDisposed() || this.getShell() == this.popupShell.getParent()) break;
                int year = this.popupCalendar.getYear();
                int month = this.popupCalendar.getMonth();
                int day = this.popupCalendar.getDay();
                this.popupShell = null;
                this.popupCalendar = null;
                this.createPopupShell(year, month, day);
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 16: {
                Point point = this.down.toControl(this.getDisplay().getCursorLocation());
                Point size = this.down.getSize();
                Rectangle rect = new Rectangle(0, 0, size.x, size.y);
                if (rect.contains(point)) {
                    boolean popupShellActivated;
                    boolean bl = popupShellActivated = this.getDisplay().getActiveShell() == this.getShell();
                    if (popupShellActivated) break;
                    this.dropDownCalendar(false);
                    break;
                }
                this.dropDownCalendar(false);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                if (this.popupCalendar.monthChanged) {
                    this.popupCalendar.monthChanged = false;
                    OS.gtk_calendar_clear_marks(this.popupCalendar.handle);
                    break;
                }
                this.dropDownCalendar(false);
                break;
            }
            case 13: {
                int year = this.popupCalendar.getYear();
                int month = this.popupCalendar.getMonth();
                int day = this.popupCalendar.getDay();
                this.setDate(year, month, day);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: 
                    case 16: {
                        event.doit = this.text.traverse(event.detail);
                        event.detail = 0;
                        if (event.doit) {
                            this.dropDownCalendar(false);
                        }
                        return;
                    }
                    case 256: 
                    case 512: {
                        return;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 1: {
                if (event.character == '\u001b') {
                    this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
                    this.setDate(this.savedYear, this.savedMonth, this.savedDay);
                    this.dropDownCalendar(false);
                }
                if (event.keyCode == 13 || (event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDownCalendar(false);
                }
                if (event.keyCode == 32) {
                    this.dropDownCalendar(false);
                }
                if (this.isDisposed()) break;
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
            }
        }
    }

    void handleFocus(int type) {
        if (this.isDisposed()) {
            return;
        }
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.text.selectAll();
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.popupListener);
                shell.addListener(27, this.popupListener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.popupFilter);
                display.addFilter(15, this.popupFilter);
                Event e = new Event();
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.down || focusControl == this.popupCalendar || focusControl == this.text) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.popupListener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.popupFilter);
                display.removeFilter(3, this.clickListener);
                Event e = new Event();
                this.notifyListeners(16, e);
            }
        }
    }

    void popupShellEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle bounds = this.popupCalendar.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, bounds.width + 1, bounds.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDownCalendar(false);
                break;
            }
            case 4: {
                this.dropDownCalendar(false);
            }
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectField(int index) {
        if (index != this.currentField) {
            this.commitCurrentField();
        }
        final int start = this.fieldIndices[index].x;
        final int end = this.fieldIndices[index].y;
        Point pt = this.text.getSelection();
        if (index == this.currentField && start == pt.x && end == pt.y) {
            return;
        }
        this.currentField = index;
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (!DateTime.this.text.isDisposed()) {
                    String value = DateTime.this.text.getText(start, end - 1);
                    int s = value.lastIndexOf(32);
                    s = s == -1 ? start : start + s + 1;
                    DateTime.this.text.setSelection(s, end);
                }
            }
        });
    }

    void sendSelectionEvent() {
        int[] y = new int[1];
        int[] m = new int[1];
        int[] d = new int[1];
        OS.gtk_calendar_get_date(this.handle, y, m, d);
        if (d[0] != this.day || m[0] != this.month || y[0] != this.year) {
            this.year = y[0];
            this.month = m[0];
            this.day = d[0];
            this.sendSelectionEvent(13);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if ((this.style & 0x400) != 0 && color == null) {
            OS.gtk_widget_modify_base(this.handle, 0, null);
        }
        this.bg = color;
        if (this.text != null) {
            this.text.setBackground(color);
        }
        if (this.popupCalendar != null) {
            this.popupCalendar.setBackground(color);
        }
    }

    void setBackgroundColor(GdkColor color) {
        if ((this.style & 0x400) != 0) {
            OS.gtk_widget_modify_base(this.handle, 0, color);
        } else {
            super.setBackgroundColor(color);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if ((this.style & 0x400) == 0) {
            this.text.setEnabled(enabled);
            this.down.setEnabled(enabled);
            if (this.up != null) {
                this.up.setEnabled(enabled);
            }
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        if (this.text != null) {
            this.text.setFont(font);
        }
        if (this.popupCalendar != null) {
            this.popupCalendar.setFont(font);
        }
        this.redraw();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.fg = color;
        if (this.text != null) {
            this.text.setForeground(color);
        }
        if (this.popupCalendar != null) {
            this.popupCalendar.setForeground(color);
        }
    }

    void setFormat(String string) {
        this.fieldCount = (this.style & 0x20) != 0 ? ((this.style & 0x8000) != 0 ? 2 : 3) : ((this.style & 0x8000) != 0 ? 3 : 4);
        this.fieldIndices = new Point[this.fieldCount];
        this.fieldNames = new int[this.fieldCount];
        if ((this.style & 0x20) != 0) {
            this.fieldNames[0] = 2;
            this.fieldIndices[0] = new Point(0, 2);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[1] = 1;
                this.fieldIndices[1] = new Point(3, 7);
            } else {
                this.fieldNames[1] = 5;
                this.fieldIndices[1] = new Point(3, 5);
                this.fieldNames[2] = 1;
                this.fieldIndices[2] = new Point(6, 10);
            }
        } else {
            this.fieldNames[0] = 10;
            this.fieldIndices[0] = new Point(0, 2);
            this.fieldNames[1] = 12;
            this.fieldIndices[1] = new Point(3, 5);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[2] = 9;
                this.fieldIndices[2] = new Point(6, 8);
            } else {
                this.fieldNames[2] = 13;
                this.fieldIndices[2] = new Point(6, 8);
                this.fieldNames[3] = 9;
                this.fieldIndices[3] = new Point(9, 11);
            }
        }
    }

    void setField(int fieldName, int value) {
        if (this.calendar.get(fieldName) == value) {
            return;
        }
        if (fieldName == 9) {
            this.calendar.roll(11, 12);
        }
        this.calendar.set(fieldName, value);
        this.sendSelectionEvent(13);
    }

    void setTextField(int fieldName, int value, boolean commit, boolean adjust) {
        if (commit) {
            int max = this.calendar.getActualMaximum(fieldName);
            int min = this.calendar.getActualMinimum(fieldName);
            if (fieldName == 1) {
                max = 9999;
                min = 1752;
                int currentYear = Calendar.getInstance().get(1);
                int currentCentury = currentYear / 100 * 100;
                if (value < (currentYear + 30) % 100) {
                    value += currentCentury;
                } else if (value < 100) {
                    value += currentCentury - 100;
                }
            }
            if (value > max) {
                value = min;
            }
            if (value < min) {
                value = max;
            }
        }
        int start = this.fieldIndices[this.currentField].x;
        int end = this.fieldIndices[this.currentField].y;
        this.text.setSelection(start, end);
        String newValue = this.formattedStringValue(fieldName, value, adjust);
        StringBuffer buffer = new StringBuffer(newValue);
        int prependCount = end - start - buffer.length();
        int i = 0;
        while (i < prependCount) {
            switch (fieldName) {
                case 12: 
                case 13: {
                    buffer.insert(0, 0);
                    break;
                }
                default: {
                    buffer.insert(0, ' ');
                }
            }
            ++i;
        }
        newValue = buffer.toString();
        this.ignoreVerify = true;
        this.text.insert(newValue);
        this.ignoreVerify = false;
        this.selectField(this.currentField);
        if (commit) {
            this.setField(fieldName, value);
        }
    }

    public void setDate(int year, int month, int day) {
        this.checkWidget();
        if (!this.isValidDate(year, month, day)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.year = year;
            this.month = month;
            this.day = day;
            OS.gtk_calendar_select_month(this.handle, month, year);
            OS.gtk_calendar_select_day(this.handle, day);
        } else {
            this.calendar.set(year, month, day);
            this.updateControl();
        }
    }

    public void setDay(int day) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), this.getMonth(), day)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.day = day;
            OS.gtk_calendar_select_day(this.handle, day);
        } else {
            this.calendar.set(5, day);
            this.updateControl();
        }
    }

    public void setHours(int hours) {
        this.checkWidget();
        if (!this.isValidTime(11, hours)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.hours = hours;
        } else {
            this.calendar.set(11, hours);
            this.updateControl();
        }
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        if (this.up != null) {
            this.up.setMenu(menu);
        }
        if (this.down != null) {
            this.down.setMenu(menu);
        }
        if (this.text != null) {
            this.text.setMenu(menu);
        }
    }

    public void setMinutes(int minutes) {
        this.checkWidget();
        if (!this.isValidTime(12, minutes)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.minutes = minutes;
        } else {
            this.calendar.set(12, minutes);
            this.updateControl();
        }
    }

    public void setMonth(int month) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), month, this.getDay())) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.month = month;
            OS.gtk_calendar_select_month(this.handle, month, this.year);
        } else {
            this.calendar.set(2, month);
            this.updateControl();
        }
    }

    public void setSeconds(int seconds) {
        this.checkWidget();
        if (!this.isValidTime(13, seconds)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.seconds = seconds;
        } else {
            this.calendar.set(13, seconds);
            this.updateControl();
        }
    }

    public void setTime(int hours, int minutes, int seconds) {
        this.checkWidget();
        if (!this.isValidTime(11, hours)) {
            return;
        }
        if (!this.isValidTime(12, minutes)) {
            return;
        }
        if (!this.isValidTime(13, seconds)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
        } else {
            this.calendar.set(11, hours);
            this.calendar.set(12, minutes);
            this.calendar.set(13, seconds);
            this.updateControl();
        }
    }

    public void setYear(int year) {
        this.checkWidget();
        if (!this.isValidDate(year, this.getMonth(), this.getDay())) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.year = year;
            OS.gtk_calendar_select_month(this.handle, this.month, year);
        } else {
            this.calendar.set(1, year);
            this.updateControl();
        }
    }

    void onTextFocusIn(Event event) {
        this.selectField(this.currentField);
        if ((this.style & 4) == 0) {
            this.sendFocusEvent(15);
        } else {
            this.handleFocus(15);
        }
    }

    void onTextFocusOut(Event event) {
        this.commitCurrentField();
        if ((this.style & 4) == 0) {
            this.sendFocusEvent(16);
        } else {
            this.handleFocus(16);
        }
    }

    void onTextKeyDown(Event event) {
        if ((this.style & 4) != 0 && (event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
            boolean dropped = this.isDropped();
            if (!dropped) {
                this.popupCalendar.calendarDisplayed = true;
                this.setFocus();
            }
            this.dropDownCalendar(!dropped);
            return;
        }
        block0 : switch (event.keyCode) {
            case 0x1000004: 
            case 16777263: {
                this.selectField((this.currentField + 1) % this.fieldCount);
                this.sendEvent(31);
                break;
            }
            case 0x1000003: {
                int index = this.currentField - 1;
                this.selectField(index < 0 ? this.fieldCount - 1 : index);
                this.sendEvent(31);
                break;
            }
            case 0x1000001: 
            case 16777259: {
                this.commitCurrentField();
                this.incrementField(1);
                break;
            }
            case 0x1000002: 
            case 16777261: {
                this.commitCurrentField();
                this.incrementField(-1);
                break;
            }
            case 0x1000007: {
                int fieldName = this.fieldNames[this.currentField];
                this.setTextField(fieldName, this.calendar.getActualMinimum(fieldName), true, true);
                break;
            }
            case 0x1000008: {
                int fieldName = this.fieldNames[this.currentField];
                this.setTextField(fieldName, this.calendar.getActualMaximum(fieldName), true, true);
                break;
            }
            default: {
                switch (event.character) {
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': {
                        this.selectField((this.currentField + 1) % this.fieldCount);
                        this.sendEvent(31);
                        break block0;
                    }
                    case '\r': {
                        this.postEvent(14);
                    }
                }
            }
        }
    }

    void onTextMouseClick(Event event) {
        if (event.button != 1) {
            return;
        }
        Point sel = this.text.getSelection();
        int i = 0;
        while (i < this.fieldCount) {
            if (sel.x >= this.fieldIndices[i].x && sel.x <= this.fieldIndices[i].y) {
                this.currentField = i;
                break;
            }
            ++i;
        }
        this.selectField(this.currentField);
    }

    void onResize(Event event) {
        Rectangle rect = this.getClientArea();
        int width = rect.width;
        int height = rect.height;
        Point buttonSize = this.down.computeSize(-1, height);
        this.text.setBounds(0, 0, width - buttonSize.x, height);
        if ((this.style & 4) != 0) {
            this.down.setBounds(width - buttonSize.x, 0, buttonSize.x, height);
        } else {
            int buttonHeight = height / 2;
            this.up.setBounds(width - buttonSize.x, 0, buttonSize.x, buttonHeight);
            this.down.setBounds(width - buttonSize.x, buttonHeight, buttonSize.x, buttonHeight);
        }
    }

    void onTextVerify(Event event) {
        if (this.ignoreVerify) {
            return;
        }
        event.doit = false;
        int fieldName = this.fieldNames[this.currentField];
        int start = this.fieldIndices[this.currentField].x;
        int end = this.fieldIndices[this.currentField].y;
        int length = end - start;
        String newText = event.text;
        if (fieldName == 9) {
            String[] ampm = this.formatSymbols.getAmPmStrings();
            if (newText.equalsIgnoreCase(ampm[0].substring(0, 1)) || newText.equalsIgnoreCase(ampm[0])) {
                this.setTextField(fieldName, 0, true, false);
            } else if (newText.equalsIgnoreCase(ampm[1].substring(0, 1)) || newText.equalsIgnoreCase(ampm[1])) {
                this.setTextField(fieldName, 1, true, false);
            }
            return;
        }
        if (this.characterCount > 0) {
            try {
                Integer.parseInt(newText);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            String value = this.text.getText(start, end - 1);
            int s = value.lastIndexOf(32);
            if (s != -1) {
                value = value.substring(s + 1);
            }
            newText = value + newText;
        }
        int newTextLength = newText.length();
        boolean first = this.characterCount == 0;
        this.characterCount = newTextLength < length ? newTextLength : 0;
        int max = this.calendar.getActualMaximum(fieldName);
        int min = this.calendar.getActualMinimum(fieldName);
        int newValue = this.unformattedIntValue(fieldName, newText, this.characterCount == 0, max);
        if (newValue == -1) {
            this.characterCount = 0;
            return;
        }
        if (first && newValue == 0 && length > 1) {
            this.setTextField(fieldName, newValue, false, false);
        } else if (min <= newValue && newValue <= max) {
            this.setTextField(fieldName, newValue, this.characterCount == 0, this.characterCount == 0);
        } else if (newTextLength >= length && (newValue = this.unformattedIntValue(fieldName, newText = newText.substring(newTextLength - length + 1), this.characterCount == 0, max)) != -1) {
            this.characterCount = length - 1;
            if (min <= newValue && newValue <= max) {
                this.setTextField(fieldName, newValue, this.characterCount == 0, true);
            }
        }
    }

    int unformattedIntValue(int fieldName, String newText, boolean adjust, int max) {
        int newValue;
        try {
            newValue = Integer.parseInt(newText);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (fieldName == 2 && adjust && --newValue == -1) {
            newValue = max;
        }
        if (fieldName == 10 && adjust && newValue == 12) {
            newValue = 0;
        }
        return newValue;
    }

    void updateControl() {
        if (this.text != null) {
            String string = this.getFormattedString(this.style);
            this.ignoreVerify = true;
            this.text.setText(string);
            this.ignoreVerify = false;
        }
        this.redraw();
    }
}

