/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.dom.CSSExtendedProperties;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.CSSExtendedPropertiesImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.css.CSSStyleDeclaration;

public abstract class ElementAdapter
implements Element,
CSSStylableElement {
    private static final String[] EMPTY_STRING = new String[0];
    private Object nativeWidget;
    protected CSSEngine engine;
    private Map defaultStyleDeclarationMap = new HashMap();
    private CSSExtendedProperties style = null;
    private List staticPseudoInstances;

    public ElementAdapter(Object nativeWidget, CSSEngine engine) {
        this.nativeWidget = nativeWidget;
        this.engine = engine;
    }

    public void addStaticPseudoInstance(String pseudoE) {
        if (this.staticPseudoInstances == null) {
            this.staticPseudoInstances = new ArrayList();
        }
        this.staticPseudoInstances.add(pseudoE);
    }

    public boolean isStaticPseudoInstance(String s) {
        if (this.staticPseudoInstances == null) {
            return false;
        }
        return this.staticPseudoInstances.contains(s);
    }

    public void copyDefaultStyleDeclarations(CSSStylableElement stylableElement) {
        this.setDefaultStyleDeclaration(null, stylableElement.getDefaultStyleDeclaration(null));
        String[] staticPseudoInstances = stylableElement.getStaticPseudoInstances();
        if (staticPseudoInstances != null) {
            int i = 0;
            while (i < staticPseudoInstances.length) {
                String pseudoE = staticPseudoInstances[i];
                CSSStyleDeclaration declaration = stylableElement.getDefaultStyleDeclaration(pseudoE);
                this.setDefaultStyleDeclaration(pseudoE, declaration);
                ++i;
            }
        }
    }

    public abstract String getLocalName();

    public abstract String getAttribute(String var1);

    public String getAttributeNS(String namespace, String attr) throws DOMException {
        return this.getAttribute(attr);
    }

    public Attr getAttributeNode(String arg0) {
        return null;
    }

    public Attr getAttributeNodeNS(String arg0, String arg1) throws DOMException {
        return null;
    }

    public NodeList getElementsByTagName(String arg0) {
        return null;
    }

    public NodeList getElementsByTagNameNS(String arg0, String arg1) throws DOMException {
        return null;
    }

    public boolean hasAttribute(String arg0) {
        return false;
    }

    public boolean hasAttributeNS(String namespace, String attr) throws DOMException {
        return this.hasAttribute(attr);
    }

    public void removeAttribute(String arg0) throws DOMException {
    }

    public void removeAttributeNS(String arg0, String arg1) throws DOMException {
    }

    public Attr removeAttributeNode(Attr arg0) throws DOMException {
        return null;
    }

    public void setAttribute(String arg0, String arg1) throws DOMException {
    }

    public void setAttributeNS(String arg0, String arg1, String arg2) throws DOMException {
    }

    public Attr setAttributeNode(Attr arg0) throws DOMException {
        return null;
    }

    public Attr setAttributeNodeNS(Attr arg0) throws DOMException {
        return null;
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.insertBefore(newChild, null);
    }

    public Node cloneNode(boolean arg0) {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public String getTagName() {
        return this.getLocalName();
    }

    public Node getNextSibling() {
        return null;
    }

    public String getNodeName() {
        return this.getLocalName();
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return null;
    }

    public boolean isSupported(String arg0, String arg1) {
        return false;
    }

    public void normalize() {
    }

    public Node removeChild(Node arg0) throws DOMException {
        return null;
    }

    public Node replaceChild(Node arg0, Node arg1) throws DOMException {
        return null;
    }

    public void setNodeValue(String arg0) throws DOMException {
    }

    public void setPrefix(String arg0) throws DOMException {
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    public String getBaseURI() {
        return null;
    }

    public Object getFeature(String feature, String version) {
        return null;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public Object getUserData(String key) {
        return null;
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    public boolean isEqualNode(Node arg) {
        return false;
    }

    public boolean isSameNode(Node other) {
        return false;
    }

    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    public void setTextContent(String textContent) throws DOMException {
    }

    public Object getNativeWidget() {
        return this.nativeWidget;
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public CSSStyleDeclaration getDefaultStyleDeclaration(String pseudoE) {
        return (CSSStyleDeclaration)this.defaultStyleDeclarationMap.get(pseudoE);
    }

    public void setDefaultStyleDeclaration(String pseudoE, CSSStyleDeclaration declaration) {
        this.defaultStyleDeclarationMap.put(pseudoE, declaration);
    }

    public void onStylesApplied(NodeList nodes) {
    }

    protected Element getElement(Object widget) {
        return this.engine.getElement(widget);
    }

    public CSSExtendedProperties getStyle() {
        if (this.style == null) {
            this.style = new CSSExtendedPropertiesImpl(this.nativeWidget, this.engine);
        }
        return this.style;
    }

    public String[] getStaticPseudoInstances() {
        if (this.staticPseudoInstances == null) {
            return EMPTY_STRING;
        }
        return this.staticPseudoInstances.toArray(EMPTY_STRING);
    }

    public boolean isPseudoInstanceOf(String s) {
        if (this.staticPseudoInstances == null) {
            return false;
        }
        return this.staticPseudoInstances.contains(s);
    }

    public void initialize() {
    }

    public void dispose() {
    }

    protected void doApplyStyles() {
        try {
            this.engine.applyStyles(this.getNativeWidget(), false, true);
        }
        catch (Exception ex) {
            this.engine.handleExceptions(ex);
        }
    }
}

