/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TaskDescriptionProvider {
    public static final String TASKS_DESCRIPTION_XML_FILE_NAME = "/org/eclipse/ant/internal/ui/editor/anttasks_1.6.0.xml";
    public static final String XML_TAG_TASKS = "tasks";
    public static final String XML_TAG_TASK = "task";
    public static final String XML_TAG_ELEMENTS = "elements";
    public static final String XML_TAG_ATTRIBUTE = "attribute";
    public static final String XML_TAG_ATTRIBUTES = "attributes";
    public static final String XML_TAG_ELEMENT = "element";
    public static final String XML_TAG_STRUCTURE = "structure";
    public static final String XML_ATTRIBUTE_REQUIRED = "required";
    private static TaskDescriptionProvider fgDefault;
    private Map taskNodes = null;

    private TaskDescriptionProvider() {
    }

    public static TaskDescriptionProvider getDefault() {
        if (fgDefault == null) {
            fgDefault = new TaskDescriptionProvider();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    fgDefault.initialize();
                }
            };
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            try {
                service.busyCursorWhile(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        return fgDefault;
    }

    protected void initialize() {
        this.taskNodes = new HashMap();
        Document doc = this.parseFile(TASKS_DESCRIPTION_XML_FILE_NAME);
        Element root = doc.getDocumentElement();
        NodeList tasks = root.getChildNodes();
        Node node = null;
        int i = 0;
        while (i < tasks.getLength()) {
            Element task;
            String name;
            node = tasks.item(i);
            if (node.getNodeType() == 1 && XML_TAG_TASK.equals(node.getNodeName()) && (name = (task = (Element)node).getAttribute("name")) != null) {
                ProposalNode tasknode = new ProposalNode(this.getDescription(task), null);
                this.taskNodes.put(name, tasknode);
                NodeList nodes = task.getElementsByTagName(XML_TAG_ATTRIBUTE);
                Element e = null;
                int j = 0;
                while (j < nodes.getLength()) {
                    e = (Element)nodes.item(j);
                    this.addNode(e, tasknode);
                    ++j;
                }
                nodes = task.getElementsByTagName(XML_TAG_ELEMENT);
                j = 0;
                while (j < nodes.getLength()) {
                    e = (Element)nodes.item(j);
                    this.addNode(e, tasknode);
                    ++j;
                }
            }
            ++i;
        }
    }

    void addNode(Element element, ProposalNode node) {
        String name = element.getAttribute("name");
        if (name != null) {
            node.addChild(name, new ProposalNode(this.getDescription(element), element.getAttribute(XML_ATTRIBUTE_REQUIRED)));
        }
    }

    String getDescription(Element element) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && "description".equals(node.getNodeName()) && (node = node.getFirstChild()) != null) {
                return node.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    private Document parseFile(String aFileName) {
        Document tempDocument = null;
        DocumentBuilderFactory tempFactory = DocumentBuilderFactory.newInstance();
        tempFactory.setIgnoringComments(true);
        tempFactory.setIgnoringElementContentWhitespace(true);
        tempFactory.setCoalescing(true);
        try {
            DocumentBuilder tempDocBuilder = tempFactory.newDocumentBuilder();
            tempDocBuilder.setErrorHandler(new DefaultHandler());
            URL tempURL = this.getClass().getResource(aFileName);
            InputSource tempInputSource = new InputSource(tempURL.toExternalForm());
            tempDocument = tempDocBuilder.parse(tempInputSource);
        }
        catch (ParserConfigurationException e) {
            AntUIPlugin.log(e);
        }
        catch (IOException ioException) {
            AntUIPlugin.log(ioException);
        }
        catch (SAXException saxException) {
            AntUIPlugin.log(saxException);
        }
        return tempDocument;
    }

    public String getDescriptionForTask(String aTaskName) {
        ProposalNode task = (ProposalNode)this.taskNodes.get(aTaskName);
        if (task != null) {
            return task.desc;
        }
        return null;
    }

    public String getDescriptionForTaskAttribute(String aTaskName, String anAttributeName) {
        ProposalNode att;
        ProposalNode task = (ProposalNode)this.taskNodes.get(aTaskName);
        if (task != null && (att = task.getChild(anAttributeName)) != null) {
            return att.desc;
        }
        return null;
    }

    public String getRequiredAttributeForTaskAttribute(String aTaskName, String anAttributeName) {
        ProposalNode att;
        ProposalNode task = (ProposalNode)this.taskNodes.get(aTaskName);
        if (task != null && (att = task.getChild(anAttributeName)) != null) {
            return att.required;
        }
        return null;
    }

    ProposalNode getTaskNode(String aTaskName) {
        return (ProposalNode)this.taskNodes.get(aTaskName);
    }

    protected static void reset() {
        if (fgDefault != null && TaskDescriptionProvider.fgDefault.taskNodes != null) {
            TaskDescriptionProvider.fgDefault.taskNodes.clear();
        }
        fgDefault = null;
    }

    class ProposalNode {
        String desc = null;
        String required = null;
        HashMap nodes = null;

        ProposalNode(String desc, String required) {
            this.desc = desc;
            this.required = required;
        }

        void addChild(String name, ProposalNode node) {
            if (this.nodes == null) {
                this.nodes = new HashMap(9);
            }
            this.nodes.put(name, node);
        }

        ProposalNode getChild(String name) {
            if (this.nodes != null) {
                return (ProposalNode)this.nodes.get(name);
            }
            return null;
        }
    }
}

