/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.E4XMIResourceFactory;
import org.eclipse.e4.ui.internal.workbench.ModelAssembler;
import org.eclipse.e4.ui.internal.workbench.ModelReconcilingService;
import org.eclipse.e4.ui.internal.workbench.URIHelper;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.e4.ui.workbench.IModelResourceHandler;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class ResourceHandler
implements IModelResourceHandler {
    private ResourceSetImpl resourceSetImpl;
    private Resource resource;
    @Inject
    private Logger logger;
    @Inject
    private IEclipseContext context;
    @Inject
    @Named(value="initialWorkbenchModelURI")
    private URI applicationDefinitionInstance;
    @Inject
    @Named(value="instanceLocation")
    private Location instanceLocation;
    private final boolean deltaRestore;
    private final boolean saveAndRestore;
    private final boolean clearPersistedState;

    @Inject
    public ResourceHandler(@Named(value="persistState") boolean saveAndRestore, @Named(value="clearPersistedState") boolean clearPersistedState, @Named(value="deltaRestore") boolean deltaRestore) {
        this.saveAndRestore = saveAndRestore;
        this.clearPersistedState = clearPersistedState;
        this.deltaRestore = deltaRestore;
    }

    @PostConstruct
    void init() {
        this.resourceSetImpl = new ResourceSetImpl();
        this.resourceSetImpl.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new E4XMIResourceFactory());
        this.resourceSetImpl.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application", (Object)ApplicationPackageImpl.eINSTANCE);
        this.resourceSetImpl.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/commands", (Object)CommandsPackageImpl.eINSTANCE);
        this.resourceSetImpl.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/ui", (Object)UiPackageImpl.eINSTANCE);
        this.resourceSetImpl.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/ui/menu", (Object)MenuPackageImpl.eINSTANCE);
        this.resourceSetImpl.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/ui/basic", (Object)org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl.eINSTANCE);
        this.resourceSetImpl.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/ui/advanced", (Object)AdvancedPackageImpl.eINSTANCE);
        this.resourceSetImpl.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/descriptor/basic", (Object)BasicPackageImpl.eINSTANCE);
    }

    public Resource loadMostRecentModel() {
        File deltaFile;
        File baseLocation;
        try {
            baseLocation = new File(URIUtil.toURI((URL)this.instanceLocation.getURL()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        baseLocation = new File(baseLocation, ".metadata");
        baseLocation = new File(baseLocation, ".plugins");
        baseLocation = new File(baseLocation, "org.eclipse.e4.workbench");
        if (this.deltaRestore && this.saveAndRestore && !this.clearPersistedState && (deltaFile = new File(baseLocation, "deltas.xml")).exists()) {
            MApplication appElement;
            block11: {
                appElement = null;
                try {
                    File workbenchData = new File(baseLocation, "workbench.xmi");
                    URI restoreLocationNew = URI.createFileURI((String)workbenchData.getAbsolutePath());
                    this.resource = this.resourceSetImpl.createResource(restoreLocationNew);
                    Resource oldResource = this.loadResource(this.applicationDefinitionInstance);
                    appElement = (MApplication)oldResource.getContents().get(0);
                    this.context.set(MApplication.class, (Object)appElement);
                    ModelAssembler contribProcessor = (ModelAssembler)ContextInjectionFactory.make(ModelAssembler.class, (IEclipseContext)this.context);
                    contribProcessor.processModel();
                    File deltaOldFile = new File(baseLocation, "deltas_42M7migration.xml");
                    deltaFile.renameTo(deltaOldFile);
                    URI restoreLocation = URI.createFileURI((String)deltaOldFile.getAbsolutePath());
                    File file = new File(restoreLocation.toFileString());
                    if (file.exists()) {
                        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                        ModelReconcilingService modelReconcilingService = new ModelReconcilingService();
                        ModelReconciler modelReconciler = modelReconcilingService.createModelReconciler();
                        document.normalizeDocument();
                        Collection<ModelDelta> deltas = modelReconciler.constructDeltas(oldResource.getContents().get(0), document);
                        modelReconcilingService.applyDeltas(deltas);
                    }
                }
                catch (Exception e) {
                    if (this.logger == null) break block11;
                    this.logger.error((Throwable)e);
                }
            }
            if (appElement != null) {
                this.resource.getContents().add((Object)((EObject)appElement));
            }
            return this.resource;
        }
        File workbenchData = new File(baseLocation, "workbench.xmi");
        if (this.clearPersistedState && workbenchData.exists()) {
            workbenchData.delete();
        }
        URI restoreLocation = null;
        if (this.saveAndRestore) {
            restoreLocation = URI.createFileURI((String)workbenchData.getAbsolutePath());
        }
        long restoreLastModified = restoreLocation == null ? 0L : new File(restoreLocation.toFileString()).lastModified();
        long lastApplicationModification = this.getLastApplicationModification();
        boolean restore = restoreLastModified > lastApplicationModification;
        this.resource = null;
        if (restore && this.saveAndRestore) {
            this.resource = this.loadResource(restoreLocation);
        }
        if (this.resource == null) {
            Resource applicationResource = this.loadResource(this.applicationDefinitionInstance);
            MApplication theApp = (MApplication)applicationResource.getContents().get(0);
            this.resource = this.resourceSetImpl.createResource(restoreLocation);
            this.resource.getContents().add((Object)((EObject)theApp));
        }
        MApplication appElement = (MApplication)this.resource.getContents().get(0);
        this.context.set(MApplication.class, (Object)appElement);
        ModelAssembler contribProcessor = (ModelAssembler)ContextInjectionFactory.make(ModelAssembler.class, (IEclipseContext)this.context);
        contribProcessor.processModel();
        return this.resource;
    }

    public void save() throws IOException {
        if (this.saveAndRestore) {
            this.resource.save(null);
        }
    }

    private Resource loadResource(URI uri) {
        Resource resource;
        try {
            resource = this.resourceSetImpl.getResource(uri, true);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, "Unable to load resource " + uri.toString());
            return null;
        }
        String contributorURI = URIHelper.EMFtoPlatform(uri);
        if (contributorURI != null) {
            TreeIterator it = EcoreUtil.getAllContents((Collection)resource.getContents());
            while (it.hasNext()) {
                EObject o = (EObject)it.next();
                if (!(o instanceof MApplicationElement)) continue;
                ((MApplicationElement)o).setContributorURI(contributorURI);
            }
        }
        return resource;
    }

    private long getLastApplicationModification() {
        long appLastModified = 0L;
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Map attributes = resourceSetImpl.getURIConverter().getAttributes(this.applicationDefinitionInstance, Collections.singletonMap("requestedAttributes", Collections.singleton("timeStamp")));
        Object timestamp = attributes.get("timeStamp");
        if (timestamp instanceof Long) {
            appLastModified = (Long)timestamp;
        } else if (this.applicationDefinitionInstance.isPlatformPlugin()) {
            try {
                URL url = new URL(this.applicationDefinitionInstance.toString());
                Object[] obj = PlatformURLPluginConnection.parse((String)url.getFile().trim(), (URL)url);
                Bundle b = (Bundle)obj[0];
                URL resolved = b.getEntry((String)obj[1]);
                if (resolved == null) {
                    resolved = b.getResource((String)obj[1]);
                }
                if (resolved != null) {
                    URLConnection openConnection = resolved.openConnection();
                    appLastModified = openConnection.getLastModified();
                }
            }
            catch (Exception exception) {}
        }
        return appLastModified;
    }
}

