/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.externaltools.internal.model;

import java.util.Map;
import org.eclipse.core.externaltools.internal.ExternalToolsCore;
import org.eclipse.core.externaltools.internal.launchConfigurations.ExternalToolsCoreUtil;
import org.eclipse.core.externaltools.internal.model.BuilderCoreUtils;
import org.eclipse.core.externaltools.internal.model.ExternalToolsModelMessages;
import org.eclipse.core.externaltools.internal.registry.ExternalToolMigration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;

public final class ExternalToolBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "org.eclipse.ui.externaltools.ExternalToolBuilder";
    private static String buildType = "none";
    private static IProject buildProject = null;
    private static IResourceDelta buildDelta = null;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        boolean kindCompatible;
        if (ExternalToolsCore.getDefault().getBundle().getState() != 32) {
            return null;
        }
        ILaunchConfiguration config = BuilderCoreUtils.configFromBuildCommandArgs(this.getProject(), args, new String[1]);
        if (config == null) {
            throw ExternalToolsCore.newError(ExternalToolsModelMessages.ExternalToolBuilder_0, null);
        }
        IProject[] projectsWithinScope = null;
        IResource[] resources = ExternalToolsCoreUtil.getResourcesForBuildScope(config);
        if (resources != null) {
            projectsWithinScope = new IProject[resources.length];
            int i = 0;
            while (i < resources.length) {
                projectsWithinScope[i] = resources[i].getProject();
                ++i;
            }
        }
        if ((kindCompatible = this.commandConfiguredForKind(config, kind)) && this.configEnabled(config)) {
            this.doBuildBasedOnScope(resources, kind, config, args, monitor);
        }
        return projectsWithinScope;
    }

    private boolean commandConfiguredForKind(ILaunchConfiguration config, int kind) {
        try {
            if (!config.getAttribute("org.eclipse.ui.externaltools.ATTR_TRIGGERS_CONFIGURED", false)) {
                ICommand command = this.getCommand();
                BuilderCoreUtils.configureTriggers(config, command);
                IProjectDescription desc = this.getProject().getDescription();
                ICommand[] commands = desc.getBuildSpec();
                int index = this.getBuilderCommandIndex(commands, command);
                if (index != -1) {
                    commands[index] = command;
                    desc.setBuildSpec(commands);
                    this.getProject().setDescription(desc, null);
                    ILaunchConfigurationWorkingCopy copy = config.getWorkingCopy();
                    copy.setAttribute("org.eclipse.ui.externaltools.ATTR_TRIGGERS_CONFIGURED", true);
                    copy.doSave();
                }
                return command.isBuilding(kind);
            }
        }
        catch (CoreException e) {
            ExternalToolsCore.log(e);
            return true;
        }
        return true;
    }

    private int getBuilderCommandIndex(ICommand[] buildSpec, ICommand command) {
        Map commandArgs = command.getArguments();
        if (commandArgs == null) {
            return -1;
        }
        String handle = (String)commandArgs.get("LaunchConfigHandle");
        if (handle == null) {
            return -1;
        }
        int i = 0;
        while (i < buildSpec.length) {
            String buildSpecHandle;
            Map buildSpecArgs;
            ICommand buildSpecCommand = buildSpec[i];
            if (ID.equals(buildSpecCommand.getBuilderName()) && (buildSpecArgs = buildSpecCommand.getArguments()) != null && handle.equals(buildSpecHandle = (String)buildSpecArgs.get("LaunchConfigHandle"))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean configEnabled(ILaunchConfiguration config) {
        try {
            return ExternalToolsCoreUtil.isBuilderEnabled(config);
        }
        catch (CoreException e) {
            ExternalToolsCore.log(e);
            return true;
        }
    }

    private void doBuildBasedOnScope(IResource[] resources, int kind, ILaunchConfiguration config, Map args, IProgressMonitor monitor) throws CoreException {
        boolean buildForChange = true;
        if (kind != 6 && resources != null && resources.length > 0) {
            buildForChange = this.buildScopeIndicatesBuild(resources);
        }
        if (buildForChange) {
            this.launchBuild(kind, config, args, monitor);
        }
    }

    private void launchBuild(int kind, ILaunchConfiguration config, Map args, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(NLS.bind((String)ExternalToolsModelMessages.ExternalToolBuilder_Running__0_____1, (Object[])new String[]{config.getName()}));
        this.buildStarted(kind, args);
        ILaunchConfiguration newconfig = ExternalToolMigration.migrateRunInBackground(config);
        newconfig.launch("run", monitor);
        this.buildEnded();
    }

    public static String getBuildType() {
        return buildType;
    }

    public static IProject getBuildProject() {
        return buildProject;
    }

    public static IResourceDelta getBuildDelta() {
        return buildDelta;
    }

    private void buildStarted(int buildKind, Map args) {
        switch (buildKind) {
            case 10: {
                buildType = "incremental";
                buildDelta = this.getDelta(this.getProject());
                break;
            }
            case 6: {
                if (args != null && args.containsKey("incclean")) {
                    buildType = "incremental";
                    buildDelta = this.getDelta(this.getProject());
                    break;
                }
                buildType = "full";
                break;
            }
            case 9: {
                buildType = "auto";
                buildDelta = this.getDelta(this.getProject());
                break;
            }
            case 15: {
                buildType = "clean";
                break;
            }
            default: {
                buildType = "none";
            }
        }
        buildProject = this.getProject();
    }

    private void buildEnded() {
        buildType = "none";
        buildProject = null;
        buildDelta = null;
    }

    private boolean buildScopeIndicatesBuild(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            IResourceDelta delta = this.getDelta(resources[i].getProject());
            if (delta == null) {
                return true;
            }
            IPath path = resources[i].getProjectRelativePath();
            IResourceDelta change = delta.findMember(path);
            if (change != null) {
                boolean[] trueChange = new boolean[]{false};
                try {
                    change.accept((IResourceDeltaVisitor)new IgnoreTeamPrivateChanges(trueChange));
                }
                catch (CoreException e) {
                    ExternalToolsCore.log("Internal error resolving changed resources during build", e);
                }
                return trueChange[0];
            }
            ++i;
        }
        return false;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        ICommand command = this.getCommand();
        ILaunchConfiguration config = BuilderCoreUtils.configFromBuildCommandArgs(this.getProject(), command.getArguments(), new String[1]);
        if (!this.configEnabled(config)) {
            return;
        }
        if (!config.getAttribute("org.eclipse.ui.externaltools.ATTR_TRIGGERS_CONFIGURED", false)) {
            super.clean(monitor);
            return;
        }
        this.launchBuild(15, config, null, monitor);
    }

    private final class IgnoreTeamPrivateChanges
    implements IResourceDeltaVisitor {
        private boolean[] fTrueChange;

        private IgnoreTeamPrivateChanges(boolean[] trueChange) {
            this.fTrueChange = trueChange;
        }

        public boolean visit(IResourceDelta visitDelta) throws CoreException {
            IResource resource = visitDelta.getResource();
            if (resource instanceof IFile) {
                this.fTrueChange[0] = true;
                return false;
            }
            return true;
        }
    }
}

