/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.subscribers.BatchingLock;

public class ReentrantLock
extends BatchingLock {
    protected BatchingLock.ThreadInfo createThreadInfo(BatchingLock.IFlushOperation operation) {
        return new CVSThreadInfo(operation);
    }

    public void folderChanged(IContainer folder) {
        CVSThreadInfo info = (CVSThreadInfo)this.getThreadInfo();
        Assert.isNotNull((Object)((Object)info), (String)"Folder changed outside of resource lock");
        info.addChangedFolder(folder);
    }

    public class CVSThreadInfo
    extends BatchingLock.ThreadInfo {
        private Set changedFolders = new HashSet();

        public CVSThreadInfo(BatchingLock.IFlushOperation operation) {
            super((BatchingLock)ReentrantLock.this, operation);
        }

        public void addChangedFolder(IContainer container) {
            this.changedFolders.add(container);
        }

        public boolean isEmpty() {
            return this.changedFolders.isEmpty() && super.isEmpty();
        }

        public IContainer[] getChangedFolders() {
            return this.changedFolders.toArray(new IContainer[this.changedFolders.size()]);
        }

        public void flush(IProgressMonitor monitor) throws TeamException {
            try {
                super.flush(monitor);
            }
            finally {
                this.changedFolders.clear();
            }
        }
    }
}

