/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.texteditor.IUpdate;

public class ConfigureColumnsAction
extends Action
implements IUpdate {
    private TreeModelViewer fViewer;

    public ConfigureColumnsAction(TreeModelViewer viewer) {
        this.setText(ActionMessages.ConfigureColumnsAction_0);
        this.setId(String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".ConfigureColumnsAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.configure_columns_context");
        this.fViewer = viewer;
    }

    public void update() {
        this.setEnabled(this.fViewer.isShowColumns());
    }

    public void run() {
        ListSelectionDialog dialog = new ListSelectionDialog(this.fViewer.getControl().getShell(), (Object)this.fViewer.getColumnPresentation(), (IStructuredContentProvider)new ColumnContentProvider(), (ILabelProvider)new ColumnLabelProvider(), ActionMessages.ConfigureColumnsAction_1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.configure_columns_dialog_context");
        String[] visibleColumns = this.fViewer.getVisibleColumns();
        ArrayList<String> initialSelection = new ArrayList<String>(visibleColumns.length);
        int i = 0;
        while (i < visibleColumns.length) {
            initialSelection.add(visibleColumns[i]);
            ++i;
        }
        dialog.setTitle(ActionMessages.ConfigureColumnsAction_2);
        dialog.setInitialElementSelections(initialSelection);
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result.length == 0) {
                this.fViewer.setShowColumns(false);
            } else {
                String[] ids = new String[result.length];
                System.arraycopy(result, 0, ids, 0, result.length);
                this.fViewer.resetColumnSizes(ids);
                this.fViewer.setVisibleColumns(ids);
            }
        }
    }

    class ColumnContentProvider
    implements IStructuredContentProvider {
        ColumnContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((IColumnPresentation)inputElement).getAvailableColumns();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ColumnLabelProvider
    extends LabelProvider {
        private Map fImages = new HashMap();

        ColumnLabelProvider() {
        }

        public Image getImage(Object element) {
            ImageDescriptor imageDescriptor = ConfigureColumnsAction.this.fViewer.getColumnPresentation().getImageDescriptor((String)element);
            if (imageDescriptor != null) {
                Image image = (Image)this.fImages.get(imageDescriptor);
                if (image == null) {
                    image = imageDescriptor.createImage();
                    this.fImages.put(imageDescriptor, image);
                }
                return image;
            }
            return null;
        }

        public String getText(Object element) {
            return ConfigureColumnsAction.this.fViewer.getColumnPresentation().getHeader((String)element);
        }

        public void dispose() {
            super.dispose();
            Iterator iterator = this.fImages.values().iterator();
            while (iterator.hasNext()) {
                Image image = (Image)iterator.next();
                image.dispose();
            }
            this.fImages.clear();
        }
    }
}

