/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.type;

import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.TypeVisitor;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorType;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardTypeImpl
implements WildcardType,
EclipseMirrorType {
    private final ITypeBinding _binding;
    private final BaseProcessorEnv _env;

    public WildcardTypeImpl(ITypeBinding binding, BaseProcessorEnv env) {
        this._binding = binding;
        this._env = env;
        assert (this._binding != null && this._binding.isWildcardType());
        assert (env != null) : "missing environment";
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visitWildcardType(this);
    }

    @Override
    public Collection<ReferenceType> getLowerBounds() {
        ITypeBinding bound = this._binding.getBound();
        if (bound == null || this._binding.isUpperbound()) {
            return Collections.emptyList();
        }
        DeclaredType mirror = Factory.createReferenceType(bound, this._env);
        if (mirror == null) {
            mirror = Factory.createErrorClassType(bound);
        }
        return Collections.singletonList(mirror);
    }

    @Override
    public Collection<ReferenceType> getUpperBounds() {
        ITypeBinding bound = this._binding.getBound();
        if (bound == null || !this._binding.isUpperbound()) {
            return Collections.emptyList();
        }
        DeclaredType mirror = Factory.createReferenceType(bound, this._env);
        if (mirror == null) {
            mirror = Factory.createErrorClassType(bound);
        }
        return Collections.singletonList(mirror);
    }

    @Override
    public String toString() {
        return this._binding.toString();
    }

    public int hashCode() {
        return this._binding.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof WildcardTypeImpl) {
            return ((WildcardTypeImpl)obj)._binding.isEqualTo((IBinding)this._binding);
        }
        return false;
    }

    @Override
    public EclipseMirrorObject.MirrorKind kind() {
        return EclipseMirrorObject.MirrorKind.TYPE_WILDCARD;
    }

    @Override
    public ITypeBinding getTypeBinding() {
        return this._binding;
    }

    @Override
    public BaseProcessorEnv getEnvironment() {
        return this._env;
    }

    @Override
    public boolean isAssignmentCompatible(EclipseMirrorType left) {
        return false;
    }

    @Override
    public boolean isSubTypeCompatible(EclipseMirrorType type) {
        return false;
    }
}

