/*******************************************************************************
 * Copyright (c) 2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.examples.podreader.views;

import java.util.Properties;

import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IManagedConnectionListener;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.examples.podreader.cp.PodProfileConstants;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;

public class PodContentView extends ViewPart {
	
	public static final String VIEW_ID = 
		"org.eclipse.datatools.examples.podreader.views.PodContentView";
	
	private TableViewer viewer;
	
	private static PodContentView view;
	
	public static PodContentView getPodView() {
		return view;
	}
	
	/**
	 * The constructor.
	 */
	public PodContentView() {
		view = this;
	}
	
	private void loadPodContent(String path) {
		if (viewer == null) {
			return;
		}
		viewer.setInput(path);
	}
	
	private void clearPodContent() {
		if (viewer == null) {
			return;
		}
		viewer.getTable().clearAll();
	}
	
	private Table createTable(Composite parent) {
		Table t = new Table(parent, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
		GridData gridData = new GridData(GridData.FILL_BOTH);
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 3;
		t.setLayoutData(gridData);
		
		t.setHeaderVisible(true);
		t.setLinesVisible(true);
		TableColumn tc = new TableColumn(t, SWT.LEFT, 0);
		tc.setText("Name");
		tc.setWidth(375);
		tc.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_NAME));
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_NAME));
			}
		});
		tc = new TableColumn(t, SWT.LEFT, 1);
		tc.setText("Artist");
		tc.setWidth(220);
		tc.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_ARTIST));
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_ARTIST));
			}
		});
		tc = new TableColumn(t, SWT.LEFT, 2);
		tc.setText("Album");
		tc.setWidth(200);
		tc.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_ALBUM));
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_ALBUM));
			}
		});
		tc = new TableColumn(t, SWT.LEFT, 3);
		tc.setText("Genre");
		tc.setWidth(75);
		tc.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_GENRE));
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				viewer.setSorter(new SongSorter(SongSorter.SONG_GENRE));
			}
		});
		return t;
	}
	
	/**
	 * This is a callback that will allow us
	 * to create the viewer and initialize it.
	 */
	public void createPartControl(Composite parent) {
		viewer = new TableViewer(createTable(parent));
		viewer.setContentProvider(new ViewContentProvider());
		viewer.setLabelProvider(new ViewLabelProvider());
		viewer.setSorter(new SongSorter(SongSorter.SONG_NAME));
		addConnectionProfileHooks();
	}
	
	private void addConnectionProfileHooks() {
		ProfileManager manager = ProfileManager.getInstance();
		// Hook existing connection profiles
		addExistingProfileHooks(manager);
		// Hook new connection profiles
		addNewProfileHooks(manager);
	}
	
	private void addNewProfileHooks(ProfileManager manager) {
		manager.addProfileListener(new IProfileListener() {
			public void profileAdded(IConnectionProfile profile) {
				addConnectionListener(profile);
				
			}
			public void profileDeleted(IConnectionProfile arg0) {
				// don't care
				
			}
			public void profileChanged(IConnectionProfile arg0) {
				// don't care
			}
		});
	}

	private void addExistingProfileHooks(ProfileManager manager) {
		IConnectionProfile[] profiles = manager.getProfiles();
		for (int i = 0; i < profiles.length; i++) {
			addConnectionListener(profiles[i]);
		}
	}

	private void addConnectionListener(IConnectionProfile profile) {
		IManagedConnection conn = 
			profile.getManagedConnection(PodProfileConstants.POD_CONNECTION_FACTORY_ID);
		if (conn != null) {
			conn.addConnectionListener(new IManagedConnectionListener() {
				public void opened(final ConnectEvent ce) {
					PodContentView.getPodView().getSite().
						getShell().getDisplay().asyncExec(new Runnable() {
							public void run() {
								Properties props = 
									ce.getConnectionProfile().getBaseProperties();
								String path = (String)props.get("podPath");
								if (path != null) {
									loadPodContent(path);
								}
							}
						});
				}
				public void modified(ConnectEvent ce) {
					// Do nothing
				}
				public boolean okToClose(ConnectEvent ce) {
					// Always ok to close
					return true;
				}
				public void aboutToClose(ConnectEvent ce) {
					// Do nothing
				}
				public void closed(ConnectEvent ce) {
					PodContentView.getPodView().getSite().
						getShell().getDisplay().asyncExec(new Runnable() {
						public void run() {
							clearPodContent();
						}
					});
				}
			});
		}
	}
	
	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		viewer.getControl().setFocus();
	}
}