/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.ComponentPackage;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.InterfaceDefinitionPackage;
import org.eclipse.comma.behavior.interfaces.scoping.InterfaceUtilities;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.project.ComponentReference;
import org.eclipse.comma.project.project.CompoundInterface;
import org.eclipse.comma.project.project.DocumentationGenerationTask;
import org.eclipse.comma.project.project.ExecutableSource;
import org.eclipse.comma.project.project.FilePath;
import org.eclipse.comma.project.project.GeneratorBlock;
import org.eclipse.comma.project.project.InterfaceMappings;
import org.eclipse.comma.project.project.InterfaceModel;
import org.eclipse.comma.project.project.InterfaceReference;
import org.eclipse.comma.project.project.MonitoringTask;
import org.eclipse.comma.project.project.Project;
import org.eclipse.comma.project.project.ProjectDescription;
import org.eclipse.comma.project.project.ProjectPackage;
import org.eclipse.comma.project.project.ReachabilityGraphGenerationTask;
import org.eclipse.comma.project.project.SimulatorGenerationTask;
import org.eclipse.comma.project.project.Task;
import org.eclipse.comma.project.project.TraceSource;
import org.eclipse.comma.project.project.TypeMapping;
import org.eclipse.comma.project.project.TypeMappings;
import org.eclipse.comma.project.validation.AbstractProjectValidator;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.types.FileImport;
import org.eclipse.comma.types.types.NamespaceImport;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class ProjectValidator
extends AbstractProjectValidator {
    public final String WARNING_CODE_EMPTY_BLOCK = "warning_code_empty_block";
    public final String ERROR_CODE_DUPLICATE_BLOCK = "error_code_duplicate_block";
    @Inject
    private IScopeProvider scopeProvider;

    @Check
    public void checkImportForValidity(FileImport imp) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((Resource)imp.eResource(), (URI)URI.createURI((String)imp.getImportURI()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Invalid resource", (EStructuralFeature)TypesPackage.Literals.FILE_IMPORT__IMPORT_URI);
        } else {
            Resource res = EcoreUtil2.getResource((Resource)imp.eResource(), (String)imp.getImportURI());
            if (res == null) {
                this.error("Invalid resource", (EStructuralFeature)TypesPackage.Literals.FILE_IMPORT__IMPORT_URI);
            } else {
                boolean _not_1;
                boolean _isEmpty = res.getErrors().isEmpty();
                boolean bl2 = _not_1 = !_isEmpty;
                if (_not_1) {
                    this.error("Resource contains errors", (EStructuralFeature)TypesPackage.Literals.FILE_IMPORT__IMPORT_URI);
                }
            }
        }
    }

    @Check
    public void checkUniqueTaskName(Project project) {
        HashSet<Task> duplicates = new HashSet<Task>();
        HashMap<String, Task> knownTasks = new HashMap<String, Task>();
        List tasks = EcoreUtil2.getAllContentsOfType((EObject)project, Task.class);
        for (Task task : tasks) {
            Task duplicate = knownTasks.put(task.getName(), task);
            if (duplicate == null) continue;
            duplicates.add(task);
            duplicates.add(duplicate);
        }
        Consumer<Task> _function = new Consumer<Task>(){

            @Override
            public void accept(Task it) {
                ProjectValidator.this.error("Duplicate task name.", it, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
            }
        };
        duplicates.forEach(_function);
    }

    @Check
    public void checkBlocks(Project project) {
        HashSet<GeneratorBlock> duplicates = new HashSet<GeneratorBlock>();
        HashMap<String, GeneratorBlock> knownBlocks = new HashMap<String, GeneratorBlock>();
        EList<GeneratorBlock> _generatorBlocks = project.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            GeneratorBlock duplicate;
            boolean _isEmpty = IteratorExtensions.isEmpty((Iterator)block.eAllContents());
            if (_isEmpty) {
                this.warning("This block contains no tasks or elements.", block, null, "warning_code_empty_block", new String[0]);
            }
            if ((duplicate = knownBlocks.put(block.eClass().getName(), block)) == null) continue;
            duplicates.add(block);
            duplicates.add(duplicate);
        }
        Consumer<GeneratorBlock> _function = new Consumer<GeneratorBlock>(){

            @Override
            public void accept(GeneratorBlock it) {
                ProjectValidator.this.error("Duplicate block.", it, null, "error_code_duplicate_block", new String[0]);
            }
        };
        duplicates.forEach(_function);
    }

    @Check
    public void checkTypeMappingsContent(TypeMappings typeMappings) {
        boolean _greaterThan;
        EObject _eContainer = typeMappings.eContainer().eContainer();
        Project root = (Project)_eContainer;
        IScope globalScope = this.scopeProvider.getScope((EObject)root, TypesPackage.Literals.TYPE__TYPE);
        String message = "";
        HashMap<String, ProjectValidator> map = new HashMap<String, ProjectValidator>();
        EList<TypeMapping> _commonMappings = typeMappings.getCommonMappings();
        for (TypeMapping tm : _commonMappings) {
            map.put(tm.getType().getName(), this);
        }
        EList<InterfaceMappings> _interfaceMappings = typeMappings.getInterfaceMappings();
        for (InterfaceMappings im : _interfaceMappings) {
            EList<TypeMapping> _mappings = im.getMappings();
            for (Object tm_1 : _mappings) {
                String _name = im.getInterface().getName();
                String _plus = String.valueOf(_name) + ".";
                String _name_1 = tm_1.getType().getName();
                String _plus_1 = String.valueOf(_plus) + _name_1;
                map.put(_plus_1, this);
            }
        }
        Functions.Function1<IEObjectDescription, Boolean> _function = new Functions.Function1<IEObjectDescription, Boolean>(){

            public Boolean apply(IEObjectDescription d) {
                return Objects.equal((Object)d.getEClass(), (Object)TypesPackage.Literals.SIMPLE_TYPE_DECL) && !TypeUtilities.isPredefinedType((String)d.getName().toString());
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)globalScope.getAllElements(), (Functions.Function1)_function);
        for (IEObjectDescription od : _filter) {
            String _plus_3;
            boolean _not;
            boolean _containsKey = map.containsKey(od.getName().toString());
            boolean bl = _not = !_containsKey;
            if (!_not) continue;
            QualifiedName _name_2 = od.getName();
            String _plus_2 = String.valueOf(message) + _name_2;
            message = _plus_3 = String.valueOf(_plus_2) + " ";
        }
        int _length = message.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            this.error("Missing mappings for types " + message, (EStructuralFeature)ProjectPackage.Literals.TYPE_MAPPINGS__NAME);
        }
    }

    public boolean typeMappingsRequired(Project prj) {
        IScope globalScope = this.scopeProvider.getScope((EObject)prj, TypesPackage.Literals.TYPE__TYPE);
        Functions.Function1<IEObjectDescription, Boolean> _function = new Functions.Function1<IEObjectDescription, Boolean>(){

            public Boolean apply(IEObjectDescription it) {
                return Objects.equal((Object)it.getEClass(), (Object)TypesPackage.Literals.SIMPLE_TYPE_DECL) && !TypeUtilities.isPredefinedType((String)it.getName().toString());
            }
        };
        return IterableExtensions.exists((Iterable)globalScope.getAllElements(), (Functions.Function1)_function);
    }

    @Check
    public void checkDuplicatedCommonMappings(TypeMappings mappings) {
        EList<TypeMapping> _commonMappings = mappings.getCommonMappings();
        for (TypeMapping m1 : _commonMappings) {
            EList<TypeMapping> _commonMappings_1 = mappings.getCommonMappings();
            for (TypeMapping m2 : _commonMappings_1) {
                if (Objects.equal((Object)m1, (Object)m2) || !Objects.equal((Object)m1.getType(), (Object)m2.getType())) continue;
                this.error("Duplicate type mapping", (EStructuralFeature)ProjectPackage.Literals.TYPE_MAPPINGS__COMMON_MAPPINGS, mappings.getCommonMappings().indexOf((Object)m1));
            }
        }
    }

    @Check
    public void checkDuplicatedInterfaceMappings(TypeMappings mappings) {
        EList<InterfaceMappings> _interfaceMappings = mappings.getInterfaceMappings();
        for (InterfaceMappings m1 : _interfaceMappings) {
            EList<InterfaceMappings> _interfaceMappings_1 = mappings.getInterfaceMappings();
            for (InterfaceMappings m2 : _interfaceMappings_1) {
                if (Objects.equal((Object)m1, (Object)m2) || !Objects.equal((Object)m1.getInterface(), (Object)m2.getInterface())) continue;
                this.error("Duplicate interface mapping", (EStructuralFeature)ProjectPackage.Literals.TYPE_MAPPINGS__INTERFACE_MAPPINGS, mappings.getInterfaceMappings().indexOf((Object)m1));
            }
        }
    }

    @Check
    public void checkDuplicatedTypesInInterfaceMappings(InterfaceMappings mapping) {
        EList<TypeMapping> _mappings = mapping.getMappings();
        for (TypeMapping m1 : _mappings) {
            EList<TypeMapping> _mappings_1 = mapping.getMappings();
            for (TypeMapping m2 : _mappings_1) {
                if (Objects.equal((Object)m1, (Object)m2) || !Objects.equal((Object)m1.getType(), (Object)m2.getType())) continue;
                this.error("Duplicate type mapping", (EStructuralFeature)ProjectPackage.Literals.INTERFACE_MAPPINGS__MAPPINGS, mapping.getMappings().indexOf((Object)m1));
            }
        }
    }

    @Check
    public void checkReachabilityGenerationTaskParameters(ReachabilityGraphGenerationTask rgTask) {
        boolean _tripleNotEquals;
        EList<String> _params = rgTask.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            EList<String> _params_1 = rgTask.getParams();
            for (String param : _params_1) {
                Resource ipres = EcoreUtil2.getResource((Resource)rgTask.eResource(), (String)param);
                if (ipres != null && IterableExtensions.head((Iterable)ipres.getContents()) instanceof Parameters) continue;
                this.error("Invalid resource", (EStructuralFeature)ProjectPackage.Literals.REACHABILITY_GRAPH_GENERATION_TASK__PARAMS, rgTask.getParams().indexOf((Object)param));
            }
        }
    }

    @Check
    public void checkSimulatorGenerationTaskParameters(SimulatorGenerationTask sTask) {
        boolean _tripleNotEquals;
        EList<String> _params = sTask.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            EList<String> _params_1 = sTask.getParams();
            for (String param : _params_1) {
                Resource ipres = EcoreUtil2.getResource((Resource)sTask.eResource(), (String)param);
                if (ipres != null && IterableExtensions.head((Iterable)ipres.getContents()) instanceof Parameters) continue;
                this.error("Invalid resource", (EStructuralFeature)ProjectPackage.Literals.SIMULATOR_GENERATION_TASK__PARAMS, sTask.getParams().indexOf((Object)param));
            }
        }
    }

    @Check
    public void checkSimulatorGenerationTaskMissingParameters(SimulatorGenerationTask sTask) {
        boolean _isEmpty;
        boolean _not;
        boolean _tripleNotEquals;
        final ArrayList<Interface> interfaces = new ArrayList<Interface>();
        ExecutableSource _target = sTask.getTarget();
        if (_target instanceof InterfaceReference) {
            ExecutableSource _target_1 = sTask.getTarget();
            interfaces.add(((InterfaceReference)_target_1).getInterface());
        } else {
            ExecutableSource _target_2 = sTask.getTarget();
            if (_target_2 instanceof ComponentReference) {
                ExecutableSource _target_3 = sTask.getTarget();
                Component comp = ((ComponentReference)_target_3).getComponent();
                final List compInterfaces = ComponentUtilities.getAllInterfaces((EObject)comp, (IScopeProvider)this.scopeProvider);
                Consumer<Port> _function = new Consumer<Port>(){

                    @Override
                    public void accept(final Port p) {
                        if (p instanceof ProvidedPort) {
                            Functions.Function1<Interface, Boolean> _function = new Functions.Function1<Interface, Boolean>(){

                                public Boolean apply(Interface i) {
                                    return i.getName().equals(((ProvidedPort)p).getInterface().getName());
                                }
                            };
                            Interface itf = (Interface)IterableExtensions.findFirst((Iterable)compInterfaces, (Functions.Function1)_function);
                            interfaces.add(itf);
                        }
                    }
                };
                comp.getPorts().forEach((Consumer)_function);
            }
        }
        Functions.Function1<Interface, Boolean> _function_1 = new Functions.Function1<Interface, Boolean>(){

            public Boolean apply(Interface itf) {
                Signature sig = InterfaceUtilities.getSignature((Interface)itf, (IScopeProvider)ProjectValidator.this.scopeProvider);
                return sig != null && ProjectValidator.this.hasInParameters(sig);
            }
        };
        Functions.Function1<Interface, String> _function_2 = new Functions.Function1<Interface, String>(){

            public String apply(Interface i) {
                return i.getName();
            }
        };
        List missing = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(interfaces, (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        EList<String> _params = sTask.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            EList<String> _params_1 = sTask.getParams();
            for (String file : _params_1) {
                Resource params = EcoreUtil2.getResource((Resource)sTask.eResource(), (String)file);
                if (params == null || !(IterableExtensions.head((Iterable)params.getContents()) instanceof Parameters)) continue;
                EObject _head = (EObject)IterableExtensions.head((Iterable)params.getContents());
                Parameters param = (Parameters)_head;
                missing.remove(param.getInterface().getName());
            }
        }
        boolean bl2 = _not = !(_isEmpty = missing.isEmpty());
        if (_not) {
            String error = String.format("Missing parameters for %s", String.join((CharSequence)", ", missing));
            this.error(error, sTask, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
        }
    }

    public boolean hasInParameters(Signature sig) {
        return IterableExtensions.exists((Iterable)sig.getCommands(), (Functions.Function1)new Functions.Function1<Command, Boolean>(){

            public Boolean apply(Command t) {
                Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                    public Boolean apply(Parameter p) {
                        DIRECTION _direction = p.getDirection();
                        return !Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
                    }
                };
                return IterableExtensions.exists((Iterable)t.getParameters(), (Functions.Function1)_function);
            }
        }) || IterableExtensions.exists((Iterable)sig.getSignals(), (Functions.Function1)new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal t) {
                Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                    public Boolean apply(Parameter p) {
                        DIRECTION _direction = p.getDirection();
                        return !Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
                    }
                };
                return IterableExtensions.exists((Iterable)t.getParameters(), (Functions.Function1)_function);
            }
        });
    }

    @Check
    public void checkMonitoringTask(MonitoringTask task) {
        this.validateTraceSources((List<TraceSource>)task.getTraces());
        this.validateDirectories((List<FilePath>)task.getTracedirs(), task);
    }

    public void validateTraceSources(List<TraceSource> sources) {
        Functions.Function1<FilePath, Boolean> _function = new Functions.Function1<FilePath, Boolean>(){

            public Boolean apply(FilePath s) {
                String _path = s.getPath();
                return _path != null;
            }
        };
        List filteredSources = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.filter(sources, FilePath.class), (Functions.Function1)_function));
        ProjectUtility.TraceResources resources = ProjectUtility.getTraceResourcesFromFiles(filteredSources);
        for (FilePath invalid : resources.invalidTraceSources) {
            this.error("Invalid resource", invalid, (EStructuralFeature)ProjectPackage.Literals.FILE_PATH__PATH);
        }
        for (FilePath wrongNamed : resources.wrongnamedTraceSources) {
            this.error("Trace file name must start with a letter and may contain letters, digits and _", wrongNamed, (EStructuralFeature)ProjectPackage.Literals.FILE_PATH__PATH);
        }
        for (FilePath duplicate : resources.duplicateTraceSources) {
            this.error("File with the same name is already used", duplicate, (EStructuralFeature)ProjectPackage.Literals.FILE_PATH__PATH);
        }
    }

    @Check
    public void checkDuplicatedInterfaces(CompoundInterface compInterface) {
        EList<InterfaceModel> _interfaces = compInterface.getInterfaces();
        for (InterfaceModel i1 : _interfaces) {
            EList<InterfaceModel> _interfaces_1 = compInterface.getInterfaces();
            for (InterfaceModel i2 : _interfaces_1) {
                if (Objects.equal((Object)i1, (Object)i2) || !Objects.equal((Object)i1.getInterfaceModel(), (Object)i2.getInterfaceModel())) continue;
                this.error("Duplicate interface", i1, null);
            }
        }
    }

    @Check
    public void checkCompoundName(CompoundInterface compound) {
        List _allInterfaces = ComponentUtilities.getAllInterfaces((EObject)compound, (IScopeProvider)this.scopeProvider);
        for (Interface interface_ : _allInterfaces) {
            boolean _equals = interface_.getName().equals(compound.getName());
            if (!_equals) continue;
            this.error("Compound interface names are not allowed to be equal to an imported interface.", (EStructuralFeature)ProjectPackage.Literals.COMPOUND_INTERFACE__NAME);
        }
    }

    public void validateDirectories(List<FilePath> filePaths, Task task) {
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        ProjectUtility.TraceResources resources = ProjectUtility.getTraceResourcesFromDirs(filePaths);
        for (FilePath dir : resources.nonexistentDirectories) {
            this.error("Directory does not exist", dir, (EStructuralFeature)ProjectPackage.Literals.FILE_PATH__PATH);
        }
        for (FilePath dir_1 : resources.duplicateDirectories) {
            this.error("Directory is already listed", dir_1, (EStructuralFeature)ProjectPackage.Literals.FILE_PATH__PATH);
        }
        boolean _isEmpty = resources.duplicateTraceFiles.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.error("Trace directories contain files with duplicate names", task, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
        }
        boolean bl2 = _not_1 = !(_isEmpty_1 = resources.wrongnamedTraceFiles.isEmpty());
        if (_not_1) {
            this.error("Trace directories contain files with wrong names", task, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
        }
    }

    @Check
    public void validateDocGenerationTask(DocumentationGenerationTask task) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((Resource)task.eResource(), (URI)URI.createURI((String)task.getTemplate()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Template not found", (EStructuralFeature)ProjectPackage.Literals.DOCUMENTATION_GENERATION_TASK__TEMPLATE);
        }
    }

    @Check
    public void checkDuplications(ProjectDescription prj) {
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)prj.getImports(), NamespaceImport.class));
        if (_isEmpty) {
            return;
        }
        Multimap multiMap = this.getGlobalDeclarations((EObject)prj, TypesPackage.eINSTANCE.getTypeDecl());
        this.placePredefinedTypes(multiMap);
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _string = ((QualifiedName)entry.getKey()).toString();
            String _plus = "Duplicate imported type " + _string;
            this.error(_plus, prj.getProject(), (EStructuralFeature)ProjectPackage.Literals.PROJECT__NAME);
        }
        multiMap = this.getGlobalDeclarations((EObject)prj, InterfaceDefinitionPackage.Literals.INTERFACE);
        Set _entrySet_1 = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet_1) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _string = ((QualifiedName)entry.getKey()).toString();
            String _plus = "Duplicate imported interface " + _string;
            this.error(_plus, prj.getProject(), (EStructuralFeature)ProjectPackage.Literals.PROJECT__NAME);
        }
        multiMap = this.getGlobalDeclarations((EObject)prj, ComponentPackage.Literals.COMPONENT);
        Set set = multiMap.asMap().entrySet();
        for (Map.Entry entry_2 : set) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry_2.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _string = ((QualifiedName)entry_2.getKey()).toString();
            String _plus = "Duplicate imported component " + _string;
            this.error(_plus, prj.getProject(), (EStructuralFeature)ProjectPackage.Literals.PROJECT__NAME);
        }
    }
}

