/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-02-13 05:14:13 +0100 (Thu, 13 Feb 2014) $
//  number=$Revision: 9728 $
//  type=root

/**
 * Localized names for the "mg" locale.
 */
public class LocalizedNamesImpl_mg extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "MG",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "ZA",
        "AL",
        "DE",
        "DZ",
        "AD",
        "GB",
        "AO",
        "AI",
        "AG",
        "AU",
        "AT",
        "AQ",
        "SA",
        "AM",
        "AW",
        "AR",
        "AX",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "BT",
        "BG",
        "BL",
        "BO",
        "BF",
        "BI",
        "BA",
        "BW",
        "BQ",
        "BR",
        "BN",
        "BV",
        "CC",
        "CI",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DJ",
        "DM",
        "EA",
        "EH",
        "EG",
        "EC",
        "SV",
        "AE",
        "ER",
        "ES",
        "EE",
        "US",
        "ET",
        "EU",
        "IO",
        "FJ",
        "PH",
        "FI",
        "VA",
        "FO",
        "FR",
        "GA",
        "GM",
        "GG",
        "GH",
        "GN",
        "GW",
        "GP",
        "GT",
        "GD",
        "GR",
        "GL",
        "GS",
        "GU",
        "GQ",
        "GY",
        "GF",
        "HT",
        "HK",
        "HM",
        "NL",
        "HN",
        "HU",
        "IC",
        "IM",
        "ID",
        "IN",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "CU",
        "KG",
        "KI",
        "KW",
        "CO",
        "KM",
        "CG",
        "KR",
        "KP",
        "CR",
        "HR",
        "LA",
        "RE",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LU",
        "LI",
        "LT",
        "MG",
        "MK",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MU",
        "MR",
        "MA",
        "MQ",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "MO",
        "MD",
        "MC",
        "MN",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NI",
        "NU",
        "NG",
        "NO",
        "VG",
        "CV",
        "FK",
        "KY",
        "CK",
        "MP",
        "MH",
        "NF",
        "SB",
        "TC",
        "VI",
        "NC",
        "NZ",
        "UG",
        "UA",
        "OM",
        "UY",
        "UZ",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PF",
        "PT",
        "PR",
        "QO",
        "DO",
        "CF",
        "CD",
        "CZ",
        "RW",
        "RO",
        "RU",
        "RS",
        "KN",
        "SH",
        "LC",
        "SM",
        "PM",
        "VC",
        "WS",
        "AS",
        "ST",
        "SN",
        "SC",
        "CL",
        "SL",
        "CN",
        "SG",
        "SJ",
        "SK",
        "SI",
        "SZ",
        "SD",
        "SE",
        "CH",
        "SO",
        "SR",
        "LK",
        "SS",
        "SX",
        "CY",
        "SY",
        "TA",
        "TW",
        "TJ",
        "TZ",
        "TF",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TN",
        "TR",
        "TM",
        "TV",
        "TT",
        "TD",
        "UM",
        "VU",
        "VE",
        "VN",
        "AN",
        "WF",
        "XK",
        "YE",
        "ZM",
        "GE",
        "GI",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AE", "Emirà Arabo mitambatra");
    namesMap.put("AG", "Antiga sy Barboda");
    namesMap.put("AN", "Vondronosy karaiba holandey");
    namesMap.put("AR", "Arzantina");
    namesMap.put("AS", "Samoa amerikanina");
    namesMap.put("AT", "Aotrisy");
    namesMap.put("AU", "Aostralia");
    namesMap.put("AW", "Arobà");
    namesMap.put("AZ", "Azerbaidjan");
    namesMap.put("BA", "Bosnia sy Herzegovina");
    namesMap.put("BB", "Barbady");
    namesMap.put("BD", "Bangladesy");
    namesMap.put("BE", "Belzika");
    namesMap.put("BF", "Borkina Faso");
    namesMap.put("BG", "Biolgaria");
    namesMap.put("BI", "Borondi");
    namesMap.put("BM", "Bermioda");
    namesMap.put("BR", "Brezila");
    namesMap.put("BT", "Bhotana");
    namesMap.put("BW", "Botsoana");
    namesMap.put("BY", "Belarosy");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Repoblikan'i Kongo");
    namesMap.put("CF", "Repoblika Ivon'Afrika");
    namesMap.put("CG", "Kôngô");
    namesMap.put("CH", "Soisa");
    namesMap.put("CK", "Nosy Kook");
    namesMap.put("CL", "Shili");
    namesMap.put("CM", "Kamerona");
    namesMap.put("CN", "Sina");
    namesMap.put("CO", "Kôlômbia");
    namesMap.put("CR", "Kosta Rikà");
    namesMap.put("CU", "Kiobà");
    namesMap.put("CV", "Nosy Cap-Vert");
    namesMap.put("CY", "Sypra");
    namesMap.put("CZ", "Repoblikan'i Tseky");
    namesMap.put("DE", "Alemaina");
    namesMap.put("DJ", "Djiboti");
    namesMap.put("DK", "Danmarka");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Repoblika Dominikanina");
    namesMap.put("DZ", "Alzeria");
    namesMap.put("EC", "Ekoatera");
    namesMap.put("EG", "Ejypta");
    namesMap.put("ES", "Espaina");
    namesMap.put("FI", "Finlandy");
    namesMap.put("FJ", "Fidji");
    namesMap.put("FK", "Nosy Falkand");
    namesMap.put("FM", "Mikrônezia");
    namesMap.put("FR", "Frantsa");
    namesMap.put("GB", "Angletera");
    namesMap.put("GD", "Grenady");
    namesMap.put("GE", "Zeorzia");
    namesMap.put("GF", "Guyana frantsay");
    namesMap.put("GI", "Zibraltara");
    namesMap.put("GL", "Groenland");
    namesMap.put("GN", "Ginea");
    namesMap.put("GP", "Goadelopy");
    namesMap.put("GQ", "Guinea Ekoatera");
    namesMap.put("GR", "Gresy");
    namesMap.put("GT", "Goatemalà");
    namesMap.put("GW", "Giné-Bisao");
    namesMap.put("HN", "Hondiorasy");
    namesMap.put("HR", "Kroasia");
    namesMap.put("HU", "Hongria");
    namesMap.put("ID", "Indonezia");
    namesMap.put("IE", "Irlandy");
    namesMap.put("IL", "Israely");
    namesMap.put("IN", "Indy");
    namesMap.put("IO", "Faridranomasina indiana britanika");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Islandy");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jamaïka");
    namesMap.put("JO", "Jordania");
    namesMap.put("JP", "Japana");
    namesMap.put("KG", "Kiordistan");
    namesMap.put("KH", "Kambôdja");
    namesMap.put("KM", "Kômaoro");
    namesMap.put("KN", "Saint-Christophe-et-Niévès");
    namesMap.put("KP", "Korea Avaratra");
    namesMap.put("KR", "Korea Atsimo");
    namesMap.put("KW", "Kôeity");
    namesMap.put("KY", "Nosy Kayman");
    namesMap.put("LA", "Laôs");
    namesMap.put("LB", "Libana");
    namesMap.put("LC", "Sainte-Lucie");
    namesMap.put("LI", "Listenstein");
    namesMap.put("LT", "Litoania");
    namesMap.put("LU", "Lioksamboro");
    namesMap.put("LV", "Letonia");
    namesMap.put("MA", "Marôka");
    namesMap.put("MC", "Mônakô");
    namesMap.put("MD", "Môldavia");
    namesMap.put("MG", "Madagasikara");
    namesMap.put("MH", "Nosy Marshall");
    namesMap.put("MK", "Makedonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MN", "Môngôlia");
    namesMap.put("MP", "Nosy Mariana Atsinanana");
    namesMap.put("MQ", "Martinika");
    namesMap.put("MR", "Maoritania");
    namesMap.put("MU", "Maorisy");
    namesMap.put("MV", "Maldiva");
    namesMap.put("MW", "Malaoì");
    namesMap.put("MX", "Meksika");
    namesMap.put("MY", "Malaizia");
    namesMap.put("MZ", "Mozambika");
    namesMap.put("NC", "Nouvelle-Calédonie");
    namesMap.put("NF", "Nosy Norfolk");
    namesMap.put("NG", "Nizeria");
    namesMap.put("NI", "Nikaragoà");
    namesMap.put("NL", "Holanda");
    namesMap.put("NO", "Nôrvezy");
    namesMap.put("NP", "Nepala");
    namesMap.put("NR", "Naorò");
    namesMap.put("NU", "Nioé");
    namesMap.put("NZ", "Nouvelle-Zélande");
    namesMap.put("PE", "Peroa");
    namesMap.put("PF", "Polynezia frantsay");
    namesMap.put("PG", "Papouasie-Nouvelle-Guinée");
    namesMap.put("PH", "Filipina");
    namesMap.put("PL", "Pôlôna");
    namesMap.put("PM", "Saint-Pierre-et-Miquelon");
    namesMap.put("PN", "Pitkairn");
    namesMap.put("PR", "Pôrtô Rikô");
    namesMap.put("PS", "Palestina");
    namesMap.put("PT", "Pôrtiogala");
    namesMap.put("PW", "Palao");
    namesMap.put("PY", "Paragoay");
    namesMap.put("QA", "Katar");
    namesMap.put("RE", "Larenion");
    namesMap.put("RU", "Rosia");
    namesMap.put("RW", "Roanda");
    namesMap.put("SA", "Arabia saodita");
    namesMap.put("SB", "Nosy Salomona");
    namesMap.put("SC", "Seyshela");
    namesMap.put("SD", "Sodan");
    namesMap.put("SE", "Soedy");
    namesMap.put("SG", "Singaporo");
    namesMap.put("SH", "Sainte-Hélène");
    namesMap.put("SM", "Saint-Marin");
    namesMap.put("SR", "Sorinam");
    namesMap.put("ST", "São Tomé-et-Príncipe");
    namesMap.put("SZ", "Soazilandy");
    namesMap.put("TC", "Nosy Turks sy Caïques");
    namesMap.put("TD", "Tsady");
    namesMap.put("TH", "Thailandy");
    namesMap.put("TK", "Tokelao");
    namesMap.put("TL", "Timor Atsinanana");
    namesMap.put("TM", "Torkmenistan");
    namesMap.put("TN", "Tonizia");
    namesMap.put("TO", "Tongà");
    namesMap.put("TR", "Torkia");
    namesMap.put("TT", "Trinidad sy Tobagô");
    namesMap.put("TV", "Tovalò");
    namesMap.put("TW", "Taioana");
    namesMap.put("UA", "Okraina");
    namesMap.put("UG", "Oganda");
    namesMap.put("US", "Etazonia");
    namesMap.put("UY", "Orogoay");
    namesMap.put("UZ", "Ozbekistan");
    namesMap.put("VA", "Firenen'i Vatikana");
    namesMap.put("VC", "Saint-Vincent-et-les Grenadines");
    namesMap.put("VE", "Venezoelà");
    namesMap.put("VG", "Nosy britanika virijiny");
    namesMap.put("VI", "Nosy Virijiny Etazonia");
    namesMap.put("VU", "Vanoatò");
    namesMap.put("WF", "Wallis sy Futuna");
    namesMap.put("YT", "Mayôty");
    namesMap.put("ZA", "Afrika Atsimo");
    namesMap.put("ZW", "Zimbaboe");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AE": "Emirà Arabo mitambatra",
        "AG": "Antiga sy Barboda",
        "AN": "Vondronosy karaiba holandey",
        "AR": "Arzantina",
        "AS": "Samoa amerikanina",
        "AT": "Aotrisy",
        "AU": "Aostralia",
        "AW": "Arobà",
        "AZ": "Azerbaidjan",
        "BA": "Bosnia sy Herzegovina",
        "BB": "Barbady",
        "BD": "Bangladesy",
        "BE": "Belzika",
        "BF": "Borkina Faso",
        "BG": "Biolgaria",
        "BI": "Borondi",
        "BM": "Bermioda",
        "BR": "Brezila",
        "BT": "Bhotana",
        "BW": "Botsoana",
        "BY": "Belarosy",
        "CA": "Kanada",
        "CD": "Repoblikan'i Kongo",
        "CF": "Repoblika Ivon'Afrika",
        "CG": "Kôngô",
        "CH": "Soisa",
        "CK": "Nosy Kook",
        "CL": "Shili",
        "CM": "Kamerona",
        "CN": "Sina",
        "CO": "Kôlômbia",
        "CR": "Kosta Rikà",
        "CU": "Kiobà",
        "CV": "Nosy Cap-Vert",
        "CY": "Sypra",
        "CZ": "Repoblikan'i Tseky",
        "DE": "Alemaina",
        "DJ": "Djiboti",
        "DK": "Danmarka",
        "DM": "Dominika",
        "DO": "Repoblika Dominikanina",
        "DZ": "Alzeria",
        "EC": "Ekoatera",
        "EG": "Ejypta",
        "ES": "Espaina",
        "FI": "Finlandy",
        "FJ": "Fidji",
        "FK": "Nosy Falkand",
        "FM": "Mikrônezia",
        "FR": "Frantsa",
        "GB": "Angletera",
        "GD": "Grenady",
        "GE": "Zeorzia",
        "GF": "Guyana frantsay",
        "GI": "Zibraltara",
        "GL": "Groenland",
        "GN": "Ginea",
        "GP": "Goadelopy",
        "GQ": "Guinea Ekoatera",
        "GR": "Gresy",
        "GT": "Goatemalà",
        "GW": "Giné-Bisao",
        "HN": "Hondiorasy",
        "HR": "Kroasia",
        "HU": "Hongria",
        "ID": "Indonezia",
        "IE": "Irlandy",
        "IL": "Israely",
        "IN": "Indy",
        "IO": "Faridranomasina indiana britanika",
        "IQ": "Irak",
        "IS": "Islandy",
        "IT": "Italia",
        "JM": "Jamaïka",
        "JO": "Jordania",
        "JP": "Japana",
        "KG": "Kiordistan",
        "KH": "Kambôdja",
        "KM": "Kômaoro",
        "KN": "Saint-Christophe-et-Niévès",
        "KP": "Korea Avaratra",
        "KR": "Korea Atsimo",
        "KW": "Kôeity",
        "KY": "Nosy Kayman",
        "LA": "Laôs",
        "LB": "Libana",
        "LC": "Sainte-Lucie",
        "LI": "Listenstein",
        "LT": "Litoania",
        "LU": "Lioksamboro",
        "LV": "Letonia",
        "MA": "Marôka",
        "MC": "Mônakô",
        "MD": "Môldavia",
        "MG": "Madagasikara",
        "MH": "Nosy Marshall",
        "MK": "Makedonia",
        "MM": "Myanmar",
        "MN": "Môngôlia",
        "MP": "Nosy Mariana Atsinanana",
        "MQ": "Martinika",
        "MR": "Maoritania",
        "MU": "Maorisy",
        "MV": "Maldiva",
        "MW": "Malaoì",
        "MX": "Meksika",
        "MY": "Malaizia",
        "MZ": "Mozambika",
        "NC": "Nouvelle-Calédonie",
        "NF": "Nosy Norfolk",
        "NG": "Nizeria",
        "NI": "Nikaragoà",
        "NL": "Holanda",
        "NO": "Nôrvezy",
        "NP": "Nepala",
        "NR": "Naorò",
        "NU": "Nioé",
        "NZ": "Nouvelle-Zélande",
        "PE": "Peroa",
        "PF": "Polynezia frantsay",
        "PG": "Papouasie-Nouvelle-Guinée",
        "PH": "Filipina",
        "PL": "Pôlôna",
        "PM": "Saint-Pierre-et-Miquelon",
        "PN": "Pitkairn",
        "PR": "Pôrtô Rikô",
        "PS": "Palestina",
        "PT": "Pôrtiogala",
        "PW": "Palao",
        "PY": "Paragoay",
        "QA": "Katar",
        "RE": "Larenion",
        "RU": "Rosia",
        "RW": "Roanda",
        "SA": "Arabia saodita",
        "SB": "Nosy Salomona",
        "SC": "Seyshela",
        "SD": "Sodan",
        "SE": "Soedy",
        "SG": "Singaporo",
        "SH": "Sainte-Hélène",
        "SM": "Saint-Marin",
        "SR": "Sorinam",
        "ST": "São Tomé-et-Príncipe",
        "SZ": "Soazilandy",
        "TC": "Nosy Turks sy Caïques",
        "TD": "Tsady",
        "TH": "Thailandy",
        "TK": "Tokelao",
        "TL": "Timor Atsinanana",
        "TM": "Torkmenistan",
        "TN": "Tonizia",
        "TO": "Tongà",
        "TR": "Torkia",
        "TT": "Trinidad sy Tobagô",
        "TV": "Tovalò",
        "TW": "Taioana",
        "UA": "Okraina",
        "UG": "Oganda",
        "US": "Etazonia",
        "UY": "Orogoay",
        "UZ": "Ozbekistan",
        "VA": "Firenen'i Vatikana",
        "VC": "Saint-Vincent-et-les Grenadines",
        "VE": "Venezoelà",
        "VG": "Nosy britanika virijiny",
        "VI": "Nosy Virijiny Etazonia",
        "VU": "Vanoatò",
        "WF": "Wallis sy Futuna",
        "YT": "Mayôty",
        "ZA": "Afrika Atsimo",
        "ZW": "Zimbaboe"
    };
  }-*/;
}
