/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;

public class ApplicationInstanceRunningTracker {
    public static final long TIMEOUT = 300000L;
    public static final long WAIT_TIME = 1000L;
    private final CloudFoundryServer cloudServer;
    private final CloudFoundryApplicationModule appModule;
    private final long timeout;

    public ApplicationInstanceRunningTracker(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        this.cloudServer = cloudServer;
        this.appModule = appModule;
        this.timeout = 300000L;
    }

    public int track(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        long currentTime = System.currentTimeMillis();
        long totalTime = currentTime + this.timeout;
        CloudFoundryServerBehaviour behaviour = this.cloudServer.getBehaviour();
        String appName = this.appModule.getDeployedApplicationName();
        this.printlnToConsole(NLS.bind((String)Messages.ApplicationInstanceStartingTracker_STARTING_TRACKING, (Object)appName), this.appModule);
        int state = 0;
        while (state != 2 && state != 4 && currentTime < totalTime) {
            if (monitor != null && monitor.isCanceled()) {
                String error = NLS.bind((String)Messages.ApplicationInstanceStartingTracker_APPLICATION_CHECK_CANCELED, (Object)appName);
                this.printlnToConsole(error, this.appModule);
                throw new OperationCanceledException(error);
            }
            CloudApplication cloudApp = behaviour.getCloudApplication(appName, monitor);
            ApplicationStats applicationStats = behaviour.getApplicationStats(appName, monitor);
            if (cloudApp == null) {
                String error = NLS.bind((String)Messages.ApplicationInstanceStartingTracker_APPLICATION_NOT_EXISTS, (Object)appName);
                this.printlnToConsole(error, this.appModule);
                throw CloudErrorUtil.toCoreException(error);
            }
            state = CloudFoundryApplicationModule.getCloudState(cloudApp, applicationStats);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            currentTime = System.currentTimeMillis();
        }
        String runningStateMessage = state == 2 ? NLS.bind((String)Messages.ApplicationInstanceStartingTracker_APPLICATION_IS_RUNNING, (Object)appName) : NLS.bind((String)Messages.ApplicationInstanceStartingTracker_APPLICATION_IS_NOT_RUNNING, (Object)appName);
        this.printlnToConsole(runningStateMessage, this.appModule);
        return state;
    }

    protected void printlnToConsole(String message, CloudFoundryApplicationModule appModule) throws CoreException {
        message = String.valueOf(message) + '\n';
        CloudFoundryPlugin.getCallback().printToConsole(this.cloudServer, appModule, message, false, false);
    }
}

