/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.util;

import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.TextLayout;

public class LogGraphics
extends Graphics {
    private final Logger log;
    private Graphics m_graphics;
    private String m_prefix = "";

    public LogGraphics(Graphics i_graphics) {
        this(i_graphics, null);
    }

    public LogGraphics(Graphics i_graphics, String i_prefix) {
        if (i_graphics == null) {
            throw new NullPointerException("i_graphics must not be null");
        }
        this.log = Logger.getLogger(LogGraphics.class.getName());
        this.log.setUseParentHandlers(false);
        Handler[] handlers = this.log.getHandlers();
        int i = 0;
        while (i < handlers.length) {
            this.log.removeHandler(handlers[i]);
            ++i;
        }
        try {
            String logFile = "/%h/logGraphics.%u.%g.log";
            FileHandler handler = new FileHandler(logFile, true);
            handler.setFormatter(new Formatter(){

                public String format(LogRecord i_record) {
                    return String.valueOf(i_record.getMessage()) + "\n";
                }
            });
            this.log.addHandler(handler);
        }
        catch (Exception ex) {
            this.log.warning(ex.getMessage());
            throw new RuntimeException("caught exception while configuring LogGraphics" + ex);
        }
        this.m_graphics = i_graphics;
        if (i_prefix != null) {
            this.m_prefix = i_prefix;
        }
        this.log.info("// ======== LogGraphics initialized ========");
    }

    private String boolArgs(boolean ... args) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            builder.append(Boolean.toString(args[i]));
            if (i < args.length - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    public void clipRect(Rectangle i_r) {
        this.log.info(String.valueOf(this.m_prefix) + "clipRect(" + this.newRectangle(i_r) + ")");
        this.m_graphics.clipRect(i_r);
    }

    public void dispose() {
        this.m_graphics.dispose();
    }

    private String doubleArgs(double ... args) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            builder.append(Double.toString(args[i])).append("d");
            if (i < args.length - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    public void drawArc(int i_x, int i_y, int i_w, int i_h, int i_offset, int i_length) {
        this.log.info(String.valueOf(this.m_prefix) + "drawArc(" + this.intArgs(i_x, i_y, i_w, i_h, i_offset, i_length) + ")");
        this.m_graphics.drawArc(i_x, i_y, i_w, i_h, i_offset, i_length);
    }

    public void drawFocus(int i_x, int i_y, int i_w, int i_h) {
        this.log.info(String.valueOf(this.m_prefix) + "drawFocus(" + this.intArgs(i_x, i_y, i_w, i_h) + ")");
        this.m_graphics.drawFocus(i_x, i_y, i_w, i_h);
    }

    public void drawImage(Image i_srcImage, int i_x, int i_y) {
        this.log.info(String.valueOf(this.m_prefix) + "drawImage(<image>, " + this.intArgs(i_x, i_y) + ")");
        this.m_graphics.drawImage(i_srcImage, i_x, i_y);
    }

    public void drawImage(Image i_srcImage, int i_x1, int i_y1, int i_w1, int i_h1, int i_x2, int i_y2, int i_w2, int i_h2) {
        this.log.info(String.valueOf(this.m_prefix) + "drawImage(<image>, " + this.intArgs(i_x1, i_y1, i_w1, i_h1, i_x2, i_y2, i_w2, i_h2) + ")");
        this.m_graphics.drawImage(i_srcImage, i_x1, i_y1, i_w1, i_h1, i_x2, i_y2, i_w2, i_h2);
    }

    public void drawLine(int i_x1, int i_y1, int i_x2, int i_y2) {
        this.log.info(String.valueOf(this.m_prefix) + "drawLine(" + this.intArgs(i_x1, i_y1, i_x2, i_y2) + ")");
        this.m_graphics.drawLine(i_x1, i_y1, i_x2, i_y2);
    }

    public void drawOval(int i_x, int i_y, int i_w, int i_h) {
        this.log.info(String.valueOf(this.m_prefix) + "drawOval(" + this.intArgs(i_x, i_y, i_w, i_h) + ")");
        this.m_graphics.drawOval(i_x, i_y, i_w, i_h);
    }

    public void drawPath(Path i_path) {
        this.log.info(String.valueOf(this.m_prefix) + "drawPath(<path>)");
        this.m_graphics.drawPath(i_path);
    }

    public void drawPolygon(PointList i_points) {
        this.log.info(String.valueOf(this.m_prefix) + "drawPolygon(" + this.newPointList(i_points) + ")");
        this.m_graphics.drawPolygon(i_points);
    }

    public void drawPolyline(PointList i_points) {
        this.log.info(String.valueOf(this.m_prefix) + "drawPolyline(" + this.newPointList(i_points) + ")");
        this.m_graphics.drawPolyline(i_points);
    }

    public void drawRectangle(int i_x, int i_y, int i_width, int i_height) {
        this.log.info(String.valueOf(this.m_prefix) + "drawRectangle(" + this.intArgs(i_x, i_y, i_width, i_height) + ")");
        this.m_graphics.drawRectangle(i_x, i_y, i_width, i_height);
    }

    public void drawRoundRectangle(Rectangle i_r, int i_arcWidth, int i_arcHeight) {
        this.log.info(String.valueOf(this.m_prefix) + "drawRoundRectangle(" + this.newRectangle(i_r) + ", " + this.intArgs(i_arcWidth, i_arcHeight) + ")");
        this.m_graphics.drawRoundRectangle(i_r, i_arcWidth, i_arcHeight);
    }

    public void drawString(String i_s, int i_x, int i_y) {
        this.log.info(String.valueOf(this.m_prefix) + "drawString(" + this.stringArg(i_s) + ", " + this.intArgs(i_x, i_y) + ")");
        this.m_graphics.drawString(i_s, i_x, i_y);
    }

    public void drawText(String i_s, int i_x, int i_y) {
        this.log.info(String.valueOf(this.m_prefix) + "drawText(" + this.stringArg(i_s) + ", " + this.intArgs(i_x, i_y) + ")");
        this.m_graphics.drawText(i_s, i_x, i_y);
    }

    public void drawText(String i_s, int i_x, int i_y, int i_style) {
        this.log.info(String.valueOf(this.m_prefix) + "drawText(" + this.stringArg(i_s) + ", " + this.intArgs(i_x, i_y, i_style) + ")");
        this.m_graphics.drawText(i_s, i_x, i_y, i_style);
    }

    public void drawTextLayout(TextLayout i_layout, int i_x, int i_y, int i_selectionStart, int i_selectionEnd, Color i_selectionForeground, Color i_selectionBackground) {
        this.log.info(String.valueOf(this.m_prefix) + "drawTextLayout(<layout>, " + this.intArgs(i_x, i_y, i_selectionStart, i_selectionEnd) + ", " + this.newColor(i_selectionForeground) + ", " + this.newColor(i_selectionBackground) + ")");
        this.m_graphics.drawTextLayout(i_layout, i_x, i_y, i_selectionStart, i_selectionEnd, i_selectionForeground, i_selectionBackground);
    }

    public void fillArc(int i_x, int i_y, int i_w, int i_h, int i_offset, int i_length) {
        this.log.info(String.valueOf(this.m_prefix) + "fillArc(" + this.intArgs(i_x, i_y, i_w, i_h, i_offset, i_length) + ")");
        this.m_graphics.fillArc(i_x, i_y, i_w, i_h, i_offset, i_length);
    }

    public void fillGradient(int i_x, int i_y, int i_w, int i_h, boolean i_vertical) {
        this.log.info(String.valueOf(this.m_prefix) + "fillGradient(" + this.intArgs(i_x, i_y, i_w, i_h) + ", " + this.boolArgs(i_vertical) + ")");
        this.m_graphics.fillGradient(i_x, i_y, i_w, i_h, i_vertical);
    }

    public void fillOval(int i_x, int i_y, int i_w, int i_h) {
        this.log.info(String.valueOf(this.m_prefix) + "fillOval(" + this.intArgs(i_x, i_y, i_w, i_h) + ")");
        this.m_graphics.fillOval(i_x, i_y, i_w, i_h);
    }

    public void fillPath(Path i_path) {
        this.log.info(String.valueOf(this.m_prefix) + "fillPath(<path>)");
        this.m_graphics.fillPath(i_path);
    }

    public void fillPolygon(PointList i_points) {
        this.log.info(String.valueOf(this.m_prefix) + "fillPolygon(" + this.newPointList(i_points) + ")");
        this.m_graphics.fillPolygon(i_points);
    }

    public void fillRectangle(int i_x, int i_y, int i_width, int i_height) {
        this.log.info(String.valueOf(this.m_prefix) + "fillRectangle(" + this.intArgs(i_x, i_y, i_width, i_height) + ")");
        this.m_graphics.fillRectangle(i_x, i_y, i_width, i_height);
    }

    public void fillRoundRectangle(Rectangle i_r, int i_arcWidth, int i_arcHeight) {
        this.log.info(String.valueOf(this.m_prefix) + "fillRoundRectangle(" + this.newRectangle(i_r) + ", " + this.intArgs(i_arcWidth, i_arcHeight) + ")");
        this.m_graphics.fillRoundRectangle(i_r, i_arcWidth, i_arcHeight);
    }

    public void fillString(String i_s, int i_x, int i_y) {
        this.log.info(String.valueOf(this.m_prefix) + "fillString(" + this.stringArg(i_s) + ", " + this.intArgs(i_x, i_y) + ")");
        this.m_graphics.fillString(i_s, i_x, i_y);
    }

    public void fillText(String i_s, int i_x, int i_y) {
        this.log.info(String.valueOf(this.m_prefix) + "fillText(" + this.stringArg(i_s) + ", " + this.intArgs(i_x, i_y) + ")");
        this.m_graphics.fillText(i_s, i_x, i_y);
    }

    private String floatArgs(float ... args) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            builder.append(Float.toString(args[i])).append("f");
            if (i < args.length - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    public boolean getAdvanced() {
        return this.m_graphics.getAdvanced();
    }

    public int getAlpha() {
        return this.m_graphics.getAlpha();
    }

    public int getAntialias() {
        return this.m_graphics.getAntialias();
    }

    public Color getBackgroundColor() {
        return this.m_graphics.getBackgroundColor();
    }

    public Rectangle getClip(Rectangle i_rect) {
        return this.m_graphics.getClip(i_rect);
    }

    public int getFillRule() {
        return this.m_graphics.getFillRule();
    }

    public Font getFont() {
        return this.m_graphics.getFont();
    }

    public FontMetrics getFontMetrics() {
        return this.m_graphics.getFontMetrics();
    }

    public Color getForegroundColor() {
        return this.m_graphics.getForegroundColor();
    }

    public int getInterpolation() {
        return this.m_graphics.getInterpolation();
    }

    public LineAttributes getLineAttributes() {
        return this.m_graphics.getLineAttributes();
    }

    public int getLineCap() {
        return this.m_graphics.getLineCap();
    }

    public int getLineJoin() {
        return this.m_graphics.getLineJoin();
    }

    public float getLineMiterLimit() {
        return this.m_graphics.getLineMiterLimit();
    }

    public int getLineStyle() {
        return this.m_graphics.getLineStyle();
    }

    public int getLineWidth() {
        return this.m_graphics.getLineWidth();
    }

    public float getLineWidthFloat() {
        return this.m_graphics.getLineWidthFloat();
    }

    public int getTextAntialias() {
        return this.m_graphics.getTextAntialias();
    }

    public boolean getXORMode() {
        return this.m_graphics.getXORMode();
    }

    private String intArgs(int ... args) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            builder.append(Integer.toString(args[i]));
            if (i < args.length - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    private String newColor(Color i_rgb) {
        return "new org.eclipse.swt.graphics.Color(display, " + this.intArgs(i_rgb.getRed(), i_rgb.getGreen(), i_rgb.getBlue()) + ")";
    }

    private String newFloatArray(float[] i_array) {
        if (i_array == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(float[]) [");
        int i = 0;
        while (i < i_array.length) {
            builder.append(Float.toString(i_array[i])).append("f");
            if (i < i_array.length - 1) {
                builder.append(", ");
            }
            ++i;
        }
        builder.append("]");
        return builder.toString();
    }

    private String newFont(Font i_font) {
        FontData[] fontData = i_font.getFontData();
        StringBuilder builder = new StringBuilder();
        builder.append("new org.eclipse.swt.graphics.Font(display, ");
        builder.append("(org.eclipse.swt.graphics.FontData[]) [");
        int i = 0;
        while (i < fontData.length) {
            builder.append("new org.eclipse.swt.graphics.FontData(");
            builder.append(this.stringArg(fontData[i].getName())).append(", ");
            builder.append(this.intArgs(fontData[i].getHeight(), fontData[i].getStyle()));
            builder.append(")");
            if (i < fontData.length - 1) {
                builder.append(", ");
            }
            ++i;
        }
        builder.append("])");
        String s = builder.toString();
        return s;
    }

    private String newIntArray(int[] i_array) {
        if (i_array == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(int[]) [");
        int i = 0;
        while (i < i_array.length) {
            builder.append(Integer.toString(i_array[i]));
            if (i < i_array.length - 1) {
                builder.append(", ");
            }
            ++i;
        }
        builder.append("]");
        return builder.toString();
    }

    private String newLineAttributes(LineAttributes i_attributes) {
        StringBuilder builder = new StringBuilder();
        builder.append("new org.eclipse.swt.graphics.LineAttributes(");
        builder.append(this.floatArgs(i_attributes.width)).append(", ");
        String cjs = this.intArgs(i_attributes.cap, i_attributes.join, i_attributes.style);
        builder.append(cjs).append(", ");
        builder.append(this.newFloatArray(i_attributes.dash)).append(", ");
        builder.append(this.floatArgs(i_attributes.dashOffset, i_attributes.miterLimit));
        builder.append(")");
        return builder.toString();
    }

    private String newPointList(PointList i_points) {
        StringBuilder builder = new StringBuilder();
        builder.append("new org.eclipse.draw2d.geometry.PointList(");
        builder.append(this.newIntArray(i_points.toIntArray()));
        builder.append(")");
        return builder.toString();
    }

    private String newRectangle(Rectangle i_r) {
        return "new org.eclipse.draw2d.geometry.Rectangle(" + this.intArgs(i_r.x, i_r.y, i_r.width, i_r.height) + ")";
    }

    public void popState() {
        this.log.info(String.valueOf(this.m_prefix) + "popState()");
        this.m_graphics.popState();
    }

    public void pushState() {
        this.log.info(String.valueOf(this.m_prefix) + "pushState()");
        this.m_graphics.pushState();
    }

    public void restoreState() {
        this.log.info(String.valueOf(this.m_prefix) + "restoreState()");
        this.m_graphics.restoreState();
    }

    public void rotate(float i_degrees) {
        this.log.info(String.valueOf(this.m_prefix) + "rotate(" + this.floatArgs(i_degrees) + ")");
        this.m_graphics.rotate(i_degrees);
    }

    public void scale(double i_amount) {
        this.log.info(String.valueOf(this.m_prefix) + "scale(" + this.doubleArgs(i_amount) + ")");
        this.m_graphics.scale(i_amount);
    }

    public void scale(float i_horizontal, float i_vertical) {
        this.log.info(String.valueOf(this.m_prefix) + "scale(" + this.floatArgs(i_horizontal, i_vertical) + ")");
        this.m_graphics.scale(i_horizontal, i_vertical);
    }

    public void setAdvanced(boolean i_advanced) {
        this.log.info(String.valueOf(this.m_prefix) + "setAdvanced(" + this.boolArgs(i_advanced) + ")");
        this.m_graphics.setAdvanced(i_advanced);
    }

    public void setAlpha(int i_alpha) {
        this.log.info(String.valueOf(this.m_prefix) + "setAlpha(" + this.intArgs(i_alpha) + ")");
        this.m_graphics.setAlpha(i_alpha);
    }

    public void setAntialias(int i_value) {
        this.log.info(String.valueOf(this.m_prefix) + "setAntialias(" + this.intArgs(i_value) + ")");
        this.m_graphics.setAntialias(i_value);
    }

    public void setBackgroundColor(Color i_rgb) {
        this.log.info(String.valueOf(this.m_prefix) + "setBackgroundColor(" + this.newColor(i_rgb) + ")");
        this.m_graphics.setBackgroundColor(i_rgb);
    }

    public void setBackgroundPattern(Pattern i_pattern) {
        this.log.info(String.valueOf(this.m_prefix) + "setBackgroundPattern(<pattern>)");
        this.m_graphics.setBackgroundPattern(i_pattern);
    }

    public void setClip(Path i_path) {
        this.log.info(String.valueOf(this.m_prefix) + "setClip(<path>)");
        this.m_graphics.setClip(i_path);
    }

    public void setClip(Rectangle i_r) {
        this.log.info(String.valueOf(this.m_prefix) + "setClip(" + this.newRectangle(i_r) + ")");
        this.m_graphics.setClip(i_r);
    }

    public void setFillRule(int i_rule) {
        this.log.info(String.valueOf(this.m_prefix) + "setFillRule(" + this.intArgs(i_rule) + ")");
        this.m_graphics.setFillRule(i_rule);
    }

    public void setFont(Font i_f) {
        this.log.info(String.valueOf(this.m_prefix) + "setFont(" + this.newFont(i_f) + ")");
        this.m_graphics.setFont(i_f);
    }

    public void setForegroundColor(Color i_rgb) {
        this.log.info(String.valueOf(this.m_prefix) + "setForegroundColor(" + this.newColor(i_rgb) + ")");
        this.m_graphics.setForegroundColor(i_rgb);
    }

    public void setForegroundPattern(Pattern i_pattern) {
        this.log.info(String.valueOf(this.m_prefix) + "setForegroundPattern(<pattern>)");
        this.m_graphics.setForegroundPattern(i_pattern);
    }

    public void setInterpolation(int i_interpolation) {
        this.log.info(String.valueOf(this.m_prefix) + "setInterpolation(" + this.intArgs(i_interpolation) + ")");
        this.m_graphics.setInterpolation(i_interpolation);
    }

    public void setLineAttributes(LineAttributes i_attributes) {
        this.log.info(String.valueOf(this.m_prefix) + "setLineAttributes(" + this.newLineAttributes(i_attributes) + ")");
        this.m_graphics.setLineAttributes(i_attributes);
    }

    public void setLineCap(int i_cap) {
        this.log.info(String.valueOf(this.m_prefix) + "setLineCap(" + this.intArgs(i_cap) + ")");
        this.m_graphics.setLineCap(i_cap);
    }

    public void setLineDash(float[] i_dash) {
        this.log.info(String.valueOf(this.m_prefix) + "setLineDash(" + this.newFloatArray(i_dash) + ")");
        this.m_graphics.setLineDash(i_dash);
    }

    public void setLineDash(int[] i_dash) {
        this.log.info(String.valueOf(this.m_prefix) + "setLineDash(" + this.newIntArray(i_dash) + ")");
        this.m_graphics.setLineDash(i_dash);
    }

    public void setLineJoin(int i_join) {
        this.log.info(String.valueOf(this.m_prefix) + "setLineJoin(" + this.intArgs(i_join) + ")");
        this.m_graphics.setLineJoin(i_join);
    }

    public void setLineMiterLimit(float i_miterLimit) {
        this.log.info(String.valueOf(this.m_prefix) + "setLineMiterLimit(" + this.floatArgs(i_miterLimit) + ")");
        this.m_graphics.setLineMiterLimit(i_miterLimit);
    }

    public void setLineStyle(int i_style) {
        this.log.info(String.valueOf(this.m_prefix) + "setLineStyle(" + this.intArgs(i_style) + ")");
        this.m_graphics.setLineStyle(i_style);
    }

    public void setLineWidth(int i_width) {
        this.log.info(String.valueOf(this.m_prefix) + "setLineWidth(" + this.intArgs(i_width) + ")");
        this.m_graphics.setLineWidth(i_width);
    }

    public void setLineWidthFloat(float i_width) {
        this.log.info(String.valueOf(this.m_prefix) + "setLineWidthFloat(" + this.floatArgs(i_width) + ")");
        this.m_graphics.setLineWidthFloat(i_width);
    }

    public void setTextAntialias(int i_value) {
        this.log.info(String.valueOf(this.m_prefix) + "setTextAntialias(" + this.intArgs(i_value) + ")");
        this.m_graphics.setTextAntialias(i_value);
    }

    public void setXORMode(boolean i_b) {
        this.log.info(String.valueOf(this.m_prefix) + "setXORMode(" + this.boolArgs(i_b) + ")");
        this.m_graphics.setXORMode(i_b);
    }

    public void shear(float i_horz, float i_vert) {
        this.log.info(String.valueOf(this.m_prefix) + "shear(" + this.floatArgs(i_horz, i_vert) + ")");
        this.m_graphics.shear(i_horz, i_vert);
    }

    private String stringArg(String i_str) {
        return "\"" + i_str + "\"";
    }

    public void translate(float i_dx, float i_dy) {
        this.log.info(String.valueOf(this.m_prefix) + "translate(" + this.floatArgs(i_dx, i_dy) + ")");
        this.m_graphics.translate(i_dx, i_dy);
    }

    public void translate(int i_dx, int i_dy) {
        this.log.info(String.valueOf(this.m_prefix) + "translate(" + this.intArgs(i_dx, i_dy) + ")");
        this.m_graphics.translate(i_dx, i_dy);
    }
}

