/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)mlib_v_ImageDivAlphaTabl.c	9.2	07/11/05 SMI"

/*
 * DESCRIPTION:
 *
 *  union {
 *    mlib_u16 tab[ 1024 ];
 *    mlib_d64 null_array[ 256 ];
 *  };
 *
 *  union  mlib_v_tab1[x]  = { 0x0000  , 0xff00/x, 0xff00/x, 0xff00/x };
 *  union  mlib_v_tab2[x]  = { 0xff00/x, 0x0000  , 0xff00/x, 0xff00/x };
 *  union  mlib_v_tab3[x]  = { 0xff00/x, 0xff00/x, 0x0000  , 0xff00/x };
 *  union  mlib_v_tab4[x]  = { 0xff00/x, 0xff00/x, 0xff00/x, 0x0000   };
 *
 * REFERENCING:
 *   this tables are used to exclude dividing in VIS
 *   versions of the following functions:
 *     mlib_ImageDivAlpha
 *     mlib_ImageDivAlpha_Inp
 */

#include <mlib_types.h>

#define	__INIT_TABLE

#include <mlib_v_ImageDivAlpha.h>

/* *********************************************************** */

const mlib_u64 mlib_DivAlpha_tbl[] = {
	0xff00ff00ff00ff00, 0xff00ff00ff00ff00,
	0x7fff7fff7fff7fff, 0x5555555555555555,
	0x4000400040004000, 0x3333333333333333,
	0x2aaa2aaa2aaa2aaa, 0x2492249224922492,
	0x2000200020002000, 0x1c711c711c711c71,
	0x1999199919991999, 0x1745174517451745,
	0x1555155515551555, 0x13b113b113b113b1,
	0x1249124912491249, 0x1111111111111111,
	0x1000100010001000, 0x0f0f0f0f0f0f0f0f,
	0x0e380e380e380e38, 0x0d790d790d790d79,
	0x0ccc0ccc0ccc0ccc, 0x0c300c300c300c30,
	0x0ba20ba20ba20ba2, 0x0b210b210b210b21,
	0x0aaa0aaa0aaa0aaa, 0x0a3d0a3d0a3d0a3d,
	0x09d809d809d809d8, 0x097b097b097b097b,
	0x0924092409240924, 0x08d308d308d308d3,
	0x0888088808880888, 0x0842084208420842,
	0x0800080008000800, 0x07c107c107c107c1,
	0x0787078707870787, 0x0750075007500750,
	0x071c071c071c071c, 0x06eb06eb06eb06eb,
	0x06bc06bc06bc06bc, 0x0690069006900690,
	0x0666066606660666, 0x063e063e063e063e,
	0x0618061806180618, 0x05f405f405f405f4,
	0x05d105d105d105d1, 0x05b005b005b005b0,
	0x0590059005900590, 0x0572057205720572,
	0x0555055505550555, 0x0539053905390539,
	0x051e051e051e051e, 0x0505050505050505,
	0x04ec04ec04ec04ec, 0x04d404d404d404d4,
	0x04bd04bd04bd04bd, 0x04a704a704a704a7,
	0x0492049204920492, 0x047d047d047d047d,
	0x0469046904690469, 0x0456045604560456,
	0x0444044404440444, 0x0432043204320432,
	0x0421042104210421, 0x0410041004100410,
	0x0400040004000400, 0x03f003f003f003f0,
	0x03e003e003e003e0, 0x03d203d203d203d2,
	0x03c303c303c303c3, 0x03b503b503b503b5,
	0x03a803a803a803a8, 0x039b039b039b039b,
	0x038e038e038e038e, 0x0381038103810381,
	0x0375037503750375, 0x0369036903690369,
	0x035e035e035e035e, 0x0353035303530353,
	0x0348034803480348, 0x033d033d033d033d,
	0x0333033303330333, 0x0329032903290329,
	0x031f031f031f031f, 0x0315031503150315,
	0x030c030c030c030c, 0x0303030303030303,
	0x02fa02fa02fa02fa, 0x02f102f102f102f1,
	0x02e802e802e802e8, 0x02e002e002e002e0,
	0x02d802d802d802d8, 0x02d002d002d002d0,
	0x02c802c802c802c8, 0x02c002c002c002c0,
	0x02b902b902b902b9, 0x02b102b102b102b1,
	0x02aa02aa02aa02aa, 0x02a302a302a302a3,
	0x029c029c029c029c, 0x0295029502950295,
	0x028f028f028f028f, 0x0288028802880288,
	0x0282028202820282, 0x027c027c027c027c,
	0x0276027602760276, 0x0270027002700270,
	0x026a026a026a026a, 0x0264026402640264,
	0x025e025e025e025e, 0x0259025902590259,
	0x0253025302530253, 0x024e024e024e024e,
	0x0249024902490249, 0x0243024302430243,
	0x023e023e023e023e, 0x0239023902390239,
	0x0234023402340234, 0x0230023002300230,
	0x022b022b022b022b, 0x0226022602260226,
	0x0222022202220222, 0x021d021d021d021d,
	0x0219021902190219, 0x0214021402140214,
	0x0210021002100210, 0x020c020c020c020c,
	0x0208020802080208, 0x0204020402040204,
	0x0200020002000200, 0x01fc01fc01fc01fc,
	0x01f801f801f801f8, 0x01f401f401f401f4,
	0x01f001f001f001f0, 0x01ec01ec01ec01ec,
	0x01e901e901e901e9, 0x01e501e501e501e5,
	0x01e101e101e101e1, 0x01de01de01de01de,
	0x01da01da01da01da, 0x01d701d701d701d7,
	0x01d401d401d401d4, 0x01d001d001d001d0,
	0x01cd01cd01cd01cd, 0x01ca01ca01ca01ca,
	0x01c701c701c701c7, 0x01c301c301c301c3,
	0x01c001c001c001c0, 0x01bd01bd01bd01bd,
	0x01ba01ba01ba01ba, 0x01b701b701b701b7,
	0x01b401b401b401b4, 0x01b201b201b201b2,
	0x01af01af01af01af, 0x01ac01ac01ac01ac,
	0x01a901a901a901a9, 0x01a601a601a601a6,
	0x01a401a401a401a4, 0x01a101a101a101a1,
	0x019e019e019e019e, 0x019c019c019c019c,
	0x0199019901990199, 0x0197019701970197,
	0x0194019401940194, 0x0192019201920192,
	0x018f018f018f018f, 0x018d018d018d018d,
	0x018a018a018a018a, 0x0188018801880188,
	0x0186018601860186, 0x0183018301830183,
	0x0181018101810181, 0x017f017f017f017f,
	0x017d017d017d017d, 0x017a017a017a017a,
	0x0178017801780178, 0x0176017601760176,
	0x0174017401740174, 0x0172017201720172,
	0x0170017001700170, 0x016e016e016e016e,
	0x016c016c016c016c, 0x016a016a016a016a,
	0x0168016801680168, 0x0166016601660166,
	0x0164016401640164, 0x0162016201620162,
	0x0160016001600160, 0x015e015e015e015e,
	0x015c015c015c015c, 0x015a015a015a015a,
	0x0158015801580158, 0x0157015701570157,
	0x0155015501550155, 0x0153015301530153,
	0x0151015101510151, 0x0150015001500150,
	0x014e014e014e014e, 0x014c014c014c014c,
	0x014a014a014a014a, 0x0149014901490149,
	0x0147014701470147, 0x0146014601460146,
	0x0144014401440144, 0x0142014201420142,
	0x0141014101410141, 0x013f013f013f013f,
	0x013e013e013e013e, 0x013c013c013c013c,
	0x013b013b013b013b, 0x0139013901390139,
	0x0138013801380138, 0x0136013601360136,
	0x0135013501350135, 0x0133013301330133,
	0x0132013201320132, 0x0130013001300130,
	0x012f012f012f012f, 0x012e012e012e012e,
	0x012c012c012c012c, 0x012b012b012b012b,
	0x0129012901290129, 0x0128012801280128,
	0x0127012701270127, 0x0125012501250125,
	0x0124012401240124, 0x0123012301230123,
	0x0121012101210121, 0x0120012001200120,
	0x011f011f011f011f, 0x011e011e011e011e,
	0x011c011c011c011c, 0x011b011b011b011b,
	0x011a011a011a011a, 0x0119011901190119,
	0x0118011801180118, 0x0116011601160116,
	0x0115011501150115, 0x0114011401140114,
	0x0113011301130113, 0x0112011201120112,
	0x0111011101110111, 0x010f010f010f010f,
	0x010e010e010e010e, 0x010d010d010d010d,
	0x010c010c010c010c, 0x010b010b010b010b,
	0x010a010a010a010a, 0x0109010901090109,
	0x0108010801080108, 0x0107010701070107,
	0x0106010601060106, 0x0105010501050105,
	0x0104010401040104, 0x0103010301030103,
	0x0102010201020102, 0x0101010101010101,
};

/* *********************************************************** */

const mlib_u64 mlib_DivAlpha_tbl4[] = {
	0x0100ff00ff00ff00, 0x0100ff00ff00ff00,
	0x01007fff7fff7fff, 0x0100555555555555,
	0x0100400040004000, 0x0100333333333333,
	0x01002aaa2aaa2aaa, 0x0100249224922492,
	0x0100200020002000, 0x01001c711c711c71,
	0x0100199919991999, 0x0100174517451745,
	0x0100155515551555, 0x010013b113b113b1,
	0x0100124912491249, 0x0100111111111111,
	0x0100100010001000, 0x01000f0f0f0f0f0f,
	0x01000e380e380e38, 0x01000d790d790d79,
	0x01000ccc0ccc0ccc, 0x01000c300c300c30,
	0x01000ba20ba20ba2, 0x01000b210b210b21,
	0x01000aaa0aaa0aaa, 0x01000a3d0a3d0a3d,
	0x010009d809d809d8, 0x0100097b097b097b,
	0x0100092409240924, 0x010008d308d308d3,
	0x0100088808880888, 0x0100084208420842,
	0x0100080008000800, 0x010007c107c107c1,
	0x0100078707870787, 0x0100075007500750,
	0x0100071c071c071c, 0x010006eb06eb06eb,
	0x010006bc06bc06bc, 0x0100069006900690,
	0x0100066606660666, 0x0100063e063e063e,
	0x0100061806180618, 0x010005f405f405f4,
	0x010005d105d105d1, 0x010005b005b005b0,
	0x0100059005900590, 0x0100057205720572,
	0x0100055505550555, 0x0100053905390539,
	0x0100051e051e051e, 0x0100050505050505,
	0x010004ec04ec04ec, 0x010004d404d404d4,
	0x010004bd04bd04bd, 0x010004a704a704a7,
	0x0100049204920492, 0x0100047d047d047d,
	0x0100046904690469, 0x0100045604560456,
	0x0100044404440444, 0x0100043204320432,
	0x0100042104210421, 0x0100041004100410,
	0x0100040004000400, 0x010003f003f003f0,
	0x010003e003e003e0, 0x010003d203d203d2,
	0x010003c303c303c3, 0x010003b503b503b5,
	0x010003a803a803a8, 0x0100039b039b039b,
	0x0100038e038e038e, 0x0100038103810381,
	0x0100037503750375, 0x0100036903690369,
	0x0100035e035e035e, 0x0100035303530353,
	0x0100034803480348, 0x0100033d033d033d,
	0x0100033303330333, 0x0100032903290329,
	0x0100031f031f031f, 0x0100031503150315,
	0x0100030c030c030c, 0x0100030303030303,
	0x010002fa02fa02fa, 0x010002f102f102f1,
	0x010002e802e802e8, 0x010002e002e002e0,
	0x010002d802d802d8, 0x010002d002d002d0,
	0x010002c802c802c8, 0x010002c002c002c0,
	0x010002b902b902b9, 0x010002b102b102b1,
	0x010002aa02aa02aa, 0x010002a302a302a3,
	0x0100029c029c029c, 0x0100029502950295,
	0x0100028f028f028f, 0x0100028802880288,
	0x0100028202820282, 0x0100027c027c027c,
	0x0100027602760276, 0x0100027002700270,
	0x0100026a026a026a, 0x0100026402640264,
	0x0100025e025e025e, 0x0100025902590259,
	0x0100025302530253, 0x0100024e024e024e,
	0x0100024902490249, 0x0100024302430243,
	0x0100023e023e023e, 0x0100023902390239,
	0x0100023402340234, 0x0100023002300230,
	0x0100022b022b022b, 0x0100022602260226,
	0x0100022202220222, 0x0100021d021d021d,
	0x0100021902190219, 0x0100021402140214,
	0x0100021002100210, 0x0100020c020c020c,
	0x0100020802080208, 0x0100020402040204,
	0x0100020002000200, 0x010001fc01fc01fc,
	0x010001f801f801f8, 0x010001f401f401f4,
	0x010001f001f001f0, 0x010001ec01ec01ec,
	0x010001e901e901e9, 0x010001e501e501e5,
	0x010001e101e101e1, 0x010001de01de01de,
	0x010001da01da01da, 0x010001d701d701d7,
	0x010001d401d401d4, 0x010001d001d001d0,
	0x010001cd01cd01cd, 0x010001ca01ca01ca,
	0x010001c701c701c7, 0x010001c301c301c3,
	0x010001c001c001c0, 0x010001bd01bd01bd,
	0x010001ba01ba01ba, 0x010001b701b701b7,
	0x010001b401b401b4, 0x010001b201b201b2,
	0x010001af01af01af, 0x010001ac01ac01ac,
	0x010001a901a901a9, 0x010001a601a601a6,
	0x010001a401a401a4, 0x010001a101a101a1,
	0x0100019e019e019e, 0x0100019c019c019c,
	0x0100019901990199, 0x0100019701970197,
	0x0100019401940194, 0x0100019201920192,
	0x0100018f018f018f, 0x0100018d018d018d,
	0x0100018a018a018a, 0x0100018801880188,
	0x0100018601860186, 0x0100018301830183,
	0x0100018101810181, 0x0100017f017f017f,
	0x0100017d017d017d, 0x0100017a017a017a,
	0x0100017801780178, 0x0100017601760176,
	0x0100017401740174, 0x0100017201720172,
	0x0100017001700170, 0x0100016e016e016e,
	0x0100016c016c016c, 0x0100016a016a016a,
	0x0100016801680168, 0x0100016601660166,
	0x0100016401640164, 0x0100016201620162,
	0x0100016001600160, 0x0100015e015e015e,
	0x0100015c015c015c, 0x0100015a015a015a,
	0x0100015801580158, 0x0100015701570157,
	0x0100015501550155, 0x0100015301530153,
	0x0100015101510151, 0x0100015001500150,
	0x0100014e014e014e, 0x0100014c014c014c,
	0x0100014a014a014a, 0x0100014901490149,
	0x0100014701470147, 0x0100014601460146,
	0x0100014401440144, 0x0100014201420142,
	0x0100014101410141, 0x0100013f013f013f,
	0x0100013e013e013e, 0x0100013c013c013c,
	0x0100013b013b013b, 0x0100013901390139,
	0x0100013801380138, 0x0100013601360136,
	0x0100013501350135, 0x0100013301330133,
	0x0100013201320132, 0x0100013001300130,
	0x0100012f012f012f, 0x0100012e012e012e,
	0x0100012c012c012c, 0x0100012b012b012b,
	0x0100012901290129, 0x0100012801280128,
	0x0100012701270127, 0x0100012501250125,
	0x0100012401240124, 0x0100012301230123,
	0x0100012101210121, 0x0100012001200120,
	0x0100011f011f011f, 0x0100011e011e011e,
	0x0100011c011c011c, 0x0100011b011b011b,
	0x0100011a011a011a, 0x0100011901190119,
	0x0100011801180118, 0x0100011601160116,
	0x0100011501150115, 0x0100011401140114,
	0x0100011301130113, 0x0100011201120112,
	0x0100011101110111, 0x0100010f010f010f,
	0x0100010e010e010e, 0x0100010d010d010d,
	0x0100010c010c010c, 0x0100010b010b010b,
	0x0100010a010a010a, 0x0100010901090109,
	0x0100010801080108, 0x0100010701070107,
	0x0100010601060106, 0x0100010501050105,
	0x0100010401040104, 0x0100010301030103,
	0x0100010201020102, 0x0100010101010101,

	0xff000100ff00ff00, 0xff000100ff00ff00,
	0x7fff01007fff7fff, 0x5555010055555555,
	0x4000010040004000, 0x3333010033333333,
	0x2aaa01002aaa2aaa, 0x2492010024922492,
	0x2000010020002000, 0x1c7101001c711c71,
	0x1999010019991999, 0x1745010017451745,
	0x1555010015551555, 0x13b1010013b113b1,
	0x1249010012491249, 0x1111010011111111,
	0x1000010010001000, 0x0f0f01000f0f0f0f,
	0x0e3801000e380e38, 0x0d7901000d790d79,
	0x0ccc01000ccc0ccc, 0x0c3001000c300c30,
	0x0ba201000ba20ba2, 0x0b2101000b210b21,
	0x0aaa01000aaa0aaa, 0x0a3d01000a3d0a3d,
	0x09d8010009d809d8, 0x097b0100097b097b,
	0x0924010009240924, 0x08d3010008d308d3,
	0x0888010008880888, 0x0842010008420842,
	0x0800010008000800, 0x07c1010007c107c1,
	0x0787010007870787, 0x0750010007500750,
	0x071c0100071c071c, 0x06eb010006eb06eb,
	0x06bc010006bc06bc, 0x0690010006900690,
	0x0666010006660666, 0x063e0100063e063e,
	0x0618010006180618, 0x05f4010005f405f4,
	0x05d1010005d105d1, 0x05b0010005b005b0,
	0x0590010005900590, 0x0572010005720572,
	0x0555010005550555, 0x0539010005390539,
	0x051e0100051e051e, 0x0505010005050505,
	0x04ec010004ec04ec, 0x04d4010004d404d4,
	0x04bd010004bd04bd, 0x04a7010004a704a7,
	0x0492010004920492, 0x047d0100047d047d,
	0x0469010004690469, 0x0456010004560456,
	0x0444010004440444, 0x0432010004320432,
	0x0421010004210421, 0x0410010004100410,
	0x0400010004000400, 0x03f0010003f003f0,
	0x03e0010003e003e0, 0x03d2010003d203d2,
	0x03c3010003c303c3, 0x03b5010003b503b5,
	0x03a8010003a803a8, 0x039b0100039b039b,
	0x038e0100038e038e, 0x0381010003810381,
	0x0375010003750375, 0x0369010003690369,
	0x035e0100035e035e, 0x0353010003530353,
	0x0348010003480348, 0x033d0100033d033d,
	0x0333010003330333, 0x0329010003290329,
	0x031f0100031f031f, 0x0315010003150315,
	0x030c0100030c030c, 0x0303010003030303,
	0x02fa010002fa02fa, 0x02f1010002f102f1,
	0x02e8010002e802e8, 0x02e0010002e002e0,
	0x02d8010002d802d8, 0x02d0010002d002d0,
	0x02c8010002c802c8, 0x02c0010002c002c0,
	0x02b9010002b902b9, 0x02b1010002b102b1,
	0x02aa010002aa02aa, 0x02a3010002a302a3,
	0x029c0100029c029c, 0x0295010002950295,
	0x028f0100028f028f, 0x0288010002880288,
	0x0282010002820282, 0x027c0100027c027c,
	0x0276010002760276, 0x0270010002700270,
	0x026a0100026a026a, 0x0264010002640264,
	0x025e0100025e025e, 0x0259010002590259,
	0x0253010002530253, 0x024e0100024e024e,
	0x0249010002490249, 0x0243010002430243,
	0x023e0100023e023e, 0x0239010002390239,
	0x0234010002340234, 0x0230010002300230,
	0x022b0100022b022b, 0x0226010002260226,
	0x0222010002220222, 0x021d0100021d021d,
	0x0219010002190219, 0x0214010002140214,
	0x0210010002100210, 0x020c0100020c020c,
	0x0208010002080208, 0x0204010002040204,
	0x0200010002000200, 0x01fc010001fc01fc,
	0x01f8010001f801f8, 0x01f4010001f401f4,
	0x01f0010001f001f0, 0x01ec010001ec01ec,
	0x01e9010001e901e9, 0x01e5010001e501e5,
	0x01e1010001e101e1, 0x01de010001de01de,
	0x01da010001da01da, 0x01d7010001d701d7,
	0x01d4010001d401d4, 0x01d0010001d001d0,
	0x01cd010001cd01cd, 0x01ca010001ca01ca,
	0x01c7010001c701c7, 0x01c3010001c301c3,
	0x01c0010001c001c0, 0x01bd010001bd01bd,
	0x01ba010001ba01ba, 0x01b7010001b701b7,
	0x01b4010001b401b4, 0x01b2010001b201b2,
	0x01af010001af01af, 0x01ac010001ac01ac,
	0x01a9010001a901a9, 0x01a6010001a601a6,
	0x01a4010001a401a4, 0x01a1010001a101a1,
	0x019e0100019e019e, 0x019c0100019c019c,
	0x0199010001990199, 0x0197010001970197,
	0x0194010001940194, 0x0192010001920192,
	0x018f0100018f018f, 0x018d0100018d018d,
	0x018a0100018a018a, 0x0188010001880188,
	0x0186010001860186, 0x0183010001830183,
	0x0181010001810181, 0x017f0100017f017f,
	0x017d0100017d017d, 0x017a0100017a017a,
	0x0178010001780178, 0x0176010001760176,
	0x0174010001740174, 0x0172010001720172,
	0x0170010001700170, 0x016e0100016e016e,
	0x016c0100016c016c, 0x016a0100016a016a,
	0x0168010001680168, 0x0166010001660166,
	0x0164010001640164, 0x0162010001620162,
	0x0160010001600160, 0x015e0100015e015e,
	0x015c0100015c015c, 0x015a0100015a015a,
	0x0158010001580158, 0x0157010001570157,
	0x0155010001550155, 0x0153010001530153,
	0x0151010001510151, 0x0150010001500150,
	0x014e0100014e014e, 0x014c0100014c014c,
	0x014a0100014a014a, 0x0149010001490149,
	0x0147010001470147, 0x0146010001460146,
	0x0144010001440144, 0x0142010001420142,
	0x0141010001410141, 0x013f0100013f013f,
	0x013e0100013e013e, 0x013c0100013c013c,
	0x013b0100013b013b, 0x0139010001390139,
	0x0138010001380138, 0x0136010001360136,
	0x0135010001350135, 0x0133010001330133,
	0x0132010001320132, 0x0130010001300130,
	0x012f0100012f012f, 0x012e0100012e012e,
	0x012c0100012c012c, 0x012b0100012b012b,
	0x0129010001290129, 0x0128010001280128,
	0x0127010001270127, 0x0125010001250125,
	0x0124010001240124, 0x0123010001230123,
	0x0121010001210121, 0x0120010001200120,
	0x011f0100011f011f, 0x011e0100011e011e,
	0x011c0100011c011c, 0x011b0100011b011b,
	0x011a0100011a011a, 0x0119010001190119,
	0x0118010001180118, 0x0116010001160116,
	0x0115010001150115, 0x0114010001140114,
	0x0113010001130113, 0x0112010001120112,
	0x0111010001110111, 0x010f0100010f010f,
	0x010e0100010e010e, 0x010d0100010d010d,
	0x010c0100010c010c, 0x010b0100010b010b,
	0x010a0100010a010a, 0x0109010001090109,
	0x0108010001080108, 0x0107010001070107,
	0x0106010001060106, 0x0105010001050105,
	0x0104010001040104, 0x0103010001030103,
	0x0102010001020102, 0x0101010001010101,

	0xff00ff000100ff00, 0xff00ff000100ff00,
	0x7fff7fff01007fff, 0x5555555501005555,
	0x4000400001004000, 0x3333333301003333,
	0x2aaa2aaa01002aaa, 0x2492249201002492,
	0x2000200001002000, 0x1c711c7101001c71,
	0x1999199901001999, 0x1745174501001745,
	0x1555155501001555, 0x13b113b1010013b1,
	0x1249124901001249, 0x1111111101001111,
	0x1000100001001000, 0x0f0f0f0f01000f0f,
	0x0e380e3801000e38, 0x0d790d7901000d79,
	0x0ccc0ccc01000ccc, 0x0c300c3001000c30,
	0x0ba20ba201000ba2, 0x0b210b2101000b21,
	0x0aaa0aaa01000aaa, 0x0a3d0a3d01000a3d,
	0x09d809d8010009d8, 0x097b097b0100097b,
	0x0924092401000924, 0x08d308d3010008d3,
	0x0888088801000888, 0x0842084201000842,
	0x0800080001000800, 0x07c107c1010007c1,
	0x0787078701000787, 0x0750075001000750,
	0x071c071c0100071c, 0x06eb06eb010006eb,
	0x06bc06bc010006bc, 0x0690069001000690,
	0x0666066601000666, 0x063e063e0100063e,
	0x0618061801000618, 0x05f405f4010005f4,
	0x05d105d1010005d1, 0x05b005b0010005b0,
	0x0590059001000590, 0x0572057201000572,
	0x0555055501000555, 0x0539053901000539,
	0x051e051e0100051e, 0x0505050501000505,
	0x04ec04ec010004ec, 0x04d404d4010004d4,
	0x04bd04bd010004bd, 0x04a704a7010004a7,
	0x0492049201000492, 0x047d047d0100047d,
	0x0469046901000469, 0x0456045601000456,
	0x0444044401000444, 0x0432043201000432,
	0x0421042101000421, 0x0410041001000410,
	0x0400040001000400, 0x03f003f0010003f0,
	0x03e003e0010003e0, 0x03d203d2010003d2,
	0x03c303c3010003c3, 0x03b503b5010003b5,
	0x03a803a8010003a8, 0x039b039b0100039b,
	0x038e038e0100038e, 0x0381038101000381,
	0x0375037501000375, 0x0369036901000369,
	0x035e035e0100035e, 0x0353035301000353,
	0x0348034801000348, 0x033d033d0100033d,
	0x0333033301000333, 0x0329032901000329,
	0x031f031f0100031f, 0x0315031501000315,
	0x030c030c0100030c, 0x0303030301000303,
	0x02fa02fa010002fa, 0x02f102f1010002f1,
	0x02e802e8010002e8, 0x02e002e0010002e0,
	0x02d802d8010002d8, 0x02d002d0010002d0,
	0x02c802c8010002c8, 0x02c002c0010002c0,
	0x02b902b9010002b9, 0x02b102b1010002b1,
	0x02aa02aa010002aa, 0x02a302a3010002a3,
	0x029c029c0100029c, 0x0295029501000295,
	0x028f028f0100028f, 0x0288028801000288,
	0x0282028201000282, 0x027c027c0100027c,
	0x0276027601000276, 0x0270027001000270,
	0x026a026a0100026a, 0x0264026401000264,
	0x025e025e0100025e, 0x0259025901000259,
	0x0253025301000253, 0x024e024e0100024e,
	0x0249024901000249, 0x0243024301000243,
	0x023e023e0100023e, 0x0239023901000239,
	0x0234023401000234, 0x0230023001000230,
	0x022b022b0100022b, 0x0226022601000226,
	0x0222022201000222, 0x021d021d0100021d,
	0x0219021901000219, 0x0214021401000214,
	0x0210021001000210, 0x020c020c0100020c,
	0x0208020801000208, 0x0204020401000204,
	0x0200020001000200, 0x01fc01fc010001fc,
	0x01f801f8010001f8, 0x01f401f4010001f4,
	0x01f001f0010001f0, 0x01ec01ec010001ec,
	0x01e901e9010001e9, 0x01e501e5010001e5,
	0x01e101e1010001e1, 0x01de01de010001de,
	0x01da01da010001da, 0x01d701d7010001d7,
	0x01d401d4010001d4, 0x01d001d0010001d0,
	0x01cd01cd010001cd, 0x01ca01ca010001ca,
	0x01c701c7010001c7, 0x01c301c3010001c3,
	0x01c001c0010001c0, 0x01bd01bd010001bd,
	0x01ba01ba010001ba, 0x01b701b7010001b7,
	0x01b401b4010001b4, 0x01b201b2010001b2,
	0x01af01af010001af, 0x01ac01ac010001ac,
	0x01a901a9010001a9, 0x01a601a6010001a6,
	0x01a401a4010001a4, 0x01a101a1010001a1,
	0x019e019e0100019e, 0x019c019c0100019c,
	0x0199019901000199, 0x0197019701000197,
	0x0194019401000194, 0x0192019201000192,
	0x018f018f0100018f, 0x018d018d0100018d,
	0x018a018a0100018a, 0x0188018801000188,
	0x0186018601000186, 0x0183018301000183,
	0x0181018101000181, 0x017f017f0100017f,
	0x017d017d0100017d, 0x017a017a0100017a,
	0x0178017801000178, 0x0176017601000176,
	0x0174017401000174, 0x0172017201000172,
	0x0170017001000170, 0x016e016e0100016e,
	0x016c016c0100016c, 0x016a016a0100016a,
	0x0168016801000168, 0x0166016601000166,
	0x0164016401000164, 0x0162016201000162,
	0x0160016001000160, 0x015e015e0100015e,
	0x015c015c0100015c, 0x015a015a0100015a,
	0x0158015801000158, 0x0157015701000157,
	0x0155015501000155, 0x0153015301000153,
	0x0151015101000151, 0x0150015001000150,
	0x014e014e0100014e, 0x014c014c0100014c,
	0x014a014a0100014a, 0x0149014901000149,
	0x0147014701000147, 0x0146014601000146,
	0x0144014401000144, 0x0142014201000142,
	0x0141014101000141, 0x013f013f0100013f,
	0x013e013e0100013e, 0x013c013c0100013c,
	0x013b013b0100013b, 0x0139013901000139,
	0x0138013801000138, 0x0136013601000136,
	0x0135013501000135, 0x0133013301000133,
	0x0132013201000132, 0x0130013001000130,
	0x012f012f0100012f, 0x012e012e0100012e,
	0x012c012c0100012c, 0x012b012b0100012b,
	0x0129012901000129, 0x0128012801000128,
	0x0127012701000127, 0x0125012501000125,
	0x0124012401000124, 0x0123012301000123,
	0x0121012101000121, 0x0120012001000120,
	0x011f011f0100011f, 0x011e011e0100011e,
	0x011c011c0100011c, 0x011b011b0100011b,
	0x011a011a0100011a, 0x0119011901000119,
	0x0118011801000118, 0x0116011601000116,
	0x0115011501000115, 0x0114011401000114,
	0x0113011301000113, 0x0112011201000112,
	0x0111011101000111, 0x010f010f0100010f,
	0x010e010e0100010e, 0x010d010d0100010d,
	0x010c010c0100010c, 0x010b010b0100010b,
	0x010a010a0100010a, 0x0109010901000109,
	0x0108010801000108, 0x0107010701000107,
	0x0106010601000106, 0x0105010501000105,
	0x0104010401000104, 0x0103010301000103,
	0x0102010201000102, 0x0101010101000101,

	0xff00ff00ff000100, 0xff00ff00ff000100,
	0x7fff7fff7fff0100, 0x5555555555550100,
	0x4000400040000100, 0x3333333333330100,
	0x2aaa2aaa2aaa0100, 0x2492249224920100,
	0x2000200020000100, 0x1c711c711c710100,
	0x1999199919990100, 0x1745174517450100,
	0x1555155515550100, 0x13b113b113b10100,
	0x1249124912490100, 0x1111111111110100,
	0x1000100010000100, 0x0f0f0f0f0f0f0100,
	0x0e380e380e380100, 0x0d790d790d790100,
	0x0ccc0ccc0ccc0100, 0x0c300c300c300100,
	0x0ba20ba20ba20100, 0x0b210b210b210100,
	0x0aaa0aaa0aaa0100, 0x0a3d0a3d0a3d0100,
	0x09d809d809d80100, 0x097b097b097b0100,
	0x0924092409240100, 0x08d308d308d30100,
	0x0888088808880100, 0x0842084208420100,
	0x0800080008000100, 0x07c107c107c10100,
	0x0787078707870100, 0x0750075007500100,
	0x071c071c071c0100, 0x06eb06eb06eb0100,
	0x06bc06bc06bc0100, 0x0690069006900100,
	0x0666066606660100, 0x063e063e063e0100,
	0x0618061806180100, 0x05f405f405f40100,
	0x05d105d105d10100, 0x05b005b005b00100,
	0x0590059005900100, 0x0572057205720100,
	0x0555055505550100, 0x0539053905390100,
	0x051e051e051e0100, 0x0505050505050100,
	0x04ec04ec04ec0100, 0x04d404d404d40100,
	0x04bd04bd04bd0100, 0x04a704a704a70100,
	0x0492049204920100, 0x047d047d047d0100,
	0x0469046904690100, 0x0456045604560100,
	0x0444044404440100, 0x0432043204320100,
	0x0421042104210100, 0x0410041004100100,
	0x0400040004000100, 0x03f003f003f00100,
	0x03e003e003e00100, 0x03d203d203d20100,
	0x03c303c303c30100, 0x03b503b503b50100,
	0x03a803a803a80100, 0x039b039b039b0100,
	0x038e038e038e0100, 0x0381038103810100,
	0x0375037503750100, 0x0369036903690100,
	0x035e035e035e0100, 0x0353035303530100,
	0x0348034803480100, 0x033d033d033d0100,
	0x0333033303330100, 0x0329032903290100,
	0x031f031f031f0100, 0x0315031503150100,
	0x030c030c030c0100, 0x0303030303030100,
	0x02fa02fa02fa0100, 0x02f102f102f10100,
	0x02e802e802e80100, 0x02e002e002e00100,
	0x02d802d802d80100, 0x02d002d002d00100,
	0x02c802c802c80100, 0x02c002c002c00100,
	0x02b902b902b90100, 0x02b102b102b10100,
	0x02aa02aa02aa0100, 0x02a302a302a30100,
	0x029c029c029c0100, 0x0295029502950100,
	0x028f028f028f0100, 0x0288028802880100,
	0x0282028202820100, 0x027c027c027c0100,
	0x0276027602760100, 0x0270027002700100,
	0x026a026a026a0100, 0x0264026402640100,
	0x025e025e025e0100, 0x0259025902590100,
	0x0253025302530100, 0x024e024e024e0100,
	0x0249024902490100, 0x0243024302430100,
	0x023e023e023e0100, 0x0239023902390100,
	0x0234023402340100, 0x0230023002300100,
	0x022b022b022b0100, 0x0226022602260100,
	0x0222022202220100, 0x021d021d021d0100,
	0x0219021902190100, 0x0214021402140100,
	0x0210021002100100, 0x020c020c020c0100,
	0x0208020802080100, 0x0204020402040100,
	0x0200020002000100, 0x01fc01fc01fc0100,
	0x01f801f801f80100, 0x01f401f401f40100,
	0x01f001f001f00100, 0x01ec01ec01ec0100,
	0x01e901e901e90100, 0x01e501e501e50100,
	0x01e101e101e10100, 0x01de01de01de0100,
	0x01da01da01da0100, 0x01d701d701d70100,
	0x01d401d401d40100, 0x01d001d001d00100,
	0x01cd01cd01cd0100, 0x01ca01ca01ca0100,
	0x01c701c701c70100, 0x01c301c301c30100,
	0x01c001c001c00100, 0x01bd01bd01bd0100,
	0x01ba01ba01ba0100, 0x01b701b701b70100,
	0x01b401b401b40100, 0x01b201b201b20100,
	0x01af01af01af0100, 0x01ac01ac01ac0100,
	0x01a901a901a90100, 0x01a601a601a60100,
	0x01a401a401a40100, 0x01a101a101a10100,
	0x019e019e019e0100, 0x019c019c019c0100,
	0x0199019901990100, 0x0197019701970100,
	0x0194019401940100, 0x0192019201920100,
	0x018f018f018f0100, 0x018d018d018d0100,
	0x018a018a018a0100, 0x0188018801880100,
	0x0186018601860100, 0x0183018301830100,
	0x0181018101810100, 0x017f017f017f0100,
	0x017d017d017d0100, 0x017a017a017a0100,
	0x0178017801780100, 0x0176017601760100,
	0x0174017401740100, 0x0172017201720100,
	0x0170017001700100, 0x016e016e016e0100,
	0x016c016c016c0100, 0x016a016a016a0100,
	0x0168016801680100, 0x0166016601660100,
	0x0164016401640100, 0x0162016201620100,
	0x0160016001600100, 0x015e015e015e0100,
	0x015c015c015c0100, 0x015a015a015a0100,
	0x0158015801580100, 0x0157015701570100,
	0x0155015501550100, 0x0153015301530100,
	0x0151015101510100, 0x0150015001500100,
	0x014e014e014e0100, 0x014c014c014c0100,
	0x014a014a014a0100, 0x0149014901490100,
	0x0147014701470100, 0x0146014601460100,
	0x0144014401440100, 0x0142014201420100,
	0x0141014101410100, 0x013f013f013f0100,
	0x013e013e013e0100, 0x013c013c013c0100,
	0x013b013b013b0100, 0x0139013901390100,
	0x0138013801380100, 0x0136013601360100,
	0x0135013501350100, 0x0133013301330100,
	0x0132013201320100, 0x0130013001300100,
	0x012f012f012f0100, 0x012e012e012e0100,
	0x012c012c012c0100, 0x012b012b012b0100,
	0x0129012901290100, 0x0128012801280100,
	0x0127012701270100, 0x0125012501250100,
	0x0124012401240100, 0x0123012301230100,
	0x0121012101210100, 0x0120012001200100,
	0x011f011f011f0100, 0x011e011e011e0100,
	0x011c011c011c0100, 0x011b011b011b0100,
	0x011a011a011a0100, 0x0119011901190100,
	0x0118011801180100, 0x0116011601160100,
	0x0115011501150100, 0x0114011401140100,
	0x0113011301130100, 0x0112011201120100,
	0x0111011101110100, 0x010f010f010f0100,
	0x010e010e010e0100, 0x010d010d010d0100,
	0x010c010c010c0100, 0x010b010b010b0100,
	0x010a010a010a0100, 0x0109010901090100,
	0x0108010801080100, 0x0107010701070100,
	0x0106010601060100, 0x0105010501050100,
	0x0104010401040100, 0x0103010301030100,
	0x0102010201020100, 0x0101010101010100,
};

/* *********************************************************** */

#ifdef MLIB_USE_FTOI_CLAMPING

const mlib_f32 mlib_v_blend_u8_sat[] = {
	0.0f, 8388608.0f, 16777216.0f, 25165824.0f,
	33554432.0f, 41943040.0f, 50331648.0f, 58720256.0f,
	67108864.0f, 75497472.0f, 83886080.0f, 92274688.0f,
	100663296.0f, 109051904.0f, 117440512.0f, 125829120.0f,
	134217728.0f, 142606336.0f, 150994944.0f, 159383552.0f,
	167772160.0f, 176160768.0f, 184549376.0f, 192937984.0f,
	201326592.0f, 209715200.0f, 218103808.0f, 226492416.0f,
	234881024.0f, 243269632.0f, 251658240.0f, 260046848.0f,
	268435456.0f, 276824064.0f, 285212672.0f, 293601280.0f,
	301989888.0f, 310378496.0f, 318767104.0f, 327155712.0f,
	335544320.0f, 343932928.0f, 352321536.0f, 360710144.0f,
	369098752.0f, 377487360.0f, 385875968.0f, 394264576.0f,
	402653184.0f, 411041792.0f, 419430400.0f, 427819008.0f,
	436207616.0f, 444596224.0f, 452984832.0f, 461373440.0f,
	469762048.0f, 478150656.0f, 486539264.0f, 494927872.0f,
	503316480.0f, 511705088.0f, 520093696.0f, 528482304.0f,
	536870912.0f, 545259520.0f, 553648128.0f, 562036736.0f,
	570425344.0f, 578813952.0f, 587202560.0f, 595591168.0f,
	603979776.0f, 612368384.0f, 620756992.0f, 629145600.0f,
	637534208.0f, 645922816.0f, 654311424.0f, 662700032.0f,
	671088640.0f, 679477248.0f, 687865856.0f, 696254464.0f,
	704643072.0f, 713031680.0f, 721420288.0f, 729808896.0f,
	738197504.0f, 746586112.0f, 754974720.0f, 763363328.0f,
	771751936.0f, 780140544.0f, 788529152.0f, 796917760.0f,
	805306368.0f, 813694976.0f, 822083584.0f, 830472192.0f,
	838860800.0f, 847249408.0f, 855638016.0f, 864026624.0f,
	872415232.0f, 880803840.0f, 889192448.0f, 897581056.0f,
	905969664.0f, 914358272.0f, 922746880.0f, 931135488.0f,
	939524096.0f, 947912704.0f, 956301312.0f, 964689920.0f,
	973078528.0f, 981467136.0f, 989855744.0f, 998244352.0f,
	1006632960.0f, 1015021568.0f, 1023410176.0f, 1031798784.0f,
	1040187392.0f, 1048576000.0f, 1056964608.0f, 1065353216.0f,
	1073741824.0f, 1082130432.0f, 1090519040.0f, 1098907648.0f,
	1107296256.0f, 1115684864.0f, 1124073472.0f, 1132462080.0f,
	1140850688.0f, 1149239296.0f, 1157627904.0f, 1166016512.0f,
	1174405120.0f, 1182793728.0f, 1191182336.0f, 1199570944.0f,
	1207959552.0f, 1216348160.0f, 1224736768.0f, 1233125376.0f,
	1241513984.0f, 1249902592.0f, 1258291200.0f, 1266679808.0f,
	1275068416.0f, 1283457024.0f, 1291845632.0f, 1300234240.0f,
	1308622848.0f, 1317011456.0f, 1325400064.0f, 1333788672.0f,
	1342177280.0f, 1350565888.0f, 1358954496.0f, 1367343104.0f,
	1375731712.0f, 1384120320.0f, 1392508928.0f, 1400897536.0f,
	1409286144.0f, 1417674752.0f, 1426063360.0f, 1434451968.0f,
	1442840576.0f, 1451229184.0f, 1459617792.0f, 1468006400.0f,
	1476395008.0f, 1484783616.0f, 1493172224.0f, 1501560832.0f,
	1509949440.0f, 1518338048.0f, 1526726656.0f, 1535115264.0f,
	1543503872.0f, 1551892480.0f, 1560281088.0f, 1568669696.0f,
	1577058304.0f, 1585446912.0f, 1593835520.0f, 1602224128.0f,
	1610612736.0f, 1619001344.0f, 1627389952.0f, 1635778560.0f,
	1644167168.0f, 1652555776.0f, 1660944384.0f, 1669332992.0f,
	1677721600.0f, 1686110208.0f, 1694498816.0f, 1702887424.0f,
	1711276032.0f, 1719664640.0f, 1728053248.0f, 1736441856.0f,
	1744830464.0f, 1753219072.0f, 1761607680.0f, 1769996288.0f,
	1778384896.0f, 1786773504.0f, 1795162112.0f, 1803550720.0f,
	1811939328.0f, 1820327936.0f, 1828716544.0f, 1837105152.0f,
	1845493760.0f, 1853882368.0f, 1862270976.0f, 1870659584.0f,
	1879048192.0f, 1887436800.0f, 1895825408.0f, 1904214016.0f,
	1912602624.0f, 1920991232.0f, 1929379840.0f, 1937768448.0f,
	1946157056.0f, 1954545664.0f, 1962934272.0f, 1971322880.0f,
	1979711488.0f, 1988100096.0f, 1996488704.0f, 2004877312.0f,
	2013265920.0f, 2021654528.0f, 2030043136.0f, 2038431744.0f,
	2046820352.0f, 2055208960.0f, 2063597568.0f, 2071986176.0f,
	2080374784.0f, 2088763392.0f, 2097152000.0f, 2105540608.0f,
	2113929216.0f, 2122317824.0f, 2130706432.0f, 2139095040.0f,
	2147483648.0f
};
#else /* MLIB_USE_FTOI_CLAMPING */

const mlib_f32 mlib_v_blend_u8_sat[] = {
	0.0f, 1.0f, 2.0f, 3.0f, 4.0f,
	5.0f, 6.0f, 7.0f, 8.0f, 9.0f,
	10.0f, 11.0f, 12.0f, 13.0f, 14.0f,
	15.0f, 16.0f, 17.0f, 18.0f, 19.0f,
	20.0f, 21.0f, 22.0f, 23.0f, 24.0f,
	25.0f, 26.0f, 27.0f, 28.0f, 29.0f,
	30.0f, 31.0f, 32.0f, 33.0f, 34.0f,
	35.0f, 36.0f, 37.0f, 38.0f, 39.0f,
	40.0f, 41.0f, 42.0f, 43.0f, 44.0f,
	45.0f, 46.0f, 47.0f, 48.0f, 49.0f,
	50.0f, 51.0f, 52.0f, 53.0f, 54.0f,
	55.0f, 56.0f, 57.0f, 58.0f, 59.0f,
	60.0f, 61.0f, 62.0f, 63.0f, 64.0f,
	65.0f, 66.0f, 67.0f, 68.0f, 69.0f,
	70.0f, 71.0f, 72.0f, 73.0f, 74.0f,
	75.0f, 76.0f, 77.0f, 78.0f, 79.0f,
	80.0f, 81.0f, 82.0f, 83.0f, 84.0f,
	85.0f, 86.0f, 87.0f, 88.0f, 89.0f,
	90.0f, 91.0f, 92.0f, 93.0f, 94.0f,
	95.0f, 96.0f, 97.0f, 98.0f, 99.0f,
	100.0f, 101.0f, 102.0f, 103.0f, 104.0f,
	105.0f, 106.0f, 107.0f, 108.0f, 109.0f,
	110.0f, 111.0f, 112.0f, 113.0f, 114.0f,
	115.0f, 116.0f, 117.0f, 118.0f, 119.0f,
	120.0f, 121.0f, 122.0f, 123.0f, 124.0f,
	125.0f, 126.0f, 127.0f, 128.0f, 129.0f,
	130.0f, 131.0f, 132.0f, 133.0f, 134.0f,
	135.0f, 136.0f, 137.0f, 138.0f, 139.0f,
	140.0f, 141.0f, 142.0f, 143.0f, 144.0f,
	145.0f, 146.0f, 147.0f, 148.0f, 149.0f,
	150.0f, 151.0f, 152.0f, 153.0f, 154.0f,
	155.0f, 156.0f, 157.0f, 158.0f, 159.0f,
	160.0f, 161.0f, 162.0f, 163.0f, 164.0f,
	165.0f, 166.0f, 167.0f, 168.0f, 169.0f,
	170.0f, 171.0f, 172.0f, 173.0f, 174.0f,
	175.0f, 176.0f, 177.0f, 178.0f, 179.0f,
	180.0f, 181.0f, 182.0f, 183.0f, 184.0f,
	185.0f, 186.0f, 187.0f, 188.0f, 189.0f,
	190.0f, 191.0f, 192.0f, 193.0f, 194.0f,
	195.0f, 196.0f, 197.0f, 198.0f, 199.0f,
	200.0f, 201.0f, 202.0f, 203.0f, 204.0f,
	205.0f, 206.0f, 207.0f, 208.0f, 209.0f,
	210.0f, 211.0f, 212.0f, 213.0f, 214.0f,
	215.0f, 216.0f, 217.0f, 218.0f, 219.0f,
	220.0f, 221.0f, 222.0f, 223.0f, 224.0f,
	225.0f, 226.0f, 227.0f, 228.0f, 229.0f,
	230.0f, 231.0f, 232.0f, 233.0f, 234.0f,
	235.0f, 236.0f, 237.0f, 238.0f, 239.0f,
	240.0f, 241.0f, 242.0f, 243.0f, 244.0f,
	245.0f, 246.0f, 247.0f, 248.0f, 249.0f,
	250.0f, 251.0f, 252.0f, 253.0f, 254.0f,
	255.0f, 256.0f
};
#endif /* MLIB_USE_FTOI_CLAMPING */

/* *********************************************************** */

const mlib_f32 mlib_div_tab_Q8[] = {
	255.00000000f, 255.00000000f, 127.50000000f, 85.00000000,
	63.75000000f, 51.00000000f, 42.50000000f, 36.42857143f,
	31.87500000f, 28.33333333f, 25.50000000f, 23.18181818f,
	21.25000000f, 19.61538462f, 18.21428571f, 17.00000000f,
	15.93750000f, 15.00000000f, 14.16666667f, 13.42105263f,
	12.75000000f, 12.14285714f, 11.59090909f, 11.08695652f,
	10.62500000f, 10.20000000f, 9.80769231f, 9.44444444f,
	9.10714286f, 8.79310345f, 8.50000000f, 8.22580645f,
	7.96875000f, 7.72727273f, 7.50000000f, 7.28571429f,
	7.08333333f, 6.89189189f, 6.71052632f, 6.53846154f,
	6.37500000f, 6.21951220f, 6.07142857f, 5.93023256f,
	5.79545455f, 5.66666667f, 5.54347826f, 5.42553191f,
	5.31250000f, 5.20408163f, 5.10000000f, 5.00000000f,
	4.90384615f, 4.81132075f, 4.72222222f, 4.63636364f,
	4.55357143f, 4.47368421f, 4.39655172f, 4.32203390f,
	4.25000000f, 4.18032787f, 4.11290323f, 4.04761905f,
	3.98437500f, 3.92307692f, 3.86363636f, 3.80597015f,
	3.75000000f, 3.69565217f, 3.64285714f, 3.59154930f,
	3.54166667f, 3.49315068f, 3.44594595f, 3.40000000f,
	3.35526316f, 3.31168831f, 3.26923077f, 3.22784810f,
	3.18750000f, 3.14814815f, 3.10975610f, 3.07228916f,
	3.03571429f, 3.00000000f, 2.96511628f, 2.93103448f,
	2.89772727f, 2.86516854f, 2.83333333f, 2.80219780f,
	2.77173913f, 2.74193548f, 2.71276596f, 2.68421053f,
	2.65625000f, 2.62886598f, 2.60204082f, 2.57575758f,
	2.55000000f, 2.52475248f, 2.50000000f, 2.47572816f,
	2.45192308f, 2.42857143f, 2.40566038f, 2.38317757f,
	2.36111111f, 2.33944954f, 2.31818182f, 2.29729730f,
	2.27678571f, 2.25663717f, 2.23684211f, 2.21739130f,
	2.19827586f, 2.17948718f, 2.16101695f, 2.14285714f,
	2.12500000f, 2.10743802f, 2.09016393f, 2.07317073f,
	2.05645161f, 2.04000000f, 2.02380952f, 2.00787402f,
	1.99218750f, 1.97674419f, 1.96153846f, 1.94656489f,
	1.93181818f, 1.91729323f, 1.90298507f, 1.88888889f,
	1.87500000f, 1.86131387f, 1.84782609f, 1.83453237f,
	1.82142857f, 1.80851064f, 1.79577465f, 1.78321678f,
	1.77083333f, 1.75862069f, 1.74657534f, 1.73469388f,
	1.72297297f, 1.71140940f, 1.70000000f, 1.68874172f,
	1.67763158f, 1.66666667f, 1.65584416f, 1.64516129f,
	1.63461538f, 1.62420382f, 1.61392405f, 1.60377358f,
	1.59375000f, 1.58385093f, 1.57407407f, 1.56441718f,
	1.55487805f, 1.54545455f, 1.53614458f, 1.52694611f,
	1.51785714f, 1.50887574f, 1.50000000f, 1.49122807f,
	1.48255814f, 1.47398844f, 1.46551724f, 1.45714286f,
	1.44886364f, 1.44067797f, 1.43258427f, 1.42458101f,
	1.41666667f, 1.40883978f, 1.40109890f, 1.39344262f,
	1.38586957f, 1.37837838f, 1.37096774f, 1.36363636f,
	1.35638298f, 1.34920635f, 1.34210526f, 1.33507853f,
	1.32812500f, 1.32124352f, 1.31443299f, 1.30769231f,
	1.30102041f, 1.29441624f, 1.28787879f, 1.28140704f,
	1.27500000f, 1.26865672f, 1.26237624f, 1.25615764f,
	1.25000000f, 1.24390244f, 1.23786408f, 1.23188406f,
	1.22596154f, 1.22009569f, 1.21428571f, 1.20853081f,
	1.20283019f, 1.19718310f, 1.19158879f, 1.18604651f,
	1.18055556f, 1.17511521f, 1.16972477f, 1.16438356f,
	1.15909091f, 1.15384615f, 1.14864865f, 1.14349776f,
	1.13839286f, 1.13333333f, 1.12831858f, 1.12334802f,
	1.11842105f, 1.11353712f, 1.10869565f, 1.10389610f,
	1.09913793f, 1.09442060f, 1.08974359f, 1.08510638f,
	1.08050847f, 1.07594937f, 1.07142857f, 1.06694561f,
	1.06250000f, 1.05809129f, 1.05371901f, 1.04938272f,
	1.04508197f, 1.04081633f, 1.03658537f, 1.03238866f,
	1.02822581f, 1.02409639f, 1.02000000f, 1.01593625f,
	1.01190476f, 1.00790514f, 1.00393701f, 1.00000000f
};

/* *********************************************************** */

const mlib_u16 mlib_v_tab1[] = {
	0x0000, 0xff00, 0xff00, 0xff00,
	0x0000, 0xff00, 0xff00, 0xff00,
	0x0000, 0x7f80, 0x7f80, 0x7f80,
	0x0000, 0x5500, 0x5500, 0x5500,
	0x0000, 0x3fc0, 0x3fc0, 0x3fc0,
	0x0000, 0x3300, 0x3300, 0x3300,
	0x0000, 0x2a80, 0x2a80, 0x2a80,
	0x0000, 0x246e, 0x246e, 0x246e,
	0x0000, 0x1fe0, 0x1fe0, 0x1fe0,
	0x0000, 0x1c55, 0x1c55, 0x1c55,
	0x0000, 0x1980, 0x1980, 0x1980,
	0x0000, 0x172f, 0x172f, 0x172f,
	0x0000, 0x1540, 0x1540, 0x1540,
	0x0000, 0x139e, 0x139e, 0x139e,
	0x0000, 0x1237, 0x1237, 0x1237,
	0x0000, 0x1100, 0x1100, 0x1100,
	0x0000, 0x0ff0, 0x0ff0, 0x0ff0,
	0x0000, 0x0f00, 0x0f00, 0x0f00,
	0x0000, 0x0e2b, 0x0e2b, 0x0e2b,
	0x0000, 0x0d6c, 0x0d6c, 0x0d6c,
	0x0000, 0x0cc0, 0x0cc0, 0x0cc0,
	0x0000, 0x0c25, 0x0c25, 0x0c25,
	0x0000, 0x0b97, 0x0b97, 0x0b97,
	0x0000, 0x0b16, 0x0b16, 0x0b16,
	0x0000, 0x0aa0, 0x0aa0, 0x0aa0,
	0x0000, 0x0a33, 0x0a33, 0x0a33,
	0x0000, 0x09cf, 0x09cf, 0x09cf,
	0x0000, 0x0972, 0x0972, 0x0972,
	0x0000, 0x091b, 0x091b, 0x091b,
	0x0000, 0x08cb, 0x08cb, 0x08cb,
	0x0000, 0x0880, 0x0880, 0x0880,
	0x0000, 0x083a, 0x083a, 0x083a,
	0x0000, 0x07f8, 0x07f8, 0x07f8,
	0x0000, 0x07ba, 0x07ba, 0x07ba,
	0x0000, 0x0780, 0x0780, 0x0780,
	0x0000, 0x0749, 0x0749, 0x0749,
	0x0000, 0x0715, 0x0715, 0x0715,
	0x0000, 0x06e4, 0x06e4, 0x06e4,
	0x0000, 0x06b6, 0x06b6, 0x06b6,
	0x0000, 0x068a, 0x068a, 0x068a,
	0x0000, 0x0660, 0x0660, 0x0660,
	0x0000, 0x0638, 0x0638, 0x0638,
	0x0000, 0x0612, 0x0612, 0x0612,
	0x0000, 0x05ee, 0x05ee, 0x05ee,
	0x0000, 0x05cc, 0x05cc, 0x05cc,
	0x0000, 0x05ab, 0x05ab, 0x05ab,
	0x0000, 0x058b, 0x058b, 0x058b,
	0x0000, 0x056d, 0x056d, 0x056d,
	0x0000, 0x0550, 0x0550, 0x0550,
	0x0000, 0x0534, 0x0534, 0x0534,
	0x0000, 0x051a, 0x051a, 0x051a,
	0x0000, 0x0500, 0x0500, 0x0500,
	0x0000, 0x04e7, 0x04e7, 0x04e7,
	0x0000, 0x04d0, 0x04d0, 0x04d0,
	0x0000, 0x04b9, 0x04b9, 0x04b9,
	0x0000, 0x04a3, 0x04a3, 0x04a3,
	0x0000, 0x048e, 0x048e, 0x048e,
	0x0000, 0x0479, 0x0479, 0x0479,
	0x0000, 0x0466, 0x0466, 0x0466,
	0x0000, 0x0452, 0x0452, 0x0452,
	0x0000, 0x0440, 0x0440, 0x0440,
	0x0000, 0x042e, 0x042e, 0x042e,
	0x0000, 0x041d, 0x041d, 0x041d,
	0x0000, 0x040c, 0x040c, 0x040c,
	0x0000, 0x03fc, 0x03fc, 0x03fc,
	0x0000, 0x03ec, 0x03ec, 0x03ec,
	0x0000, 0x03dd, 0x03dd, 0x03dd,
	0x0000, 0x03ce, 0x03ce, 0x03ce,
	0x0000, 0x03c0, 0x03c0, 0x03c0,
	0x0000, 0x03b2, 0x03b2, 0x03b2,
	0x0000, 0x03a5, 0x03a5, 0x03a5,
	0x0000, 0x0397, 0x0397, 0x0397,
	0x0000, 0x038b, 0x038b, 0x038b,
	0x0000, 0x037e, 0x037e, 0x037e,
	0x0000, 0x0372, 0x0372, 0x0372,
	0x0000, 0x0366, 0x0366, 0x0366,
	0x0000, 0x035b, 0x035b, 0x035b,
	0x0000, 0x0350, 0x0350, 0x0350,
	0x0000, 0x0345, 0x0345, 0x0345,
	0x0000, 0x033a, 0x033a, 0x033a,
	0x0000, 0x0330, 0x0330, 0x0330,
	0x0000, 0x0326, 0x0326, 0x0326,
	0x0000, 0x031c, 0x031c, 0x031c,
	0x0000, 0x0313, 0x0313, 0x0313,
	0x0000, 0x0309, 0x0309, 0x0309,
	0x0000, 0x0300, 0x0300, 0x0300,
	0x0000, 0x02f7, 0x02f7, 0x02f7,
	0x0000, 0x02ee, 0x02ee, 0x02ee,
	0x0000, 0x02e6, 0x02e6, 0x02e6,
	0x0000, 0x02dd, 0x02dd, 0x02dd,
	0x0000, 0x02d5, 0x02d5, 0x02d5,
	0x0000, 0x02cd, 0x02cd, 0x02cd,
	0x0000, 0x02c6, 0x02c6, 0x02c6,
	0x0000, 0x02be, 0x02be, 0x02be,
	0x0000, 0x02b6, 0x02b6, 0x02b6,
	0x0000, 0x02af, 0x02af, 0x02af,
	0x0000, 0x02a8, 0x02a8, 0x02a8,
	0x0000, 0x02a1, 0x02a1, 0x02a1,
	0x0000, 0x029a, 0x029a, 0x029a,
	0x0000, 0x0293, 0x0293, 0x0293,
	0x0000, 0x028d, 0x028d, 0x028d,
	0x0000, 0x0286, 0x0286, 0x0286,
	0x0000, 0x0280, 0x0280, 0x0280,
	0x0000, 0x027a, 0x027a, 0x027a,
	0x0000, 0x0274, 0x0274, 0x0274,
	0x0000, 0x026e, 0x026e, 0x026e,
	0x0000, 0x0268, 0x0268, 0x0268,
	0x0000, 0x0262, 0x0262, 0x0262,
	0x0000, 0x025c, 0x025c, 0x025c,
	0x0000, 0x0257, 0x0257, 0x0257,
	0x0000, 0x0251, 0x0251, 0x0251,
	0x0000, 0x024c, 0x024c, 0x024c,
	0x0000, 0x0247, 0x0247, 0x0247,
	0x0000, 0x0242, 0x0242, 0x0242,
	0x0000, 0x023d, 0x023d, 0x023d,
	0x0000, 0x0238, 0x0238, 0x0238,
	0x0000, 0x0233, 0x0233, 0x0233,
	0x0000, 0x022e, 0x022e, 0x022e,
	0x0000, 0x0229, 0x0229, 0x0229,
	0x0000, 0x0225, 0x0225, 0x0225,
	0x0000, 0x0220, 0x0220, 0x0220,
	0x0000, 0x021c, 0x021c, 0x021c,
	0x0000, 0x0217, 0x0217, 0x0217,
	0x0000, 0x0213, 0x0213, 0x0213,
	0x0000, 0x020e, 0x020e, 0x020e,
	0x0000, 0x020a, 0x020a, 0x020a,
	0x0000, 0x0206, 0x0206, 0x0206,
	0x0000, 0x0202, 0x0202, 0x0202,
	0x0000, 0x01fe, 0x01fe, 0x01fe,
	0x0000, 0x01fa, 0x01fa, 0x01fa,
	0x0000, 0x01f6, 0x01f6, 0x01f6,
	0x0000, 0x01f2, 0x01f2, 0x01f2,
	0x0000, 0x01ef, 0x01ef, 0x01ef,
	0x0000, 0x01eb, 0x01eb, 0x01eb,
	0x0000, 0x01e7, 0x01e7, 0x01e7,
	0x0000, 0x01e4, 0x01e4, 0x01e4,
	0x0000, 0x01e0, 0x01e0, 0x01e0,
	0x0000, 0x01dc, 0x01dc, 0x01dc,
	0x0000, 0x01d9, 0x01d9, 0x01d9,
	0x0000, 0x01d6, 0x01d6, 0x01d6,
	0x0000, 0x01d2, 0x01d2, 0x01d2,
	0x0000, 0x01cf, 0x01cf, 0x01cf,
	0x0000, 0x01cc, 0x01cc, 0x01cc,
	0x0000, 0x01c9, 0x01c9, 0x01c9,
	0x0000, 0x01c5, 0x01c5, 0x01c5,
	0x0000, 0x01c2, 0x01c2, 0x01c2,
	0x0000, 0x01bf, 0x01bf, 0x01bf,
	0x0000, 0x01bc, 0x01bc, 0x01bc,
	0x0000, 0x01b9, 0x01b9, 0x01b9,
	0x0000, 0x01b6, 0x01b6, 0x01b6,
	0x0000, 0x01b3, 0x01b3, 0x01b3,
	0x0000, 0x01b0, 0x01b0, 0x01b0,
	0x0000, 0x01ad, 0x01ad, 0x01ad,
	0x0000, 0x01ab, 0x01ab, 0x01ab,
	0x0000, 0x01a8, 0x01a8, 0x01a8,
	0x0000, 0x01a5, 0x01a5, 0x01a5,
	0x0000, 0x01a2, 0x01a2, 0x01a2,
	0x0000, 0x01a0, 0x01a0, 0x01a0,
	0x0000, 0x019d, 0x019d, 0x019d,
	0x0000, 0x019b, 0x019b, 0x019b,
	0x0000, 0x0198, 0x0198, 0x0198,
	0x0000, 0x0195, 0x0195, 0x0195,
	0x0000, 0x0193, 0x0193, 0x0193,
	0x0000, 0x0190, 0x0190, 0x0190,
	0x0000, 0x018e, 0x018e, 0x018e,
	0x0000, 0x018c, 0x018c, 0x018c,
	0x0000, 0x0189, 0x0189, 0x0189,
	0x0000, 0x0187, 0x0187, 0x0187,
	0x0000, 0x0185, 0x0185, 0x0185,
	0x0000, 0x0182, 0x0182, 0x0182,
	0x0000, 0x0180, 0x0180, 0x0180,
	0x0000, 0x017e, 0x017e, 0x017e,
	0x0000, 0x017c, 0x017c, 0x017c,
	0x0000, 0x0179, 0x0179, 0x0179,
	0x0000, 0x0177, 0x0177, 0x0177,
	0x0000, 0x0175, 0x0175, 0x0175,
	0x0000, 0x0173, 0x0173, 0x0173,
	0x0000, 0x0171, 0x0171, 0x0171,
	0x0000, 0x016f, 0x016f, 0x016f,
	0x0000, 0x016d, 0x016d, 0x016d,
	0x0000, 0x016b, 0x016b, 0x016b,
	0x0000, 0x0169, 0x0169, 0x0169,
	0x0000, 0x0167, 0x0167, 0x0167,
	0x0000, 0x0165, 0x0165, 0x0165,
	0x0000, 0x0163, 0x0163, 0x0163,
	0x0000, 0x0161, 0x0161, 0x0161,
	0x0000, 0x015f, 0x015f, 0x015f,
	0x0000, 0x015d, 0x015d, 0x015d,
	0x0000, 0x015b, 0x015b, 0x015b,
	0x0000, 0x0159, 0x0159, 0x0159,
	0x0000, 0x0158, 0x0158, 0x0158,
	0x0000, 0x0156, 0x0156, 0x0156,
	0x0000, 0x0154, 0x0154, 0x0154,
	0x0000, 0x0152, 0x0152, 0x0152,
	0x0000, 0x0150, 0x0150, 0x0150,
	0x0000, 0x014f, 0x014f, 0x014f,
	0x0000, 0x014d, 0x014d, 0x014d,
	0x0000, 0x014b, 0x014b, 0x014b,
	0x0000, 0x014a, 0x014a, 0x014a,
	0x0000, 0x0148, 0x0148, 0x0148,
	0x0000, 0x0146, 0x0146, 0x0146,
	0x0000, 0x0145, 0x0145, 0x0145,
	0x0000, 0x0143, 0x0143, 0x0143,
	0x0000, 0x0142, 0x0142, 0x0142,
	0x0000, 0x0140, 0x0140, 0x0140,
	0x0000, 0x013e, 0x013e, 0x013e,
	0x0000, 0x013d, 0x013d, 0x013d,
	0x0000, 0x013b, 0x013b, 0x013b,
	0x0000, 0x013a, 0x013a, 0x013a,
	0x0000, 0x0138, 0x0138, 0x0138,
	0x0000, 0x0137, 0x0137, 0x0137,
	0x0000, 0x0135, 0x0135, 0x0135,
	0x0000, 0x0134, 0x0134, 0x0134,
	0x0000, 0x0132, 0x0132, 0x0132,
	0x0000, 0x0131, 0x0131, 0x0131,
	0x0000, 0x0130, 0x0130, 0x0130,
	0x0000, 0x012e, 0x012e, 0x012e,
	0x0000, 0x012d, 0x012d, 0x012d,
	0x0000, 0x012b, 0x012b, 0x012b,
	0x0000, 0x012a, 0x012a, 0x012a,
	0x0000, 0x0129, 0x0129, 0x0129,
	0x0000, 0x0127, 0x0127, 0x0127,
	0x0000, 0x0126, 0x0126, 0x0126,
	0x0000, 0x0125, 0x0125, 0x0125,
	0x0000, 0x0123, 0x0123, 0x0123,
	0x0000, 0x0122, 0x0122, 0x0122,
	0x0000, 0x0121, 0x0121, 0x0121,
	0x0000, 0x0120, 0x0120, 0x0120,
	0x0000, 0x011e, 0x011e, 0x011e,
	0x0000, 0x011d, 0x011d, 0x011d,
	0x0000, 0x011c, 0x011c, 0x011c,
	0x0000, 0x011b, 0x011b, 0x011b,
	0x0000, 0x0119, 0x0119, 0x0119,
	0x0000, 0x0118, 0x0118, 0x0118,
	0x0000, 0x0117, 0x0117, 0x0117,
	0x0000, 0x0116, 0x0116, 0x0116,
	0x0000, 0x0115, 0x0115, 0x0115,
	0x0000, 0x0113, 0x0113, 0x0113,
	0x0000, 0x0112, 0x0112, 0x0112,
	0x0000, 0x0111, 0x0111, 0x0111,
	0x0000, 0x0110, 0x0110, 0x0110,
	0x0000, 0x010f, 0x010f, 0x010f,
	0x0000, 0x010e, 0x010e, 0x010e,
	0x0000, 0x010d, 0x010d, 0x010d,
	0x0000, 0x010c, 0x010c, 0x010c,
	0x0000, 0x010a, 0x010a, 0x010a,
	0x0000, 0x0109, 0x0109, 0x0109,
	0x0000, 0x0108, 0x0108, 0x0108,
	0x0000, 0x0107, 0x0107, 0x0107,
	0x0000, 0x0106, 0x0106, 0x0106,
	0x0000, 0x0105, 0x0105, 0x0105,
	0x0000, 0x0104, 0x0104, 0x0104,
	0x0000, 0x0103, 0x0103, 0x0103,
	0x0000, 0x0102, 0x0102, 0x0102,
	0x0000, 0x0101, 0x0101, 0x0101,
	0x0000, 0x0100, 0x0100, 0x0100,
};

/* *********************************************************** */

const mlib_u16 mlib_v_tab2[] = {
	0xff00, 0x0000, 0xff00, 0xff00,
	0xff00, 0x0000, 0xff00, 0xff00,
	0x7f80, 0x0000, 0x7f80, 0x7f80,
	0x5500, 0x0000, 0x5500, 0x5500,
	0x3fc0, 0x0000, 0x3fc0, 0x3fc0,
	0x3300, 0x0000, 0x3300, 0x3300,
	0x2a80, 0x0000, 0x2a80, 0x2a80,
	0x246e, 0x0000, 0x246e, 0x246e,
	0x1fe0, 0x0000, 0x1fe0, 0x1fe0,
	0x1c55, 0x0000, 0x1c55, 0x1c55,
	0x1980, 0x0000, 0x1980, 0x1980,
	0x172f, 0x0000, 0x172f, 0x172f,
	0x1540, 0x0000, 0x1540, 0x1540,
	0x139e, 0x0000, 0x139e, 0x139e,
	0x1237, 0x0000, 0x1237, 0x1237,
	0x1100, 0x0000, 0x1100, 0x1100,
	0x0ff0, 0x0000, 0x0ff0, 0x0ff0,
	0x0f00, 0x0000, 0x0f00, 0x0f00,
	0x0e2b, 0x0000, 0x0e2b, 0x0e2b,
	0x0d6c, 0x0000, 0x0d6c, 0x0d6c,
	0x0cc0, 0x0000, 0x0cc0, 0x0cc0,
	0x0c25, 0x0000, 0x0c25, 0x0c25,
	0x0b97, 0x0000, 0x0b97, 0x0b97,
	0x0b16, 0x0000, 0x0b16, 0x0b16,
	0x0aa0, 0x0000, 0x0aa0, 0x0aa0,
	0x0a33, 0x0000, 0x0a33, 0x0a33,
	0x09cf, 0x0000, 0x09cf, 0x09cf,
	0x0972, 0x0000, 0x0972, 0x0972,
	0x091b, 0x0000, 0x091b, 0x091b,
	0x08cb, 0x0000, 0x08cb, 0x08cb,
	0x0880, 0x0000, 0x0880, 0x0880,
	0x083a, 0x0000, 0x083a, 0x083a,
	0x07f8, 0x0000, 0x07f8, 0x07f8,
	0x07ba, 0x0000, 0x07ba, 0x07ba,
	0x0780, 0x0000, 0x0780, 0x0780,
	0x0749, 0x0000, 0x0749, 0x0749,
	0x0715, 0x0000, 0x0715, 0x0715,
	0x06e4, 0x0000, 0x06e4, 0x06e4,
	0x06b6, 0x0000, 0x06b6, 0x06b6,
	0x068a, 0x0000, 0x068a, 0x068a,
	0x0660, 0x0000, 0x0660, 0x0660,
	0x0638, 0x0000, 0x0638, 0x0638,
	0x0612, 0x0000, 0x0612, 0x0612,
	0x05ee, 0x0000, 0x05ee, 0x05ee,
	0x05cc, 0x0000, 0x05cc, 0x05cc,
	0x05ab, 0x0000, 0x05ab, 0x05ab,
	0x058b, 0x0000, 0x058b, 0x058b,
	0x056d, 0x0000, 0x056d, 0x056d,
	0x0550, 0x0000, 0x0550, 0x0550,
	0x0534, 0x0000, 0x0534, 0x0534,
	0x051a, 0x0000, 0x051a, 0x051a,
	0x0500, 0x0000, 0x0500, 0x0500,
	0x04e7, 0x0000, 0x04e7, 0x04e7,
	0x04d0, 0x0000, 0x04d0, 0x04d0,
	0x04b9, 0x0000, 0x04b9, 0x04b9,
	0x04a3, 0x0000, 0x04a3, 0x04a3,
	0x048e, 0x0000, 0x048e, 0x048e,
	0x0479, 0x0000, 0x0479, 0x0479,
	0x0466, 0x0000, 0x0466, 0x0466,
	0x0452, 0x0000, 0x0452, 0x0452,
	0x0440, 0x0000, 0x0440, 0x0440,
	0x042e, 0x0000, 0x042e, 0x042e,
	0x041d, 0x0000, 0x041d, 0x041d,
	0x040c, 0x0000, 0x040c, 0x040c,
	0x03fc, 0x0000, 0x03fc, 0x03fc,
	0x03ec, 0x0000, 0x03ec, 0x03ec,
	0x03dd, 0x0000, 0x03dd, 0x03dd,
	0x03ce, 0x0000, 0x03ce, 0x03ce,
	0x03c0, 0x0000, 0x03c0, 0x03c0,
	0x03b2, 0x0000, 0x03b2, 0x03b2,
	0x03a5, 0x0000, 0x03a5, 0x03a5,
	0x0397, 0x0000, 0x0397, 0x0397,
	0x038b, 0x0000, 0x038b, 0x038b,
	0x037e, 0x0000, 0x037e, 0x037e,
	0x0372, 0x0000, 0x0372, 0x0372,
	0x0366, 0x0000, 0x0366, 0x0366,
	0x035b, 0x0000, 0x035b, 0x035b,
	0x0350, 0x0000, 0x0350, 0x0350,
	0x0345, 0x0000, 0x0345, 0x0345,
	0x033a, 0x0000, 0x033a, 0x033a,
	0x0330, 0x0000, 0x0330, 0x0330,
	0x0326, 0x0000, 0x0326, 0x0326,
	0x031c, 0x0000, 0x031c, 0x031c,
	0x0313, 0x0000, 0x0313, 0x0313,
	0x0309, 0x0000, 0x0309, 0x0309,
	0x0300, 0x0000, 0x0300, 0x0300,
	0x02f7, 0x0000, 0x02f7, 0x02f7,
	0x02ee, 0x0000, 0x02ee, 0x02ee,
	0x02e6, 0x0000, 0x02e6, 0x02e6,
	0x02dd, 0x0000, 0x02dd, 0x02dd,
	0x02d5, 0x0000, 0x02d5, 0x02d5,
	0x02cd, 0x0000, 0x02cd, 0x02cd,
	0x02c6, 0x0000, 0x02c6, 0x02c6,
	0x02be, 0x0000, 0x02be, 0x02be,
	0x02b6, 0x0000, 0x02b6, 0x02b6,
	0x02af, 0x0000, 0x02af, 0x02af,
	0x02a8, 0x0000, 0x02a8, 0x02a8,
	0x02a1, 0x0000, 0x02a1, 0x02a1,
	0x029a, 0x0000, 0x029a, 0x029a,
	0x0293, 0x0000, 0x0293, 0x0293,
	0x028d, 0x0000, 0x028d, 0x028d,
	0x0286, 0x0000, 0x0286, 0x0286,
	0x0280, 0x0000, 0x0280, 0x0280,
	0x027a, 0x0000, 0x027a, 0x027a,
	0x0274, 0x0000, 0x0274, 0x0274,
	0x026e, 0x0000, 0x026e, 0x026e,
	0x0268, 0x0000, 0x0268, 0x0268,
	0x0262, 0x0000, 0x0262, 0x0262,
	0x025c, 0x0000, 0x025c, 0x025c,
	0x0257, 0x0000, 0x0257, 0x0257,
	0x0251, 0x0000, 0x0251, 0x0251,
	0x024c, 0x0000, 0x024c, 0x024c,
	0x0247, 0x0000, 0x0247, 0x0247,
	0x0242, 0x0000, 0x0242, 0x0242,
	0x023d, 0x0000, 0x023d, 0x023d,
	0x0238, 0x0000, 0x0238, 0x0238,
	0x0233, 0x0000, 0x0233, 0x0233,
	0x022e, 0x0000, 0x022e, 0x022e,
	0x0229, 0x0000, 0x0229, 0x0229,
	0x0225, 0x0000, 0x0225, 0x0225,
	0x0220, 0x0000, 0x0220, 0x0220,
	0x021c, 0x0000, 0x021c, 0x021c,
	0x0217, 0x0000, 0x0217, 0x0217,
	0x0213, 0x0000, 0x0213, 0x0213,
	0x020e, 0x0000, 0x020e, 0x020e,
	0x020a, 0x0000, 0x020a, 0x020a,
	0x0206, 0x0000, 0x0206, 0x0206,
	0x0202, 0x0000, 0x0202, 0x0202,
	0x01fe, 0x0000, 0x01fe, 0x01fe,
	0x01fa, 0x0000, 0x01fa, 0x01fa,
	0x01f6, 0x0000, 0x01f6, 0x01f6,
	0x01f2, 0x0000, 0x01f2, 0x01f2,
	0x01ef, 0x0000, 0x01ef, 0x01ef,
	0x01eb, 0x0000, 0x01eb, 0x01eb,
	0x01e7, 0x0000, 0x01e7, 0x01e7,
	0x01e4, 0x0000, 0x01e4, 0x01e4,
	0x01e0, 0x0000, 0x01e0, 0x01e0,
	0x01dc, 0x0000, 0x01dc, 0x01dc,
	0x01d9, 0x0000, 0x01d9, 0x01d9,
	0x01d6, 0x0000, 0x01d6, 0x01d6,
	0x01d2, 0x0000, 0x01d2, 0x01d2,
	0x01cf, 0x0000, 0x01cf, 0x01cf,
	0x01cc, 0x0000, 0x01cc, 0x01cc,
	0x01c9, 0x0000, 0x01c9, 0x01c9,
	0x01c5, 0x0000, 0x01c5, 0x01c5,
	0x01c2, 0x0000, 0x01c2, 0x01c2,
	0x01bf, 0x0000, 0x01bf, 0x01bf,
	0x01bc, 0x0000, 0x01bc, 0x01bc,
	0x01b9, 0x0000, 0x01b9, 0x01b9,
	0x01b6, 0x0000, 0x01b6, 0x01b6,
	0x01b3, 0x0000, 0x01b3, 0x01b3,
	0x01b0, 0x0000, 0x01b0, 0x01b0,
	0x01ad, 0x0000, 0x01ad, 0x01ad,
	0x01ab, 0x0000, 0x01ab, 0x01ab,
	0x01a8, 0x0000, 0x01a8, 0x01a8,
	0x01a5, 0x0000, 0x01a5, 0x01a5,
	0x01a2, 0x0000, 0x01a2, 0x01a2,
	0x01a0, 0x0000, 0x01a0, 0x01a0,
	0x019d, 0x0000, 0x019d, 0x019d,
	0x019b, 0x0000, 0x019b, 0x019b,
	0x0198, 0x0000, 0x0198, 0x0198,
	0x0195, 0x0000, 0x0195, 0x0195,
	0x0193, 0x0000, 0x0193, 0x0193,
	0x0190, 0x0000, 0x0190, 0x0190,
	0x018e, 0x0000, 0x018e, 0x018e,
	0x018c, 0x0000, 0x018c, 0x018c,
	0x0189, 0x0000, 0x0189, 0x0189,
	0x0187, 0x0000, 0x0187, 0x0187,
	0x0185, 0x0000, 0x0185, 0x0185,
	0x0182, 0x0000, 0x0182, 0x0182,
	0x0180, 0x0000, 0x0180, 0x0180,
	0x017e, 0x0000, 0x017e, 0x017e,
	0x017c, 0x0000, 0x017c, 0x017c,
	0x0179, 0x0000, 0x0179, 0x0179,
	0x0177, 0x0000, 0x0177, 0x0177,
	0x0175, 0x0000, 0x0175, 0x0175,
	0x0173, 0x0000, 0x0173, 0x0173,
	0x0171, 0x0000, 0x0171, 0x0171,
	0x016f, 0x0000, 0x016f, 0x016f,
	0x016d, 0x0000, 0x016d, 0x016d,
	0x016b, 0x0000, 0x016b, 0x016b,
	0x0169, 0x0000, 0x0169, 0x0169,
	0x0167, 0x0000, 0x0167, 0x0167,
	0x0165, 0x0000, 0x0165, 0x0165,
	0x0163, 0x0000, 0x0163, 0x0163,
	0x0161, 0x0000, 0x0161, 0x0161,
	0x015f, 0x0000, 0x015f, 0x015f,
	0x015d, 0x0000, 0x015d, 0x015d,
	0x015b, 0x0000, 0x015b, 0x015b,
	0x0159, 0x0000, 0x0159, 0x0159,
	0x0158, 0x0000, 0x0158, 0x0158,
	0x0156, 0x0000, 0x0156, 0x0156,
	0x0154, 0x0000, 0x0154, 0x0154,
	0x0152, 0x0000, 0x0152, 0x0152,
	0x0150, 0x0000, 0x0150, 0x0150,
	0x014f, 0x0000, 0x014f, 0x014f,
	0x014d, 0x0000, 0x014d, 0x014d,
	0x014b, 0x0000, 0x014b, 0x014b,
	0x014a, 0x0000, 0x014a, 0x014a,
	0x0148, 0x0000, 0x0148, 0x0148,
	0x0146, 0x0000, 0x0146, 0x0146,
	0x0145, 0x0000, 0x0145, 0x0145,
	0x0143, 0x0000, 0x0143, 0x0143,
	0x0142, 0x0000, 0x0142, 0x0142,
	0x0140, 0x0000, 0x0140, 0x0140,
	0x013e, 0x0000, 0x013e, 0x013e,
	0x013d, 0x0000, 0x013d, 0x013d,
	0x013b, 0x0000, 0x013b, 0x013b,
	0x013a, 0x0000, 0x013a, 0x013a,
	0x0138, 0x0000, 0x0138, 0x0138,
	0x0137, 0x0000, 0x0137, 0x0137,
	0x0135, 0x0000, 0x0135, 0x0135,
	0x0134, 0x0000, 0x0134, 0x0134,
	0x0132, 0x0000, 0x0132, 0x0132,
	0x0131, 0x0000, 0x0131, 0x0131,
	0x0130, 0x0000, 0x0130, 0x0130,
	0x012e, 0x0000, 0x012e, 0x012e,
	0x012d, 0x0000, 0x012d, 0x012d,
	0x012b, 0x0000, 0x012b, 0x012b,
	0x012a, 0x0000, 0x012a, 0x012a,
	0x0129, 0x0000, 0x0129, 0x0129,
	0x0127, 0x0000, 0x0127, 0x0127,
	0x0126, 0x0000, 0x0126, 0x0126,
	0x0125, 0x0000, 0x0125, 0x0125,
	0x0123, 0x0000, 0x0123, 0x0123,
	0x0122, 0x0000, 0x0122, 0x0122,
	0x0121, 0x0000, 0x0121, 0x0121,
	0x0120, 0x0000, 0x0120, 0x0120,
	0x011e, 0x0000, 0x011e, 0x011e,
	0x011d, 0x0000, 0x011d, 0x011d,
	0x011c, 0x0000, 0x011c, 0x011c,
	0x011b, 0x0000, 0x011b, 0x011b,
	0x0119, 0x0000, 0x0119, 0x0119,
	0x0118, 0x0000, 0x0118, 0x0118,
	0x0117, 0x0000, 0x0117, 0x0117,
	0x0116, 0x0000, 0x0116, 0x0116,
	0x0115, 0x0000, 0x0115, 0x0115,
	0x0113, 0x0000, 0x0113, 0x0113,
	0x0112, 0x0000, 0x0112, 0x0112,
	0x0111, 0x0000, 0x0111, 0x0111,
	0x0110, 0x0000, 0x0110, 0x0110,
	0x010f, 0x0000, 0x010f, 0x010f,
	0x010e, 0x0000, 0x010e, 0x010e,
	0x010d, 0x0000, 0x010d, 0x010d,
	0x010c, 0x0000, 0x010c, 0x010c,
	0x010a, 0x0000, 0x010a, 0x010a,
	0x0109, 0x0000, 0x0109, 0x0109,
	0x0108, 0x0000, 0x0108, 0x0108,
	0x0107, 0x0000, 0x0107, 0x0107,
	0x0106, 0x0000, 0x0106, 0x0106,
	0x0105, 0x0000, 0x0105, 0x0105,
	0x0104, 0x0000, 0x0104, 0x0104,
	0x0103, 0x0000, 0x0103, 0x0103,
	0x0102, 0x0000, 0x0102, 0x0102,
	0x0101, 0x0000, 0x0101, 0x0101,
	0x0100, 0x0000, 0x0100, 0x0100,
};

/* *********************************************************** */

const mlib_u16 mlib_v_tab3[] = {
	0xff00, 0xff00, 0x0000, 0xff00,
	0xff00, 0xff00, 0x0000, 0xff00,
	0x7f80, 0x7f80, 0x0000, 0x7f80,
	0x5500, 0x5500, 0x0000, 0x5500,
	0x3fc0, 0x3fc0, 0x0000, 0x3fc0,
	0x3300, 0x3300, 0x0000, 0x3300,
	0x2a80, 0x2a80, 0x0000, 0x2a80,
	0x246e, 0x246e, 0x0000, 0x246e,
	0x1fe0, 0x1fe0, 0x0000, 0x1fe0,
	0x1c55, 0x1c55, 0x0000, 0x1c55,
	0x1980, 0x1980, 0x0000, 0x1980,
	0x172f, 0x172f, 0x0000, 0x172f,
	0x1540, 0x1540, 0x0000, 0x1540,
	0x139e, 0x139e, 0x0000, 0x139e,
	0x1237, 0x1237, 0x0000, 0x1237,
	0x1100, 0x1100, 0x0000, 0x1100,
	0x0ff0, 0x0ff0, 0x0000, 0x0ff0,
	0x0f00, 0x0f00, 0x0000, 0x0f00,
	0x0e2b, 0x0e2b, 0x0000, 0x0e2b,
	0x0d6c, 0x0d6c, 0x0000, 0x0d6c,
	0x0cc0, 0x0cc0, 0x0000, 0x0cc0,
	0x0c25, 0x0c25, 0x0000, 0x0c25,
	0x0b97, 0x0b97, 0x0000, 0x0b97,
	0x0b16, 0x0b16, 0x0000, 0x0b16,
	0x0aa0, 0x0aa0, 0x0000, 0x0aa0,
	0x0a33, 0x0a33, 0x0000, 0x0a33,
	0x09cf, 0x09cf, 0x0000, 0x09cf,
	0x0972, 0x0972, 0x0000, 0x0972,
	0x091b, 0x091b, 0x0000, 0x091b,
	0x08cb, 0x08cb, 0x0000, 0x08cb,
	0x0880, 0x0880, 0x0000, 0x0880,
	0x083a, 0x083a, 0x0000, 0x083a,
	0x07f8, 0x07f8, 0x0000, 0x07f8,
	0x07ba, 0x07ba, 0x0000, 0x07ba,
	0x0780, 0x0780, 0x0000, 0x0780,
	0x0749, 0x0749, 0x0000, 0x0749,
	0x0715, 0x0715, 0x0000, 0x0715,
	0x06e4, 0x06e4, 0x0000, 0x06e4,
	0x06b6, 0x06b6, 0x0000, 0x06b6,
	0x068a, 0x068a, 0x0000, 0x068a,
	0x0660, 0x0660, 0x0000, 0x0660,
	0x0638, 0x0638, 0x0000, 0x0638,
	0x0612, 0x0612, 0x0000, 0x0612,
	0x05ee, 0x05ee, 0x0000, 0x05ee,
	0x05cc, 0x05cc, 0x0000, 0x05cc,
	0x05ab, 0x05ab, 0x0000, 0x05ab,
	0x058b, 0x058b, 0x0000, 0x058b,
	0x056d, 0x056d, 0x0000, 0x056d,
	0x0550, 0x0550, 0x0000, 0x0550,
	0x0534, 0x0534, 0x0000, 0x0534,
	0x051a, 0x051a, 0x0000, 0x051a,
	0x0500, 0x0500, 0x0000, 0x0500,
	0x04e7, 0x04e7, 0x0000, 0x04e7,
	0x04d0, 0x04d0, 0x0000, 0x04d0,
	0x04b9, 0x04b9, 0x0000, 0x04b9,
	0x04a3, 0x04a3, 0x0000, 0x04a3,
	0x048e, 0x048e, 0x0000, 0x048e,
	0x0479, 0x0479, 0x0000, 0x0479,
	0x0466, 0x0466, 0x0000, 0x0466,
	0x0452, 0x0452, 0x0000, 0x0452,
	0x0440, 0x0440, 0x0000, 0x0440,
	0x042e, 0x042e, 0x0000, 0x042e,
	0x041d, 0x041d, 0x0000, 0x041d,
	0x040c, 0x040c, 0x0000, 0x040c,
	0x03fc, 0x03fc, 0x0000, 0x03fc,
	0x03ec, 0x03ec, 0x0000, 0x03ec,
	0x03dd, 0x03dd, 0x0000, 0x03dd,
	0x03ce, 0x03ce, 0x0000, 0x03ce,
	0x03c0, 0x03c0, 0x0000, 0x03c0,
	0x03b2, 0x03b2, 0x0000, 0x03b2,
	0x03a5, 0x03a5, 0x0000, 0x03a5,
	0x0397, 0x0397, 0x0000, 0x0397,
	0x038b, 0x038b, 0x0000, 0x038b,
	0x037e, 0x037e, 0x0000, 0x037e,
	0x0372, 0x0372, 0x0000, 0x0372,
	0x0366, 0x0366, 0x0000, 0x0366,
	0x035b, 0x035b, 0x0000, 0x035b,
	0x0350, 0x0350, 0x0000, 0x0350,
	0x0345, 0x0345, 0x0000, 0x0345,
	0x033a, 0x033a, 0x0000, 0x033a,
	0x0330, 0x0330, 0x0000, 0x0330,
	0x0326, 0x0326, 0x0000, 0x0326,
	0x031c, 0x031c, 0x0000, 0x031c,
	0x0313, 0x0313, 0x0000, 0x0313,
	0x0309, 0x0309, 0x0000, 0x0309,
	0x0300, 0x0300, 0x0000, 0x0300,
	0x02f7, 0x02f7, 0x0000, 0x02f7,
	0x02ee, 0x02ee, 0x0000, 0x02ee,
	0x02e6, 0x02e6, 0x0000, 0x02e6,
	0x02dd, 0x02dd, 0x0000, 0x02dd,
	0x02d5, 0x02d5, 0x0000, 0x02d5,
	0x02cd, 0x02cd, 0x0000, 0x02cd,
	0x02c6, 0x02c6, 0x0000, 0x02c6,
	0x02be, 0x02be, 0x0000, 0x02be,
	0x02b6, 0x02b6, 0x0000, 0x02b6,
	0x02af, 0x02af, 0x0000, 0x02af,
	0x02a8, 0x02a8, 0x0000, 0x02a8,
	0x02a1, 0x02a1, 0x0000, 0x02a1,
	0x029a, 0x029a, 0x0000, 0x029a,
	0x0293, 0x0293, 0x0000, 0x0293,
	0x028d, 0x028d, 0x0000, 0x028d,
	0x0286, 0x0286, 0x0000, 0x0286,
	0x0280, 0x0280, 0x0000, 0x0280,
	0x027a, 0x027a, 0x0000, 0x027a,
	0x0274, 0x0274, 0x0000, 0x0274,
	0x026e, 0x026e, 0x0000, 0x026e,
	0x0268, 0x0268, 0x0000, 0x0268,
	0x0262, 0x0262, 0x0000, 0x0262,
	0x025c, 0x025c, 0x0000, 0x025c,
	0x0257, 0x0257, 0x0000, 0x0257,
	0x0251, 0x0251, 0x0000, 0x0251,
	0x024c, 0x024c, 0x0000, 0x024c,
	0x0247, 0x0247, 0x0000, 0x0247,
	0x0242, 0x0242, 0x0000, 0x0242,
	0x023d, 0x023d, 0x0000, 0x023d,
	0x0238, 0x0238, 0x0000, 0x0238,
	0x0233, 0x0233, 0x0000, 0x0233,
	0x022e, 0x022e, 0x0000, 0x022e,
	0x0229, 0x0229, 0x0000, 0x0229,
	0x0225, 0x0225, 0x0000, 0x0225,
	0x0220, 0x0220, 0x0000, 0x0220,
	0x021c, 0x021c, 0x0000, 0x021c,
	0x0217, 0x0217, 0x0000, 0x0217,
	0x0213, 0x0213, 0x0000, 0x0213,
	0x020e, 0x020e, 0x0000, 0x020e,
	0x020a, 0x020a, 0x0000, 0x020a,
	0x0206, 0x0206, 0x0000, 0x0206,
	0x0202, 0x0202, 0x0000, 0x0202,
	0x01fe, 0x01fe, 0x0000, 0x01fe,
	0x01fa, 0x01fa, 0x0000, 0x01fa,
	0x01f6, 0x01f6, 0x0000, 0x01f6,
	0x01f2, 0x01f2, 0x0000, 0x01f2,
	0x01ef, 0x01ef, 0x0000, 0x01ef,
	0x01eb, 0x01eb, 0x0000, 0x01eb,
	0x01e7, 0x01e7, 0x0000, 0x01e7,
	0x01e4, 0x01e4, 0x0000, 0x01e4,
	0x01e0, 0x01e0, 0x0000, 0x01e0,
	0x01dc, 0x01dc, 0x0000, 0x01dc,
	0x01d9, 0x01d9, 0x0000, 0x01d9,
	0x01d6, 0x01d6, 0x0000, 0x01d6,
	0x01d2, 0x01d2, 0x0000, 0x01d2,
	0x01cf, 0x01cf, 0x0000, 0x01cf,
	0x01cc, 0x01cc, 0x0000, 0x01cc,
	0x01c9, 0x01c9, 0x0000, 0x01c9,
	0x01c5, 0x01c5, 0x0000, 0x01c5,
	0x01c2, 0x01c2, 0x0000, 0x01c2,
	0x01bf, 0x01bf, 0x0000, 0x01bf,
	0x01bc, 0x01bc, 0x0000, 0x01bc,
	0x01b9, 0x01b9, 0x0000, 0x01b9,
	0x01b6, 0x01b6, 0x0000, 0x01b6,
	0x01b3, 0x01b3, 0x0000, 0x01b3,
	0x01b0, 0x01b0, 0x0000, 0x01b0,
	0x01ad, 0x01ad, 0x0000, 0x01ad,
	0x01ab, 0x01ab, 0x0000, 0x01ab,
	0x01a8, 0x01a8, 0x0000, 0x01a8,
	0x01a5, 0x01a5, 0x0000, 0x01a5,
	0x01a2, 0x01a2, 0x0000, 0x01a2,
	0x01a0, 0x01a0, 0x0000, 0x01a0,
	0x019d, 0x019d, 0x0000, 0x019d,
	0x019b, 0x019b, 0x0000, 0x019b,
	0x0198, 0x0198, 0x0000, 0x0198,
	0x0195, 0x0195, 0x0000, 0x0195,
	0x0193, 0x0193, 0x0000, 0x0193,
	0x0190, 0x0190, 0x0000, 0x0190,
	0x018e, 0x018e, 0x0000, 0x018e,
	0x018c, 0x018c, 0x0000, 0x018c,
	0x0189, 0x0189, 0x0000, 0x0189,
	0x0187, 0x0187, 0x0000, 0x0187,
	0x0185, 0x0185, 0x0000, 0x0185,
	0x0182, 0x0182, 0x0000, 0x0182,
	0x0180, 0x0180, 0x0000, 0x0180,
	0x017e, 0x017e, 0x0000, 0x017e,
	0x017c, 0x017c, 0x0000, 0x017c,
	0x0179, 0x0179, 0x0000, 0x0179,
	0x0177, 0x0177, 0x0000, 0x0177,
	0x0175, 0x0175, 0x0000, 0x0175,
	0x0173, 0x0173, 0x0000, 0x0173,
	0x0171, 0x0171, 0x0000, 0x0171,
	0x016f, 0x016f, 0x0000, 0x016f,
	0x016d, 0x016d, 0x0000, 0x016d,
	0x016b, 0x016b, 0x0000, 0x016b,
	0x0169, 0x0169, 0x0000, 0x0169,
	0x0167, 0x0167, 0x0000, 0x0167,
	0x0165, 0x0165, 0x0000, 0x0165,
	0x0163, 0x0163, 0x0000, 0x0163,
	0x0161, 0x0161, 0x0000, 0x0161,
	0x015f, 0x015f, 0x0000, 0x015f,
	0x015d, 0x015d, 0x0000, 0x015d,
	0x015b, 0x015b, 0x0000, 0x015b,
	0x0159, 0x0159, 0x0000, 0x0159,
	0x0158, 0x0158, 0x0000, 0x0158,
	0x0156, 0x0156, 0x0000, 0x0156,
	0x0154, 0x0154, 0x0000, 0x0154,
	0x0152, 0x0152, 0x0000, 0x0152,
	0x0150, 0x0150, 0x0000, 0x0150,
	0x014f, 0x014f, 0x0000, 0x014f,
	0x014d, 0x014d, 0x0000, 0x014d,
	0x014b, 0x014b, 0x0000, 0x014b,
	0x014a, 0x014a, 0x0000, 0x014a,
	0x0148, 0x0148, 0x0000, 0x0148,
	0x0146, 0x0146, 0x0000, 0x0146,
	0x0145, 0x0145, 0x0000, 0x0145,
	0x0143, 0x0143, 0x0000, 0x0143,
	0x0142, 0x0142, 0x0000, 0x0142,
	0x0140, 0x0140, 0x0000, 0x0140,
	0x013e, 0x013e, 0x0000, 0x013e,
	0x013d, 0x013d, 0x0000, 0x013d,
	0x013b, 0x013b, 0x0000, 0x013b,
	0x013a, 0x013a, 0x0000, 0x013a,
	0x0138, 0x0138, 0x0000, 0x0138,
	0x0137, 0x0137, 0x0000, 0x0137,
	0x0135, 0x0135, 0x0000, 0x0135,
	0x0134, 0x0134, 0x0000, 0x0134,
	0x0132, 0x0132, 0x0000, 0x0132,
	0x0131, 0x0131, 0x0000, 0x0131,
	0x0130, 0x0130, 0x0000, 0x0130,
	0x012e, 0x012e, 0x0000, 0x012e,
	0x012d, 0x012d, 0x0000, 0x012d,
	0x012b, 0x012b, 0x0000, 0x012b,
	0x012a, 0x012a, 0x0000, 0x012a,
	0x0129, 0x0129, 0x0000, 0x0129,
	0x0127, 0x0127, 0x0000, 0x0127,
	0x0126, 0x0126, 0x0000, 0x0126,
	0x0125, 0x0125, 0x0000, 0x0125,
	0x0123, 0x0123, 0x0000, 0x0123,
	0x0122, 0x0122, 0x0000, 0x0122,
	0x0121, 0x0121, 0x0000, 0x0121,
	0x0120, 0x0120, 0x0000, 0x0120,
	0x011e, 0x011e, 0x0000, 0x011e,
	0x011d, 0x011d, 0x0000, 0x011d,
	0x011c, 0x011c, 0x0000, 0x011c,
	0x011b, 0x011b, 0x0000, 0x011b,
	0x0119, 0x0119, 0x0000, 0x0119,
	0x0118, 0x0118, 0x0000, 0x0118,
	0x0117, 0x0117, 0x0000, 0x0117,
	0x0116, 0x0116, 0x0000, 0x0116,
	0x0115, 0x0115, 0x0000, 0x0115,
	0x0113, 0x0113, 0x0000, 0x0113,
	0x0112, 0x0112, 0x0000, 0x0112,
	0x0111, 0x0111, 0x0000, 0x0111,
	0x0110, 0x0110, 0x0000, 0x0110,
	0x010f, 0x010f, 0x0000, 0x010f,
	0x010e, 0x010e, 0x0000, 0x010e,
	0x010d, 0x010d, 0x0000, 0x010d,
	0x010c, 0x010c, 0x0000, 0x010c,
	0x010a, 0x010a, 0x0000, 0x010a,
	0x0109, 0x0109, 0x0000, 0x0109,
	0x0108, 0x0108, 0x0000, 0x0108,
	0x0107, 0x0107, 0x0000, 0x0107,
	0x0106, 0x0106, 0x0000, 0x0106,
	0x0105, 0x0105, 0x0000, 0x0105,
	0x0104, 0x0104, 0x0000, 0x0104,
	0x0103, 0x0103, 0x0000, 0x0103,
	0x0102, 0x0102, 0x0000, 0x0102,
	0x0101, 0x0101, 0x0000, 0x0101,
	0x0100, 0x0100, 0x0000, 0x0100,
};

/* *********************************************************** */

const mlib_u16 mlib_v_tab4[] = {
	0xff00, 0xff00, 0xff00, 0x0000,
	0xff00, 0xff00, 0xff00, 0x0000,
	0x7f80, 0x7f80, 0x7f80, 0x0000,
	0x5500, 0x5500, 0x5500, 0x0000,
	0x3fc0, 0x3fc0, 0x3fc0, 0x0000,
	0x3300, 0x3300, 0x3300, 0x0000,
	0x2a80, 0x2a80, 0x2a80, 0x0000,
	0x246e, 0x246e, 0x246e, 0x0000,
	0x1fe0, 0x1fe0, 0x1fe0, 0x0000,
	0x1c55, 0x1c55, 0x1c55, 0x0000,
	0x1980, 0x1980, 0x1980, 0x0000,
	0x172f, 0x172f, 0x172f, 0x0000,
	0x1540, 0x1540, 0x1540, 0x0000,
	0x139e, 0x139e, 0x139e, 0x0000,
	0x1237, 0x1237, 0x1237, 0x0000,
	0x1100, 0x1100, 0x1100, 0x0000,
	0x0ff0, 0x0ff0, 0x0ff0, 0x0000,
	0x0f00, 0x0f00, 0x0f00, 0x0000,
	0x0e2b, 0x0e2b, 0x0e2b, 0x0000,
	0x0d6c, 0x0d6c, 0x0d6c, 0x0000,
	0x0cc0, 0x0cc0, 0x0cc0, 0x0000,
	0x0c25, 0x0c25, 0x0c25, 0x0000,
	0x0b97, 0x0b97, 0x0b97, 0x0000,
	0x0b16, 0x0b16, 0x0b16, 0x0000,
	0x0aa0, 0x0aa0, 0x0aa0, 0x0000,
	0x0a33, 0x0a33, 0x0a33, 0x0000,
	0x09cf, 0x09cf, 0x09cf, 0x0000,
	0x0972, 0x0972, 0x0972, 0x0000,
	0x091b, 0x091b, 0x091b, 0x0000,
	0x08cb, 0x08cb, 0x08cb, 0x0000,
	0x0880, 0x0880, 0x0880, 0x0000,
	0x083a, 0x083a, 0x083a, 0x0000,
	0x07f8, 0x07f8, 0x07f8, 0x0000,
	0x07ba, 0x07ba, 0x07ba, 0x0000,
	0x0780, 0x0780, 0x0780, 0x0000,
	0x0749, 0x0749, 0x0749, 0x0000,
	0x0715, 0x0715, 0x0715, 0x0000,
	0x06e4, 0x06e4, 0x06e4, 0x0000,
	0x06b6, 0x06b6, 0x06b6, 0x0000,
	0x068a, 0x068a, 0x068a, 0x0000,
	0x0660, 0x0660, 0x0660, 0x0000,
	0x0638, 0x0638, 0x0638, 0x0000,
	0x0612, 0x0612, 0x0612, 0x0000,
	0x05ee, 0x05ee, 0x05ee, 0x0000,
	0x05cc, 0x05cc, 0x05cc, 0x0000,
	0x05ab, 0x05ab, 0x05ab, 0x0000,
	0x058b, 0x058b, 0x058b, 0x0000,
	0x056d, 0x056d, 0x056d, 0x0000,
	0x0550, 0x0550, 0x0550, 0x0000,
	0x0534, 0x0534, 0x0534, 0x0000,
	0x051a, 0x051a, 0x051a, 0x0000,
	0x0500, 0x0500, 0x0500, 0x0000,
	0x04e7, 0x04e7, 0x04e7, 0x0000,
	0x04d0, 0x04d0, 0x04d0, 0x0000,
	0x04b9, 0x04b9, 0x04b9, 0x0000,
	0x04a3, 0x04a3, 0x04a3, 0x0000,
	0x048e, 0x048e, 0x048e, 0x0000,
	0x0479, 0x0479, 0x0479, 0x0000,
	0x0466, 0x0466, 0x0466, 0x0000,
	0x0452, 0x0452, 0x0452, 0x0000,
	0x0440, 0x0440, 0x0440, 0x0000,
	0x042e, 0x042e, 0x042e, 0x0000,
	0x041d, 0x041d, 0x041d, 0x0000,
	0x040c, 0x040c, 0x040c, 0x0000,
	0x03fc, 0x03fc, 0x03fc, 0x0000,
	0x03ec, 0x03ec, 0x03ec, 0x0000,
	0x03dd, 0x03dd, 0x03dd, 0x0000,
	0x03ce, 0x03ce, 0x03ce, 0x0000,
	0x03c0, 0x03c0, 0x03c0, 0x0000,
	0x03b2, 0x03b2, 0x03b2, 0x0000,
	0x03a5, 0x03a5, 0x03a5, 0x0000,
	0x0397, 0x0397, 0x0397, 0x0000,
	0x038b, 0x038b, 0x038b, 0x0000,
	0x037e, 0x037e, 0x037e, 0x0000,
	0x0372, 0x0372, 0x0372, 0x0000,
	0x0366, 0x0366, 0x0366, 0x0000,
	0x035b, 0x035b, 0x035b, 0x0000,
	0x0350, 0x0350, 0x0350, 0x0000,
	0x0345, 0x0345, 0x0345, 0x0000,
	0x033a, 0x033a, 0x033a, 0x0000,
	0x0330, 0x0330, 0x0330, 0x0000,
	0x0326, 0x0326, 0x0326, 0x0000,
	0x031c, 0x031c, 0x031c, 0x0000,
	0x0313, 0x0313, 0x0313, 0x0000,
	0x0309, 0x0309, 0x0309, 0x0000,
	0x0300, 0x0300, 0x0300, 0x0000,
	0x02f7, 0x02f7, 0x02f7, 0x0000,
	0x02ee, 0x02ee, 0x02ee, 0x0000,
	0x02e6, 0x02e6, 0x02e6, 0x0000,
	0x02dd, 0x02dd, 0x02dd, 0x0000,
	0x02d5, 0x02d5, 0x02d5, 0x0000,
	0x02cd, 0x02cd, 0x02cd, 0x0000,
	0x02c6, 0x02c6, 0x02c6, 0x0000,
	0x02be, 0x02be, 0x02be, 0x0000,
	0x02b6, 0x02b6, 0x02b6, 0x0000,
	0x02af, 0x02af, 0x02af, 0x0000,
	0x02a8, 0x02a8, 0x02a8, 0x0000,
	0x02a1, 0x02a1, 0x02a1, 0x0000,
	0x029a, 0x029a, 0x029a, 0x0000,
	0x0293, 0x0293, 0x0293, 0x0000,
	0x028d, 0x028d, 0x028d, 0x0000,
	0x0286, 0x0286, 0x0286, 0x0000,
	0x0280, 0x0280, 0x0280, 0x0000,
	0x027a, 0x027a, 0x027a, 0x0000,
	0x0274, 0x0274, 0x0274, 0x0000,
	0x026e, 0x026e, 0x026e, 0x0000,
	0x0268, 0x0268, 0x0268, 0x0000,
	0x0262, 0x0262, 0x0262, 0x0000,
	0x025c, 0x025c, 0x025c, 0x0000,
	0x0257, 0x0257, 0x0257, 0x0000,
	0x0251, 0x0251, 0x0251, 0x0000,
	0x024c, 0x024c, 0x024c, 0x0000,
	0x0247, 0x0247, 0x0247, 0x0000,
	0x0242, 0x0242, 0x0242, 0x0000,
	0x023d, 0x023d, 0x023d, 0x0000,
	0x0238, 0x0238, 0x0238, 0x0000,
	0x0233, 0x0233, 0x0233, 0x0000,
	0x022e, 0x022e, 0x022e, 0x0000,
	0x0229, 0x0229, 0x0229, 0x0000,
	0x0225, 0x0225, 0x0225, 0x0000,
	0x0220, 0x0220, 0x0220, 0x0000,
	0x021c, 0x021c, 0x021c, 0x0000,
	0x0217, 0x0217, 0x0217, 0x0000,
	0x0213, 0x0213, 0x0213, 0x0000,
	0x020e, 0x020e, 0x020e, 0x0000,
	0x020a, 0x020a, 0x020a, 0x0000,
	0x0206, 0x0206, 0x0206, 0x0000,
	0x0202, 0x0202, 0x0202, 0x0000,
	0x01fe, 0x01fe, 0x01fe, 0x0000,
	0x01fa, 0x01fa, 0x01fa, 0x0000,
	0x01f6, 0x01f6, 0x01f6, 0x0000,
	0x01f2, 0x01f2, 0x01f2, 0x0000,
	0x01ef, 0x01ef, 0x01ef, 0x0000,
	0x01eb, 0x01eb, 0x01eb, 0x0000,
	0x01e7, 0x01e7, 0x01e7, 0x0000,
	0x01e4, 0x01e4, 0x01e4, 0x0000,
	0x01e0, 0x01e0, 0x01e0, 0x0000,
	0x01dc, 0x01dc, 0x01dc, 0x0000,
	0x01d9, 0x01d9, 0x01d9, 0x0000,
	0x01d6, 0x01d6, 0x01d6, 0x0000,
	0x01d2, 0x01d2, 0x01d2, 0x0000,
	0x01cf, 0x01cf, 0x01cf, 0x0000,
	0x01cc, 0x01cc, 0x01cc, 0x0000,
	0x01c9, 0x01c9, 0x01c9, 0x0000,
	0x01c5, 0x01c5, 0x01c5, 0x0000,
	0x01c2, 0x01c2, 0x01c2, 0x0000,
	0x01bf, 0x01bf, 0x01bf, 0x0000,
	0x01bc, 0x01bc, 0x01bc, 0x0000,
	0x01b9, 0x01b9, 0x01b9, 0x0000,
	0x01b6, 0x01b6, 0x01b6, 0x0000,
	0x01b3, 0x01b3, 0x01b3, 0x0000,
	0x01b0, 0x01b0, 0x01b0, 0x0000,
	0x01ad, 0x01ad, 0x01ad, 0x0000,
	0x01ab, 0x01ab, 0x01ab, 0x0000,
	0x01a8, 0x01a8, 0x01a8, 0x0000,
	0x01a5, 0x01a5, 0x01a5, 0x0000,
	0x01a2, 0x01a2, 0x01a2, 0x0000,
	0x01a0, 0x01a0, 0x01a0, 0x0000,
	0x019d, 0x019d, 0x019d, 0x0000,
	0x019b, 0x019b, 0x019b, 0x0000,
	0x0198, 0x0198, 0x0198, 0x0000,
	0x0195, 0x0195, 0x0195, 0x0000,
	0x0193, 0x0193, 0x0193, 0x0000,
	0x0190, 0x0190, 0x0190, 0x0000,
	0x018e, 0x018e, 0x018e, 0x0000,
	0x018c, 0x018c, 0x018c, 0x0000,
	0x0189, 0x0189, 0x0189, 0x0000,
	0x0187, 0x0187, 0x0187, 0x0000,
	0x0185, 0x0185, 0x0185, 0x0000,
	0x0182, 0x0182, 0x0182, 0x0000,
	0x0180, 0x0180, 0x0180, 0x0000,
	0x017e, 0x017e, 0x017e, 0x0000,
	0x017c, 0x017c, 0x017c, 0x0000,
	0x0179, 0x0179, 0x0179, 0x0000,
	0x0177, 0x0177, 0x0177, 0x0000,
	0x0175, 0x0175, 0x0175, 0x0000,
	0x0173, 0x0173, 0x0173, 0x0000,
	0x0171, 0x0171, 0x0171, 0x0000,
	0x016f, 0x016f, 0x016f, 0x0000,
	0x016d, 0x016d, 0x016d, 0x0000,
	0x016b, 0x016b, 0x016b, 0x0000,
	0x0169, 0x0169, 0x0169, 0x0000,
	0x0167, 0x0167, 0x0167, 0x0000,
	0x0165, 0x0165, 0x0165, 0x0000,
	0x0163, 0x0163, 0x0163, 0x0000,
	0x0161, 0x0161, 0x0161, 0x0000,
	0x015f, 0x015f, 0x015f, 0x0000,
	0x015d, 0x015d, 0x015d, 0x0000,
	0x015b, 0x015b, 0x015b, 0x0000,
	0x0159, 0x0159, 0x0159, 0x0000,
	0x0158, 0x0158, 0x0158, 0x0000,
	0x0156, 0x0156, 0x0156, 0x0000,
	0x0154, 0x0154, 0x0154, 0x0000,
	0x0152, 0x0152, 0x0152, 0x0000,
	0x0150, 0x0150, 0x0150, 0x0000,
	0x014f, 0x014f, 0x014f, 0x0000,
	0x014d, 0x014d, 0x014d, 0x0000,
	0x014b, 0x014b, 0x014b, 0x0000,
	0x014a, 0x014a, 0x014a, 0x0000,
	0x0148, 0x0148, 0x0148, 0x0000,
	0x0146, 0x0146, 0x0146, 0x0000,
	0x0145, 0x0145, 0x0145, 0x0000,
	0x0143, 0x0143, 0x0143, 0x0000,
	0x0142, 0x0142, 0x0142, 0x0000,
	0x0140, 0x0140, 0x0140, 0x0000,
	0x013e, 0x013e, 0x013e, 0x0000,
	0x013d, 0x013d, 0x013d, 0x0000,
	0x013b, 0x013b, 0x013b, 0x0000,
	0x013a, 0x013a, 0x013a, 0x0000,
	0x0138, 0x0138, 0x0138, 0x0000,
	0x0137, 0x0137, 0x0137, 0x0000,
	0x0135, 0x0135, 0x0135, 0x0000,
	0x0134, 0x0134, 0x0134, 0x0000,
	0x0132, 0x0132, 0x0132, 0x0000,
	0x0131, 0x0131, 0x0131, 0x0000,
	0x0130, 0x0130, 0x0130, 0x0000,
	0x012e, 0x012e, 0x012e, 0x0000,
	0x012d, 0x012d, 0x012d, 0x0000,
	0x012b, 0x012b, 0x012b, 0x0000,
	0x012a, 0x012a, 0x012a, 0x0000,
	0x0129, 0x0129, 0x0129, 0x0000,
	0x0127, 0x0127, 0x0127, 0x0000,
	0x0126, 0x0126, 0x0126, 0x0000,
	0x0125, 0x0125, 0x0125, 0x0000,
	0x0123, 0x0123, 0x0123, 0x0000,
	0x0122, 0x0122, 0x0122, 0x0000,
	0x0121, 0x0121, 0x0121, 0x0000,
	0x0120, 0x0120, 0x0120, 0x0000,
	0x011e, 0x011e, 0x011e, 0x0000,
	0x011d, 0x011d, 0x011d, 0x0000,
	0x011c, 0x011c, 0x011c, 0x0000,
	0x011b, 0x011b, 0x011b, 0x0000,
	0x0119, 0x0119, 0x0119, 0x0000,
	0x0118, 0x0118, 0x0118, 0x0000,
	0x0117, 0x0117, 0x0117, 0x0000,
	0x0116, 0x0116, 0x0116, 0x0000,
	0x0115, 0x0115, 0x0115, 0x0000,
	0x0113, 0x0113, 0x0113, 0x0000,
	0x0112, 0x0112, 0x0112, 0x0000,
	0x0111, 0x0111, 0x0111, 0x0000,
	0x0110, 0x0110, 0x0110, 0x0000,
	0x010f, 0x010f, 0x010f, 0x0000,
	0x010e, 0x010e, 0x010e, 0x0000,
	0x010d, 0x010d, 0x010d, 0x0000,
	0x010c, 0x010c, 0x010c, 0x0000,
	0x010a, 0x010a, 0x010a, 0x0000,
	0x0109, 0x0109, 0x0109, 0x0000,
	0x0108, 0x0108, 0x0108, 0x0000,
	0x0107, 0x0107, 0x0107, 0x0000,
	0x0106, 0x0106, 0x0106, 0x0000,
	0x0105, 0x0105, 0x0105, 0x0000,
	0x0104, 0x0104, 0x0104, 0x0000,
	0x0103, 0x0103, 0x0103, 0x0000,
	0x0102, 0x0102, 0x0102, 0x0000,
	0x0101, 0x0101, 0x0101, 0x0000,
	0x0100, 0x0100, 0x0100, 0x0000,
};

/* *********************************************************** */
