/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _MLIB_IMAGE_TYPES_H
#define	_MLIB_IMAGE_TYPES_H

#pragma ident	"@(#)mlib_image_types.h	9.4	07/10/09 SMI"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	MLIB_BIT = 0,		/* 1-bit data */
	MLIB_BYTE = 1,		/* 8-bit unsigned integer data */
	MLIB_SHORT = 2,		/* 16-bit signed integer data */
	MLIB_INT = 3,		/* 32-bit signed integer data */
	MLIB_FLOAT = 4,		/* 32-bit floating-point data */
	MLIB_DOUBLE = 5,	/* 64-bit floating-point data */
	MLIB_USHORT = 6		/* 16-bit unsigned integer data */
} mlib_type;

typedef enum
{
	MLIB_NEAREST = 0,	/* nearest neighbor filter */
	MLIB_BILINEAR = 1,	/* bilinear filter */
	MLIB_BICUBIC = 2,	/* bicubic filter */
	MLIB_BICUBIC2 = 3	/* bicubic2 filter */
} mlib_filter;

typedef enum
{
	MLIB_EDGE_DST_NO_WRITE = 0,		/* no write to dst edge */
	MLIB_EDGE_DST_FILL_ZERO = 1,		/* set dst edge to zero */
	MLIB_EDGE_DST_COPY_SRC = 2,		/* copy src edge to dst edge */
	MLIB_EDGE_OP_NEAREST = 3,		/* use nearest neighbor */
						/*   interpolation for edge */
						/*   pixels */
	MLIB_EDGE_OP_DEGRADED = 4,		/* use degraded interpolation */
						/*   for edge pixels, i.e., */
						/*   bicubic -> bilinear -> */
						/*   nearest neighbor */
	MLIB_EDGE_SRC_EXTEND = 5,		/* extend src edge by */
						/*   replication */
	MLIB_EDGE_SRC_EXTEND_ZERO = 6,		/* extend src edge with zeros */
	MLIB_EDGE_SRC_EXTEND_MIRROR = 7,	/* extend src edge with */
						/*   mirrored data */
	MLIB_EDGE_SRC_PADDED = 8,		/* use borders specified in */
						/*   mlib_image structure */
	MLIB_EDGE_SRC_EXTEND_INDEF = 9		/* extend src edge */
						/*   indefinitely */
} mlib_edge;

typedef enum
{
	MLIB_BLEND_ZERO = 0,
	MLIB_BLEND_ONE = 1,
	MLIB_BLEND_DST_COLOR = 2,
	MLIB_BLEND_SRC_COLOR = 3,
	MLIB_BLEND_ONE_MINUS_DST_COLOR = 4,
	MLIB_BLEND_ONE_MINUS_SRC_COLOR = 5,
	MLIB_BLEND_DST_ALPHA = 6,
	MLIB_BLEND_SRC_ALPHA = 7,
	MLIB_BLEND_ONE_MINUS_DST_ALPHA = 8,
	MLIB_BLEND_ONE_MINUS_SRC_ALPHA = 9,
	MLIB_BLEND_SRC_ALPHA_SATURATE = 10,
	MLIB_BLEND_GTK_SRC = 11,
	MLIB_BLEND_GTK_SRC_OVER = 12,
	MLIB_BLEND_GTK_SRC_OVER2 = 13
} mlib_blend;

typedef enum
{
	MLIB_DFT_SCALE_NONE = 0,	/* forward transform without scaling */
	MLIB_DFT_SCALE_MXN = 1,		/* forward transform with scaling */
					/*   of 1/(M*N) */
	MLIB_DFT_SCALE_SQRT = 2,	/* forward transform with scaling of */
					/*   1/sqrt(M*N) */
	MLIB_IDFT_SCALE_NONE = 3,	/* inverse transform without scaling */
	MLIB_IDFT_SCALE_MXN = 4,	/* inverse transform with scaling of */
					/*   1/(M*N) */
	MLIB_IDFT_SCALE_SQRT = 5	/* inverse transform with scaling of */
					/*   1/sqrt(M*N) */
} mlib_fourier_mode;

typedef enum
{
	MLIB_MEDIAN_MASK_RECT = 0,		/* rectangle shaped mask */
	MLIB_MEDIAN_MASK_PLUS = 1,		/* plus shaped mask */
	MLIB_MEDIAN_MASK_X = 2,			/* X shaped mask */
	MLIB_MEDIAN_MASK_RECT_SEPARABLE = 3	/* separable rectangle mask */
} mlib_median_mask;

/* constants used for pixel format */

typedef enum
{
	MLIB_FORMAT_UNKNOWN = 0,
	MLIB_FORMAT_INDEXED = 1,
	MLIB_FORMAT_GRAYSCALE = 2,
	MLIB_FORMAT_RGB = 3,
	MLIB_FORMAT_BGR = 4,
	MLIB_FORMAT_ARGB = 5,
	MLIB_FORMAT_ABGR = 6,
	MLIB_FORMAT_PACKED_ARGB = 7,
	MLIB_FORMAT_PACKED_ABGR = 8,
	MLIB_FORMAT_GRAYSCALE_ALPHA = 9,
	MLIB_FORMAT_RGBA = 10,
	MLIB_FORMAT_CMYK = 11,
	MLIB_FORMAT_YCC = 12,
	MLIB_FORMAT_YCCA = 13,
	MLIB_FORMAT_YCCK = 14,
	MLIB_FORMAT_BGRA = 15
} mlib_format;

typedef struct
{
	mlib_type type;		/* data type of image */
	mlib_s32 channels;	/* number of channels */
	mlib_s32 width;		/* width of image in pixels, x dimension */
	mlib_s32 height;	/* height of image in pixels, y dimension */
	mlib_s32 stride;	/* linestride = bytes to next row */
	mlib_s32 flags;		/* collection of helpful hints */
	void *data;		/* pointer to first data pixel */
	void *state;		/* internal state structure */
	mlib_u8 paddings[4];	/* left, top, right, bottom */
	mlib_s32 bitoffset;	/* the offset in bits from the beginning */
				/*   of the data buffer to the first pixel */
	mlib_format format;	/* pixel format */
	mlib_s32 reserved[7 - 2 * sizeof (void *) / 4];
				/* Reserved for future use. Also makes the */
				/*   size of this structure = 64 bytes, */
				/*   which is the size of the cache line. */
} mlib_image;

/*
 * Flags or hints are contained in a 32-bit integer. The bit structure is
 * shown below:
 *
 *      3                   2                   1
 *    1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
 *   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *   |S|                 |U|V| shint | hhint | whint |     dhint     |
 *   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *
 *      S = 0   - attributes have been set (attribute field >= 0)
 *          1   - attributes have not been set (attribute field < 0)
 *
 *      U = 0   - mediaLib allocated data space
 *          1   - user allocated data space
 *
 *      V = 0   - stride == width => 1-D vector
 *          1   - stride != width
 *
 *      shint   - last 4 bits of stride
 *
 *      hhint   - last 4 bits of height
 *
 *      whint   - last 4 bits of width
 *
 *      dhint   - last 8 bits of data address
 */

enum
{
	MLIB_IMAGE_ALIGNED64 = 0x3f,
	MLIB_IMAGE_ALIGNED8 = 0x7,
	MLIB_IMAGE_ALIGNED4 = 0x3,
	MLIB_IMAGE_ALIGNED2 = 0x1,
	MLIB_IMAGE_WIDTH8X = 0x700,
	MLIB_IMAGE_WIDTH4X = 0x300,
	MLIB_IMAGE_WIDTH2X = 0x100,
	MLIB_IMAGE_HEIGHT8X = 0x7000,
	MLIB_IMAGE_HEIGHT4X = 0x3000,
	MLIB_IMAGE_HEIGHT2X = 0x1000,
	MLIB_IMAGE_STRIDE8X = 0x70000,
	MLIB_IMAGE_ONEDVECTOR = 0x100000,
	MLIB_IMAGE_USERALLOCATED = 0x200000,
	MLIB_IMAGE_ATTRIBUTESET = 0x7fffffff
};

#ifdef __cplusplus
}
#endif

#endif /* _MLIB_IMAGE_TYPES_H */
