/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _MLIB_IMAGEAFFINE_H
#define	_MLIB_IMAGEAFFINE_H

#pragma ident	"@(#)mlib_ImageAffine.h	9.2	07/10/09 SMI"

#ifdef __cplusplus
extern "C" {
#endif

#include <mlib_image.h>
#include <mlib_ImageDivTables.h>
#include <mlib_ImageFilters.h>

/*
 * DESCRIPTION
 *   Internal macro for mlib_ImageAffine.
 *
 *   DTYPE define must be set to data type of image.
 *   FTYPE define must be set to type of floating-point operations.
 */
/* *********************************************************** */
    typedef struct
{
	mlib_image *src;
	mlib_image *dst;
	mlib_u8 *buff_malloc;
	mlib_u8 **lineAddr;
	mlib_u8 *dstData;
	mlib_s32 *leftEdges;
	mlib_s32 *rightEdges;
	mlib_s32 *xStarts;
	mlib_s32 *yStarts;
	mlib_s32 yStart;
	mlib_s32 yFinish;
	mlib_s32 dX;
	mlib_s32 dY;
	mlib_s32 max_xsize;
	mlib_s32 srcYStride;
	mlib_s32 dstYStride;
	mlib_s32 affine;
	mlib_s32 *warp_tbl;
	mlib_filter filter;
} mlib_affine_param;

/* *********************************************************** */

#define	LOAD_PARAM(param, x)	x = param->x
#define	STORE_PARAM(param, x)	param->x = x

/* *********************************************************** */
mlib_status mlib_AffineEdges(
    mlib_affine_param *param,
    const mlib_image *dst,
    const mlib_image *src,
    void *buff_lcl,
    mlib_s32 buff_size,
    mlib_s32 kw,
    mlib_s32 kh,
    mlib_s32 kw1,
    mlib_s32 kh1,
    mlib_edge edge,
    const mlib_d64 *mtx,
    mlib_s32 shiftx,
    mlib_s32 shifty);

/* *********************************************************** */
typedef mlib_status(*type_affine_fun) (
    mlib_affine_param *param);

/* *********************************************************** */
void mlib_ImageAffine_bit_1ch_nn(
    mlib_affine_param *param,
    mlib_s32 s_bitoff,
    mlib_s32 d_bitoff);

mlib_status mlib_ImageAffine_u8_1ch_nn(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u8_2ch_nn(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u8_3ch_nn(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u8_4ch_nn(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s16_1ch_nn(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s16_2ch_nn(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s16_3ch_nn(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s16_4ch_nn(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s32_1ch_nn(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s32_2ch_nn(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s32_3ch_nn(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s32_4ch_nn(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_d64_1ch_nn(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_d64_2ch_nn(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_d64_3ch_nn(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_d64_4ch_nn(
    mlib_affine_param *param);

mlib_status mlib_ImageAffine_u8_1ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u8_2ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u8_3ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u8_4ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s16_1ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s16_2ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s16_3ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s16_4ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u16_1ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u16_2ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u16_3ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u16_4ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s32_1ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s32_2ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s32_3ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s32_4ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_f32_1ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_f32_2ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_f32_3ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_f32_4ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_d64_1ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_d64_2ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_d64_3ch_bl(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_d64_4ch_bl(
    mlib_affine_param *param);

mlib_status mlib_ImageAffine_u8_1ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u8_2ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u8_3ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u8_4ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s16_1ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s16_2ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s16_3ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s16_4ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u16_1ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u16_2ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u16_3ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_u16_4ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s32_1ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s32_2ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s32_3ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_s32_4ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_f32_1ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_f32_2ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_f32_3ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_f32_4ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_d64_1ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_d64_2ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_d64_3ch_bc(
    mlib_affine_param *param);
mlib_status mlib_ImageAffine_d64_4ch_bc(
    mlib_affine_param *param);

/* *********************************************************** */
void mlib_ImageAffineEdgeZero(
    mlib_affine_param *param,
    mlib_affine_param *param_e,
    const void *colormap);

void mlib_ImageAffineEdgeNearest(
    mlib_affine_param *param,
    mlib_affine_param *param_e);

mlib_status mlib_ImageAffineEdgeExtend_BL(
    mlib_affine_param *param,
    mlib_affine_param *param_e,
    const void *colormap);

mlib_status mlib_ImageAffineEdgeExtend_BC(
    mlib_affine_param *param,
    mlib_affine_param *param_e,
    const void *colormap);

mlib_status mlib_ImageAffineEdgeExtend_BC2(
    mlib_affine_param *param,
    mlib_affine_param *param_e,
    const void *colormap);

/* *********************************************************** */
typedef mlib_status (*type_affine_i_fun) (
    mlib_affine_param *param,
    const void *colormap);

mlib_status mlib_ImageAffine_u8_u8_i_bl(
    mlib_affine_param *param,
    const void *colormap);
mlib_status mlib_ImageAffine_u8_s16_i_bl(
    mlib_affine_param *param,
    const void *colormap);
mlib_status mlib_ImageAffine_s16_u8_i_bl(
    mlib_affine_param *param,
    const void *colormap);
mlib_status mlib_ImageAffine_s16_s16_i_bl(
    mlib_affine_param *param,
    const void *colormap);

mlib_status mlib_ImageAffine_u8_u8_i_bc(
    mlib_affine_param *param,
    const void *colormap);
mlib_status mlib_ImageAffine_u8_s16_i_bc(
    mlib_affine_param *param,
    const void *colormap);
mlib_status mlib_ImageAffine_s16_u8_i_bc(
    mlib_affine_param *param,
    const void *colormap);
mlib_status mlib_ImageAffine_s16_s16_i_bc(
    mlib_affine_param *param,
    const void *colormap);

void mlib_ImageAffineEdgeZeroIndex(
    mlib_affine_param *param,
    mlib_affine_param *param_e,
    const void *colormap);

void mlib_ImageAffineEdgeExtendIndex_BL(
    mlib_affine_param *param,
    mlib_affine_param *param_e,
    const void *colormap);

void mlib_ImageAffineEdgeExtendIndex_BC(
    mlib_affine_param *param,
    mlib_affine_param *param_e,
    const void *colormap);

void mlib_ImageAffineEdgeExtendIndex_BC2(
    mlib_affine_param *param,
    mlib_affine_param *param_e,
    const void *colormap);

void mlib_ImageZoomTranslateTableBlendEdgeZero(
    mlib_affine_param *param,
    mlib_affine_param *param_e,
    mlib_s32 dchan,
    mlib_s32 schan,
    mlib_s32 alpha_shift,
    mlib_blend blend);

void mlib_ImageZoomTranslateTableBlendEdgeNearest(
    mlib_affine_param *param,
    mlib_affine_param *param_e,
    mlib_s32 dchan,
    mlib_s32 schan,
    mlib_s32 alpha_shift,
    mlib_blend blend);

/* *********************************************************** */
#define	PROT_AFFINEINDEX_BC(ITYPE, LTYPE, NCHAN)                   \
	mlib_status                                                \
	mlib_ImageAffineIndex_##ITYPE##_##LTYPE##_##NCHAN##CH_BC   \
	    (mlib_affine_param *param, const void *colormap)

PROT_AFFINEINDEX_BC(U8, U8, 3);
PROT_AFFINEINDEX_BC(U8, S16, 3);
PROT_AFFINEINDEX_BC(U8, U8, 4);
PROT_AFFINEINDEX_BC(U8, S16, 4);
PROT_AFFINEINDEX_BC(S16, U8, 3);
PROT_AFFINEINDEX_BC(S16, S16, 3);
PROT_AFFINEINDEX_BC(S16, U8, 4);
PROT_AFFINEINDEX_BC(S16, S16, 4);

/* *********************************************************** */
#define	PROT_AFFINEINDEX_BL(ITYPE, LTYPE, NCHAN)                   \
	mlib_status                                                \
	mlib_ImageAffineIndex_##ITYPE##_##LTYPE##_##NCHAN##CH_BL   \
	    (mlib_affine_param *param, const void *colormap)

PROT_AFFINEINDEX_BL(U8, U8, 3);
PROT_AFFINEINDEX_BL(U8, S16, 3);
PROT_AFFINEINDEX_BL(U8, U8, 4);
PROT_AFFINEINDEX_BL(U8, S16, 4);
PROT_AFFINEINDEX_BL(S16, U8, 3);
PROT_AFFINEINDEX_BL(S16, S16, 3);
PROT_AFFINEINDEX_BL(S16, U8, 4);
PROT_AFFINEINDEX_BL(S16, S16, 4);

/* *********************************************************** */
mlib_status mlib_ImageAffine_alltypes(
    mlib_image *dst,
    const mlib_image *src,
    const mlib_d64 *mtx,
    mlib_filter filter,
    mlib_edge edge,
    const void *colormap);

/* *********************************************************** */
extern const type_affine_i_fun mlib_AffineFunArr_bl_i[];
extern const type_affine_fun mlib_AffineFunArr_nn[];
extern const type_affine_fun mlib_AffineFunArr_bl[];
extern const type_affine_fun mlib_AffineFunArr_bc[];

/* *********************************************************** */
typedef union
{
	mlib_d64 d64;
	struct
	{
		mlib_f32 f0;
		mlib_f32 f1;
	} f32s;
} d64_2x32;

/* *********************************************************** */
#define	MLIB_SHIFT	16
#define	MLIB_PREC	(1 << MLIB_SHIFT)
#define	MLIB_MASK	(MLIB_PREC - 1)

/* *********************************************************** */
#define	ONE	(FTYPE)1.0

/* *********************************************************** */
#ifdef MLIB_USE_FTOI_CLAMPING

#define	SAT32(DST)	DST = (mlib_s32)val0

#else

#define	SAT32(DST)                                              \
	if (val0 >= MLIB_S32_MAX)                               \
	    val0 = MLIB_S32_MAX;                                \
	if (val0 <= MLIB_S32_MIN)                               \
	    val0 = MLIB_S32_MIN;                                \
	DST = (mlib_s32)val0

#endif /* MLIB_USE_FTOI_CLAMPING */

/* *********************************************************** */
#ifdef _LP64
#define	PBITS	3
#define	MLIB_POINTER_SHIFT(P)	(((P) >> (MLIB_SHIFT - 3)) &~ 7)
#define	MLIB_POINTER_GET(A, P)	(*(DTYPE**)((mlib_u8*)(A) + (P)))
#else
#define	PBITS	2
#define	MLIB_POINTER_SHIFT(P)	(((P) >> (MLIB_SHIFT - 2)) &~ 3)
#define	MLIB_POINTER_GET(A, P)	(*(DTYPE**)((mlib_addr)(A) + (P)))
#endif /* _LP64 */

#define	PTR_SHIFT	MLIB_POINTER_SHIFT

/* *********************************************************** */
#define	SHIFT(X, SH, LO_BITS)                                   \
	(((X) >> (SH - LO_BITS)) & ((1 << (15 + LO_BITS)) -     \
	    (1 << LO_BITS)))

/* *********************************************************** */
#define	S_PTRl(Y, SH)                                               \
	(*(DTYPE **) ((mlib_u8 *)lineAddr + SHIFT(Y, SH, PBITS)))

#define	S_PTR(Y)	S_PTRl(Y, 16)

/* *********************************************************** */
#define	AL_ADDR(sp, ind)	(mlib_d64*)((mlib_addr)(sp + ind) &~ 7)

/* *********************************************************** */
#define	FILTER_ELEM_BITS	3

/* *********************************************************** */
#define	FILTER_SHIFT	(MLIB_SHIFT - FILTER_BITS - FILTER_ELEM_BITS)
#define	FILTER_SIZE	(1 << FILTER_BITS)
#define	FILTER_MASK	((FILTER_SIZE - 1) << FILTER_ELEM_BITS)

/* *********************************************************** */
#define	DECLAREVAR0()                                           \
	mlib_s32 *leftEdges = param->leftEdges;                 \
	mlib_s32 *rightEdges = param->rightEdges;               \
	mlib_s32 *xStarts = param->xStarts;                     \
	mlib_s32 *yStarts = param->yStarts;                     \
	mlib_u8 *dstData = param->dstData;                      \
	mlib_u8 **lineAddr = param->lineAddr;                   \
	mlib_s32 dstYStride = param->dstYStride;                \
	mlib_s32 xLeft, xRight, X, Y;                           \
	mlib_s32 yStart = param->yStart;                        \
	mlib_s32 yFinish = param->yFinish;                      \
	mlib_s32 dX = param->dX;                                \
	mlib_s32 dY = param->dY;                                \
	mlib_s32 j

/* *********************************************************** */
#define	DECLAREVAR()                                            \
	DECLAREVAR0();                                          \
	mlib_s32 *warp_tbl = param->warp_tbl;                   \
	DTYPE *dstPixelPtr

/* *********************************************************** */
#define	DECLAREVAR_NN()                                         \
	DECLAREVAR();                                           \
	DTYPE *srcPixelPtr;                                     \
	mlib_s32 xSrc, ySrc

/* *********************************************************** */
#define	DECLAREVAR_BL()                                         \
	DECLAREVAR_NN();                                        \
	mlib_s32 srcYStride = param->srcYStride

/* *********************************************************** */
#define	DECLAREVAR_BC()                                         \
	DECLAREVAR_BL();                                        \
	mlib_filter filter = param->filter

/* *********************************************************** */
#define	PREPARE_DELTAS                                          \
	if (warp_tbl != NULL) {                                 \
	    dX = warp_tbl[2 * j];                               \
	    dY = warp_tbl[2 * j + 1];                           \
	}

/* *********************************************************** */
#define	CLIP(N)                                                 \
	dstData += dstYStride;                                  \
	xLeft = leftEdges[j];                                   \
	xRight = rightEdges[j];                                 \
	X = xStarts[j];                                         \
	Y = yStarts[j];                                         \
	PREPARE_DELTAS;                                         \
	if (xLeft > xRight)                                     \
	    continue;                                           \
	dstPixelPtr = (DTYPE *) dstData + N * xLeft

/* *********************************************************** */
#define	NEW_LINE(NCHAN)                                                    \
	dstData += dstYStride;                                             \
	xLeft = leftEdges[j];                                              \
	xRight = rightEdges[j];                                            \
	X = xStarts[j];                                                    \
	Y = yStarts[j];                                                    \
	PREPARE_DELTAS dl = (void *)((DTYPE *) dstData + NCHAN * xLeft);   \
	                                                                   \
	size = xRight - xLeft + 1;                                         \
	if (size <= 0)                                                     \
	    continue

/* *********************************************************** */

#ifdef __cplusplus
}
#endif

#endif /* _MLIB_IMAGEAFFINE_H */
