/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)mlib_GraphicsDrawSet.c	9.2	07/10/09 SMI"

/*
 * TABLES
 *
 *   mlib_GraphicsStepTable_f32
 *   mlib_GraphicsDivTable_f32
 *
 *  DESCRIPTION
 *
 *    mlib_GraphicsStepTable_f32[-1] = 1.0f;
 *    mlib_GraphicsStepTable_f32[0]  = 1.f/32768;
 *    mlib_GraphicsStepTable_f32[k]  = 32768.f/k;
 *
 *    mlib_GraphicsDivTable_f32[0]   = 0.f;
 *    mlib_GraphicsDivTable_f32[k]   = 1.f/k;
 *
 *  Where 1 <= k < MLIB_STEP_TABLE_LENGTH
 *
 *  COMMENTS
 *
 *  Table mlib_GraphicsStepTable_f32 is used by mlib_GraphicsClipLineSet*
 *  functions for calculate step value with precalculated division.
 *  Table mlib_GraphicsDivTable_f32 is used by mlib_GraphicsClipLineHor*
 *  functions for calculate X step value.
 *
 */

#include <mlib_types.h>
#include <mlib_GraphicsDrawSet.h>

/* *********************************************************** */

mlib_f32 mlib_GraphicsStepTable_f32_xxx[MLIB_STEP_TABLE_LENGTH + 1] = {
	1.f,
	3.05175781250000000e-05f, 3.27680000000000000e+04f,
		1.63840000000000000e+04f, 1.09226666666666661e+04f,
	8.19200000000000000e+03f, 6.55360000000000036e+03f,
		5.46133333333333303e+03f, 4.68114285714285688e+03f,
	4.09600000000000000e+03f, 3.64088888888888869e+03f,
		3.27680000000000018e+03f, 2.97890909090909099e+03f,
	2.73066666666666652e+03f, 2.52061538461538476e+03f,
		2.34057142857142844e+03f, 2.18453333333333330e+03f,
	2.04800000000000000e+03f, 1.92752941176470586e+03f,
		1.82044444444444434e+03f, 1.72463157894736833e+03f,
	1.63840000000000009e+03f, 1.56038095238095229e+03f,
		1.48945454545454550e+03f, 1.42469565217391300e+03f,
	1.36533333333333326e+03f, 1.31072000000000003e+03f,
		1.26030769230769238e+03f, 1.21362962962962956e+03f,
	1.17028571428571422e+03f, 1.12993103448275861e+03f,
		1.09226666666666665e+03f, 1.05703225806451610e+03f,
	1.02400000000000000e+03f, 9.92969696969696997e+02f,
		9.63764705882352928e+02f, 9.36228571428571399e+02f,
	9.10222222222222172e+02f, 8.85621621621621671e+02f,
		8.62315789473684163e+02f, 8.40205128205128176e+02f,
	8.19200000000000045e+02f, 7.99219512195121979e+02f,
		7.80190476190476147e+02f, 7.62046511627906966e+02f,
	7.44727272727272748e+02f, 7.28177777777777806e+02f,
		7.12347826086956502e+02f, 6.97191489361702111e+02f,
	6.82666666666666629e+02f, 6.68734693877550967e+02f,
		6.55360000000000014e+02f, 6.42509803921568619e+02f,
	6.30153846153846189e+02f, 6.18264150943396203e+02f,
		6.06814814814814781e+02f, 5.95781818181818153e+02f,
	5.85142857142857110e+02f, 5.74877192982456108e+02f,
		5.64965517241379303e+02f, 5.55389830508474574e+02f,
	5.46133333333333326e+02f, 5.37180327868852487e+02f,
		5.28516129032258050e+02f, 5.20126984126984098e+02f,
	5.12000000000000000e+02f, 5.04123076923076951e+02f,
		4.96484848484848499e+02f, 4.89074626865671632e+02f,
	4.81882352941176464e+02f, 4.74898550724637687e+02f,
		4.68114285714285700e+02f, 4.61521126760563391e+02f,
	4.55111111111111086e+02f, 4.48876712328767098e+02f,
		4.42810810810810835e+02f, 4.36906666666666695e+02f,
	4.31157894736842081e+02f, 4.25558441558441586e+02f,
		4.20102564102564088e+02f, 4.14784810126582272e+02f,
	4.09600000000000023e+02f, 4.04543209876543187e+02f,
		3.99609756097560989e+02f, 3.94795180722891587e+02f,
	3.90095238095238074e+02f, 3.85505882352941171e+02f,
		3.81023255813953483e+02f, 3.76643678160919535e+02f,
	3.72363636363636374e+02f, 3.68179775280898866e+02f,
		3.64088888888888903e+02f, 3.60087912087912116e+02f,
	3.56173913043478251e+02f, 3.52344086021505404e+02f,
		3.48595744680851055e+02f, 3.44926315789473676e+02f,
	3.41333333333333314e+02f, 3.37814432989690715e+02f,
		3.34367346938775484e+02f, 3.30989898989899018e+02f,
	3.27680000000000007e+02f, 3.24435643564356440e+02f,
		3.21254901960784309e+02f, 3.18135922330097060e+02f,
	3.15076923076923094e+02f, 3.12076190476190504e+02f,
		3.09132075471698101e+02f, 3.06242990654205585e+02f,
	3.03407407407407391e+02f, 3.00623853211009191e+02f,
		2.97890909090909076e+02f, 2.95207207207207205e+02f,
	2.92571428571428555e+02f, 2.89982300884955748e+02f,
		2.87438596491228054e+02f, 2.84939130434782612e+02f,
	2.82482758620689651e+02f, 2.80068376068376097e+02f,
		2.77694915254237287e+02f, 2.75361344537815114e+02f,
	2.73066666666666663e+02f, 2.70809917355371908e+02f,
		2.68590163934426243e+02f, 2.66406504065040679e+02f,
	2.64258064516129025e+02f, 2.62144000000000005e+02f,
		2.60063492063492049e+02f, 2.58015748031496059e+02f,
	2.56000000000000000e+02f, 2.54015503875968989e+02f,
		2.52061538461538476e+02f, 2.50137404580152662e+02f,
	2.48242424242424249e+02f, 2.46375939849624046e+02f,
		2.44537313432835816e+02f, 2.42725925925925935e+02f,
	2.40941176470588232e+02f, 2.39182481751824810e+02f,
		2.37449275362318843e+02f, 2.35741007194244617e+02f,
	2.34057142857142850e+02f, 2.32397163120567370e+02f,
		2.30760563380281695e+02f, 2.29146853146853147e+02f,
	2.27555555555555543e+02f, 2.25986206896551721e+02f,
		2.24438356164383549e+02f, 2.22911564625850332e+02f,
	2.21405405405405418e+02f, 2.19919463087248317e+02f,
		2.18453333333333347e+02f, 2.17006622516556291e+02f,
	2.15578947368421041e+02f, 2.14169934640522882e+02f,
		2.12779220779220793e+02f, 2.11406451612903226e+02f,
	2.10051282051282044e+02f, 2.08713375796178354e+02f,
		2.07392405063291136e+02f, 2.06088050314465420e+02f,
	2.04800000000000011e+02f, 2.03527950310558992e+02f,
		2.02271604938271594e+02f, 2.01030674846625772e+02f,
	1.99804878048780495e+02f, 1.98593939393939394e+02f,
		1.97397590361445793e+02f, 1.96215568862275461e+02f,
	1.95047619047619037e+02f, 1.93893491124260350e+02f,
		1.92752941176470586e+02f, 1.91625730994152036e+02f,
	1.90511627906976742e+02f, 1.89410404624277447e+02f,
		1.88321839080459768e+02f, 1.87245714285714286e+02f,
	1.86181818181818187e+02f, 1.85129943502824858e+02f,
		1.84089887640449433e+02f, 1.83061452513966486e+02f,
	1.82044444444444451e+02f, 1.81038674033149164e+02f,
		1.80043956043956058e+02f, 1.79060109289617486e+02f,
	1.78086956521739125e+02f, 1.77124324324324334e+02f,
		1.76172043010752702e+02f, 1.75229946524064161e+02f,
	1.74297872340425528e+02f, 1.73375661375661366e+02f,
		1.72463157894736838e+02f, 1.71560209424083780e+02f,
	1.70666666666666657e+02f, 1.69782383419689126e+02f,
		1.68907216494845358e+02f, 1.68041025641025641e+02f,
	1.67183673469387742e+02f, 1.66335025380710647e+02f,
		1.65494949494949509e+02f, 1.64663316582914575e+02f,
	1.63840000000000003e+02f, 1.63024875621890544e+02f,
		1.62217821782178220e+02f, 1.61418719211822662e+02f,
	1.60627450980392155e+02f, 1.59843902439024390e+02f,
		1.59067961165048530e+02f, 1.58299516908212553e+02f,
	1.57538461538461547e+02f, 1.56784688995215305e+02f,
		1.56038095238095252e+02f, 1.55298578199052145e+02f,
	1.54566037735849051e+02f, 1.53840375586854464e+02f,
		1.53121495327102792e+02f, 1.52409302325581393e+02f,
	1.51703703703703695e+02f, 1.51004608294930875e+02f,
		1.50311926605504595e+02f, 1.49625570776255699e+02f,
	1.48945454545454538e+02f, 1.48271493212669697e+02f,
		1.47603603603603602e+02f, 1.46941704035874437e+02f,
	1.46285714285714278e+02f, 1.45635555555555555e+02f,
		1.44991150442477874e+02f, 1.44352422907489000e+02f,
	1.43719298245614027e+02f, 1.43091703056768552e+02f,
		1.42469565217391306e+02f, 1.41852813852813853e+02f,
	1.41241379310344826e+02f, 1.40635193133047210e+02f,
		1.40034188034188048e+02f, 1.39438297872340428e+02f,
	1.38847457627118644e+02f, 1.38261603375527415e+02f,
		1.37680672268907557e+02f, 1.37104602510460239e+02f,
	1.36533333333333331e+02f, 1.35966804979253112e+02f,
		1.35404958677685954e+02f, 1.34847736625514415e+02f,
	1.34295081967213122e+02f, 1.33746938775510216e+02f,
		1.33203252032520339e+02f, 1.32663967611336034e+02f,
	1.32129032258064512e+02f, 1.31598393574297177e+02f,
		1.31072000000000003e+02f, 1.30549800796812747e+02f,
	1.30031746031746025e+02f, 1.29517786561264813e+02f,
		1.29007874015748030e+02f, 1.28501960784313724e+02f
};

/* *********************************************************** */

mlib_f32 *mlib_GraphicsStepTable_f32 = mlib_GraphicsStepTable_f32_xxx + 1;

/* *********************************************************** */

mlib_f32 mlib_GraphicsDivTable_f32[MLIB_STEP_TABLE_LENGTH] = {
	0.00000000000000000000e+00f, 1.00000000000000000000e+00f,
		5.00000000000000000000e-01f, 3.33333333333333314830e-01f,
	2.50000000000000000000e-01f, 2.00000000000000011102e-01f,
		1.66666666666666657415e-01f, 1.42857142857142849213e-01f,
	1.25000000000000000000e-01f, 1.11111111111111104943e-01f,
		1.00000000000000005551e-01f, 9.09090909090909116141e-02f,
	8.33333333333333287074e-02f, 7.69230769230769273470e-02f,
		7.14285714285714246063e-02f, 6.66666666666666657415e-02f,
	6.25000000000000000000e-02f, 5.88235294117647050660e-02f,
		5.55555555555555524716e-02f, 5.26315789473684181310e-02f,
	5.00000000000000027756e-02f, 4.76190476190476164042e-02f,
		4.54545454545454558071e-02f, 4.34782608695652161845e-02f,
	4.16666666666666643537e-02f, 4.00000000000000008327e-02f,
		3.84615384615384636735e-02f, 3.70370370370370349811e-02f,
	3.57142857142857123032e-02f, 3.44827586206896546939e-02f,
		3.33333333333333328707e-02f, 3.22580645161290313627e-02f,
	3.12500000000000000000e-02f, 3.03030303030303038714e-02f,
		2.94117647058823525330e-02f, 2.85714285714285705364e-02f,
	2.77777777777777762358e-02f, 2.70270270270270285273e-02f,
		2.63157894736842090655e-02f, 2.56410256410256401360e-02f,
	2.50000000000000013878e-02f, 2.43902439024390252365e-02f,
		2.38095238095238082021e-02f, 2.32558139534883717703e-02f,
	2.27272727272727279035e-02f, 2.22222222222222230703e-02f,
		2.17391304347826080923e-02f, 2.12765957446808505471e-02f,
	2.08333333333333321769e-02f, 2.04081632653061208205e-02f,
		2.00000000000000004163e-02f, 1.96078431372549016887e-02f,
	1.92307692307692318368e-02f, 1.88679245283018860724e-02f,
		1.85185185185185174905e-02f, 1.81818181818181809350e-02f,
	1.78571428571428561516e-02f, 1.75438596491228060437e-02f,
		1.72413793103448273469e-02f, 1.69491525423728812971e-02f,
	1.66666666666666664354e-02f, 1.63934426229508205253e-02f,
		1.61290322580645156814e-02f, 1.58730158730158721347e-02f,
	1.56250000000000000000e-02f, 1.53846153846153854694e-02f,
		1.51515151515151519357e-02f, 1.49253731343283579241e-02f,
	1.47058823529411762665e-02f, 1.44927536231884059731e-02f,
		1.42857142857142852682e-02f, 1.40845070422535214444e-02f,
	1.38888888888888881179e-02f, 1.36986301369863006094e-02f,
		1.35135135135135142637e-02f, 1.33333333333333341891e-02f,
	1.31578947368421045327e-02f, 1.29870129870129878691e-02f,
		1.28205128205128200680e-02f, 1.26582278481012656252e-02f,
	1.25000000000000006939e-02f, 1.23456790123456783270e-02f,
		1.21951219512195126182e-02f, 1.20481927710843379764e-02f,
	1.19047619047619041011e-02f, 1.17647058823529410132e-02f,
		1.16279069767441858851e-02f, 1.14942528735632182313e-02f,
	1.13636363636363639518e-02f, 1.12359550561797749690e-02f,
		1.11111111111111115352e-02f, 1.09890109890109898688e-02f,
	1.08695652173913040461e-02f, 1.07526881720430116107e-02f,
		1.06382978723404252736e-02f, 1.05263157894736839731e-02f,
	1.04166666666666660884e-02f, 1.03092783505154637208e-02f,
		1.02040816326530604102e-02f, 1.01010101010101018687e-02f,
	1.00000000000000002082e-02f, 9.90099009900990111033e-03f,
		9.80392156862745084434e-03f, 9.70873786407766906081e-03f,
	9.61538461538461591838e-03f, 9.52380952380952466862e-03f,
		9.43396226415094303619e-03f, 9.34579439252336378885e-03f,
	9.25925925925925874527e-03f, 9.17431192660550509643e-03f,
		9.09090909090909046752e-03f, 9.00900900900900893087e-03f,
	8.92857142857142807579e-03f, 8.84955752212389368250e-03f,
		8.77192982456140302183e-03f, 8.69565217391304358385e-03f,
	8.62068965517241367347e-03f, 8.54700854700854786850e-03f,
		8.47457627118644064856e-03f, 8.40336134453781476161e-03f,
	8.33333333333333321769e-03f, 8.26446280991735560129e-03f,
		8.19672131147541026264e-03f, 8.13008130081300899039e-03f,
	8.06451612903225784068e-03f, 8.00000000000000016653e-03f,
		7.93650793650793606737e-03f, 7.87401574803149595372e-03f,
	7.81250000000000000000e-03f, 7.75193798449612392343e-03f,
		7.69230769230769273470e-03f, 7.63358778625954168678e-03f,
	7.57575757575757596785e-03f, 7.51879699248120259014e-03f,
		7.46268656716417896207e-03f, 7.40740740740740769010e-03f,
	7.35294117647058813325e-03f, 7.29927007299270048934e-03f,
		7.24637681159420298654e-03f, 7.19424460431654713699e-03f,
	7.14285714285714263411e-03f, 7.09219858156028351570e-03f,
		7.04225352112676072219e-03f, 6.99300699300699300093e-03f,
	6.94444444444444405895e-03f, 6.89655172413793093877e-03f,
		6.84931506849315030472e-03f, 6.80272108843537389594e-03f,
	6.75675675675675713183e-03f, 6.71140939597315421689e-03f,
		6.66666666666666709457e-03f, 6.62251655629139072273e-03f,
	6.57894736842105226637e-03f, 6.53594771241830085201e-03f,
		6.49350649350649393454e-03f, 6.45161290322580644602e-03f,
	6.41025641025641003401e-03f, 6.36942675159235700832e-03f,
		6.32911392405063281258e-03f, 6.28930817610062926903e-03f,
	6.25000000000000034694e-03f, 6.21118012422360206426e-03f,
		6.17283950617283916351e-03f, 6.13496932515337437680e-03f,
	6.09756097560975630911e-03f, 6.06060606060606060080e-03f,
		6.02409638554216898820e-03f, 5.98802395209580874680e-03f,
	5.95238095238095205053e-03f, 5.91715976331360932888e-03f,
		5.88235294117647050660e-03f, 5.84795321637426868122e-03f,
	5.81395348837209294257e-03f, 5.78034682080924826914e-03f,
		5.74712643678160911564e-03f, 5.71428571428571428076e-03f,
	5.68181818181818197588e-03f, 5.64971751412429376571e-03f,
		5.61797752808988748452e-03f, 5.58659217877094989996e-03f,
	5.55555555555555576758e-03f, 5.52486187845303844401e-03f,
		5.49450549450549493441e-03f, 5.46448087431693988597e-03f,
	5.43478260869565202307e-03f, 5.40540540540540570547e-03f,
		5.37634408602150580536e-03f, 5.34759358288770022399e-03f,
	5.31914893617021263678e-03f, 5.29100529100529071158e-03f,
		5.26315789473684198657e-03f, 5.23560209424083801422e-03f,
	5.20833333333333304421e-03f, 5.18134715025906755076e-03f,
		5.15463917525773186040e-03f, 5.12820512820512820068e-03f,
	5.10204081632653020512e-03f, 5.07614213197969503522e-03f,
		5.05050505050505093435e-03f, 5.02512562814070359168e-03f,
	5.00000000000000010408e-03f, 4.97512437810945264138e-03f,
		4.95049504950495055516e-03f, 4.92610837438423650875e-03f,
	4.90196078431372542217e-03f, 4.87804878048780487382e-03f,
		4.85436893203883453041e-03f, 4.83091787439613503524e-03f,
	4.80769230769230795919e-03f, 4.78468899521531081803e-03f,
		4.76190476190476233431e-03f, 4.73933649289099562241e-03f,
	4.71698113207547151809e-03f, 4.69483568075117381480e-03f,
		4.67289719626168189442e-03f, 4.65116279069767435406e-03f,
	4.62962962962962937263e-03f, 4.60829493087557603287e-03f,
		4.58715596330275254822e-03f, 4.56621004566210020315e-03f,
	4.54545454545454523376e-03f, 4.52488687782805470289e-03f,
		4.50450450450450446543e-03f, 4.48430493273542594285e-03f,
	4.46428571428571403790e-03f, 4.44444444444444444059e-03f,
		4.42477876106194684125e-03f, 4.40528634361233521061e-03f,
	4.38596491228070151092e-03f, 4.36681222707423558060e-03f,
		4.34782608695652179193e-03f, 4.32900432900432900057e-03f,
	4.31034482758620683673e-03f, 4.29184549356223174477e-03f,
		4.27350427350427393425e-03f, 4.25531914893617028289e-03f,
	4.23728813559322032428e-03f, 4.21940928270042158593e-03f,
		4.20168067226890738081e-03f, 4.18410041841004148172e-03f,
	4.16666666666666660884e-03f, 4.14937759336099585422e-03f,
		4.13223140495867780064e-03f, 4.11522633744856002058e-03f,
	4.09836065573770513132e-03f, 4.08163265306122485798e-03f,
		4.06504065040650449520e-03f, 4.04858299595141704619e-03f,
	4.03225806451612892034e-03f, 4.01606425702811208056e-03f,
		4.00000000000000008327e-03f, 3.98406374501992024961e-03f,
	3.96825396825396803369e-03f, 3.95256916996047404089e-03f,
		3.93700787401574797686e-03f, 3.92156862745098033773e-03f,
};

/* *********************************************************** */
