/*
 * Created on Mar 19, 2003
 *
 * @author henkel@cs.colorado.edu
 * 
 */
package bibtex.dom;

import java.io.PrintWriter;
import java.io.Serializable;

/**
 * @author 	henkel
 * @author 	Yann-Gal Guhneuc
 */
public class BibtexPreamble
	extends BibtexAbstractEntry
	implements Serializable {

	private BibtexAbstractValue content;

	protected BibtexPreamble(BibtexAbstractValue content) {
		this.content = content;
	}

	/* (non-Javadoc)
	 * @see bibtex.dom.BibtexNode#printBibtex(java.io.PrintWriter)
	 */
	public void print(PrintWriter writer) {
		writer.println("@preamble{");
		content.print(writer);
		writer.println("}");
	}

	/**
	 * @return BibtexAbstractValue
	 */
	public BibtexAbstractValue getContent() {
		return content;
	}

	/**
	 * Sets the content.
	 * @param content The content to set
	 */
	public void setContent(BibtexAbstractValue content) {
		this.content = content;
	}

}
