/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.IntegerContentCommand;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.StartElement;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import com.dickimawbooks.texparserlib.latex.glossaries.L2HGlsStyleTree;
import com.dickimawbooks.texparserlib.latex.latex3.TokenListCommand;
import java.io.IOException;

public class TreeSubGlossEntry
extends AbstractGlsCommand {
    protected L2HGlsStyleTree treeStyle;

    public TreeSubGlossEntry(L2HGlsStyleTree l2HGlsStyleTree) {
        this("subglossentry", l2HGlsStyleTree);
    }

    public TreeSubGlossEntry(String string, L2HGlsStyleTree l2HGlsStyleTree) {
        super(string, l2HGlsStyleTree.getGlossariesSty());
        this.treeStyle = l2HGlsStyleTree;
    }

    @Override
    public Object clone() {
        return new TreeSubGlossEntry(this.getName(), this.treeStyle);
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        int n = this.popInt(teXParser, teXObjectList);
        GlsLabel glsLabel = this.popEntryLabel(teXParser, teXObjectList);
        GlossaryEntry glossaryEntry = glsLabel.getEntry();
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        IntegerContentCommand integerContentCommand = this.treeStyle.getLevelCommand();
        int n2 = integerContentCommand.getValue();
        TokenListCommand tokenListCommand = this.treeStyle.getPendingCommand();
        TeXObjectList teXObjectList2 = tokenListCommand.getContent();
        if (glossaryEntry == null) {
            this.sty.undefWarnOrError(teXObjectList, "glossaries.entry.not.defined", glsLabel.getLabel());
        } else {
            TeXParserListener teXParserListener = teXParser.getListener();
            TeXObjectList teXObjectList3 = teXParserListener.createStack();
            if (n2 >= n) {
                for (int i = n; i <= n2 && !teXObjectList2.isEmpty(); ++i) {
                    teXObjectList3.add(teXObjectList2.pop());
                }
            } else {
                teXObjectList3.add(new StartElement("dd"));
                teXObjectList2.push(new EndElement("dd"));
            }
            teXObjectList3.add(new StartElement("dt"));
            teXObjectList3.add(teXParserListener.getControlSequence("glsentryitem"));
            teXObjectList3.add(glsLabel);
            teXObjectList3.add(teXParserListener.getControlSequence("glstreenamefmt"));
            Group group = teXParserListener.createGroup();
            teXObjectList3.add(group);
            group.add(teXParserListener.getControlSequence("glstarget"));
            group.add(glsLabel);
            if (this.treeStyle.showChildName()) {
                group.add(TeXParserUtils.createGroup(teXParserListener, teXParserListener.getControlSequence("glossentryname"), glsLabel));
            } else {
                group.add(teXParserListener.createGroup());
            }
            teXObjectList3.add(new EndElement("dt"));
            teXObjectList3.add(new StartElement("dd"));
            if (glossaryEntry.hasField("symbol")) {
                teXObjectList3.add(teXParserListener.getControlSequence("space"));
                teXObjectList3.add(teXParserListener.getOther(40));
                teXObjectList3.add(teXParserListener.getControlSequence("glossentrysymbol"));
                teXObjectList3.add(glsLabel);
                teXObjectList3.add(teXParserListener.getOther(41));
            }
            teXObjectList3.add(teXParserListener.getControlSequence("glstreechildpredesc"));
            teXObjectList3.add(teXParserListener.getControlSequence("glossentrydesc"));
            teXObjectList3.add(glsLabel);
            teXObjectList3.add(teXParserListener.getControlSequence("glspostdescription"));
            teXObjectList3.add(teXParserListener.getControlSequence("space"));
            teXObjectList3.add(teXObject);
            teXObjectList2.add(new EndElement("dd"));
            TeXParserUtils.process(teXObjectList3, teXParser, teXObjectList);
        }
        integerContentCommand.setValue(n);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

