/*
 * Decompiled with CFR 0.152.
 */
package de.nm.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import sun.security.action.GetPropertyAction;

public class XFile {
    private static final int BUFFERSIZE64KB = 65535;
    private static final SecureRandom random = new SecureRandom();

    public static File changeExt(File file, String oldext, String newext) {
        return new File(file.getName().replace(oldext, newext));
    }

    public static void copy(File srcfile, File destfile) throws IOException {
        BufferedInputStream insrc = new BufferedInputStream(new FileInputStream(srcfile));
        BufferedOutputStream outdest = new BufferedOutputStream(new FileOutputStream(destfile));
        byte[] buffer = new byte[65535];
        int len = 0;
        while ((len = insrc.read(buffer)) != -1) {
            outdest.write(buffer, 0, len);
        }
        insrc.close();
        outdest.close();
    }

    public static void copy(InputStream src, OutputStream dest) throws IOException {
        BufferedInputStream insrc = new BufferedInputStream(src, 65535);
        BufferedOutputStream outdest = new BufferedOutputStream(dest, 4095);
        byte[] buffer = new byte[65535];
        int len = 0;
        while ((len = insrc.read(buffer)) != -1) {
            outdest.write(buffer, 0, len);
        }
        insrc.close();
        outdest.close();
    }

    public static void copy(URL src, File dest) throws IOException {
        XFile.copy(src.openStream(), new FileOutputStream(dest));
    }

    public static ArrayList<FilePair> copyDirList(File srcdir, File destdir, boolean ifnewer, boolean overwrite, boolean copydotfiles, boolean skipfirstdir) throws IOException {
        ArrayList<FilePair> copyfiles = new ArrayList<FilePair>(1024);
        if (srcdir.isDirectory() && (copydotfiles || !srcdir.getName().startsWith("."))) {
            File[] files;
            File[] fileArray = files = srcdir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (copydotfiles || !file.getName().startsWith(".")) {
                    if (file.isDirectory()) {
                        File newdestdir = skipfirstdir ? destdir : XFile.createFile(destdir, file.getName());
                        ArrayList<FilePair> newlist = XFile.copyDirList(file, newdestdir, ifnewer, overwrite, copydotfiles, false);
                        copyfiles.addAll(newlist);
                    } else {
                        File destfile = XFile.createFile(destdir, file.getName());
                        if (ifnewer && !overwrite) {
                            if (XFile.isnewer(file, destfile)) {
                                copyfiles.add(new FilePair(file, destfile));
                            }
                        } else {
                            copyfiles.add(new FilePair(file, destfile));
                        }
                    }
                }
                ++n2;
            }
        }
        return copyfiles;
    }

    public static boolean copyisnewer(File srcfile, File destfile) throws IOException {
        if (XFile.isnewer(srcfile, destfile)) {
            XFile.copy(srcfile, destfile);
            return true;
        }
        return false;
    }

    public static File createDestFile(File srcfile, File dest) throws IOException {
        if (srcfile == null) {
            throw new FileNotFoundException("srcfile is null");
        }
        if (dest == null) {
            throw new FileNotFoundException("dest directory is null");
        }
        if (!dest.isDirectory()) {
            throw new IOException("dest direcotry is not a directroy!");
        }
        if (!srcfile.exists()) {
            throw new FileNotFoundException("srcfile ismissing!");
        }
        if (!srcfile.isFile()) {
            throw new IOException("srcfile is not a file!");
        }
        return new File(dest.getAbsoluteFile() + File.separator + srcfile.getName());
    }

    public static void createDirectory(File path) {
        if (path.exists()) {
            if (path.isFile()) {
                path.delete();
            } else {
                return;
            }
        }
        path.mkdir();
    }

    public static File createFile(File dir, String name) {
        if (dir == null || name == null) {
            return null;
        }
        return new File(dir.getAbsoluteFile() + File.separator + name);
    }

    public static File createFile(File dir, String name, String ext) {
        if (dir == null || name == null || ext == null) {
            return null;
        }
        return XFile.createFile(dir, String.valueOf(name) + "." + ext);
    }

    public static File createFile(String dir, String name) {
        if (dir == null || name == null) {
            return null;
        }
        return XFile.createFile(new File(dir), name);
    }

    public static File createFile(String dir, String name, String ext) {
        if (dir == null || name == null || ext == null) {
            return null;
        }
        return XFile.createFile(dir, String.valueOf(name) + "." + ext);
    }

    public static File createFileBeauty(File dir, String name, String ext) {
        if (dir == null || name == null || ext == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append(name.replace('.', '_').replace(" ", ""));
        return XFile.createFile(dir, buf.toString(), ext);
    }

    public static void createParent(File file) {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static File createTempDir(String prefix) throws IOException {
        return XFile.createTempDir(prefix, AccessController.doPrivileged(new GetPropertyAction("java.io.tmpdir")));
    }

    public static File createTempDir(String prefix, File parent) throws IOException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        long n = random.nextLong();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        File dir = new File(parent, String.valueOf(prefix) + Long.toString(n));
        if (dir.exists()) {
            if (dir.isFile()) {
                if (!dir.delete()) {
                    throw new IOException("File " + dir + " can not be deleted!");
                }
            } else if (!XFile.deleteDirectory(dir)) {
                throw new IOException("Directory " + dir + " can not be deleted!");
            }
        }
        dir.mkdir();
        return dir;
    }

    public static File createTempDir(String prefix, String parent) throws IOException {
        return XFile.createTempDir(prefix, new File(parent));
    }

    public static File createTmpFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix);
    }

    public static File createTmpFile(String prefix, String suffix, File dir) throws IOException {
        return File.createTempFile(prefix, suffix, dir);
    }

    public static File createTmpTextFile(InputStream in, String prefix, String suffix, File workdir, String encoding, int buffersize) throws IOException {
        String line;
        File tmp = XFile.createTmpFile(prefix, suffix, workdir);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), encoding), buffersize);
        BufferedReader bin = new BufferedReader(new InputStreamReader(in, encoding), buffersize);
        while ((line = bin.readLine()) != null) {
            out.write(line);
            out.newLine();
        }
        out.close();
        in.close();
        return tmp;
    }

    public static File createTmpTextFile(StringBuilder buf, String prefix, String suffix, File workdir, String encoding, int buffersize) throws IOException {
        File tmp = XFile.createTmpFile(prefix, suffix, workdir);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), encoding), buffersize);
        out.write(buf.toString());
        out.close();
        return tmp;
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists() && path.isDirectory()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    XFile.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return path.delete();
    }

    public static boolean diff(File srcfile, File destfile) throws IOException {
        BufferedInputStream insrc = new BufferedInputStream(new FileInputStream(srcfile));
        BufferedInputStream indest = new BufferedInputStream(new FileInputStream(destfile));
        long i = 0L;
        long n = srcfile.length();
        while (i < n) {
            if (insrc.read() != indest.read()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void findRecursive(List<File> filelist, File startDir, String regexp) {
        File[] files;
        File[] fileArray = files = startDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                XFile.findRecursive(filelist, file, regexp);
            } else if (file.getName().matches(regexp)) {
                filelist.add(file);
            }
            ++n2;
        }
    }

    public static void findRecursive(List<File> filelist, String startDir, String regexp) {
        XFile.findRecursive(filelist, new File(startDir), regexp);
    }

    public static String getBasename(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(46);
        String ext = "";
        if (pos >= 0) {
            ext = name.substring(pos);
        }
        if (ext.length() == 0) {
            return name;
        }
        return name.replace(ext, "");
    }

    public static String getBasename(String file) {
        int pos = file.lastIndexOf(46);
        String ext = "";
        if (pos >= 0) {
            ext = file.substring(pos);
        }
        if (ext.length() == 0) {
            return file;
        }
        return file.replace(ext, "");
    }

    public static String getExtension(String file) {
        int pos = file.lastIndexOf(46);
        if (pos >= 0) {
            return file.substring(pos + 1);
        }
        return "";
    }

    public static String getExtensionWithDot(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            return name.substring(pos);
        }
        return "";
    }

    public static String getExtensionWithDot(String file) {
        int pos = file.lastIndexOf(46);
        if (pos >= 0) {
            return file.substring(pos);
        }
        return "";
    }

    public static InputStream getInputStream(File file) throws IOException {
        return new BufferedInputStream(new FileInputStream(file), 65535);
    }

    public static OutputStream getOutputStream(File file) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(file), 65535);
    }

    public static BufferedReader getReader(File file, String encoding) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding), 65535);
    }

    public static BufferedWriter getWriter(File file, String encoding) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding), 65535);
    }

    public static boolean isnewer(File srcfile, File destfile) throws IOException {
        if (!destfile.exists()) {
            return true;
        }
        if (srcfile.length() != destfile.length()) {
            return true;
        }
        return XFile.diff(srcfile, destfile);
    }

    public static boolean isnewerDate(File srcfile, File destfile) throws IOException {
        if (!destfile.exists()) {
            return true;
        }
        return destfile.lastModified() < srcfile.lastModified();
    }

    public static void removeOther(File destdir, File workingfile, String[] ext) {
        File[] ff;
        File[] fileArray = ff = destdir.listFiles(new RemoveFilenameFilter(workingfile, ext));
        int n = ff.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    public static boolean rename(File workingdir, File src, File dest) {
        File d = new File(workingdir.getAbsoluteFile() + File.separator + dest.getName());
        File s = new File(workingdir.getAbsoluteFile() + File.separator + src.getName());
        if (d.exists()) {
            d.delete();
        }
        return s.renameTo(d);
    }

    public static String readFile(File file, String encoding) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file + " not found!");
        }
        if (file.length() > 65535L) {
            throw new IOException("File is too big for a string (>64kb)!");
        }
        byte[] buf = new byte[(int)file.length()];
        FileInputStream in = new FileInputStream(file);
        in.read(buf);
        in.close();
        return new String(buf, encoding);
    }

    public static void storeString(File file, String text, String encoding) throws IOException {
        if (text == null) {
            throw new IOException("'text' is null!");
        }
        if (encoding == null) {
            throw new IOException("'encoding' is null!");
        }
        FileOutputStream out = new FileOutputStream(file);
        out.write(text.getBytes(encoding));
        out.close();
    }

    public static class FilePair {
        private final File destFile;
        private final File srcFile;

        public FilePair(File src, File dest) {
            this.srcFile = src;
            this.destFile = dest;
        }

        public File getDestFile() {
            return this.destFile;
        }

        public File getSrcFile() {
            return this.srcFile;
        }
    }

    private static class RemoveFilenameFilter
    implements FilenameFilter {
        private final String basename;
        private final String[] ext;

        public RemoveFilenameFilter(File workingfile, String[] ext) {
            this.basename = XFile.getBasename(workingfile);
            this.ext = ext;
            Arrays.sort(this.ext);
        }

        @Override
        public boolean accept(File dir, String name) {
            String sext;
            String namext;
            return name.startsWith(this.basename) && (namext = XFile.getExtensionWithDot(name)).length() > 0 && Arrays.binarySearch(this.ext, sext = namext.substring(1)) < 0;
        }
    }
}

