/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.mixins;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.http.Link;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class ZoneRefresh {
    @Parameter(required=true, defaultPrefix="literal")
    private int period;
    @Parameter
    private Object[] context;
    @InjectContainer
    private Zone zone;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    @Inject
    private ComponentResources resources;

    ZoneRefresh(Object[] context, ComponentResources resources, JavaScriptSupport javaScriptSupport, Zone zone) {
        this.context = context;
        this.resources = resources;
        this.javaScriptSupport = javaScriptSupport;
        this.zone = zone;
    }

    @AfterRender
    void addJavaScript() {
        Link link = this.resources.createEventLink("zoneRefresh", this.context);
        this.javaScriptSupport.require("t5/core/zone-refresh").with(this.zone.getClientId(), this.period, link.toString());
    }

    Object onZoneRefresh(EventContext eventContext) {
        CaptureResultCallback callback = new CaptureResultCallback();
        this.resources.triggerContextEvent("refresh", eventContext, callback);
        if (callback.getResult() != null) {
            return callback.getResult();
        }
        return this.zone.getBody();
    }
}

