/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.apache.tapestry5.jmx.MBeanSupport;
import org.slf4j.Logger;

public class MBeanSupportImpl
implements MBeanSupport {
    private final Logger logger;
    private final MBeanServer server;
    private final OneShotLock lock = new OneShotLock();
    private final Set<ObjectName> registeredBeans = CollectionFactory.newSet();

    public MBeanSupportImpl(Logger logger) {
        this.logger = logger;
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        MBeanServer server = null;
        if (servers != null && 0 < servers.size()) {
            server = (MBeanServer)servers.get(0);
        }
        if (server == null) {
            server = ManagementFactory.getPlatformMBeanServer();
        }
        this.server = server;
    }

    @PostInjection
    public void listenForShutdown(RegistryShutdownHub hub) {
        hub.addRegistryShutdownListener(new Runnable(){

            @Override
            public void run() {
                MBeanSupportImpl.this.registryDidShutdown();
            }
        });
    }

    @Override
    public void register(Object bean, String name) {
        this.register(bean, MBeanSupportImpl.toObjectName(name));
    }

    private static ObjectName toObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void register(Object object, ObjectName objectName) {
        this.lock.check();
        if (this.server.isRegistered(objectName)) {
            return;
        }
        try {
            this.server.registerMBean(object, objectName);
            this.registeredBeans.add(objectName);
            this.logger.info(String.format("Registered MBean '%s' with server", objectName));
        }
        catch (Exception e) {
            this.logger.error(String.format("Failed to register MBean '%s' with server", objectName), (Throwable)e);
        }
    }

    @Override
    public void unregister(ObjectName objectName) {
        this.lock.check();
        this.doUnregister(objectName);
    }

    private void doUnregister(ObjectName objectName) {
        if (this.server.isRegistered(objectName)) {
            try {
                this.server.unregisterMBean(objectName);
                this.logger.info(String.format("Unregistered MBean '%s' from server", objectName));
                if (this.registeredBeans.contains(objectName)) {
                    this.registeredBeans.remove(objectName);
                }
            }
            catch (Exception e) {
                this.logger.error(String.format("Failed to unregister MBean '%s' from server", objectName), (Throwable)e);
            }
        }
    }

    private void registryDidShutdown() {
        ObjectName[] objects;
        this.lock.lock();
        for (ObjectName name : objects = this.registeredBeans.toArray(new ObjectName[this.registeredBeans.size()])) {
            this.doUnregister(name);
        }
        this.registeredBeans.clear();
    }
}

