/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMergeMatrix;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.runtime.util.DataConverter;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.runtime.util.LocalFileUtils;

public class ResultMergeLocalFile
extends ResultMergeMatrix {
    private static final long serialVersionUID = -6905893742840020489L;
    public static final boolean ALLOW_COPY_CELLFILES = false;
    private IDSequence _seq = new IDSequence();

    public ResultMergeLocalFile(MatrixObject out, MatrixObject[] in, String outputFilename, boolean accum) {
        super(out, in, outputFilename, accum);
    }

    @Override
    public MatrixObject executeSerialMerge() {
        MatrixObject moNew = null;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ResultMerge (local, file): Execute serial merge for output " + ((MatrixObject)this._output).hashCode() + " (fname=" + ((MatrixObject)this._output).getFileName() + ")"));
        }
        try {
            ArrayList<MatrixObject> inMO = new ArrayList<MatrixObject>();
            for (MatrixObject in : (MatrixObject[])this._inputs) {
                if (in == null || in == this._output) continue;
                in.exportData();
                inMO.add(in);
            }
            if (!inMO.isEmpty()) {
                ((MatrixObject)this._output).exportData();
                this.merge(this._outputFName, (MatrixObject)this._output, inMO);
                moNew = this.createNewMatrixObject((MatrixObject)this._output, inMO);
            } else {
                moNew = (MatrixObject)this._output;
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return moNew;
    }

    @Override
    public MatrixObject executeParallelMerge(int par) {
        return this.executeSerialMerge();
    }

    private MatrixObject createNewMatrixObject(MatrixObject output, ArrayList<MatrixObject> inMO) {
        MetaDataFormat metadata = (MetaDataFormat)((MatrixObject)this._output).getMetaData();
        MatrixObject moNew = new MatrixObject(((MatrixObject)this._output).getValueType(), this._outputFName);
        DataCharacteristics mcOld = metadata.getDataCharacteristics();
        MatrixCharacteristics mc = new MatrixCharacteristics(mcOld);
        mc.setNonZeros(this._isAccum ? -1L : this.computeNonZeros(output, inMO));
        moNew.setMetaData(new MetaDataFormat(mc, metadata.getFileFormat()));
        return moNew;
    }

    private void merge(String fnameNew, MatrixObject outMo, ArrayList<MatrixObject> inMO) {
        boolean withCompare;
        Types.FileFormat fmt = ((MetaDataFormat)outMo.getMetaData()).getFileFormat();
        boolean bl = withCompare = outMo.getNnz() != 0L;
        if (fmt == Types.FileFormat.BINARY) {
            if (withCompare) {
                this.mergeBinaryBlockWithComp(fnameNew, outMo, inMO);
            } else {
                this.mergeBinaryBlockWithoutComp(fnameNew, outMo, inMO);
            }
        }
    }

    private void mergeBinaryBlockWithoutComp(String fnameNew, MatrixObject outMo, ArrayList<MatrixObject> inMO) {
        String fnameStaging = LocalFileUtils.getUniqueWorkingDir("resultmerge");
        try {
            HDFSTool.deleteFileIfExistOnHDFS(fnameNew);
            for (MatrixObject in : inMO) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("ResultMerge (local, file): Merge input " + in.hashCode() + " (fname=" + in.getFileName() + ")"));
                }
                this.createBinaryBlockStagingFile(fnameStaging, in);
            }
            this.createBinaryBlockResultFile(fnameStaging, null, fnameNew, (MetaDataFormat)outMo.getMetaData(), false);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to merge binary block results.", ex);
        }
        LocalFileUtils.cleanupWorkingDirectory(fnameStaging);
    }

    private void mergeBinaryBlockWithComp(String fnameNew, MatrixObject outMo, ArrayList<MatrixObject> inMO) {
        String fnameStaging = LocalFileUtils.getUniqueWorkingDir("resultmerge");
        String fnameStagingCompare = LocalFileUtils.getUniqueWorkingDir("resultmerge");
        try {
            HDFSTool.deleteFileIfExistOnHDFS(fnameNew);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("ResultMerge (local, file): Create merge compare matrix for output " + outMo.hashCode() + " (fname=" + outMo.getFileName() + ")"));
            }
            this.createBinaryBlockStagingFile(fnameStagingCompare, outMo);
            for (MatrixObject in : inMO) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("ResultMerge (local, file): Merge input " + in.hashCode() + " (fname=" + in.getFileName() + ")"));
                }
                this.createBinaryBlockStagingFile(fnameStaging, in);
            }
            this.createBinaryBlockResultFile(fnameStaging, fnameStagingCompare, fnameNew, (MetaDataFormat)outMo.getMetaData(), true);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to merge binary block results.", ex);
        }
        LocalFileUtils.cleanupWorkingDirectory(fnameStaging);
        LocalFileUtils.cleanupWorkingDirectory(fnameStagingCompare);
    }

    private void createBinaryBlockStagingFile(String fnameStaging, MatrixObject mo) throws IOException {
        MatrixIndexes key = new MatrixIndexes();
        MatrixBlock value = new MatrixBlock();
        JobConf tmpJob = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path tmpPath = new Path(mo.getFileName());
        FileSystem fs = IOUtilFunctions.getFileSystem(tmpPath, (Configuration)tmpJob);
        for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, tmpPath)) {
            try (SequenceFile.Reader reader = new SequenceFile.Reader(fs, lpath, (Configuration)tmpJob);){
                while (reader.next((Writable)key, (Writable)value)) {
                    String lname = key.getRowIndex() + "_" + key.getColumnIndex();
                    String dir = fnameStaging + "/" + lname;
                    if (value.getNonZeros() <= 0L) continue;
                    LocalFileUtils.checkAndCreateStagingDir(dir);
                    LocalFileUtils.writeMatrixBlockToLocal(dir + "/" + this._seq.getNextID(), value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBinaryBlockResultFile(String fnameStaging, String fnameStagingCompare, String fnameNew, MetaDataFormat metadata, boolean withCompare) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fnameNew);
        DataCharacteristics mc = metadata.getDataCharacteristics();
        long rlen = mc.getRows();
        long clen = mc.getCols();
        int blen = mc.getBlocksize();
        SequenceFile.Writer writer = IOUtilFunctions.getSeqWriter(path, (Configuration)job, 1);
        try {
            MatrixIndexes indexes = new MatrixIndexes();
            for (long brow = 1L; brow <= (long)Math.ceil((double)rlen / (double)blen); ++brow) {
                for (long bcol = 1L; bcol <= (long)Math.ceil((double)clen / (double)blen); ++bcol) {
                    File dir = new File(fnameStaging + "/" + brow + "_" + bcol);
                    File dir2 = new File(fnameStagingCompare + "/" + brow + "_" + bcol);
                    MatrixBlock mb = null;
                    if (dir.exists()) {
                        if (withCompare && dir2.exists()) {
                            String[] lnames2 = dir2.list();
                            if (lnames2.length != 1) {
                                throw new DMLRuntimeException("Unable to merge results because multiple compare blocks found.");
                            }
                            mb = LocalFileUtils.readMatrixBlockFromLocal(dir2 + "/" + lnames2[0]);
                            boolean appendOnly = mb.isInSparseFormat();
                            DenseBlock compare = DataConverter.convertToDenseBlock(mb, true);
                            for (String lname : dir.list()) {
                                MatrixBlock tmp = LocalFileUtils.readMatrixBlockFromLocal(dir + "/" + lname);
                                if (this._isAccum) {
                                    this.mergeWithoutComp(mb, tmp, compare, appendOnly);
                                    continue;
                                }
                                this.mergeWithComp(mb, tmp, compare);
                            }
                            if (appendOnly && !this._isAccum) {
                                mb.sortSparseRows();
                            }
                            mb.examSparsity();
                        } else {
                            boolean appendOnly = false;
                            for (String lname : dir.list()) {
                                if (mb == null) {
                                    mb = LocalFileUtils.readMatrixBlockFromLocal(dir + "/" + lname);
                                    appendOnly = mb.isInSparseFormat();
                                    continue;
                                }
                                MatrixBlock tmp = LocalFileUtils.readMatrixBlockFromLocal(dir + "/" + lname);
                                this.mergeWithoutComp(mb, tmp, null, appendOnly);
                            }
                            if (appendOnly && !this._isAccum) {
                                mb.sortSparseRows();
                            }
                            mb.examSparsity();
                        }
                    } else {
                        int maxRow = (int)((brow - 1L) * (long)blen + (long)blen < rlen ? (long)blen : rlen - (brow - 1L) * (long)blen);
                        int maxCol = (int)((bcol - 1L) * (long)blen + (long)blen < clen ? (long)blen : clen - (bcol - 1L) * (long)blen);
                        mb = new MatrixBlock(maxRow, maxCol, true);
                    }
                    indexes.setIndexes(brow, bcol);
                    writer.append((Writable)indexes, (Writable)mb);
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }
}

