/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ACachingMBDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictLibMatrixMult;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.LibMatrixMult;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.RightScalarOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;
import org.apache.sysds.utils.MemoryEstimates;

public class Dictionary
extends ACachingMBDictionary {
    private static final long serialVersionUID = -6517136537249507753L;
    protected final double[] _values;

    protected Dictionary(double[] values) {
        this._values = values;
    }

    public static Dictionary create(double[] values) {
        if (values == null) {
            throw new DMLCompressionException("Invalid construction of dictionary with null array");
        }
        if (values.length == 0) {
            throw new DMLCompressionException("Invalid construction of dictionary with empty array");
        }
        boolean nonZero = false;
        for (double d : values) {
            if (d == 0.0) continue;
            nonZero = true;
            break;
        }
        return nonZero ? new Dictionary(values) : null;
    }

    public static Dictionary createNoCheck(double[] values) {
        return new Dictionary(values);
    }

    @Override
    public double[] getValues() {
        return this._values;
    }

    @Override
    public double getValue(int i) {
        return this._values[i];
    }

    @Override
    public final double getValue(int r, int c, int nCol) {
        return this._values[r * nCol + c];
    }

    @Override
    public long getInMemorySize() {
        return Dictionary.getInMemorySize(this.size());
    }

    public static long getInMemorySize(int valuesCount) {
        return 16L + (long)MemoryEstimates.doubleArrayCost(valuesCount);
    }

    @Override
    public double aggregate(double init, Builtin fn) {
        double ret = init;
        for (int i = 0; i < this._values.length; ++i) {
            ret = fn.execute(ret, this._values[i]);
        }
        return ret;
    }

    @Override
    public double aggregateWithReference(double init, Builtin fn, double[] reference, boolean def) {
        int i;
        int nCol = reference.length;
        double ret = init;
        for (i = 0; i < this._values.length; ++i) {
            ret = fn.execute(ret, this._values[i] + reference[i % nCol]);
        }
        if (def) {
            for (i = 0; i < nCol; ++i) {
                ret = fn.execute(ret, reference[i]);
            }
        }
        return ret;
    }

    @Override
    public double[] aggregateRows(Builtin fn, int nCol) {
        if (nCol == 1) {
            return this._values;
        }
        int nRows = this._values.length / nCol;
        double[] res = new double[nRows];
        for (int i = 0; i < nRows; ++i) {
            int off = i * nCol;
            res[i] = this._values[off];
            for (int j = off + 1; j < off + nCol; ++j) {
                res[i] = fn.execute(res[i], this._values[j]);
            }
        }
        return res;
    }

    @Override
    public double[] aggregateRowsWithDefault(Builtin fn, double[] defaultTuple) {
        int nCol = defaultTuple.length;
        int nRows = this._values.length / nCol;
        double[] res = new double[nRows + 1];
        for (int i = 0; i < nRows; ++i) {
            int off = i * nCol;
            res[i] = this._values[off];
            for (int j = off + 1; j < off + nCol; ++j) {
                res[i] = fn.execute(res[i], this._values[j]);
            }
        }
        int def = res.length - 1;
        res[def] = defaultTuple[0];
        for (int i = 1; i < nCol; ++i) {
            res[def] = fn.execute(res[def], defaultTuple[i]);
        }
        return res;
    }

    @Override
    public double[] aggregateRowsWithReference(Builtin fn, double[] reference) {
        int i;
        int nCol = reference.length;
        int nRows = this._values.length / nCol;
        double[] res = new double[nRows + 1];
        int off = 0;
        for (i = 0; i < nRows; ++i) {
            res[i] = this._values[off++] + reference[0];
            for (int j = 1; j < nCol; ++j) {
                res[i] = fn.execute(res[i], this._values[off++] + reference[j]);
            }
        }
        res[nRows] = reference[0];
        for (i = 0; i < nCol; ++i) {
            res[nRows] = fn.execute(res[nRows], reference[i]);
        }
        return res;
    }

    @Override
    public IDictionary applyScalarOp(ScalarOperator op) {
        if (op.fn instanceof Multiply) {
            return this.applyScalarMultOp(op.getConstant());
        }
        return this.applyScalarGeneric(op);
    }

    private IDictionary applyScalarGeneric(ScalarOperator op) {
        double[] retV = new double[this._values.length];
        for (int i = 0; i < this._values.length; ++i) {
            retV[i] = op.executeScalar(this._values[i]);
        }
        return Dictionary.create(retV);
    }

    private IDictionary applyScalarMultOp(double v) {
        double[] retV = new double[this._values.length];
        LibMatrixMult.vectMultiplyAdd(v, this._values, retV, 0, 0, this._values.length);
        return Dictionary.create(retV);
    }

    @Override
    public IDictionary applyScalarOpAndAppend(ScalarOperator op, double v0, int nCol) {
        int i;
        double[] retV = new double[this._values.length + nCol];
        for (i = 0; i < this._values.length; ++i) {
            retV[i] = op.executeScalar(this._values[i]);
        }
        for (i = this._values.length; i < retV.length; ++i) {
            retV[i] = v0;
        }
        return Dictionary.create(retV);
    }

    @Override
    public Dictionary applyUnaryOp(UnaryOperator op) {
        double[] retV = new double[this._values.length];
        for (int i = 0; i < this._values.length; ++i) {
            retV[i] = op.fn.execute(this._values[i]);
        }
        return Dictionary.create(retV);
    }

    @Override
    public IDictionary applyUnaryOpAndAppend(UnaryOperator op, double v0, int nCol) {
        int i;
        double[] retV = new double[this._values.length + nCol];
        for (i = 0; i < this._values.length; ++i) {
            retV[i] = op.fn.execute(this._values[i]);
        }
        for (i = this._values.length; i < retV.length; ++i) {
            retV[i] = v0;
        }
        return Dictionary.create(retV);
    }

    @Override
    public Dictionary applyScalarOpWithReference(ScalarOperator op, double[] reference, double[] newReference) {
        double[] retV = new double[this._values.length];
        int nCol = reference.length;
        int nRow = this._values.length / nCol;
        int off = 0;
        for (int i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                retV[off] = op.executeScalar(this._values[off] + reference[j]) - newReference[j];
                ++off;
            }
        }
        return Dictionary.create(retV);
    }

    @Override
    public IDictionary applyUnaryOpWithReference(UnaryOperator op, double[] reference, double[] newReference) {
        double[] retV = new double[this._values.length];
        int nCol = reference.length;
        int nRow = this._values.length / nCol;
        int off = 0;
        for (int i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                retV[off] = op.fn.execute(this._values[off] + reference[j]) - newReference[j];
                ++off;
            }
        }
        return Dictionary.create(retV);
    }

    @Override
    public Dictionary binOpRight(BinaryOperator op, double[] v, IColIndex colIndexes) {
        ValueFunction fn = op.fn;
        double[] retVals = new double[this._values.length];
        int len = this.size();
        int lenV = colIndexes.size();
        for (int i = 0; i < len; ++i) {
            retVals[i] = fn.execute(this._values[i], v[colIndexes.get(i % lenV)]);
        }
        return Dictionary.create(retVals);
    }

    @Override
    public Dictionary binOpRight(BinaryOperator op, double[] v) {
        ValueFunction fn = op.fn;
        double[] retVals = new double[this._values.length];
        int len = this.size();
        int lenV = v.length;
        for (int i = 0; i < len; ++i) {
            retVals[i] = fn.execute(this._values[i], v[i % lenV]);
        }
        return Dictionary.create(retVals);
    }

    @Override
    public IDictionary binOpRightAndAppend(BinaryOperator op, double[] v, IColIndex colIndexes) {
        int i;
        ValueFunction fn = op.fn;
        double[] retVals = new double[this._values.length + colIndexes.size()];
        int lenV = colIndexes.size();
        for (i = 0; i < this._values.length; ++i) {
            retVals[i] = fn.execute(this._values[i], v[colIndexes.get(i % lenV)]);
        }
        for (i = this._values.length; i < retVals.length; ++i) {
            retVals[i] = fn.execute(0.0, v[colIndexes.get(i % lenV)]);
        }
        return Dictionary.create(retVals);
    }

    @Override
    public Dictionary binOpRightWithReference(BinaryOperator op, double[] v, IColIndex colIndexes, double[] reference, double[] newReference) {
        ValueFunction fn = op.fn;
        double[] retV = new double[this._values.length];
        int nCol = reference.length;
        int nRow = this._values.length / nCol;
        int off = 0;
        for (int i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                retV[off] = fn.execute(this._values[off] + reference[j], v[colIndexes.get(j)]) - newReference[j];
                ++off;
            }
        }
        return Dictionary.create(retV);
    }

    @Override
    public final Dictionary binOpLeft(BinaryOperator op, double[] v, IColIndex colIndexes) {
        ValueFunction fn = op.fn;
        double[] retVals = new double[this._values.length];
        int lenV = colIndexes.size();
        for (int i = 0; i < this._values.length; ++i) {
            retVals[i] = fn.execute(v[colIndexes.get(i % lenV)], this._values[i]);
        }
        return Dictionary.create(retVals);
    }

    @Override
    public IDictionary binOpLeftAndAppend(BinaryOperator op, double[] v, IColIndex colIndexes) {
        int i;
        ValueFunction fn = op.fn;
        double[] retVals = new double[this._values.length + colIndexes.size()];
        int lenV = colIndexes.size();
        for (i = 0; i < this._values.length; ++i) {
            retVals[i] = fn.execute(v[colIndexes.get(i % lenV)], this._values[i]);
        }
        for (i = this._values.length; i < retVals.length; ++i) {
            retVals[i] = fn.execute(v[colIndexes.get(i % lenV)], 0.0);
        }
        return Dictionary.create(retVals);
    }

    @Override
    public Dictionary binOpLeftWithReference(BinaryOperator op, double[] v, IColIndex colIndexes, double[] reference, double[] newReference) {
        ValueFunction fn = op.fn;
        double[] retV = new double[this._values.length];
        int nCol = reference.length;
        int nRow = this._values.length / nCol;
        int off = 0;
        for (int i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                retV[off] = fn.execute(v[colIndexes.get(j)], this._values[off] + reference[j]) - newReference[j];
                ++off;
            }
        }
        return Dictionary.create(retV);
    }

    @Override
    public Dictionary clone() {
        return Dictionary.createNoCheck((double[])this._values.clone());
    }

    public static Dictionary read(DataInput in) throws IOException {
        int numVals = in.readInt();
        double[] values = new double[numVals];
        for (int i = 0; i < numVals; ++i) {
            values[i] = in.readDouble();
        }
        return Dictionary.createNoCheck(values);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(DictionaryFactory.Type.FP64_DICT.ordinal());
        out.writeInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            out.writeDouble(this._values[i]);
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        return 5 + 8 * this.size();
    }

    private int size() {
        return this._values.length;
    }

    @Override
    public int getNumberOfValues(int nCol) {
        return this._values.length / nCol;
    }

    @Override
    public int getNumberOfColumns(int nrow) {
        return this._values.length / nrow;
    }

    @Override
    public double[] sumAllRowsToDouble(int nrColumns) {
        if (nrColumns == 1) {
            return this.getValues();
        }
        int numVals = this.getNumberOfValues(nrColumns);
        double[] ret = new double[numVals];
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.sumRow(k, nrColumns);
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleWithDefault(double[] defaultTuple) {
        int nCol = defaultTuple.length;
        int numVals = this.getNumberOfValues(nCol);
        double[] ret = new double[numVals + 1];
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.sumRow(k, nCol);
        }
        for (int i = 0; i < nCol; ++i) {
            int n = ret.length - 1;
            ret[n] = ret[n] + defaultTuple[i];
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleWithReference(double[] reference) {
        int nCol = reference.length;
        int numVals = this.getNumberOfValues(nCol);
        double[] ret = new double[numVals + 1];
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.sumRowWithReference(k, nCol, reference);
        }
        for (int i = 0; i < nCol; ++i) {
            int n = numVals;
            ret[n] = ret[n] + reference[i];
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleSq(int nrColumns) {
        int numVals = this.getNumberOfValues(nrColumns);
        double[] ret = new double[numVals];
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.sumRowSq(k, nrColumns);
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleSqWithDefault(double[] defaultTuple) {
        int nCol = defaultTuple.length;
        int numVals = this.getNumberOfValues(nCol);
        double[] ret = new double[numVals + 1];
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.sumRowSq(k, nCol);
        }
        for (int i = 0; i < nCol; ++i) {
            int n = ret.length - 1;
            ret[n] = ret[n] + defaultTuple[i] * defaultTuple[i];
        }
        return ret;
    }

    @Override
    public double[] productAllRowsToDouble(int nCol) {
        int numVals = this.getNumberOfValues(nCol);
        double[] ret = new double[numVals];
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.prodRow(k, nCol);
        }
        return ret;
    }

    @Override
    public double[] productAllRowsToDoubleWithDefault(double[] defaultTuple) {
        int nCol = defaultTuple.length;
        int numVals = this.getNumberOfValues(nCol);
        double[] ret = new double[numVals + 1];
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.prodRow(k, nCol);
        }
        ret[numVals] = defaultTuple[0];
        for (int i = 1; i < nCol; ++i) {
            int n = numVals;
            ret[n] = ret[n] * defaultTuple[i];
        }
        return ret;
    }

    @Override
    public double[] productAllRowsToDoubleWithReference(double[] reference) {
        int nCol = reference.length;
        int numVals = this.getNumberOfValues(nCol);
        double[] ret = new double[numVals + 1];
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.prodRowWithReference(k, nCol, reference);
        }
        ret[ret.length - 1] = reference[0];
        for (int i = 1; i < nCol; ++i) {
            int n = ret.length - 1;
            ret[n] = ret[n] * reference[i];
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleSqWithReference(double[] reference) {
        int nCol = reference.length;
        int numVals = this.getNumberOfValues(nCol);
        double[] ret = new double[numVals + 1];
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.sumRowSqWithReference(k, nCol, reference);
        }
        for (int i = 0; i < nCol; ++i) {
            int n = numVals;
            ret[n] = ret[n] + reference[i] * reference[i];
        }
        return ret;
    }

    private double sumRow(int k, int nrColumns) {
        int valOff = k * nrColumns;
        double res = 0.0;
        for (int i = 0; i < nrColumns; ++i) {
            res += this._values[valOff + i];
        }
        return res;
    }

    public double sumRowWithReference(int k, int nrColumns, double[] reference) {
        int valOff = k * nrColumns;
        double res = 0.0;
        for (int i = 0; i < nrColumns; ++i) {
            res += this._values[valOff + i] + reference[i];
        }
        return res;
    }

    private double sumRowSq(int k, int nrColumns) {
        int valOff = k * nrColumns;
        double res = 0.0;
        for (int i = 0; i < nrColumns; ++i) {
            res += this._values[valOff + i] * this._values[valOff + i];
        }
        return res;
    }

    private double prodRow(int k, int nrColumns) {
        int valOff = k * nrColumns;
        int end = valOff + nrColumns;
        double res = this._values[valOff];
        for (int i = valOff + 1; i < end && res != 0.0; res *= this._values[i], ++i) {
        }
        return res;
    }

    private double prodRowWithReference(int k, int nrColumns, double[] reference) {
        int valOff = k * nrColumns;
        double res = this._values[valOff] + reference[0];
        for (int i = 1; i < nrColumns; ++i) {
            res *= this._values[valOff + i] + reference[i];
        }
        return res;
    }

    private double sumRowSqWithReference(int k, int nrColumns, double[] reference) {
        int valOff = k * nrColumns;
        double res = 0.0;
        for (int i = 0; i < nrColumns; ++i) {
            double v = this._values[valOff + i] + reference[i];
            res += v * v;
        }
        return res;
    }

    @Override
    public void colSum(double[] c, int[] counts, IColIndex colIndexes) {
        int nCol = colIndexes.size();
        for (int k = 0; k < counts.length; ++k) {
            int cntk = counts[k];
            int off = k * nCol;
            for (int j = 0; j < nCol; ++j) {
                int n = colIndexes.get(j);
                c[n] = c[n] + this._values[off + j] * (double)cntk;
            }
        }
    }

    @Override
    public void colSumSq(double[] c, int[] counts, IColIndex colIndexes) {
        int nCol = colIndexes.size();
        int nRow = counts.length;
        int off = 0;
        for (int k = 0; k < nRow; ++k) {
            int cntk = counts[k];
            for (int j = 0; j < nCol; ++j) {
                double v = this._values[off++];
                int n = colIndexes.get(j);
                c[n] = c[n] + v * v * (double)cntk;
            }
        }
    }

    @Override
    public void colProduct(double[] res, int[] counts, IColIndex colIndexes) {
        int nCol = colIndexes.size();
        for (int k = 0; k < counts.length; ++k) {
            int cntk = counts[k];
            int off = k * nCol;
            for (int j = 0; j < nCol; ++j) {
                int n = colIndexes.get(j);
                res[n] = res[n] * Math.pow(this._values[off + j], cntk);
            }
        }
        Dictionary.correctNan(res, colIndexes);
    }

    @Override
    public void colProductWithReference(double[] res, int[] counts, IColIndex colIndexes, double[] reference) {
        int nCol = colIndexes.size();
        for (int k = 0; k < counts.length; ++k) {
            int cntk = counts[k];
            int off = k * nCol;
            for (int j = 0; j < nCol; ++j) {
                int n = colIndexes.get(j);
                res[n] = res[n] * Math.pow(this._values[off + j] + reference[j], cntk);
            }
        }
        Dictionary.correctNan(res, colIndexes);
    }

    @Override
    public void colSumSqWithReference(double[] c, int[] counts, IColIndex colIndexes, double[] reference) {
        int nCol = colIndexes.size();
        int nRow = counts.length;
        int off = 0;
        for (int k = 0; k < nRow; ++k) {
            int cntk = counts[k];
            for (int j = 0; j < nCol; ++j) {
                double v = this._values[off++] + reference[j];
                int n = colIndexes.get(j);
                c[n] = c[n] + v * v * (double)cntk;
            }
        }
    }

    @Override
    public double sum(int[] counts, int nCol) {
        double out = 0.0;
        int valOff = 0;
        for (int k = 0; k < counts.length; ++k) {
            double rowSum = 0.0;
            int countK = counts[k];
            for (int j = 0; j < nCol; ++j) {
                rowSum += this._values[valOff++] * (double)countK;
            }
            out += rowSum;
        }
        return out;
    }

    @Override
    public double sumSq(int[] counts, int nCol) {
        double out = 0.0;
        int valOff = 0;
        for (int k = 0; k < counts.length; ++k) {
            int countK = counts[k];
            for (int j = 0; j < nCol; ++j) {
                double val = this._values[valOff++];
                out += val * val * (double)countK;
            }
        }
        return out;
    }

    @Override
    public double sumSqWithReference(int[] counts, double[] reference) {
        int nCol = reference.length;
        int nRow = counts.length;
        double out = 0.0;
        int valOff = 0;
        for (int k = 0; k < nRow; ++k) {
            int countK = counts[k];
            for (int j = 0; j < nCol; ++j) {
                double val = this._values[valOff++] + reference[j];
                out += val * val * (double)countK;
            }
        }
        return out;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this._values.length * 3 + 10);
        sb.append("Dictionary : ");
        Dictionary.stringArray(sb, this._values);
        return sb.toString();
    }

    private static void stringArray(StringBuilder sb, double[] val) {
        sb.append("[");
        if (val.length > 0) {
            sb.append(Dictionary.doubleToString(val[0]));
            for (int i = 1; i < val.length; ++i) {
                sb.append(", ");
                sb.append(Dictionary.doubleToString(val[i]));
            }
        }
        sb.append("]");
    }

    @Override
    public String getString(int colIndexes) {
        StringBuilder sb = new StringBuilder();
        if (colIndexes == 1) {
            Dictionary.stringArray(sb, this._values);
        } else {
            sb.append("[\n\t");
            for (int i = 0; i < this._values.length - 1; ++i) {
                sb.append(Dictionary.doubleToString(this._values[i]));
                sb.append(i % colIndexes == colIndexes - 1 ? "\n\t" : ", ");
            }
            sb.append(Dictionary.doubleToString(this._values[this._values.length - 1]));
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public IDictionary sliceOutColumnRange(int idxStart, int idxEnd, int previousNumberOfColumns) {
        int numberTuples = this.getNumberOfValues(previousNumberOfColumns);
        int tupleLengthAfter = idxEnd - idxStart;
        double[] newDictValues = new double[tupleLengthAfter * numberTuples];
        int orgOffset = idxStart;
        int targetOffset = 0;
        for (int v = 0; v < numberTuples; ++v) {
            int c = 0;
            while (c < tupleLengthAfter) {
                newDictValues[targetOffset] = this._values[orgOffset];
                ++c;
                ++orgOffset;
                ++targetOffset;
            }
            orgOffset += previousNumberOfColumns - idxEnd + idxStart;
        }
        return Dictionary.create(newDictValues);
    }

    @Override
    public boolean containsValue(double pattern) {
        boolean NaNpattern = Double.isNaN(pattern);
        if (NaNpattern) {
            for (double v : this._values) {
                if (!Double.isNaN(v)) continue;
                return true;
            }
        } else {
            for (double v : this._values) {
                if (v != pattern) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsValueWithReference(double pattern, double[] reference) {
        if (Double.isNaN(pattern)) {
            return super.containsValueWithReference(pattern, reference);
        }
        int nCol = reference.length;
        for (int i = 0; i < this._values.length; ++i) {
            if (this._values[i] + reference[i % nCol] != pattern) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getNumberNonZeros(int[] counts, int nCol) {
        long nnz = 0L;
        int nRow = counts.length;
        for (int i = 0; i < nRow; ++i) {
            int off;
            long rowCount = 0L;
            for (int j = off = i * nCol; j < off + nCol; ++j) {
                if (this._values[j] == 0.0) continue;
                ++rowCount;
            }
            nnz += rowCount * (long)counts[i];
        }
        return nnz;
    }

    @Override
    public int[] countNNZZeroColumns(int[] counts) {
        int nRow = counts.length;
        int nCol = this._values.length / nRow;
        int[] ret = new int[nCol];
        for (int i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                int off = i * nCol + j;
                if (this._values[off] == 0.0) continue;
                int n = j;
                ret[n] = ret[n] + counts[i];
            }
        }
        return ret;
    }

    @Override
    public long getNumberNonZerosWithReference(int[] counts, double[] reference, int nRows) {
        long nnz = 0L;
        int nCol = reference.length;
        int nRow = counts.length;
        for (int i = 0; i < nRow; ++i) {
            int off;
            long rowCount = 0L;
            int j = off = i * nCol;
            int jj = 0;
            while (j < off + nCol) {
                if (this._values[j] + reference[jj] != 0.0) {
                    ++rowCount;
                }
                ++j;
                ++jj;
            }
            nnz += rowCount * (long)counts[i];
        }
        return nnz;
    }

    @Override
    public final void addToEntry(double[] v, int fr, int to, int nCol) {
        int sf = fr * nCol;
        int st = to * nCol;
        this.addToOffsets(v, sf, st, nCol);
    }

    private final void addToOffsets(double[] v, int sf, int st, int nCol) {
        int j = st;
        for (int i = sf; i < sf + nCol; ++i) {
            int n = j++;
            v[n] = v[n] + this._values[i];
        }
    }

    @Override
    public final void addToEntry(double[] v, int fr, int to, int nCol, int rep) {
        int sf = fr * nCol;
        int st = to * nCol;
        this.addToOffsets(v, sf, st, nCol, rep);
    }

    private final void addToOffsets(double[] v, int sf, int st, int nCol, int rep) {
        int j = st;
        for (int i = sf; i < sf + nCol; ++i) {
            int n = j++;
            v[n] = v[n] + this._values[i] * (double)rep;
        }
    }

    @Override
    public void addToEntryVectorized(double[] v, int f1, int f2, int f3, int f4, int f5, int f6, int f7, int f8, int t1, int t2, int t3, int t4, int t5, int t6, int t7, int t8, int nCol) {
        this.addToOffsets(v, f1 * nCol, t1 * nCol, nCol);
        this.addToOffsets(v, f2 * nCol, t2 * nCol, nCol);
        this.addToOffsets(v, f3 * nCol, t3 * nCol, nCol);
        this.addToOffsets(v, f4 * nCol, t4 * nCol, nCol);
        this.addToOffsets(v, f5 * nCol, t5 * nCol, nCol);
        this.addToOffsets(v, f6 * nCol, t6 * nCol, nCol);
        this.addToOffsets(v, f7 * nCol, t7 * nCol, nCol);
        this.addToOffsets(v, f8 * nCol, t8 * nCol, nCol);
    }

    @Override
    public IDictionary.DictType getDictType() {
        return IDictionary.DictType.Dict;
    }

    @Override
    public IDictionary subtractTuple(double[] tuple) {
        double[] newValues = new double[this._values.length];
        int i = 0;
        while (i < this._values.length) {
            for (int j = 0; j < tuple.length; ++j) {
                newValues[i] = this._values[i] - tuple[j];
                ++i;
            }
        }
        return Dictionary.create(newValues);
    }

    @Override
    public MatrixBlockDictionary createMBDict(int nCol) {
        MatrixBlockDictionary ret = MatrixBlockDictionary.createDictionary(this._values, nCol, true);
        return ret;
    }

    @Override
    public void aggregateCols(double[] c, Builtin fn, IColIndex colIndexes) {
        int nCol = colIndexes.size();
        int rlen = this._values.length / nCol;
        for (int k = 0; k < rlen; ++k) {
            int valOff = k * nCol;
            for (int j = 0; j < nCol; ++j) {
                c[colIndexes.get((int)j)] = fn.execute(c[colIndexes.get(j)], this._values[valOff + j]);
            }
        }
    }

    @Override
    public void aggregateColsWithReference(double[] c, Builtin fn, IColIndex colIndexes, double[] reference, boolean def) {
        int nCol = reference.length;
        int rlen = this._values.length / nCol;
        for (int k = 0; k < rlen; ++k) {
            int valOff = k * nCol;
            for (int j = 0; j < nCol; ++j) {
                c[colIndexes.get((int)j)] = fn.execute(c[colIndexes.get(j)], this._values[valOff + j] + reference[j]);
            }
        }
        if (def) {
            for (int i = 0; i < nCol; ++i) {
                int cix = colIndexes.get(i);
                c[cix] = fn.execute(c[cix], reference[i]);
            }
        }
    }

    @Override
    public IDictionary scaleTuples(int[] scaling, int nCol) {
        double[] scaledValues = new double[this._values.length];
        int off = 0;
        for (int tuple = 0; tuple < this._values.length / nCol; ++tuple) {
            int scale = scaling[tuple];
            for (int v = 0; v < nCol; ++v) {
                scaledValues[off] = this._values[off] * (double)scale;
                ++off;
            }
        }
        return Dictionary.create(scaledValues);
    }

    @Override
    public Dictionary preaggValuesFromDense(int numVals, IColIndex colIndexes, IColIndex aggregateColumns, double[] b, int cut) {
        int cz = colIndexes.size();
        int az = aggregateColumns.size();
        double[] ret = new double[numVals * az];
        int k = 0;
        int off = 0;
        while (k < numVals * cz) {
            for (int h = 0; h < cz; ++h) {
                int idb = colIndexes.get(h) * cut;
                double v = this._values[k + h];
                if (v == 0.0) continue;
                for (int i = 0; i < az; ++i) {
                    int n = off + i;
                    ret[n] = ret[n] + v * b[idb + aggregateColumns.get(i)];
                }
            }
            k += cz;
            off += az;
        }
        return Dictionary.create(ret);
    }

    @Override
    public IDictionary replace(double pattern, double replace, int nCol) {
        double[] retV = new double[this._values.length];
        for (int i = 0; i < this._values.length; ++i) {
            double v = this._values[i];
            retV[i] = Util.eq(v, pattern) ? replace : v;
        }
        return Dictionary.create(retV);
    }

    @Override
    public IDictionary replaceWithReference(double pattern, double replace, double[] reference) {
        int nCol = reference.length;
        int nRow = this._values.length / nCol;
        if (Util.eq(pattern, Double.NaN)) {
            return this.replaceWithReferenceNaN(replace, reference, nCol, nRow);
        }
        double[] retV = new double[this._values.length];
        int off = 0;
        for (int i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                double v = this._values[off];
                double ref = reference[j];
                retV[off] = Math.abs(v + ref - pattern) < 1.0E-6 ? replace - ref : v;
                ++off;
            }
        }
        return Dictionary.create(retV);
    }

    private IDictionary replaceWithReferenceNaN(double replace, double[] reference, int nCol, int nRow) {
        double[] retV;
        Set<Integer> colsWithNan = Dictionary.getColsWithNan(replace, reference);
        if (colsWithNan != null) {
            if (colsWithNan.size() == nCol && replace == 0.0) {
                return null;
            }
            retV = new double[this._values.length];
            Dictionary.replaceWithReferenceNanDenseWithNanCols(replace, reference, nRow, nCol, colsWithNan, this._values, retV);
        } else {
            retV = new double[this._values.length];
            Dictionary.replaceWithReferenceNanDenseWithoutNanCols(replace, reference, nRow, nCol, retV, this._values);
        }
        return Dictionary.create(retV);
    }

    protected static Set<Integer> getColsWithNan(double replace, double[] reference) {
        HashSet<Integer> colsWithNan = null;
        for (int i = 0; i < reference.length; ++i) {
            if (!Util.eq(reference[i], Double.NaN)) continue;
            if (colsWithNan == null) {
                colsWithNan = new HashSet<Integer>();
            }
            colsWithNan.add(i);
            reference[i] = replace;
        }
        return colsWithNan;
    }

    protected static void replaceWithReferenceNanDenseWithoutNanCols(double replace, double[] reference, int nRow, int nCol, double[] retV, double[] values) {
        int off = 0;
        for (int i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                double v = values[off];
                retV[off++] = Util.eq(Double.NaN, v) ? replace - reference[j] : v;
            }
        }
    }

    protected static void replaceWithReferenceNanDenseWithNanCols(double replace, double[] reference, int nRow, int nCol, Set<Integer> colsWithNan, double[] values, double[] retV) {
        int off = 0;
        for (int i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                double v = values[off];
                retV[off++] = colsWithNan.contains(j) ? 0.0 : (Util.eq(v, Double.NaN) ? replace - reference[j] : v);
            }
        }
    }

    @Override
    public void product(double[] ret, int[] counts, int nCol) {
        if (ret[0] == 0.0) {
            return;
        }
        MathContext cont = MathContext.DECIMAL128;
        int len = counts.length;
        BigDecimal tmp = BigDecimal.ONE;
        for (int i = 0; i < len; ++i) {
            for (int j = i * nCol; j < (i + 1) * nCol; ++j) {
                double v = this._values[j];
                if (v == 0.0) {
                    ret[0] = 0.0;
                    return;
                }
                tmp = tmp.multiply(new BigDecimal(v).pow(counts[i], cont), cont);
            }
        }
        if (Math.abs(tmp.doubleValue()) == 0.0) {
            ret[0] = 0.0;
        } else if (!Double.isInfinite(ret[0])) {
            ret[0] = new BigDecimal(ret[0]).multiply(tmp, MathContext.DECIMAL128).doubleValue();
        }
    }

    @Override
    public void productWithDefault(double[] ret, int[] counts, double[] def, int defCount) {
        if (ret[0] == 0.0) {
            return;
        }
        MathContext cont = MathContext.DECIMAL128;
        int len = counts.length;
        int nCol = def.length;
        BigDecimal tmp = BigDecimal.ONE;
        for (int i = 0; i < len; ++i) {
            for (int j = i * nCol; j < (i + 1) * nCol; ++j) {
                double v = this._values[j];
                if (v == 0.0) {
                    ret[0] = 0.0;
                    return;
                }
                tmp = tmp.multiply(new BigDecimal(v).pow(counts[i], cont), cont);
            }
        }
        for (int x = 0; x < def.length; ++x) {
            tmp = tmp.multiply(new BigDecimal(def[x]).pow(defCount, cont), cont);
        }
        if (Math.abs(tmp.doubleValue()) == 0.0) {
            ret[0] = 0.0;
        } else if (!Double.isInfinite(ret[0])) {
            ret[0] = new BigDecimal(ret[0]).multiply(tmp, MathContext.DECIMAL128).doubleValue();
        }
    }

    @Override
    public void productWithReference(double[] ret, int[] counts, double[] reference, int refCount) {
        if (ret[0] == 0.0) {
            return;
        }
        MathContext cont = MathContext.DECIMAL128;
        int nRow = counts.length;
        int nCol = reference.length;
        BigDecimal tmp = BigDecimal.ONE;
        int off = 0;
        for (int i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                double v;
                if ((v = this._values[off++] + reference[j]) == 0.0) {
                    ret[0] = 0.0;
                    return;
                }
                if (!Double.isFinite(v)) {
                    ret[0] = v;
                    return;
                }
                tmp = tmp.multiply(new BigDecimal(v).pow(counts[i], cont), cont);
            }
        }
        for (int x = 0; x < reference.length; ++x) {
            tmp = tmp.multiply(new BigDecimal(reference[x]).pow(refCount, cont), cont);
        }
        if (Math.abs(tmp.doubleValue()) == 0.0) {
            ret[0] = 0.0;
        } else if (!Double.isInfinite(ret[0])) {
            ret[0] = new BigDecimal(ret[0]).multiply(tmp, MathContext.DECIMAL128).doubleValue();
        }
    }

    @Override
    public CM_COV_Object centralMoment(CM_COV_Object ret, ValueFunction fn, int[] counts, int nRows) {
        for (int i = 0; i < this._values.length; ++i) {
            fn.execute(ret, this._values[i], counts[i]);
        }
        if (ret.getWeight() < (double)nRows) {
            fn.execute(ret, 0.0, (double)nRows - ret.getWeight());
        }
        return ret;
    }

    @Override
    public CM_COV_Object centralMomentWithDefault(CM_COV_Object ret, ValueFunction fn, int[] counts, double def, int nRows) {
        for (int i = 0; i < this._values.length; ++i) {
            fn.execute(ret, this._values[i], counts[i]);
        }
        if (ret.getWeight() < (double)nRows) {
            fn.execute(ret, def, (double)nRows - ret.getWeight());
        }
        return ret;
    }

    @Override
    public CM_COV_Object centralMomentWithReference(CM_COV_Object ret, ValueFunction fn, int[] counts, double reference, int nRows) {
        for (int i = 0; i < this._values.length; ++i) {
            fn.execute(ret, this._values[i] + reference, counts[i]);
        }
        if (ret.getWeight() < (double)nRows) {
            fn.execute(ret, reference, (double)nRows - ret.getWeight());
        }
        return ret;
    }

    @Override
    public IDictionary rexpandCols(int max, boolean ignore, boolean cast, int nCol) {
        if (nCol > 1) {
            throw new DMLCompressionException("Invalid to rexpand the column groups if more than one column");
        }
        MatrixBlockDictionary m = this.getMBDict(nCol);
        return m == null ? null : m.rexpandCols(max, ignore, cast, nCol);
    }

    @Override
    public IDictionary rexpandColsWithReference(int max, boolean ignore, boolean cast, int reference) {
        MatrixBlockDictionary m = this.getMBDict(1);
        if (m == null) {
            return null;
        }
        IDictionary a = m.applyScalarOp(new RightScalarOperator(Plus.getPlusFnObject(), reference));
        if (a == null) {
            return null;
        }
        a = a.rexpandCols(max, ignore, cast, 1);
        return a;
    }

    @Override
    public double getSparsity() {
        int zeros = 0;
        for (double v : this._values) {
            if (v != 0.0) continue;
            ++zeros;
        }
        return OptimizerUtils.getSparsity(this._values.length, 1L, this._values.length - zeros);
    }

    @Override
    public void multiplyScalar(double v, double[] ret, int off, int dictIdx, IColIndex cols) {
        int offD = dictIdx * cols.size();
        for (int i = 0; i < cols.size(); ++i) {
            double a = v * this._values[offD + i];
            int n = off + cols.get(i);
            ret[n] = ret[n] + a;
        }
    }

    @Override
    public void TSMMWithScaling(int[] counts, IColIndex rows, IColIndex cols, MatrixBlock ret) {
        DictLibMatrixMult.TSMMDictsDenseWithScaling(this._values, rows, cols, counts, ret);
    }

    @Override
    public void MMDict(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        right.MMDictDense(this._values, rowsLeft, colsRight, result);
    }

    @Override
    public void MMDictScaling(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        right.MMDictScalingDense(this._values, rowsLeft, colsRight, result, scaling);
    }

    @Override
    public void MMDictDense(double[] left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        DictLibMatrixMult.MMDictsDenseDense(left, this._values, rowsLeft, colsRight, result);
    }

    @Override
    public void MMDictScalingDense(double[] left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        DictLibMatrixMult.MMDictsScalingDenseDense(left, this._values, rowsLeft, colsRight, result, scaling);
    }

    @Override
    public void MMDictSparse(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        DictLibMatrixMult.MMDictsSparseDense(left, this._values, rowsLeft, colsRight, result);
    }

    @Override
    public void MMDictScalingSparse(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        DictLibMatrixMult.MMDictsScalingSparseDense(left, this._values, rowsLeft, colsRight, result, scaling);
    }

    @Override
    public void TSMMToUpperTriangle(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        right.TSMMToUpperTriangleDense(this._values, rowsLeft, colsRight, result);
    }

    @Override
    public void TSMMToUpperTriangleDense(double[] left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        DictLibMatrixMult.MMToUpperTriangleDenseDense(left, this._values, rowsLeft, colsRight, result);
    }

    @Override
    public void TSMMToUpperTriangleSparse(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        DictLibMatrixMult.MMToUpperTriangleSparseDense(left, this._values, rowsLeft, colsRight, result);
    }

    @Override
    public void TSMMToUpperTriangleScaling(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        right.TSMMToUpperTriangleDenseScaling(this._values, rowsLeft, colsRight, scale, result);
    }

    @Override
    public void TSMMToUpperTriangleDenseScaling(double[] left, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        DictLibMatrixMult.TSMMToUpperTriangleDenseDenseScaling(left, this._values, rowsLeft, colsRight, scale, result);
    }

    @Override
    public void TSMMToUpperTriangleSparseScaling(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        DictLibMatrixMult.TSMMToUpperTriangleSparseDenseScaling(left, this._values, rowsLeft, colsRight, scale, result);
    }

    @Override
    public boolean equals(IDictionary o) {
        if (o instanceof Dictionary) {
            return Arrays.equals(this._values, ((Dictionary)o)._values);
        }
        if (o != null) {
            return o.equals(this);
        }
        return false;
    }

    @Override
    public IDictionary cbind(IDictionary that, int nCol) {
        int nRowThat = that.getNumberOfValues(nCol);
        int nColThis = this._values.length / nRowThat;
        MatrixBlockDictionary mbd = this.getMBDict(nColThis);
        return mbd.cbind(that, nCol);
    }

    @Override
    public IDictionary reorder(int[] reorder) {
        double[] retV = new double[this._values.length];
        Dictionary ret = new Dictionary(retV);
        int nRows = this._values.length / reorder.length;
        for (int r = 0; r < nRows; ++r) {
            int off = r * reorder.length;
            for (int c = 0; c < reorder.length; ++c) {
                retV[off + c] = this._values[off + reorder[c]];
            }
        }
        return ret;
    }

    @Override
    protected IDictionary rightMMPreAggSparseSelectedCols(int numVals, SparseBlock b, IColIndex thisCols, IColIndex aggregateColumns) {
        int thisColsSize = thisCols.size();
        int aggColSize = aggregateColumns.size();
        double[] ret = new double[numVals * aggColSize];
        for (int h = 0; h < thisColsSize; ++h) {
            int colIdx = thisCols.get(h);
            if (b.isEmpty(colIdx)) continue;
            double[] sValues = b.values(colIdx);
            int[] sIndexes = b.indexes(colIdx);
            int sPos = b.pos(colIdx);
            int sEnd = b.size(colIdx) + sPos;
            for (int j = 0; j < numVals; ++j) {
                int offOut = j * aggColSize;
                double v = this.getValue(j, h, thisColsSize);
                this.sparseAddSelected(sPos, sEnd, aggColSize, aggregateColumns, sIndexes, sValues, ret, offOut, v);
            }
        }
        return Dictionary.create(ret);
    }

    private void sparseAddSelected(int sPos, int sEnd, int aggColSize, IColIndex aggregateColumns, int[] sIndexes, double[] sValues, double[] ret, int offOut, double v) {
        int retIdx = 0;
        for (int i = sPos; i < sEnd; ++i) {
            while (retIdx < aggColSize && aggregateColumns.get(retIdx) < sIndexes[i]) {
                ++retIdx;
            }
            if (retIdx == aggColSize) break;
            int n = offOut + retIdx;
            ret[n] = ret[n] + v * sValues[i];
        }
        retIdx = 0;
    }

    @Override
    protected IDictionary rightMMPreAggSparseAllColsRight(int numVals, SparseBlock b, IColIndex thisCols, int nColRight) {
        int thisColsSize = thisCols.size();
        double[] ret = new double[numVals * nColRight];
        for (int h = 0; h < thisColsSize; ++h) {
            int colIdx = thisCols.get(h);
            if (b.isEmpty(colIdx)) continue;
            double[] sValues = b.values(colIdx);
            int[] sIndexes = b.indexes(colIdx);
            int sPos = b.pos(colIdx);
            int sEnd = b.size(colIdx) + sPos;
            for (int i = 0; i < numVals; ++i) {
                int offOut = i * nColRight;
                double v = this.getValue(i, h, thisColsSize);
                this.SparseAdd(sPos, sEnd, ret, offOut, sIndexes, sValues, v);
            }
        }
        return Dictionary.create(ret);
    }

    private void SparseAdd(int sPos, int sEnd, double[] ret, int offOut, int[] sIdx, double[] sVals, double v) {
        if (v != 0.0) {
            for (int k = sPos; k < sEnd; ++k) {
                int n = offOut + sIdx[k];
                ret[n] = ret[n] + v * sVals[k];
            }
        }
    }

    @Override
    public IDictionary append(double[] row) {
        double[] retV = new double[this._values.length + row.length];
        System.arraycopy(this._values, 0, retV, 0, this._values.length);
        System.arraycopy(row, 0, retV, this._values.length, row.length);
        return new Dictionary(retV);
    }
}

