/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.bitmap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.bitmap.Bitmap;
import org.apache.sysds.runtime.compress.bitmap.MultiColBitmap;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.DblArrayIntListHashMap;
import org.apache.sysds.runtime.compress.utils.DoubleIntListHashMap;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class BitmapEncoder {
    static Log LOG = LogFactory.getLog((String)BitmapEncoder.class.getName());

    public static ABitmap extractBitmap(IColIndex colIndices, MatrixBlock rawBlock, int estimatedNumberOfUniques, CompressionSettings cs) {
        return BitmapEncoder.extractBitmap(colIndices, rawBlock, cs.transposed, estimatedNumberOfUniques, cs.sortTuplesByFrequency);
    }

    public static ABitmap extractBitmap(IColIndex colIndices, MatrixBlock rawBlock, boolean transposed, int estimatedNumberOfUniques, boolean sortedEntries) {
        if (rawBlock == null || rawBlock.isEmpty()) {
            return null;
        }
        int numRows = transposed ? rawBlock.getNumColumns() : rawBlock.getNumRows();
        int estimatedNumber = Math.max(estimatedNumberOfUniques, 8);
        if (colIndices.size() == 1) {
            return BitmapEncoder.extractBitmapSingleColumn(colIndices.get(0), rawBlock, numRows, transposed, estimatedNumber, sortedEntries);
        }
        return BitmapEncoder.extractBitmapMultiColumns(colIndices, rawBlock, numRows, transposed, estimatedNumber, sortedEntries);
    }

    private static ABitmap extractBitmapSingleColumn(int colIndex, MatrixBlock rawBlock, int numRows, boolean transposed, int est, boolean sort) {
        if (transposed) {
            if (rawBlock.isInSparseFormat() && rawBlock.getSparseBlock().isEmpty(colIndex)) {
                return null;
            }
            return BitmapEncoder.makeSingleColBitmap(BitmapEncoder.extractSingleColT(colIndex, rawBlock, est), rawBlock.getNumColumns(), sort);
        }
        return BitmapEncoder.makeSingleColBitmap(BitmapEncoder.extractSingleCol(colIndex, rawBlock, est), rawBlock.getNumRows(), sort);
    }

    private static DoubleIntListHashMap extractSingleCol(int colIndex, MatrixBlock rawBlock, int estimatedUnique) {
        DoubleIntListHashMap distinctVals = new DoubleIntListHashMap(estimatedUnique);
        int nRows = rawBlock.getNumRows();
        int nCols = rawBlock.getNumColumns();
        boolean sparse = rawBlock.isInSparseFormat();
        if (sparse) {
            SparseBlock sb = rawBlock.getSparseBlock();
            for (int r = 0; r < nRows; ++r) {
                if (sb.isEmpty(r)) continue;
                int apos = sb.pos(r);
                int alen = sb.size(r) + apos;
                int[] aix = sb.indexes(r);
                int idx = Arrays.binarySearch(aix, apos, alen, colIndex);
                if (idx < 0) continue;
                distinctVals.appendValue(sb.values(r)[idx], r);
            }
        } else if (rawBlock.getDenseBlock().isContiguous()) {
            double[] values = rawBlock.getDenseBlockValues();
            if (nCols == 1) {
                for (int i = 0; i < values.length; ++i) {
                    distinctVals.appendValue(values[i], i);
                }
            } else {
                int i = 0;
                for (int off = colIndex; off < nRows * nCols; off += nCols) {
                    distinctVals.appendValue(values[off], i);
                    ++i;
                }
            }
        } else {
            for (int i = 0; i < nRows; ++i) {
                distinctVals.appendValue(rawBlock.get(i, colIndex), i);
            }
        }
        return distinctVals;
    }

    private static DoubleIntListHashMap extractSingleColT(int colIndex, MatrixBlock rawBlock, int estimatedUnique) {
        DoubleIntListHashMap distinctVals = new DoubleIntListHashMap(estimatedUnique);
        if (rawBlock.isInSparseFormat()) {
            SparseBlock a = rawBlock.getSparseBlock();
            int apos = a.pos(colIndex);
            int alen = a.size(colIndex) + apos;
            int[] aix = a.indexes(colIndex);
            double[] avals = a.values(colIndex);
            for (int j = apos; j < alen; ++j) {
                distinctVals.appendValue(avals[j], aix[j]);
            }
        } else if (rawBlock.getNumRows() == 1) {
            double[] values = rawBlock.getDenseBlockValues();
            for (int i = 0; i < values.length; ++i) {
                distinctVals.appendValue(values[i], i);
            }
        } else {
            DenseBlock db = rawBlock.getDenseBlock();
            double[] values = db.values(colIndex);
            int nCol = rawBlock.getNumColumns();
            int i = 0;
            int off = db.pos(colIndex);
            while (i < nCol) {
                distinctVals.appendValue(values[off], i);
                ++i;
                ++off;
            }
        }
        return distinctVals;
    }

    private static ABitmap extractBitmapMultiColumns(IColIndex colIndices, MatrixBlock rawBlock, int numRows, boolean transposed, int estimatedUnique, boolean sort) {
        DblArrayIntListHashMap map = new DblArrayIntListHashMap(estimatedUnique);
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(rawBlock, colIndices, transposed);
        DblArray cellVals = null;
        try {
            DblArray empty = new DblArray(new double[colIndices.size()]);
            while ((cellVals = reader.nextRow()) != null) {
                if (cellVals.equals(empty)) continue;
                map.appendValue(cellVals, reader.getCurrentRowIndex());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("failed extracting bitmap and adding. " + map + "  \n " + cellVals, e);
        }
        return BitmapEncoder.makeMultiColBitmap(map, numRows, colIndices.size(), sort);
    }

    private static ABitmap makeMultiColBitmap(DblArrayIntListHashMap map, int numRows, int numCols, boolean sort) {
        int numVals = map.size();
        if (numVals > 0) {
            List<DblArrayIntListHashMap.DArrayIListEntry> mVals = map.extractValues();
            if (sort) {
                Collections.sort(mVals, new CompSizeDArrayIListEntry());
            }
            double[][] values = new double[numVals][];
            IntArrayList[] offsetsLists = new IntArrayList[numVals];
            int bitmapIx = 0;
            for (DblArrayIntListHashMap.DArrayIListEntry val : mVals) {
                values[bitmapIx] = val.key.getData();
                offsetsLists[bitmapIx++] = val.value;
            }
            return new MultiColBitmap(offsetsLists, values, numRows);
        }
        return null;
    }

    private static Bitmap makeSingleColBitmap(DoubleIntListHashMap distinctVals, int numRows, boolean sort) {
        int numVals = distinctVals.size();
        if (numVals > 0) {
            ArrayList<DoubleIntListHashMap.DIListEntry> mVals = distinctVals.extractValues();
            if (sort) {
                Collections.sort(mVals, new CompSizeDIListEntry());
            }
            double[] values = new double[numVals];
            IntArrayList[] offsetsLists = new IntArrayList[numVals];
            int bitmapIx = 0;
            for (DoubleIntListHashMap.DIListEntry val : mVals) {
                values[bitmapIx] = val.key;
                offsetsLists[bitmapIx++] = val.value;
            }
            return new Bitmap(offsetsLists, values, numRows);
        }
        return null;
    }

    static class CompSizeDIListEntry
    implements Comparator<DoubleIntListHashMap.DIListEntry> {
        CompSizeDIListEntry() {
        }

        @Override
        public int compare(DoubleIntListHashMap.DIListEntry o1, DoubleIntListHashMap.DIListEntry o2) {
            int v1 = o1.value.size();
            int v2 = o2.value.size();
            return -Integer.compare(v1, v2);
        }
    }

    static class CompSizeDArrayIListEntry
    implements Comparator<DblArrayIntListHashMap.DArrayIListEntry> {
        CompSizeDArrayIListEntry() {
        }

        @Override
        public int compare(DblArrayIntListHashMap.DArrayIListEntry o1, DblArrayIntListHashMap.DArrayIListEntry o2) {
            int v1 = o1.value.size();
            int v2 = o2.value.size();
            return -Integer.compare(v1, v2);
        }
    }
}

