/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.models;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.BaseEntityModel;

public class StatsEntityModel
extends BaseEntityModel {
    private Long _workerId;
    private double _cpuUsage;
    private double _memoryUsage;
    private Map<String, Pair<Long, Double>> _heavyHitterInstructionsObj;
    private String _heavyHitterInstructions;
    private List<Triple<LocalDateTime, String, Long>> _transferredBytesObj;
    private String _transferredBytes;

    public StatsEntityModel() {
    }

    public StatsEntityModel(Long workerId, double cpuUsage, double memoryUsage, Map<String, Pair<Long, Double>> heavyHitterInstructionsObj, List<Triple<LocalDateTime, String, Long>> transferredBytesObj) {
        this._workerId = workerId;
        this._cpuUsage = cpuUsage;
        this._memoryUsage = memoryUsage;
        this._heavyHitterInstructionsObj = heavyHitterInstructionsObj;
        this._transferredBytesObj = transferredBytesObj;
        this._heavyHitterInstructions = "";
        this._transferredBytes = "";
    }

    public Long getWorkerId() {
        return this._workerId;
    }

    public void setWorkerId(Long workerId) {
        this._workerId = workerId;
    }

    public double getCPUUsage() {
        return this._cpuUsage;
    }

    public void setCPUUsage(double cpuUsage) {
        this._cpuUsage = cpuUsage;
    }

    public double getMemoryUsage() {
        return this._memoryUsage;
    }

    public void setMemoryUsage(double memoryUsage) {
        this._memoryUsage = memoryUsage;
    }

    public String getHeavyHitterInstructions() {
        if (this._heavyHitterInstructions.isEmpty() || this._heavyHitterInstructions.isBlank()) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (Map.Entry<String, Pair<Long, Double>> entry : this._heavyHitterInstructionsObj.entrySet()) {
                String instruction = entry.getKey();
                Long count = (Long)entry.getValue().getLeft();
                double duration = (Double)entry.getValue().getRight();
                sb.append(String.format("{\"instruction\": %s,\"count\": \"%d\",\"duration\": \"%.2f\",},", instruction, count, duration));
            }
            sb.append("}");
            this._heavyHitterInstructions = sb.toString();
        }
        return this._heavyHitterInstructions;
    }

    public void setHeavyHitterInstructions(String heavyHitterInstructionsJsonString) {
        this._heavyHitterInstructions = heavyHitterInstructionsJsonString;
    }

    public String getTransferredBytes() {
        if (this._transferredBytes.isEmpty() || this._transferredBytes.isBlank()) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (Triple<LocalDateTime, String, Long> entry : this._transferredBytesObj) {
                sb.append(String.format("{\"datetime\": %s,\"coordinatorAddress\": \"%s\",\"byteAmount\": \"%d\",},", ((LocalDateTime)entry.getLeft()).format(DateTimeFormatter.ISO_DATE_TIME), entry.getMiddle(), entry.getRight()));
            }
            sb.append("}");
            this._transferredBytes = sb.toString();
        }
        return this._transferredBytes;
    }

    public void setTransferredBytes(String transferredBytesJsonString) {
        this._transferredBytes = transferredBytesJsonString;
    }

    public String toString() {
        return String.format("{\"cpuUsage\": %.2f,\"memoryUsage\": %.2f,\"coordinatorTraffic\": %s,\"heavyHitters\": %s}", this._cpuUsage, this._memoryUsage, this.getTransferredBytes(), this.getHeavyHitterInstructions());
    }
}

