/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser.dml;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Builtins;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.parser.AssignmentStatement;
import org.apache.sysds.parser.BinaryExpression;
import org.apache.sysds.parser.BooleanExpression;
import org.apache.sysds.parser.BooleanIdentifier;
import org.apache.sysds.parser.BuiltinConstant;
import org.apache.sysds.parser.BuiltinFunctionExpression;
import org.apache.sysds.parser.ConditionalPredicate;
import org.apache.sysds.parser.ConstIdentifier;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.DataExpression;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.DoubleIdentifier;
import org.apache.sysds.parser.Expression;
import org.apache.sysds.parser.ExpressionList;
import org.apache.sysds.parser.ForStatement;
import org.apache.sysds.parser.FunctionCallIdentifier;
import org.apache.sysds.parser.FunctionDictionary;
import org.apache.sysds.parser.FunctionStatement;
import org.apache.sysds.parser.FunctionStatementBlock;
import org.apache.sysds.parser.IfStatement;
import org.apache.sysds.parser.ImportStatement;
import org.apache.sysds.parser.IndexedIdentifier;
import org.apache.sysds.parser.IntIdentifier;
import org.apache.sysds.parser.IterablePredicate;
import org.apache.sysds.parser.LanguageException;
import org.apache.sysds.parser.MultiAssignmentStatement;
import org.apache.sysds.parser.OutputStatement;
import org.apache.sysds.parser.ParForStatement;
import org.apache.sysds.parser.ParameterExpression;
import org.apache.sysds.parser.ParameterizedBuiltinFunctionExpression;
import org.apache.sysds.parser.ParseException;
import org.apache.sysds.parser.ParseInfo;
import org.apache.sysds.parser.ParserWrapper;
import org.apache.sysds.parser.PathStatement;
import org.apache.sysds.parser.PrintStatement;
import org.apache.sysds.parser.RelationalExpression;
import org.apache.sysds.parser.Statement;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.parser.StringIdentifier;
import org.apache.sysds.parser.WhileStatement;
import org.apache.sysds.parser.dml.CustomErrorListener;
import org.apache.sysds.parser.dml.DMLParserWrapper;
import org.apache.sysds.parser.dml.DmlListener;
import org.apache.sysds.parser.dml.DmlParser;
import org.apache.sysds.parser.dml.ExpressionInfo;
import org.apache.sysds.parser.dml.StatementInfo;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DmlSyntacticValidator
implements DmlListener {
    private static final String DEF_WORK_DIR = ".";
    protected static ThreadLocal<HashMap<String, String>> _tScripts = new ThreadLocal<HashMap<String, String>>(){

        @Override
        protected HashMap<String, String> initialValue() {
            return new HashMap<String, String>();
        }
    };
    protected static ThreadLocal<HashMap<String, String>> _f2NS = new ThreadLocal<HashMap<String, String>>(){

        @Override
        protected HashMap<String, String> initialValue() {
            return new HashMap<String, String>();
        }
    };
    protected final CustomErrorListener errorListener;
    protected final String currentFile;
    protected String _workingDir = ".";
    protected Map<String, String> argVals = null;
    protected String sourceNamespace = null;
    protected HashMap<String, String> sources;
    protected Set<String> functions;
    protected FunctionDictionary<FunctionStatementBlock> builtinFuns;
    protected HashMap<String, FunctionDictionary<FunctionStatementBlock>> builtinFunsNs;

    public DmlSyntacticValidator(CustomErrorListener errorListener, Map<String, String> argVals, String sourceNamespace, Set<String> prepFunctions) {
        this.errorListener = errorListener;
        this.currentFile = errorListener.getCurrentFileName();
        this.argVals = argVals;
        this.sourceNamespace = sourceNamespace;
        this.sources = new HashMap();
        this.functions = null != prepFunctions ? prepFunctions : new HashSet();
        this.builtinFuns = new FunctionDictionary();
        this.builtinFunsNs = new HashMap();
    }

    public String namespaceResolutionOp() {
        return "::";
    }

    public String trueStringLiteral() {
        return "TRUE";
    }

    public String falseStringLiteral() {
        return "FALSE";
    }

    public FunctionDictionary<FunctionStatementBlock> getParsedBuiltinFunctions() {
        return this.builtinFuns;
    }

    public Map<String, FunctionDictionary<FunctionStatementBlock>> getParsedBuiltinFunctionsNs() {
        return this.builtinFunsNs;
    }

    protected ArrayList<ParameterExpression> getParameterExpressionList(List<DmlParser.ParameterizedExpressionContext> paramExprs) {
        ArrayList<ParameterExpression> retVal = new ArrayList<ParameterExpression>();
        for (DmlParser.ParameterizedExpressionContext ctx : paramExprs) {
            String paramName = null;
            if (ctx.paramName != null && ctx.paramName.getText() != null && !ctx.paramName.getText().isEmpty()) {
                paramName = ctx.paramName.getText();
            }
            ParameterExpression myArg = new ParameterExpression(paramName, ctx.paramVal.info.expr);
            retVal.add(myArg);
        }
        return retVal;
    }

    @Override
    public void enterEveryRule(ParserRuleContext arg0) {
        if (arg0 instanceof DmlParser.StatementContext && ((DmlParser.StatementContext)arg0).info == null) {
            ((DmlParser.StatementContext)arg0).info = new StatementInfo();
        }
        if (arg0 instanceof DmlParser.FunctionStatementContext && ((DmlParser.FunctionStatementContext)arg0).info == null) {
            ((DmlParser.FunctionStatementContext)arg0).info = new StatementInfo();
        }
        if (arg0 instanceof DmlParser.ExpressionContext && ((DmlParser.ExpressionContext)arg0).info == null) {
            ((DmlParser.ExpressionContext)arg0).info = new ExpressionInfo();
        }
        if (arg0 instanceof DmlParser.DataIdentifierContext && ((DmlParser.DataIdentifierContext)arg0).dataInfo == null) {
            ((DmlParser.DataIdentifierContext)arg0).dataInfo = new ExpressionInfo();
        }
    }

    @Override
    public void exitAddSubExpression(DmlParser.AddSubExpressionContext ctx) {
        this.binaryExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitModIntDivExpression(DmlParser.ModIntDivExpressionContext ctx) {
        this.binaryExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitUnaryExpression(DmlParser.UnaryExpressionContext ctx) {
        this.unaryExpressionHelper(ctx, ctx.left.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitMultDivExpression(DmlParser.MultDivExpressionContext ctx) {
        this.binaryExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitPowerExpression(DmlParser.PowerExpressionContext ctx) {
        this.binaryExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitMatrixMulExpression(DmlParser.MatrixMulExpressionContext ctx) {
        this.binaryExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitRelationalExpression(DmlParser.RelationalExpressionContext ctx) {
        this.relationalExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitBooleanAndExpression(DmlParser.BooleanAndExpressionContext ctx) {
        this.booleanExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitBooleanOrExpression(DmlParser.BooleanOrExpressionContext ctx) {
        this.booleanExpressionHelper(ctx, ctx.left.info, ctx.right.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitBooleanNotExpression(DmlParser.BooleanNotExpressionContext ctx) {
        this.unaryBooleanExpressionHelper(ctx, ctx.left.info, ctx.info, ctx.op.getText());
    }

    @Override
    public void exitAtomicExpression(DmlParser.AtomicExpressionContext ctx) {
        ctx.info.expr = ctx.left.info.expr;
        this.setFileLineColumn(ctx.info.expr, (ParserRuleContext)ctx);
    }

    @Override
    public void exitConstFalseExpression(DmlParser.ConstFalseExpressionContext ctx) {
        this.booleanIdentifierHelper(ctx, false, ctx.info);
    }

    @Override
    public void exitConstTrueExpression(DmlParser.ConstTrueExpressionContext ctx) {
        this.booleanIdentifierHelper(ctx, true, ctx.info);
    }

    @Override
    public void exitConstDoubleIdExpression(DmlParser.ConstDoubleIdExpressionContext ctx) {
        this.constDoubleIdExpressionHelper(ctx, ctx.info);
    }

    @Override
    public void exitConstIntIdExpression(DmlParser.ConstIntIdExpressionContext ctx) {
        this.constIntIdExpressionHelper(ctx, ctx.info);
    }

    @Override
    public void exitConstStringIdExpression(DmlParser.ConstStringIdExpressionContext ctx) {
        this.constStringIdExpressionHelper(ctx, ctx.info);
    }

    @Override
    public void exitDataIdExpression(DmlParser.DataIdExpressionContext ctx) {
        this.exitDataIdExpressionHelper(ctx, ctx.info, ctx.dataIdentifier().dataInfo);
    }

    @Override
    public void exitSimpleDataIdentifierExpression(DmlParser.SimpleDataIdentifierExpressionContext ctx) {
        ctx.dataInfo.expr = new DataIdentifier(ctx.getText());
        this.setFileLineColumn(ctx.dataInfo.expr, (ParserRuleContext)ctx);
    }

    @Override
    public void exitIndexedExpression(DmlParser.IndexedExpressionContext ctx) {
        boolean isRowLower = ctx.rowLower != null && !ctx.rowLower.isEmpty() && ctx.rowLower.info.expr != null;
        boolean isRowUpper = ctx.rowUpper != null && !ctx.rowUpper.isEmpty() && ctx.rowUpper.info.expr != null;
        boolean isColLower = ctx.colLower != null && !ctx.colLower.isEmpty() && ctx.colLower.info.expr != null;
        boolean isColUpper = ctx.colUpper != null && !ctx.colUpper.isEmpty() && ctx.colUpper.info.expr != null;
        ExpressionInfo rowLower = isRowLower ? ctx.rowLower.info : null;
        ExpressionInfo rowUpper = isRowUpper ? ctx.rowUpper.info : null;
        ExpressionInfo colLower = isColLower ? ctx.colLower.info : null;
        ExpressionInfo colUpper = isColUpper ? ctx.colUpper.info : null;
        ctx.dataInfo.expr = new IndexedIdentifier(ctx.name.getText(), false, false);
        this.setFileLineColumn(ctx.dataInfo.expr, (ParserRuleContext)ctx);
        try {
            ArrayList<ArrayList<Expression>> exprList = new ArrayList<ArrayList<Expression>>();
            ArrayList<Expression> rowIndices = new ArrayList<Expression>();
            ArrayList<Expression> colIndices = new ArrayList<Expression>();
            if (!isRowLower && !isRowUpper) {
                rowIndices.add(null);
                rowIndices.add(null);
            } else if (isRowLower && isRowUpper) {
                rowIndices.add(rowLower.expr);
                rowIndices.add(rowUpper.expr);
            } else if (isRowLower && !isRowUpper) {
                rowIndices.add(rowLower.expr);
            } else {
                this.notifyErrorListeners("incorrect index expression for row", ctx.start);
                return;
            }
            if (!isColLower && !isColUpper) {
                colIndices.add(null);
                colIndices.add(null);
            } else if (isColLower && isColUpper) {
                colIndices.add(colLower.expr);
                colIndices.add(colUpper.expr);
            } else if (isColLower && !isColUpper) {
                colIndices.add(colLower.expr);
            } else {
                this.notifyErrorListeners("incorrect index expression for column", ctx.start);
                return;
            }
            exprList.add(rowIndices);
            exprList.add(colIndices);
            ((IndexedIdentifier)ctx.dataInfo.expr).setIndices(exprList);
        }
        catch (Exception e) {
            this.notifyErrorListeners("cannot set the indices", ctx.start);
            return;
        }
    }

    @Override
    public void exitCommandlineParamExpression(DmlParser.CommandlineParamExpressionContext ctx) {
        this.handleCommandlineArgumentExpression(ctx);
    }

    @Override
    public void exitCommandlinePositionExpression(DmlParser.CommandlinePositionExpressionContext ctx) {
        this.handleCommandlineArgumentExpression(ctx);
    }

    private void handleCommandlineArgumentExpression(DmlParser.DataIdentifierContext ctx) {
        String varName = ctx.getText().trim();
        this.fillExpressionInfoCommandLineParameters(ctx, varName, ctx.dataInfo);
        if (ctx.dataInfo.expr == null && !(ctx.parent instanceof DmlParser.IfdefAssignmentStatementContext)) {
            String msg = "The parameter " + varName + " either needs to be passed through commandline or initialized to default value.";
            if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.IGNORE_UNSPECIFIED_ARGS)) {
                ctx.dataInfo.expr = this.getConstIdFromString(ctx, " ");
                if (!ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.MLCONTEXT)) {
                    this.raiseWarning(msg, ctx.start);
                }
            } else {
                this.notifyErrorListeners(msg, ctx.start);
            }
        }
    }

    @Override
    public void exitImportStatement(DmlParser.ImportStatementContext ctx) {
        String filePath = this.getWorkingFilePath(UtilFunctions.unquote(ctx.filePath.getText()));
        String namespace = this.getNamespaceSafe(ctx.namespace);
        this.setupContextInfo(ctx.info, namespace, filePath, ctx.filePath.getText(), this.parseAndAddImportedFunctions(namespace, filePath, ctx));
    }

    @Override
    public void exitAssignmentStatement(DmlParser.AssignmentStatementContext ctx) {
        if (ctx.targetList == null) {
            this.notifyErrorListeners("incorrect parsing for assignment", ctx.start);
            return;
        }
        this.exitAssignmentStatementHelper(ctx, ctx.targetList.getText(), ctx.targetList.dataInfo, ctx.targetList.start, ctx.source.info, ctx.info);
    }

    public ConvertedDMLSyntax convertToDMLSyntax(ParserRuleContext ctx, String namespace, String functionName, ArrayList<ParameterExpression> paramExpression, Token fnName) {
        return new ConvertedDMLSyntax(namespace, functionName, paramExpression);
    }

    protected Expression handleLanguageSpecificFunction(ParserRuleContext ctx, String functionName, ArrayList<ParameterExpression> paramExpressions) {
        return null;
    }

    @Override
    public void exitFunctionCallAssignmentStatement(DmlParser.FunctionCallAssignmentStatementContext ctx) {
        HashSet<String> printStatements = new HashSet<String>();
        printStatements.add("print");
        printStatements.add("stop");
        printStatements.add("assert");
        HashSet<String> outputStatements = new HashSet<String>();
        outputStatements.add("write");
        String[] fnNames = this.getQualifiedNames(ctx.name.getText());
        if (fnNames == null) {
            String errorMsg = "incorrect function name (only namespace " + this.namespaceResolutionOp() + " functionName allowed. Hint: If you are trying to use builtin functions, you can skip the namespace)";
            this.notifyErrorListeners(errorMsg, ctx.name);
            return;
        }
        String namespace = fnNames[0];
        String functionName = fnNames[1];
        ArrayList<ParameterExpression> paramExpression = this.getParameterExpressionList(ctx.paramExprs);
        this.castAsScalarDeprecationCheck(functionName, ctx);
        boolean hasLHS = ctx.targetList != null;
        this.functionCallAssignmentStatementHelper(ctx, printStatements, outputStatements, hasLHS ? ctx.targetList.dataInfo.expr : null, ctx.info, ctx.name, hasLHS ? ctx.targetList.start : null, namespace, functionName, paramExpression, hasLHS);
    }

    private void castAsScalarDeprecationCheck(String functionName, ParserRuleContext ctx) {
        if ("castAsScalar".equalsIgnoreCase(functionName)) {
            this.raiseWarning("castAsScalar() has been deprecated. Please use as.scalar().", ctx.start);
        }
    }

    @Override
    public void exitBuiltinFunctionExpression(DmlParser.BuiltinFunctionExpressionContext ctx) {
        String[] names = this.getQualifiedNames(ctx.name.getText());
        if (names == null) {
            this.notifyErrorListeners("incorrect function name (only namespace " + this.namespaceResolutionOp() + " functionName allowed. Hint: If you are trying to use builtin functions, you can skip the namespace)", ctx.name);
            return;
        }
        String namespace = names[0];
        String functionName = names[1];
        ArrayList<ParameterExpression> paramExpression = this.getParameterExpressionList(ctx.paramExprs);
        this.castAsScalarDeprecationCheck(functionName, ctx);
        ConvertedDMLSyntax convertedSyntax = this.convertToDMLSyntax(ctx, namespace, functionName, paramExpression, ctx.name);
        if (convertedSyntax == null) {
            return;
        }
        functionName = convertedSyntax.functionName;
        paramExpression = convertedSyntax.paramExpression;
        ctx.info.expr = this.buildForBuiltInFunction(ctx, functionName, paramExpression);
        if (ctx.info.expr != null) {
            return;
        }
        ctx.info.expr = this.createFunctionCall(ctx, namespace, functionName, paramExpression);
    }

    @Override
    public void exitFunctionCallMultiAssignmentStatement(DmlParser.FunctionCallMultiAssignmentStatementContext ctx) {
        if (ctx.name == null) {
            throw new ParseException("Missing name of multi-assignment function call (see parser issues above).");
        }
        String[] names = this.getQualifiedNames(ctx.name.getText());
        if (names == null) {
            this.notifyErrorListeners("incorrect function name (only namespace::functionName allowed. Hint: If you are trying to use builtin functions, you can skip the namespace)", ctx.name);
            return;
        }
        String namespace = names[0];
        String functionName = names[1];
        ArrayList<ParameterExpression> paramExpression = this.getParameterExpressionList(ctx.paramExprs);
        ConvertedDMLSyntax convertedSyntax = this.convertToDMLSyntax(ctx, namespace, functionName, paramExpression, ctx.name);
        if (convertedSyntax == null) {
            return;
        }
        namespace = convertedSyntax.namespace;
        functionName = convertedSyntax.functionName;
        paramExpression = convertedSyntax.paramExpression;
        FunctionCallIdentifier functCall = new FunctionCallIdentifier(paramExpression);
        functCall.setFunctionName(functionName);
        functCall.setFunctionNamespace(namespace);
        ArrayList<DataIdentifier> targetList = new ArrayList<DataIdentifier>();
        for (DmlParser.DataIdentifierContext dataCtx : ctx.targetList) {
            if (dataCtx.dataInfo.expr instanceof DataIdentifier) {
                targetList.add((DataIdentifier)dataCtx.dataInfo.expr);
                continue;
            }
            this.notifyErrorListeners("incorrect type for variable ", dataCtx.start);
            return;
        }
        if (namespace.equals(".defaultNS")) {
            Expression e = this.buildForBuiltInFunction(ctx, functionName, paramExpression);
            if (e != null) {
                this.setMultiAssignmentStatement(targetList, e, ctx, ctx.info);
                return;
            }
            this.handleDMLBodiedBuiltinFunction(functionName, ".builtinNS", ctx);
        }
        String inferNamespace = this.sourceNamespace != null && this.sourceNamespace.length() > 0 && ".defaultNS".equals(namespace) ? this.sourceNamespace : namespace;
        functCall.setFunctionNamespace(inferNamespace);
        this.setMultiAssignmentStatement(targetList, functCall, ctx, ctx.info);
    }

    private void handleDMLBodiedBuiltinFunction(String functionName, String namespace, ParserRuleContext ctx) {
        String filePath;
        DMLProgram tmpProg;
        FunctionDictionary<FunctionStatementBlock> prog;
        if (Builtins.contains(functionName, true, false) && !this.builtinFuns.containsFunction(functionName) && (prog = (tmpProg = this.parseAndAddImportedFunctions(namespace, filePath = Builtins.getFilePath(functionName), ctx)).getBuiltinFunctionDictionary()) != null) {
            for (Map.Entry<String, FunctionStatementBlock> f : prog.getFunctions().entrySet()) {
                this.builtinFuns.addFunction(f.getKey(), f.getValue());
            }
            tmpProg.getNamespaces().entrySet().stream().filter(e -> !((String)e.getKey()).equals(".builtinNS")).forEach(e -> {
                String ns = this.getQualifiedNamespace((String)e.getKey());
                if (this.builtinFunsNs.containsKey(ns)) {
                    this.builtinFunsNs.get(ns).merge((FunctionDictionary)e.getValue());
                } else {
                    this.builtinFunsNs.put(ns, (FunctionDictionary)e.getValue());
                }
            });
        }
    }

    public static Map<String, FunctionStatementBlock> loadAndParseBuiltinFunction(String name, String namespace, boolean forced) {
        if (!Builtins.contains(name, true, false)) {
            throw new DMLRuntimeException("Function " + DMLProgram.constructFunctionKey(namespace, name) + " is not a builtin function.");
        }
        DmlSyntacticValidator tmp = new DmlSyntacticValidator(new CustomErrorListener(), new HashMap<String, String>(), namespace, new HashSet<String>());
        String filePath = Builtins.getFilePath(name);
        FunctionDictionary<FunctionStatementBlock> dict = tmp.parseAndAddImportedFunctions(namespace, filePath, null, forced).getBuiltinFunctionDictionary();
        if (dict == null) {
            throw new RuntimeException("Failed function load: " + name + " " + namespace);
        }
        return dict.getFunctions();
    }

    private static StatementBlock getStatementBlock(Statement current) {
        return ParserWrapper.getStatementBlock(current);
    }

    @Override
    public void exitIfStatement(DmlParser.IfStatementContext ctx) {
        IfStatement ifStmt = new IfStatement();
        ConditionalPredicate predicate = new ConditionalPredicate(ctx.predicate.info.expr);
        ifStmt.setConditionalPredicate(predicate);
        ifStmt.setCtxValuesAndFilename(ctx, this.currentFile);
        if (ctx.ifBody.size() > 0) {
            for (DmlParser.StatementContext stmtCtx : ctx.ifBody) {
                ifStmt.addStatementBlockIfBody(DmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            ifStmt.mergeStatementBlocksIfBody();
        }
        if (ctx.elseBody.size() > 0) {
            for (DmlParser.StatementContext stmtCtx : ctx.elseBody) {
                ifStmt.addStatementBlockElseBody(DmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            ifStmt.mergeStatementBlocksElseBody();
        }
        ctx.info.stmt = ifStmt;
        this.setFileLineColumn(ctx.info.stmt, (ParserRuleContext)ctx);
    }

    @Override
    public void exitWhileStatement(DmlParser.WhileStatementContext ctx) {
        WhileStatement whileStmt = new WhileStatement();
        ConditionalPredicate predicate = new ConditionalPredicate(ctx.predicate.info.expr);
        whileStmt.setPredicate(predicate);
        whileStmt.setCtxValuesAndFilename(ctx, this.currentFile);
        if (ctx.body.size() > 0) {
            for (DmlParser.StatementContext stmtCtx : ctx.body) {
                whileStmt.addStatementBlock(DmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            whileStmt.mergeStatementBlocks();
        }
        ctx.info.stmt = whileStmt;
        this.setFileLineColumn(ctx.info.stmt, (ParserRuleContext)ctx);
    }

    @Override
    public void exitForStatement(DmlParser.ForStatementContext ctx) {
        ForStatement forStmt = new ForStatement();
        DataIdentifier iterVar = new DataIdentifier(ctx.iterVar.getText());
        HashMap<String, String> parForParamValues = null;
        Expression incrementExpr = null;
        if (ctx.iterPred.info.increment != null) {
            incrementExpr = ctx.iterPred.info.increment;
        }
        IterablePredicate predicate = new IterablePredicate(ctx, iterVar, ctx.iterPred.info.from, ctx.iterPred.info.to, incrementExpr, parForParamValues, this.currentFile);
        forStmt.setPredicate(predicate);
        if (ctx.body.size() > 0) {
            for (DmlParser.StatementContext stmtCtx : ctx.body) {
                forStmt.addStatementBlock(DmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            forStmt.mergeStatementBlocks();
        }
        ctx.info.stmt = forStmt;
    }

    @Override
    public void exitParForStatement(DmlParser.ParForStatementContext ctx) {
        ParForStatement parForStmt = new ParForStatement();
        DataIdentifier iterVar = new DataIdentifier(ctx.iterVar.getText());
        HashMap<String, String> parForParamValues = new HashMap<String, String>();
        if (ctx.parForParams != null && ctx.parForParams.size() > 0) {
            for (DmlParser.StrictParameterizedExpressionContext parForParamCtx : ctx.parForParams) {
                String paramVal = parForParamCtx.paramVal.getText();
                if (this.argVals.containsKey(paramVal)) {
                    paramVal = this.argVals.get(paramVal);
                }
                parForParamValues.put(parForParamCtx.paramName.getText(), paramVal);
            }
        }
        Expression incrementExpr = null;
        if (ctx.iterPred.info.increment != null) {
            incrementExpr = ctx.iterPred.info.increment;
        }
        IterablePredicate predicate = new IterablePredicate(ctx, iterVar, ctx.iterPred.info.from, ctx.iterPred.info.to, incrementExpr, parForParamValues, this.currentFile);
        parForStmt.setPredicate(predicate);
        if (ctx.body.size() > 0) {
            for (DmlParser.StatementContext stmtCtx : ctx.body) {
                parForStmt.addStatementBlock(DmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
            parForStmt.mergeStatementBlocks();
        }
        ctx.info.stmt = parForStmt;
    }

    private ArrayList<DataIdentifier> getFunctionParametersNoAssign(List<DmlParser.TypedArgNoAssignContext> ctx) {
        ArrayList<DataIdentifier> retVal = new ArrayList<DataIdentifier>(ctx.size());
        for (DmlParser.TypedArgNoAssignContext paramCtx : ctx) {
            DataIdentifier dataId = new DataIdentifier(paramCtx.paramName.getText());
            String dataType = paramCtx.paramType == null || paramCtx.paramType.dataType() == null || paramCtx.paramType.dataType().getText() == null || paramCtx.paramType.dataType().getText().isEmpty() ? "scalar" : paramCtx.paramType.dataType().getText();
            String valueType = paramCtx.paramType.valueType().getText();
            this.checkValidDataType(dataType, paramCtx.start);
            if (!this.setDataAndValueType(dataId, dataType, valueType, paramCtx.start, false, true)) {
                return null;
            }
            retVal.add(dataId);
        }
        return retVal;
    }

    private ArrayList<DataIdentifier> getFunctionParametersAssign(List<DmlParser.TypedArgAssignContext> ctx) {
        ArrayList<DataIdentifier> retVal = new ArrayList<DataIdentifier>(ctx.size());
        for (DmlParser.TypedArgAssignContext paramCtx : ctx) {
            DataIdentifier dataId = new DataIdentifier(paramCtx.paramName.getText());
            String dataType = paramCtx.paramType == null || paramCtx.paramType.dataType() == null || paramCtx.paramType.dataType().getText() == null || paramCtx.paramType.dataType().getText().isEmpty() ? "scalar" : paramCtx.paramType.dataType().getText();
            String valueType = paramCtx.paramType.valueType().getText();
            this.checkValidDataType(dataType, paramCtx.start);
            if (!this.setDataAndValueType(dataId, dataType, valueType, paramCtx.start, false, true)) {
                return null;
            }
            retVal.add(dataId);
        }
        return retVal;
    }

    private static ArrayList<Expression> getFunctionDefaults(List<DmlParser.TypedArgAssignContext> ctx) {
        return new ArrayList<Expression>(ctx.stream().map(arg -> arg.paramVal != null ? arg.paramVal.info.expr : null).collect(Collectors.toList()));
    }

    @Override
    public void exitIterablePredicateColonExpression(DmlParser.IterablePredicateColonExpressionContext ctx) {
        ctx.info.from = ctx.from.info.expr;
        ctx.info.to = ctx.to.info.expr;
        ctx.info.increment = null;
    }

    @Override
    public void exitIterablePredicateSeqExpression(DmlParser.IterablePredicateSeqExpressionContext ctx) {
        if (!ctx.ID().getText().equals("seq")) {
            this.notifyErrorListeners("incorrect function:'" + ctx.ID().getText() + "'. expected 'seq'", ctx.start);
            return;
        }
        ctx.info.from = ctx.from.info.expr;
        ctx.info.to = ctx.to.info.expr;
        if (ctx.increment != null && ctx.increment.info != null) {
            ctx.info.increment = ctx.increment.info.expr;
        }
    }

    @Override
    public void exitInternalFunctionDefExpression(DmlParser.InternalFunctionDefExpressionContext ctx) {
        ArrayList<StatementBlock> body;
        FunctionStatement functionStmt = new FunctionStatement();
        functionStmt.setName(ctx.name.getText());
        functionStmt.setInputParams(this.getFunctionParametersAssign(ctx.inputParams));
        functionStmt.setInputDefaults(DmlSyntacticValidator.getFunctionDefaults(ctx.inputParams));
        functionStmt.setOutputParams(this.getFunctionParametersNoAssign(ctx.outputParams));
        if (ctx.body.size() > 0) {
            body = new ArrayList<StatementBlock>();
            for (DmlParser.StatementContext stmtCtx : ctx.body) {
                body.add(DmlSyntacticValidator.getStatementBlock(stmtCtx.info.stmt));
            }
        } else {
            this.notifyErrorListeners("functions with no statements are not allowed", ctx.start);
            return;
        }
        functionStmt.setBody(body);
        functionStmt.mergeStatementBlocks();
        ctx.info.stmt = functionStmt;
        this.setFileLineColumn(ctx.info.stmt, (ParserRuleContext)ctx);
        ctx.info.functionName = ctx.name.getText();
    }

    @Override
    public void exitPathStatement(DmlParser.PathStatementContext ctx) {
        String filePath;
        PathStatement stmt = new PathStatement(ctx.pathValue.getText());
        this._workingDir = filePath = UtilFunctions.unquote(ctx.pathValue.getText());
        ctx.info.stmt = stmt;
    }

    @Override
    public void exitIfdefAssignmentStatement(DmlParser.IfdefAssignmentStatementContext ctx) {
        if (!ctx.commandLineParam.getText().startsWith("$")) {
            this.notifyErrorListeners("the first argument of ifdef function should be a commandline argument parameter (which starts with $)", ctx.commandLineParam.start);
            return;
        }
        if (ctx.targetList == null) {
            this.notifyErrorListeners("ifdef assignment needs an lvalue ", ctx.start);
            return;
        }
        String targetListText = ctx.targetList.getText();
        if (targetListText.startsWith("$")) {
            this.notifyErrorListeners("lhs of ifdef function cannot be a commandline parameters. Use local variable instead", ctx.start);
            return;
        }
        DataIdentifier target = null;
        if (ctx.targetList.dataInfo.expr instanceof DataIdentifier) {
            target = (DataIdentifier)ctx.targetList.dataInfo.expr;
            Expression source = null;
            source = ctx.commandLineParam.dataInfo.expr != null ? ctx.commandLineParam.dataInfo.expr : ctx.source.info.expr;
            try {
                ctx.info.stmt = new AssignmentStatement(ctx, target, source, this.currentFile);
            }
            catch (LanguageException e) {
                this.notifyErrorListeners("invalid assignment for ifdef function", ctx.targetList.start);
                return;
            }
        } else {
            this.notifyErrorListeners("incorrect lvalue in ifdef function ", ctx.targetList.start);
            return;
        }
    }

    @Override
    public void exitAccumulatorAssignmentStatement(DmlParser.AccumulatorAssignmentStatementContext ctx) {
        if (ctx.targetList == null) {
            this.notifyErrorListeners("incorrect parsing for accumulator assignment", ctx.start);
            return;
        }
        this.exitAssignmentStatementHelper(ctx, ctx.targetList.getText(), ctx.targetList.dataInfo, ctx.targetList.start, ctx.source.info, ctx.info);
        ((AssignmentStatement)ctx.info.stmt).setAccumulator(true);
    }

    @Override
    public void exitMatrixDataTypeCheck(DmlParser.MatrixDataTypeCheckContext ctx) {
        this.checkValidDataType(ctx.ID().getText(), ctx.start);
    }

    @Override
    public void visitTerminal(TerminalNode node) {
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
    }

    @Override
    public void exitEveryRule(ParserRuleContext ctx) {
    }

    @Override
    public void enterModIntDivExpression(DmlParser.ModIntDivExpressionContext ctx) {
    }

    @Override
    public void enterExternalFunctionDefExpression(DmlParser.ExternalFunctionDefExpressionContext ctx) {
    }

    @Override
    public void enterBooleanNotExpression(DmlParser.BooleanNotExpressionContext ctx) {
    }

    @Override
    public void enterPowerExpression(DmlParser.PowerExpressionContext ctx) {
    }

    @Override
    public void enterInternalFunctionDefExpression(DmlParser.InternalFunctionDefExpressionContext ctx) {
    }

    @Override
    public void enterBuiltinFunctionExpression(DmlParser.BuiltinFunctionExpressionContext ctx) {
    }

    @Override
    public void enterConstIntIdExpression(DmlParser.ConstIntIdExpressionContext ctx) {
    }

    @Override
    public void enterAtomicExpression(DmlParser.AtomicExpressionContext ctx) {
    }

    @Override
    public void enterIfdefAssignmentStatement(DmlParser.IfdefAssignmentStatementContext ctx) {
    }

    @Override
    public void enterAccumulatorAssignmentStatement(DmlParser.AccumulatorAssignmentStatementContext ctx) {
    }

    @Override
    public void enterConstStringIdExpression(DmlParser.ConstStringIdExpressionContext ctx) {
    }

    @Override
    public void enterConstTrueExpression(DmlParser.ConstTrueExpressionContext ctx) {
    }

    @Override
    public void enterParForStatement(DmlParser.ParForStatementContext ctx) {
    }

    @Override
    public void enterUnaryExpression(DmlParser.UnaryExpressionContext ctx) {
    }

    @Override
    public void enterImportStatement(DmlParser.ImportStatementContext ctx) {
    }

    @Override
    public void enterPathStatement(DmlParser.PathStatementContext ctx) {
    }

    @Override
    public void enterWhileStatement(DmlParser.WhileStatementContext ctx) {
    }

    @Override
    public void enterCommandlineParamExpression(DmlParser.CommandlineParamExpressionContext ctx) {
    }

    @Override
    public void enterFunctionCallAssignmentStatement(DmlParser.FunctionCallAssignmentStatementContext ctx) {
    }

    @Override
    public void enterAddSubExpression(DmlParser.AddSubExpressionContext ctx) {
    }

    @Override
    public void enterIfStatement(DmlParser.IfStatementContext ctx) {
    }

    @Override
    public void enterConstDoubleIdExpression(DmlParser.ConstDoubleIdExpressionContext ctx) {
    }

    @Override
    public void enterMatrixMulExpression(DmlParser.MatrixMulExpressionContext ctx) {
    }

    @Override
    public void enterMatrixDataTypeCheck(DmlParser.MatrixDataTypeCheckContext ctx) {
    }

    @Override
    public void enterCommandlinePositionExpression(DmlParser.CommandlinePositionExpressionContext ctx) {
    }

    @Override
    public void enterIterablePredicateColonExpression(DmlParser.IterablePredicateColonExpressionContext ctx) {
    }

    @Override
    public void enterAssignmentStatement(DmlParser.AssignmentStatementContext ctx) {
    }

    @Override
    public void enterValueType(DmlParser.ValueTypeContext ctx) {
    }

    @Override
    public void exitValueType(DmlParser.ValueTypeContext ctx) {
    }

    @Override
    public void enterMl_type(DmlParser.Ml_typeContext ctx) {
    }

    @Override
    public void exitMl_type(DmlParser.Ml_typeContext ctx) {
    }

    @Override
    public void enterBooleanAndExpression(DmlParser.BooleanAndExpressionContext ctx) {
    }

    @Override
    public void enterForStatement(DmlParser.ForStatementContext ctx) {
    }

    @Override
    public void enterRelationalExpression(DmlParser.RelationalExpressionContext ctx) {
    }

    @Override
    public void enterTypedArgNoAssign(DmlParser.TypedArgNoAssignContext ctx) {
    }

    @Override
    public void exitTypedArgNoAssign(DmlParser.TypedArgNoAssignContext ctx) {
    }

    @Override
    public void enterTypedArgAssign(DmlParser.TypedArgAssignContext ctx) {
    }

    @Override
    public void exitTypedArgAssign(DmlParser.TypedArgAssignContext ctx) {
    }

    @Override
    public void enterStrictParameterizedExpression(DmlParser.StrictParameterizedExpressionContext ctx) {
    }

    @Override
    public void exitStrictParameterizedExpression(DmlParser.StrictParameterizedExpressionContext ctx) {
    }

    @Override
    public void enterMultDivExpression(DmlParser.MultDivExpressionContext ctx) {
    }

    @Override
    public void enterConstFalseExpression(DmlParser.ConstFalseExpressionContext ctx) {
    }

    @Override
    public void enterStrictParameterizedKeyValueString(DmlParser.StrictParameterizedKeyValueStringContext ctx) {
    }

    @Override
    public void exitStrictParameterizedKeyValueString(DmlParser.StrictParameterizedKeyValueStringContext ctx) {
    }

    @Override
    public void enterProgramroot(DmlParser.ProgramrootContext ctx) {
    }

    @Override
    public void exitProgramroot(DmlParser.ProgramrootContext ctx) {
    }

    @Override
    public void enterDataIdExpression(DmlParser.DataIdExpressionContext ctx) {
    }

    @Override
    public void enterIndexedExpression(DmlParser.IndexedExpressionContext ctx) {
    }

    @Override
    public void enterParameterizedExpression(DmlParser.ParameterizedExpressionContext ctx) {
    }

    @Override
    public void exitParameterizedExpression(DmlParser.ParameterizedExpressionContext ctx) {
    }

    @Override
    public void enterFunctionCallMultiAssignmentStatement(DmlParser.FunctionCallMultiAssignmentStatementContext ctx) {
    }

    @Override
    public void enterIterablePredicateSeqExpression(DmlParser.IterablePredicateSeqExpressionContext ctx) {
    }

    @Override
    public void enterSimpleDataIdentifierExpression(DmlParser.SimpleDataIdentifierExpressionContext ctx) {
    }

    @Override
    public void enterBooleanOrExpression(DmlParser.BooleanOrExpressionContext ctx) {
    }

    @Override
    public void enterMultiIdExpression(DmlParser.MultiIdExpressionContext ctx) {
    }

    @Override
    public void exitMultiIdExpression(DmlParser.MultiIdExpressionContext ctx) {
        ArrayList<Expression> values = new ArrayList<Expression>();
        for (DmlParser.ExpressionContext elem : ctx.targetList) {
            values.add(elem.info.expr);
        }
        ctx.info.expr = new ExpressionList(values);
    }

    @Override
    public void exitExternalFunctionDefExpression(DmlParser.ExternalFunctionDefExpressionContext ctx) {
    }

    public static void init() {
        _f2NS.get().clear();
    }

    public static void init(Map<String, String> scripts) {
        _f2NS.get().clear();
        _tScripts.get().clear();
        for (Map.Entry<String, String> e : scripts.entrySet()) {
            _tScripts.get().put(DmlSyntacticValidator.getDefWorkingFilePath(e.getKey()), e.getValue());
        }
    }

    protected void notifyErrorListeners(String message, Token op) {
        if (!DMLScript.VALIDATOR_IGNORE_ISSUES) {
            this.errorListener.validationError(op.getLine(), op.getCharPositionInLine(), message);
        }
    }

    protected void raiseWarning(String message, Token op) {
        this.errorListener.validationWarning(op.getLine(), op.getCharPositionInLine(), message);
    }

    protected String[] getQualifiedNames(String fullyQualifiedFunctionName) {
        String splitStr = Pattern.quote(this.namespaceResolutionOp());
        String[] fnNames = fullyQualifiedFunctionName.split(splitStr);
        String functionName = "";
        String namespace = "";
        if (fnNames.length == 1) {
            namespace = ".defaultNS";
            functionName = fnNames[0].trim();
        } else if (fnNames.length == 2) {
            namespace = this.getQualifiedNamespace(fnNames[0].trim());
            functionName = fnNames[1].trim();
        } else {
            return null;
        }
        String[] retVal = new String[]{namespace, functionName};
        return retVal;
    }

    protected String getQualifiedNamespace(String namespace) {
        String path = this.sources.get(namespace);
        return path != null && path.length() > 0 ? path : namespace;
    }

    public String getWorkingFilePath(String filePath) {
        return DmlSyntacticValidator.getWorkingFilePath(filePath, this._workingDir);
    }

    public static String getDefWorkingFilePath(String filePath) {
        return DmlSyntacticValidator.getWorkingFilePath(filePath, DEF_WORK_DIR);
    }

    private static String getWorkingFilePath(String filePath, String workingDir) {
        String prefix = workingDir + "/";
        return new File(filePath).isAbsolute() | filePath.startsWith(prefix) ? filePath : prefix + filePath;
    }

    public String getNamespaceSafe(Token ns) {
        return ns != null && ns.getText() != null && !ns.getText().isEmpty() ? ns.getText() : ".defaultNS";
    }

    protected void validateNamespace(String namespace, String filePath, ParserRuleContext ctx) {
        if (!DMLProgram.isInternalNamespace(namespace)) {
            if (this.sources.containsKey(namespace) && !this.sources.get(namespace).equals(filePath)) {
                this.notifyErrorListeners("Namespace Conflict: '" + namespace + "' already defined as " + this.sources.get(namespace), ctx.start);
            } else {
                this.sources.put(namespace, filePath);
            }
        }
    }

    protected void setupContextInfo(StatementInfo info, String namespace, String filePath, String filePath2, DMLProgram prog) {
        info.namespaces = new HashMap();
        if (prog != null) {
            for (Map.Entry<String, FunctionDictionary<FunctionStatementBlock>> e : prog.getNamespaces().entrySet()) {
                info.namespaces.put(this.getQualifiedNamespace(e.getKey()), e.getValue());
            }
            ImportStatement istmt = new ImportStatement();
            istmt.setCompletePath(filePath);
            istmt.setFilename(filePath2);
            istmt.setNamespace(namespace);
            info.stmt = istmt;
        }
    }

    protected void setFileLineColumn(Expression expr, ParserRuleContext ctx) {
        expr.setCtxValuesAndFilename(ctx, this.currentFile);
    }

    protected void setFileLineColumn(Statement stmt, ParserRuleContext ctx) {
        stmt.setCtxValuesAndFilename(ctx, this.currentFile);
    }

    protected void binaryExpressionHelper(ParserRuleContext ctx, ExpressionInfo left, ExpressionInfo right, ExpressionInfo me, String op) {
        if (left.expr != null && right.expr != null) {
            Expression.BinaryOp bop = Expression.getBinaryOp(op);
            BinaryExpression be = new BinaryExpression(bop);
            be = new BinaryExpression(bop);
            be.setLeft(left.expr);
            be.setRight(right.expr);
            me.expr = be;
            this.setFileLineColumn(me.expr, ctx);
        }
    }

    protected void relationalExpressionHelper(ParserRuleContext ctx, ExpressionInfo left, ExpressionInfo right, ExpressionInfo me, String op) {
        if (left.expr != null && right.expr != null) {
            Expression.RelationalOp rop = Expression.getRelationalOp(op);
            RelationalExpression re = new RelationalExpression(rop);
            re.setLeft(left.expr);
            re.setRight(right.expr);
            me.expr = re;
            this.setFileLineColumn(me.expr, ctx);
        }
    }

    protected void booleanExpressionHelper(ParserRuleContext ctx, ExpressionInfo left, ExpressionInfo right, ExpressionInfo me, String op) {
        if (left.expr != null && right.expr != null) {
            Expression.BooleanOp bop = Expression.getBooleanOp(op);
            BooleanExpression re = new BooleanExpression(bop);
            re.setLeft(left.expr);
            re.setRight(right.expr);
            me.expr = re;
            this.setFileLineColumn(me.expr, ctx);
        }
    }

    protected void unaryExpressionHelper(ParserRuleContext ctx, ExpressionInfo left, ExpressionInfo me, String op) {
        if (left.expr != null) {
            if (left.expr instanceof IntIdentifier) {
                if (op.equals("-")) {
                    ((IntIdentifier)left.expr).multiplyByMinusOne();
                }
                me.expr = left.expr;
            } else if (left.expr instanceof DoubleIdentifier) {
                if (op.equals("-")) {
                    ((DoubleIdentifier)left.expr).multiplyByMinusOne();
                }
                me.expr = left.expr;
            } else {
                IntIdentifier right = new IntIdentifier(ctx, 1L, this.currentFile);
                if (op.equals("-")) {
                    right = new IntIdentifier(ctx, -1L, this.currentFile);
                }
                Expression.BinaryOp bop = Expression.getBinaryOp("*");
                BinaryExpression be = new BinaryExpression(bop);
                be.setLeft(left.expr);
                be.setRight(right);
                me.expr = be;
            }
            this.setFileLineColumn(me.expr, ctx);
        }
    }

    protected void unaryBooleanExpressionHelper(ParserRuleContext ctx, ExpressionInfo left, ExpressionInfo me, String op) {
        if (left.expr != null) {
            Expression.BooleanOp bop = Expression.getBooleanOp(op);
            BooleanExpression be = new BooleanExpression(bop);
            be.setLeft(left.expr);
            me.expr = be;
            this.setFileLineColumn(me.expr, ctx);
        }
    }

    protected void constDoubleIdExpressionHelper(ParserRuleContext ctx, ExpressionInfo me) {
        try {
            double val = Double.parseDouble(ctx.getText());
            me.expr = new DoubleIdentifier(ctx, val, this.currentFile);
        }
        catch (Exception e) {
            this.notifyErrorListeners("cannot parse the float value: '" + ctx.getText() + "'", ctx.getStart());
            return;
        }
    }

    protected void constIntIdExpressionHelper(ParserRuleContext ctx, ExpressionInfo me) {
        try {
            long val = Long.parseLong(ctx.getText());
            me.expr = new IntIdentifier(ctx, val, this.currentFile);
        }
        catch (Exception e) {
            this.notifyErrorListeners("cannot parse the int value: '" + ctx.getText() + "'", ctx.getStart());
            return;
        }
    }

    protected String extractStringInQuotes(String text, boolean inQuotes) {
        String val = null;
        if (inQuotes) {
            if (text.startsWith("\"") && text.endsWith("\"") || text.startsWith("'") && text.endsWith("'")) {
                if (text.length() > 2) {
                    val = text.substring(1, text.length() - 1).replaceAll("\\\\b", "\b").replaceAll("\\\\t", "\t").replaceAll("\\\\n", "\n").replaceAll("\\\\f", "\f").replaceAll("\\\\r", "\r").replace("\\'", "'").replace("\\\"", "\"");
                } else if (text.equals("\"\"") || text.equals("''")) {
                    val = "";
                }
            }
        } else {
            val = text.replaceAll("\\\\b", "\b").replaceAll("\\\\t", "\t").replaceAll("\\\\n", "\n").replaceAll("\\\\f", "\f").replaceAll("\\\\r", "\r").replace("\\'", "'").replace("\\\"", "\"");
        }
        return val;
    }

    protected void constStringIdExpressionHelper(ParserRuleContext ctx, ExpressionInfo me) {
        String val = this.extractStringInQuotes(ctx.getText(), true);
        if (val == null) {
            this.notifyErrorListeners("incorrect string literal ", ctx.start);
            return;
        }
        me.expr = new StringIdentifier(ctx, val, this.currentFile);
    }

    protected void booleanIdentifierHelper(ParserRuleContext ctx, boolean val, ExpressionInfo info) {
        info.expr = new BooleanIdentifier(ctx, val, this.currentFile);
        this.setFileLineColumn(info.expr, ctx);
    }

    protected void exitDataIdExpressionHelper(ParserRuleContext ctx, ExpressionInfo me, ExpressionInfo dataInfo) {
        DataIdentifier id;
        if (dataInfo.expr instanceof DataIdentifier && BuiltinConstant.contains((id = (DataIdentifier)dataInfo.expr).getName())) {
            dataInfo.expr = new DoubleIdentifier(BuiltinConstant.valueOf(id.getName()).get(), (ParseInfo)dataInfo.expr);
        }
        me.expr = dataInfo.expr;
        if (me.expr != null) {
            me.expr.setCtxValuesAndFilename(ctx, this.currentFile);
        }
    }

    protected ConstIdentifier getConstIdFromString(ParserRuleContext ctx, String varValue) {
        if (varValue.equals(this.trueStringLiteral())) {
            return new BooleanIdentifier(ctx, true, this.currentFile);
        }
        if (varValue.equals(this.falseStringLiteral())) {
            return new BooleanIdentifier(ctx, false, this.currentFile);
        }
        try {
            long lval = Long.parseLong(varValue);
            return new IntIdentifier(ctx, lval, this.currentFile);
        }
        catch (Exception lval) {
            try {
                double dval = Double.parseDouble(varValue);
                return new DoubleIdentifier(ctx, dval, this.currentFile);
            }
            catch (Exception dval) {
                String val = "";
                String text = varValue;
                if (text.startsWith("\"") && text.endsWith("\"") || text.startsWith("'") && text.endsWith("'")) {
                    if (text.length() > 2) {
                        val = this.extractStringInQuotes(text, true);
                    }
                } else {
                    val = this.extractStringInQuotes(text, false);
                }
                return new StringIdentifier(ctx, val, this.currentFile);
            }
        }
    }

    protected void fillExpressionInfoCommandLineParameters(ParserRuleContext ctx, String varName, ExpressionInfo dataInfo) {
        if (!varName.startsWith("$")) {
            this.notifyErrorListeners("commandline param does not start with $", ctx.start);
            return;
        }
        String varValue = null;
        for (Map.Entry<String, String> arg : this.argVals.entrySet()) {
            if (!arg.getKey().equals(varName)) continue;
            if (varValue != null) {
                this.notifyErrorListeners("multiple values passed for the parameter " + varName + " via commandline", ctx.start);
                return;
            }
            varValue = arg.getValue();
        }
        if (varValue == null) {
            return;
        }
        if (varValue.equals("")) {
            return;
        }
        dataInfo.expr = this.getConstIdFromString(ctx, varValue);
    }

    protected void exitAssignmentStatementHelper(ParserRuleContext ctx, String lhs, ExpressionInfo dataInfo, Token lhsStart, ExpressionInfo rhs, StatementInfo info) {
        if (lhs.startsWith("$")) {
            this.notifyErrorListeners("assignment of commandline parameters is not allowed. (Quickfix: try using someLocalVariable=ifdef(" + lhs + ", default value))", ctx.start);
            return;
        }
        DataIdentifier target = null;
        if (dataInfo.expr instanceof DataIdentifier) {
            target = (DataIdentifier)dataInfo.expr;
            Expression source = rhs.expr;
            try {
                info.stmt = new AssignmentStatement(ctx, target, source, this.currentFile);
            }
            catch (LanguageException e) {
                this.notifyErrorListeners("invalid assignment: " + e.getMessage(), lhsStart);
                return;
            }
        } else {
            this.notifyErrorListeners("incorrect lvalue in assignment statement", lhsStart);
            return;
        }
    }

    protected void setPrintStatement(ParserRuleContext ctx, String functionName, ArrayList<ParameterExpression> paramExpression, StatementInfo thisinfo) {
        if (DMLScript.VALIDATOR_IGNORE_ISSUES) {
            try {
                thisinfo.stmt = new PrintStatement(ctx, functionName, this.currentFile);
            }
            catch (LanguageException e) {
                e.printStackTrace();
            }
            return;
        }
        int numParams = paramExpression.size();
        if (numParams == 0) {
            this.notifyErrorListeners(functionName + "() must have more than 0 parameters", ctx.start);
            return;
        }
        if (numParams == 1) {
            Expression expr = paramExpression.get(0).getExpr();
            if (expr == null) {
                this.notifyErrorListeners("cannot process " + functionName + "() function", ctx.start);
                return;
            }
            try {
                ArrayList<Expression> expList = new ArrayList<Expression>();
                expList.add(expr);
                thisinfo.stmt = new PrintStatement(ctx, functionName, expList, this.currentFile);
            }
            catch (LanguageException e) {
                this.notifyErrorListeners("cannot process " + functionName + "() function", ctx.start);
                return;
            }
        }
        if (numParams > 1) {
            if ("stop".equals(functionName)) {
                this.notifyErrorListeners("stop() function cannot have more than 1 parameter", ctx.start);
                return;
            }
            Expression firstExp = paramExpression.get(0).getExpr();
            if (firstExp == null) {
                this.notifyErrorListeners("cannot process " + functionName + "() function", ctx.start);
                return;
            }
            if (!(firstExp instanceof StringIdentifier)) {
                this.notifyErrorListeners("printf-style functionality requires first print parameter to be a string", ctx.start);
                return;
            }
            try {
                ArrayList<Expression> expressions = new ArrayList<Expression>();
                for (ParameterExpression pe : paramExpression) {
                    Expression expression = pe.getExpr();
                    expressions.add(expression);
                }
                thisinfo.stmt = new PrintStatement(ctx, functionName, expressions, this.currentFile);
            }
            catch (LanguageException e) {
                this.notifyErrorListeners("cannot process " + functionName + "() function", ctx.start);
                return;
            }
        }
    }

    protected void setOutputStatement(ParserRuleContext ctx, ArrayList<ParameterExpression> paramExpression, StatementInfo info) {
        if (paramExpression.size() < 2) {
            this.notifyErrorListeners("incorrect usage of write function (at least 2 arguments required)", ctx.start);
            return;
        }
        if (paramExpression.get(0).getExpr() instanceof DataIdentifier) {
            HashMap<String, Expression> varParams = new HashMap<String, Expression>();
            varParams.put("iofilename", paramExpression.get(1).getExpr());
            for (int i = 2; i < paramExpression.size(); ++i) {
                varParams.put(paramExpression.get(i).getName(), paramExpression.get(i).getExpr());
            }
            DataExpression dataExpression = new DataExpression(ctx, Expression.DataOp.WRITE, varParams, this.currentFile);
            info.stmt = new OutputStatement(ctx, (DataIdentifier)paramExpression.get(0).getExpr(), Expression.DataOp.WRITE, this.currentFile);
            ((OutputStatement)info.stmt).setExprParams(dataExpression);
        } else {
            this.notifyErrorListeners("incorrect usage of write function", ctx.start);
        }
    }

    protected void setAssignmentStatement(ParserRuleContext ctx, StatementInfo info, DataIdentifier target, Expression expression) {
        try {
            info.stmt = new AssignmentStatement(ctx, target, expression, this.currentFile);
        }
        catch (LanguageException e) {
            this.notifyErrorListeners("invalid function call", ctx.start);
            return;
        }
    }

    protected Expression buildForBuiltInFunction(ParserRuleContext ctx, String functionName, ArrayList<ParameterExpression> paramExpressions) {
        try {
            if (this.functions.contains(functionName)) {
                return null;
            }
            Expression lsf = this.handleLanguageSpecificFunction(ctx, functionName, paramExpressions);
            if (lsf != null) {
                this.setFileLineColumn(lsf, ctx);
                return lsf;
            }
            BuiltinFunctionExpression bife = BuiltinFunctionExpression.getBuiltinFunctionExpression(ctx, functionName, paramExpressions, this.currentFile);
            if (bife != null) {
                return bife;
            }
            ParameterizedBuiltinFunctionExpression pbife = ParameterizedBuiltinFunctionExpression.getParamBuiltinFunctionExpression(ctx, functionName, paramExpressions, this.currentFile);
            if (pbife != null) {
                return pbife;
            }
            DataExpression dbife = DataExpression.getDataExpression(ctx, functionName, paramExpressions, this.currentFile, this.errorListener);
            if (dbife != null) {
                return dbife;
            }
        }
        catch (Exception e) {
            this.notifyErrorListeners("unable to process builtin function expression " + functionName + ":" + e.getMessage(), ctx.start);
        }
        return null;
    }

    protected void functionCallAssignmentStatementHelper(ParserRuleContext ctx, Set<String> printStatements, Set<String> outputStatements, Expression dataInfo, StatementInfo info, Token nameToken, Token targetListToken, String namespace, String functionName, ArrayList<ParameterExpression> paramExpression, boolean hasLHS) {
        ConvertedDMLSyntax convertedSyntax = this.convertToDMLSyntax(ctx, namespace, functionName, paramExpression, nameToken);
        if (convertedSyntax == null) {
            return;
        }
        namespace = convertedSyntax.namespace;
        functionName = convertedSyntax.functionName;
        paramExpression = convertedSyntax.paramExpression;
        if (namespace.equals(".defaultNS") && !this.functions.contains(functionName)) {
            if (printStatements.contains(functionName)) {
                this.setPrintStatement(ctx, functionName, paramExpression, info);
                return;
            }
            if (outputStatements.contains(functionName)) {
                this.setOutputStatement(ctx, paramExpression, info);
                return;
            }
        }
        DataIdentifier target = null;
        if (dataInfo instanceof DataIdentifier) {
            target = (DataIdentifier)dataInfo;
        } else if (dataInfo != null) {
            this.notifyErrorListeners("incorrect lvalue for function call ", targetListToken);
            return;
        }
        if (namespace.equals(".defaultNS") && !this.functions.contains(functionName)) {
            Expression e = this.buildForBuiltInFunction(ctx, functionName, paramExpression);
            if (e != null) {
                this.setAssignmentStatement(ctx, info, target, e);
                return;
            }
            this.handleDMLBodiedBuiltinFunction(functionName, ".builtinNS", ctx);
        }
        this.setAssignmentStatement(ctx, info, target, this.createFunctionCall(ctx, namespace, functionName, paramExpression));
    }

    protected FunctionCallIdentifier createFunctionCall(ParserRuleContext ctx, String namespace, String functionName, ArrayList<ParameterExpression> paramExpression) {
        FunctionCallIdentifier functCall = new FunctionCallIdentifier(paramExpression);
        functCall.setFunctionName(functionName);
        String inferNamespace = this.sourceNamespace != null && this.sourceNamespace.length() > 0 && ".defaultNS".equals(namespace) ? this.sourceNamespace : namespace;
        functCall.setFunctionNamespace(inferNamespace);
        functCall.setCtxValuesAndFilename(ctx, this.currentFile);
        return functCall;
    }

    protected void setMultiAssignmentStatement(ArrayList<DataIdentifier> target, Expression expression, ParserRuleContext ctx, StatementInfo info) {
        info.stmt = new MultiAssignmentStatement(target, expression);
        info.stmt.setCtxValuesAndFilename(ctx, this.currentFile);
    }

    protected void checkValidDataType(String datatype, Token start) {
        boolean validMatrixType;
        boolean bl = validMatrixType = datatype.equals("matrix") || datatype.equals("Matrix") || datatype.equals("frame") || datatype.equals("Frame") || datatype.equals("list") || datatype.equals("List") || datatype.equals("scalar") || datatype.equals("Scalar");
        if (!validMatrixType) {
            this.notifyErrorListeners("incorrect datatype (expected matrix, frame, list, or scalar)", start);
        }
    }

    protected boolean setDataAndValueType(DataIdentifier dataId, String dataType, String valueType, Token start, boolean shortVt, boolean helpBool) {
        if (dataType.equalsIgnoreCase("matrix")) {
            dataId.setDataType(Types.DataType.MATRIX);
        } else if (dataType.equalsIgnoreCase("frame")) {
            dataId.setDataType(Types.DataType.FRAME);
        } else if (dataType.equalsIgnoreCase("list")) {
            dataId.setDataType(Types.DataType.LIST);
        } else if (dataType.equalsIgnoreCase("scalar")) {
            dataId.setDataType(Types.DataType.SCALAR);
        }
        if (shortVt && valueType.equals("int") || valueType.equals("int") || valueType.equals("integer") || valueType.equals("Int") || valueType.equals("Integer")) {
            dataId.setValueType(Types.ValueType.INT64);
        } else if (shortVt && valueType.equals("str") || valueType.equals("string") || valueType.equals("String")) {
            dataId.setValueType(Types.ValueType.STRING);
        } else if (shortVt && valueType.equals("bool") || valueType.equals("boolean") || valueType.equals("Boolean")) {
            dataId.setValueType(Types.ValueType.BOOLEAN);
        } else if (shortVt && valueType.equals("float") || valueType.equals("double") || valueType.equals("Double")) {
            dataId.setValueType(Types.ValueType.FP64);
        } else if (valueType.equals("unknown") || !shortVt && valueType.equals("Unknown")) {
            dataId.setValueType(Types.ValueType.UNKNOWN);
        } else {
            if (helpBool && valueType.equals("bool")) {
                this.notifyErrorListeners("invalid valuetype " + valueType + " (Quickfix: use 'boolean' instead)", start);
                return false;
            }
            this.notifyErrorListeners("invalid valuetype " + valueType, start);
            return false;
        }
        return true;
    }

    private DMLProgram parseAndAddImportedFunctions(String namespace, String filePath, ParserRuleContext ctx) {
        return this.parseAndAddImportedFunctions(namespace, filePath, ctx, false);
    }

    private DMLProgram parseAndAddImportedFunctions(String namespace, String filePath, ParserRuleContext ctx, boolean forced) {
        this.validateNamespace(namespace, filePath, ctx);
        String scriptID = DMLProgram.constructFunctionKey(namespace, filePath);
        DMLProgram prog = null;
        if (forced || !_f2NS.get().containsKey(scriptID)) {
            _f2NS.get().put(scriptID, namespace);
            try {
                prog = new DMLParserWrapper().doParse(filePath, _tScripts.get().get(filePath), this.getQualifiedNamespace(namespace), this.argVals);
            }
            catch (ParseException e) {
                this.notifyErrorListeners(e.getMessage(), ctx.start);
                return prog;
            }
            if (prog == null) {
                this.notifyErrorListeners("One or more errors found during importing a program from file " + filePath, ctx.start);
                return prog;
            }
        } else {
            prog = new DMLProgram();
        }
        return prog;
    }

    public static class ConvertedDMLSyntax {
        public final String namespace;
        public final String functionName;
        public final ArrayList<ParameterExpression> paramExpression;

        public ConvertedDMLSyntax(String namespace, String functionName, ArrayList<ParameterExpression> paramExpression) {
            this.namespace = namespace;
            this.functionName = functionName;
            this.paramExpression = paramExpression;
        }
    }
}

