/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cost;

import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.cost.ACostEstimate;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class DistinctCostEstimator
extends ACostEstimate {
    private static final long serialVersionUID = 4784682182584508597L;
    private static final int toSmallForAnalysis = 64;
    private final double largestDistinct;

    public DistinctCostEstimator(int nRows, CompressionSettings cs, double sparsity) {
        this.largestDistinct = Math.min(4096, Math.max(256, (int)((double)nRows * cs.coCodePercentage)));
    }

    @Override
    protected double getCostSafe(CompressedSizeInfoColGroup g) {
        int nVals = Math.max(g.getNumVals(), 64);
        return (double)nVals < this.largestDistinct ? (double)nVals : Double.POSITIVE_INFINITY;
    }

    @Override
    public double getCost(MatrixBlock mb) {
        throw new NotImplementedException();
    }

    @Override
    public double getCost(AColGroup cg, int nRows) {
        throw new NotImplementedException();
    }

    @Override
    public boolean shouldSparsify() {
        return false;
    }
}

