/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.TfUtils;
import org.apache.sysds.runtime.transform.encode.Encoder;
import org.apache.sysds.runtime.transform.encode.EncoderBin;
import org.apache.sysds.runtime.transform.encode.EncoderRecode;
import org.apache.sysds.runtime.transform.meta.TfMetaUtils;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class EncoderDummycode
extends Encoder {
    private static final long serialVersionUID = 5832130477659116489L;
    public int[] _domainSizes = null;
    private long _dummycodedLength = 0L;

    public EncoderDummycode(JSONObject parsedSpec, String[] colnames, int clen, int minCol, int maxCol) throws JSONException {
        super(null, clen);
        if (parsedSpec.containsKey(TfUtils.TfMethod.DUMMYCODE.toString())) {
            int[] collist = TfMetaUtils.parseJsonIDList(parsedSpec, colnames, TfUtils.TfMethod.DUMMYCODE.toString(), minCol, maxCol);
            this.initColList(collist);
        }
    }

    public EncoderDummycode() {
        super(new int[0], 0);
    }

    public EncoderDummycode(int[] colList, int clen, int[] domainSizes, long dummycodedLength) {
        super(colList, clen);
        this._domainSizes = domainSizes;
        this._dummycodedLength = dummycodedLength;
    }

    @Override
    public int getNumCols() {
        return (int)this._dummycodedLength;
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        return this.apply(in, out);
    }

    @Override
    public void build(FrameBlock in) {
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(out.getNumRows(), this.getNumCols(), out.getNonZeros());
        MatrixBlock ret = new MatrixBlock(out.getNumRows(), this.getNumCols(), sparse);
        int clen = out.getNumColumns();
        for (int i = 0; i < out.getNumRows(); ++i) {
            int idx = 0;
            int ncolID = 1;
            for (int colID = 1; colID <= clen; ++colID) {
                double val = out.quickGetValue(i, colID - 1);
                if (idx < this._colList.length && colID == this._colList[idx]) {
                    ret.appendValue(i, ncolID - 1 + (int)val - 1, 1.0);
                    ncolID += this._domainSizes[idx];
                    ++idx;
                    continue;
                }
                double ptval = out.quickGetValue(i, colID - 1);
                ret.appendValue(i, ncolID - 1, ptval);
                ++ncolID;
            }
        }
        return ret;
    }

    @Override
    public Encoder subRangeEncoder(IndexRange ixRange) {
        ArrayList<Integer> cols = new ArrayList<Integer>();
        ArrayList<Integer> domainSizes = new ArrayList<Integer>();
        int newDummycodedLength = (int)ixRange.colSpan();
        for (int i2 = 0; i2 < this._colList.length; ++i2) {
            int col = this._colList[i2];
            if (!ixRange.inColRange(col)) continue;
            int corrColumn = (int)((long)col - (ixRange.colStart - 1L));
            cols.add(corrColumn);
            domainSizes.add(this._domainSizes[i2]);
            newDummycodedLength += this._domainSizes[i2] - 1;
        }
        if (cols.isEmpty()) {
            return null;
        }
        return new EncoderDummycode(cols.stream().mapToInt(i -> i).toArray(), (int)ixRange.colSpan(), domainSizes.stream().mapToInt(i -> i).toArray(), newDummycodedLength);
    }

    @Override
    public void mergeAt(Encoder other, int row, int col) {
        if (other instanceof EncoderDummycode) {
            this.mergeColumnInfo(other, col);
            this._domainSizes = new int[this._colList.length];
            this._dummycodedLength = this._clen;
            Arrays.fill(this._domainSizes, 0, this._colList.length, 1);
            return;
        }
        super.mergeAt(other, row, col);
    }

    @Override
    public void updateIndexRanges(long[] beginDims, long[] endDims) {
        long[] initialBegin = Arrays.copyOf(beginDims, beginDims.length);
        long[] initialEnd = Arrays.copyOf(endDims, endDims.length);
        for (int i = 0; i < this._colList.length; ++i) {
            if ((long)this._colList[i] < initialBegin[1] + 1L) {
                beginDims[1] = beginDims[1] + (long)(this._domainSizes[i] - 1);
                endDims[1] = endDims[1] + (long)(this._domainSizes[i] - 1);
                continue;
            }
            if ((long)this._colList[i] >= initialEnd[1] + 1L) continue;
            endDims[1] = endDims[1] + (long)(this._domainSizes[i] - 1);
        }
    }

    public void updateDomainSizes(List<Encoder> encoders) {
        if (this._colList == null) {
            return;
        }
        HashMap<Integer, Integer> colIDToIxMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < this._colList.length; ++i) {
            colIDToIxMap.put(this._colList[i], i);
        }
        this._dummycodedLength = this._clen;
        for (Encoder encoder : encoders) {
            int[] distinct = null;
            if (encoder instanceof EncoderRecode) {
                EncoderRecode encoderRecode = (EncoderRecode)encoder;
                distinct = encoderRecode.numDistinctValues();
            } else if (encoder instanceof EncoderBin) {
                distinct = ((EncoderBin)encoder)._numBins;
            }
            if (distinct == null) continue;
            for (int i = 0; i < encoder._colList.length; ++i) {
                Integer ix = (Integer)colIDToIxMap.get(encoder._colList[i]);
                if (ix == null) continue;
                this._domainSizes[ix.intValue()] = distinct[i];
                this._dummycodedLength += (long)(this._domainSizes[ix] - 1);
            }
        }
    }

    @Override
    public FrameBlock getMetaData(FrameBlock out) {
        return out;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        this._domainSizes = new int[this._colList.length];
        this._dummycodedLength = this._clen;
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            this._domainSizes[j] = (int)meta.getColumnMetadata()[colID - 1].getNumDistinct();
            this._dummycodedLength += (long)(this._domainSizes[j] - 1);
        }
    }

    @Override
    public MatrixBlock getColMapping(FrameBlock meta, MatrixBlock out) {
        int clen = out.getNumRows();
        int idx = 0;
        int ncolID = 1;
        for (int colID = 1; colID <= clen; ++colID) {
            int start = ncolID;
            if (idx < this._colList.length && colID == this._colList[idx]) {
                ncolID = (int)((long)ncolID + meta.getColumnMetadata(colID - 1).getNumDistinct());
                ++idx;
            } else {
                ++ncolID;
            }
            out.quickSetValue(colID - 1, 0, colID);
            out.quickSetValue(colID - 1, 1, start);
            out.quickSetValue(colID - 1, 2, ncolID - 1);
        }
        return out;
    }
}

