/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopProperties;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class BinaryScalar
extends Lop {
    private final Types.OpOp2 operation;

    public BinaryScalar(Lop input1, Lop input2, Types.OpOp2 op, Types.DataType dt, Types.ValueType vt) {
        super(Lop.Type.BinaryCP, dt, vt);
        this.operation = op;
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this.lps.setProperties(this.inputs, LopProperties.ExecType.CP);
    }

    @Override
    public String toString() {
        return "Operation: " + (Object)((Object)this.operation);
    }

    public Types.OpOp2 getOperationType() {
        return this.operation;
    }

    @Override
    public Lop.SimpleInstType getSimpleInstructionType() {
        return Lop.SimpleInstType.Scalar;
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        return InstructionUtils.concatOperands(this.getExecType().name(), this.operation.toString(), this.getInputs().get(0).prepScalarInputOperand(this.getExecType()), this.getInputs().get(1).prepScalarInputOperand(this.getExecType()), this.prepOutputOperand(output));
    }
}

