/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

public class NodeHealthScriptRunner
extends AbstractService {
    private static Log LOG = LogFactory.getLog(NodeHealthScriptRunner.class);
    private String nodeHealthScript;
    private long intervalTime;
    private long scriptTimeout;
    private Timer nodeHealthScriptScheduler;
    Shell.ShellCommandExecutor shexec = null;
    private Configuration conf;
    private static final String ERROR_PATTERN = "ERROR";
    static final String NODE_HEALTH_SCRIPT_TIMED_OUT_MSG = "Node health script timed out";
    private boolean isHealthy = true;
    private String healthReport = "";
    private long lastReportedTime = System.currentTimeMillis();
    private TimerTask timer;

    public NodeHealthScriptRunner() {
        super(NodeHealthScriptRunner.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.conf = conf;
        this.nodeHealthScript = conf.get("yarn.nodemanager.health-checker.script.path");
        this.intervalTime = conf.getLong("yarn.nodemanager.health-checker.interval-ms", 600000L);
        this.scriptTimeout = conf.getLong("yarn.nodemanager.health-checker.script.timeout-ms", 1200000L);
        String[] args = conf.getStrings("yarn.nodemanager.health-checker.script.opts", new String[0]);
        this.timer = new NodeHealthMonitorExecutor(args);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        if (!NodeHealthScriptRunner.shouldRun(this.conf)) {
            LOG.info((Object)"Not starting node health monitor");
            return;
        }
        this.nodeHealthScriptScheduler = new Timer("NodeHealthMonitor-Timer", true);
        this.nodeHealthScriptScheduler.scheduleAtFixedRate(this.timer, 0L, this.intervalTime);
        super.serviceStart();
    }

    protected void serviceStop() {
        Process p;
        if (!NodeHealthScriptRunner.shouldRun(this.conf)) {
            return;
        }
        if (this.nodeHealthScriptScheduler != null) {
            this.nodeHealthScriptScheduler.cancel();
        }
        if (this.shexec != null && (p = this.shexec.getProcess()) != null) {
            p.destroy();
        }
    }

    public boolean isHealthy() {
        return this.isHealthy;
    }

    private synchronized void setHealthy(boolean isHealthy) {
        this.isHealthy = isHealthy;
    }

    public String getHealthReport() {
        return this.healthReport;
    }

    private synchronized void setHealthReport(String healthReport) {
        this.healthReport = healthReport;
    }

    public long getLastReportedTime() {
        return this.lastReportedTime;
    }

    private synchronized void setLastReportedTime(long lastReportedTime) {
        this.lastReportedTime = lastReportedTime;
    }

    public static boolean shouldRun(Configuration conf) {
        String nodeHealthScript = conf.get("yarn.nodemanager.health-checker.script.path");
        if (nodeHealthScript == null || nodeHealthScript.trim().isEmpty()) {
            return false;
        }
        File f = new File(nodeHealthScript);
        return f.exists() && FileUtil.canExecute((File)f);
    }

    private synchronized void setHealthStatus(boolean isHealthy, String output) {
        this.setHealthy(isHealthy);
        this.setHealthReport(output);
    }

    private synchronized void setHealthStatus(boolean isHealthy, String output, long time) {
        this.setHealthStatus(isHealthy, output);
        this.setLastReportedTime(time);
    }

    TimerTask getTimerTask() {
        return this.timer;
    }

    private class NodeHealthMonitorExecutor
    extends TimerTask {
        String exceptionStackTrace = "";

        public NodeHealthMonitorExecutor(String[] args) {
            ArrayList<String> execScript = new ArrayList<String>();
            execScript.add(NodeHealthScriptRunner.this.nodeHealthScript);
            if (args != null) {
                execScript.addAll(Arrays.asList(args));
            }
            NodeHealthScriptRunner.this.shexec = new Shell.ShellCommandExecutor(execScript.toArray(new String[execScript.size()]), null, null, NodeHealthScriptRunner.this.scriptTimeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HealthCheckerExitStatus status = HealthCheckerExitStatus.SUCCESS;
            try {
                NodeHealthScriptRunner.this.shexec.execute();
            }
            catch (Shell.ExitCodeException e) {
                status = HealthCheckerExitStatus.FAILED_WITH_EXIT_CODE;
                if (Shell.WINDOWS && NodeHealthScriptRunner.this.shexec.isTimedOut()) {
                    status = HealthCheckerExitStatus.TIMED_OUT;
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Caught exception : " + e.getMessage()));
                status = !NodeHealthScriptRunner.this.shexec.isTimedOut() ? HealthCheckerExitStatus.FAILED_WITH_EXCEPTION : HealthCheckerExitStatus.TIMED_OUT;
                this.exceptionStackTrace = StringUtils.stringifyException((Throwable)e);
            }
            finally {
                if (status == HealthCheckerExitStatus.SUCCESS && this.hasErrors(NodeHealthScriptRunner.this.shexec.getOutput())) {
                    status = HealthCheckerExitStatus.FAILED;
                }
                this.reportHealthStatus(status);
            }
        }

        void reportHealthStatus(HealthCheckerExitStatus status) {
            long now = System.currentTimeMillis();
            switch (status) {
                case SUCCESS: {
                    NodeHealthScriptRunner.this.setHealthStatus(true, "", now);
                    break;
                }
                case TIMED_OUT: {
                    NodeHealthScriptRunner.this.setHealthStatus(false, NodeHealthScriptRunner.NODE_HEALTH_SCRIPT_TIMED_OUT_MSG);
                    break;
                }
                case FAILED_WITH_EXCEPTION: {
                    NodeHealthScriptRunner.this.setHealthStatus(false, this.exceptionStackTrace);
                    break;
                }
                case FAILED_WITH_EXIT_CODE: {
                    NodeHealthScriptRunner.this.setHealthStatus(true, "", now);
                    break;
                }
                case FAILED: {
                    NodeHealthScriptRunner.this.setHealthStatus(false, NodeHealthScriptRunner.this.shexec.getOutput());
                }
            }
        }

        private boolean hasErrors(String output) {
            String[] splits;
            for (String split : splits = output.split("\n")) {
                if (!split.startsWith(NodeHealthScriptRunner.ERROR_PATTERN)) continue;
                return true;
            }
            return false;
        }
    }

    private static enum HealthCheckerExitStatus {
        SUCCESS,
        TIMED_OUT,
        FAILED_WITH_EXIT_CODE,
        FAILED_WITH_EXCEPTION,
        FAILED;

    }
}

