/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.mr.AggregateBinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.CSVReblockInstruction;
import org.apache.sysml.runtime.instructions.mr.DataGenMRInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.PMMJMRInstruction;
import org.apache.sysml.runtime.instructions.mr.ReblockInstruction;
import org.apache.sysml.runtime.matrix.data.Converter;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.matrix.mapred.MRBaseForCommonInstructions;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;

public abstract class MapperBase
extends MRBaseForCommonInstructions {
    protected ArrayList<Byte> representativeMatrixes = null;
    protected long[] rlens = null;
    protected long[] clens = null;
    protected int[] brlens = null;
    protected int[] bclens = null;
    protected long[] rbounds = null;
    protected long[] cbounds = null;
    protected int[] lastblockrlens = null;
    protected int[] lastblockclens = null;
    protected ArrayList<DataGenMRInstruction> dataGen_instructions = new ArrayList();
    protected ArrayList<ArrayList<MRInstruction>> mapper_instructions = new ArrayList();
    protected ArrayList<ArrayList<ReblockInstruction>> reblock_instructions = new ArrayList();
    protected ArrayList<ArrayList<CSVReblockInstruction>> csv_reblock_instructions = new ArrayList();
    protected ArrayList<ArrayList<Byte>> outputIndexes = new ArrayList();
    protected Converter inputConverter = null;

    protected void commonMap(Writable rawKey, Writable rawValue, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.representativeMatrixes.size(); ++i) {
            byte thisMatrix = this.representativeMatrixes.get(i);
            this.inputConverter.setBlockSize(this.brlens[i], this.bclens[i]);
            this.inputConverter.convert(rawKey, rawValue);
            while (this.inputConverter.hasNext()) {
                Pair pair = this.inputConverter.next();
                MatrixIndexes indexes = (MatrixIndexes)pair.getKey();
                MatrixValue value = (MatrixValue)pair.getValue();
                this.checkValidity(indexes, value, i);
                this.cachedValues.reset();
                this.cachedValues.set(thisMatrix, indexes, value);
                this.specialOperationsForActualMap(i, out, reporter);
            }
        }
        reporter.incrCounter((Enum)Counters.MAP_TIME, System.currentTimeMillis() - start);
    }

    protected abstract void specialOperationsForActualMap(int var1, OutputCollector<Writable, Writable> var2, Reporter var3) throws IOException;

    protected void checkValidity(MatrixIndexes indexes, MatrixValue value, int rep) throws IOException {
        if (indexes.getRowIndex() <= 0L || indexes.getColumnIndex() <= 0L || indexes.getRowIndex() > this.rbounds[rep] || indexes.getColumnIndex() > this.cbounds[rep]) {
            throw new IOException("key: " + indexes + " is out of range: [1, " + this.rbounds[rep] + "] and [1, " + this.cbounds[rep] + "] (tag=" + rep + ")!");
        }
        if (indexes.getRowIndex() == this.rbounds[rep] && value.getNumRows() > this.lastblockrlens[rep]) {
            throw new IOException("boundary block with " + value.getNumRows() + " rows exceeds the size " + this.lastblockrlens[rep] + " (tag=" + rep + ", ix=" + indexes + ", " + value.getNumRows() + "x" + value.getNumColumns() + ")");
        }
        if (indexes.getColumnIndex() == this.cbounds[rep] && value.getNumColumns() > this.lastblockclens[rep]) {
            throw new IOException("boundary block with " + value.getNumColumns() + " columns exceeds the size " + this.lastblockclens[rep] + " (tag=" + rep + ", ix=" + indexes + ", " + value.getNumRows() + "x" + value.getNumColumns() + ")");
        }
    }

    public boolean allowsFilterEmptyInputBlocks() {
        boolean ret = true;
        int count = 0;
        if (ret && this.mapper_instructions != null) {
            for (ArrayList<MRInstruction> vinst : this.mapper_instructions) {
                for (MRInstruction inst : vinst) {
                    ret &= inst instanceof AggregateBinaryInstruction && !((AggregateBinaryInstruction)inst).getOutputEmptyBlocks() || inst instanceof PMMJMRInstruction && !((PMMJMRInstruction)inst).getOutputEmptyBlocks();
                    ++count;
                }
            }
        }
        return ret && count > 0;
    }

    @Override
    public void configure(JobConf job) {
        int i;
        CSVReblockInstruction[] allCSVReblockIns;
        ReblockInstruction[] allReblockIns;
        MRInstruction[] allMapperIns;
        DataGenMRInstruction[] allDataGenIns;
        super.configure(job);
        try {
            this.representativeMatrixes = MRJobConfiguration.getInputMatrixIndexesInMapper(job);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.inputConverter = MRJobConfiguration.getInputConverter(job, this.representativeMatrixes.get(0));
        try {
            allDataGenIns = MRJobConfiguration.getDataGenInstructions(job);
            allMapperIns = MRJobConfiguration.getInstructionsInMapper(job);
            allReblockIns = MRJobConfiguration.getReblockInstructions(job);
            allCSVReblockIns = MRJobConfiguration.getCSVReblockInstructions(job);
        }
        catch (DMLRuntimeException e) {
            throw new RuntimeException(e);
        }
        byte[] outputs = MRJobConfiguration.getOutputIndexesInMapper(job);
        this.rlens = new long[this.representativeMatrixes.size()];
        this.clens = new long[this.representativeMatrixes.size()];
        for (i = 0; i < this.representativeMatrixes.size(); ++i) {
            this.rlens[i] = MRJobConfiguration.getNumRows(job, this.representativeMatrixes.get(i));
            this.clens[i] = MRJobConfiguration.getNumColumns(job, this.representativeMatrixes.get(i));
        }
        this.brlens = new int[this.representativeMatrixes.size()];
        this.bclens = new int[this.representativeMatrixes.size()];
        for (i = 0; i < this.representativeMatrixes.size(); ++i) {
            this.brlens[i] = MRJobConfiguration.getNumRowsPerBlock(job, this.representativeMatrixes.get(i));
            this.bclens[i] = MRJobConfiguration.getNumColumnsPerBlock(job, this.representativeMatrixes.get(i));
        }
        this.rbounds = new long[this.representativeMatrixes.size()];
        this.cbounds = new long[this.representativeMatrixes.size()];
        this.lastblockrlens = new int[this.representativeMatrixes.size()];
        this.lastblockclens = new int[this.representativeMatrixes.size()];
        if (this.valueClass.equals(MatrixBlock.class)) {
            for (i = 0; i < this.representativeMatrixes.size(); ++i) {
                this.rbounds[i] = (long)Math.max(Math.ceil((double)this.rlens[i] / (double)this.brlens[i]), 1.0);
                this.cbounds[i] = (long)Math.max(Math.ceil((double)this.clens[i] / (double)this.bclens[i]), 1.0);
                this.lastblockrlens[i] = (int)(this.rlens[i] % (long)this.brlens[i]);
                this.lastblockclens[i] = (int)(this.clens[i] % (long)this.bclens[i]);
                if (this.lastblockrlens[i] == 0) {
                    this.lastblockrlens[i] = this.brlens[i];
                }
                if (this.lastblockclens[i] != 0) continue;
                this.lastblockclens[i] = this.bclens[i];
            }
        } else {
            for (i = 0; i < this.representativeMatrixes.size(); ++i) {
                this.rbounds[i] = this.rlens[i];
                this.cbounds[i] = this.clens[i];
                this.lastblockrlens[i] = 1;
                this.lastblockclens[i] = 1;
            }
        }
        try {
            this.setupDistCacheFiles(job);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        HashSet<Byte> set = new HashSet<Byte>();
        for (int i2 = 0; i2 < this.representativeMatrixes.size(); ++i2) {
            set.clear();
            set.add(this.representativeMatrixes.get(i2));
            ArrayList<DataGenMRInstruction> dataGensForThisMatrix = new ArrayList<DataGenMRInstruction>();
            if (allDataGenIns != null) {
                for (DataGenMRInstruction ins : allDataGenIns) {
                    if (!set.contains(ins.getInput())) continue;
                    dataGensForThisMatrix.add(ins);
                    set.add(ins.output);
                }
            }
            if (dataGensForThisMatrix.size() > 1) {
                throw new RuntimeException("only expects at most one rand instruction per input");
            }
            if (dataGensForThisMatrix.isEmpty()) {
                this.dataGen_instructions.add(null);
            } else {
                this.dataGen_instructions.add((DataGenMRInstruction)dataGensForThisMatrix.get(0));
            }
            ArrayList<MRInstruction> opsForThisMatrix = new ArrayList<MRInstruction>();
            if (allMapperIns != null) {
                for (MRInstruction ins : allMapperIns) {
                    try {
                        boolean toAdd = false;
                        for (byte input : ins.getInputIndexes()) {
                            if (!set.contains(input)) continue;
                            toAdd = true;
                            break;
                        }
                        if (!toAdd) continue;
                        opsForThisMatrix.add(ins);
                        set.add(ins.output);
                    }
                    catch (DMLRuntimeException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            this.mapper_instructions.add(opsForThisMatrix);
            ArrayList<ReblockInstruction> reblocksForThisMatrix = new ArrayList<ReblockInstruction>();
            if (allReblockIns != null) {
                for (ReblockInstruction ins : allReblockIns) {
                    if (!set.contains(ins.input)) continue;
                    reblocksForThisMatrix.add(ins);
                    set.add(ins.output);
                }
            }
            this.reblock_instructions.add(reblocksForThisMatrix);
            ArrayList<CSVReblockInstruction> csvReblocksForThisMatrix = new ArrayList<CSVReblockInstruction>();
            if (allCSVReblockIns != null) {
                for (CSVReblockInstruction ins : allCSVReblockIns) {
                    if (!set.contains(ins.input)) continue;
                    csvReblocksForThisMatrix.add(ins);
                    set.add(ins.output);
                }
            }
            this.csv_reblock_instructions.add(csvReblocksForThisMatrix);
            ArrayList<Byte> outsForThisMatrix = new ArrayList<Byte>();
            for (byte output : outputs) {
                if (!set.contains(output)) continue;
                outsForThisMatrix.add(output);
            }
            this.outputIndexes.add(outsForThisMatrix);
        }
    }

    protected void processMapperInstructionsForMatrix(int index) throws IOException {
        try {
            this.processMixedInstructions(this.mapper_instructions.get(index));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected static enum Counters {
        MAP_TIME;

    }
}

