/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.PartialBlock;

public class AdaptivePartialBlock
implements WritableComparable<AdaptivePartialBlock> {
    private boolean _blocked = false;
    private PartialBlock _cell = null;
    private MatrixBlock _block = null;

    public AdaptivePartialBlock() {
    }

    public AdaptivePartialBlock(PartialBlock cell) {
        this.set(cell);
    }

    public void set(MatrixBlock mb) {
        this._blocked = true;
        this._block = mb;
    }

    public void set(PartialBlock pb) {
        this._blocked = false;
        this._cell = pb;
    }

    public boolean isBlocked() {
        return this._blocked;
    }

    public MatrixBlock getMatrixBlock() {
        return this._block;
    }

    public PartialBlock getPartialBlock() {
        return this._cell;
    }

    public void readFields(DataInput in) throws IOException {
        this._blocked = in.readBoolean();
        if (this._blocked) {
            if (this._block == null) {
                this._block = new MatrixBlock();
            }
            this._block.readFields(in);
        } else {
            if (this._cell == null) {
                this._cell = new PartialBlock();
            }
            this._cell.readFields(in);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this._blocked);
        if (this._blocked) {
            this._block.write(out);
        } else {
            this._cell.write(out);
        }
    }

    public int compareTo(AdaptivePartialBlock that) {
        if (this._blocked != that._blocked) {
            return -1;
        }
        if (this._blocked) {
            return this._block.compareTo(that._block);
        }
        return this._cell.compareTo(that._cell);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AdaptivePartialBlock)) {
            return false;
        }
        AdaptivePartialBlock that = (AdaptivePartialBlock)o;
        return this._blocked == that._blocked && (this._blocked ? this._block.equals(that._block) : this._cell.equals(that._cell));
    }

    public int hashCode() {
        throw new RuntimeException("hashCode() should never be called on instances of this class.");
    }

    public String toString() {
        String ret = "null";
        if (this._blocked) {
            if (this._block != null) {
                ret = this._block.toString();
            }
        } else if (this._cell != null) {
            ret = this._cell.toString();
        }
        return ret;
    }
}

